/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.utils;

import eu.europeana.corelib.definitions.jibx.AgentType;
import eu.europeana.corelib.definitions.jibx.AggregatedCHO;
import eu.europeana.corelib.definitions.jibx.Aggregates;
import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.Alt;
import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.Alternative;
import eu.europeana.corelib.definitions.jibx.Begin;
import eu.europeana.corelib.definitions.jibx.BiographicalInformation;
import eu.europeana.corelib.definitions.jibx.BroadMatch;
import eu.europeana.corelib.definitions.jibx.Broader;
import eu.europeana.corelib.definitions.jibx.CloseMatch;
import eu.europeana.corelib.definitions.jibx.CollectionName;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.ConformsTo;
import eu.europeana.corelib.definitions.jibx.Contributor;
import eu.europeana.corelib.definitions.jibx.Country;
import eu.europeana.corelib.definitions.jibx.CountryCodes;
import eu.europeana.corelib.definitions.jibx.Coverage;
import eu.europeana.corelib.definitions.jibx.Created;
import eu.europeana.corelib.definitions.jibx.Creator;
import eu.europeana.corelib.definitions.jibx.CurrentLocation;
import eu.europeana.corelib.definitions.jibx.DataProvider;
import eu.europeana.corelib.definitions.jibx.DateOfBirth;
import eu.europeana.corelib.definitions.jibx.DateOfDeath;
import eu.europeana.corelib.definitions.jibx.DateOfEstablishment;
import eu.europeana.corelib.definitions.jibx.DateOfTermination;
import eu.europeana.corelib.definitions.jibx.DateType;
import eu.europeana.corelib.definitions.jibx.Description;
import eu.europeana.corelib.definitions.jibx.EdmType;
import eu.europeana.corelib.definitions.jibx.End;
import eu.europeana.corelib.definitions.jibx.EuropeanaAggregationType;
import eu.europeana.corelib.definitions.jibx.EuropeanaProxy;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.ExactMatch;
import eu.europeana.corelib.definitions.jibx.Extent;
import eu.europeana.corelib.definitions.jibx.Format;
import eu.europeana.corelib.definitions.jibx.Gender;
import eu.europeana.corelib.definitions.jibx.HasFormat;
import eu.europeana.corelib.definitions.jibx.HasMet;
import eu.europeana.corelib.definitions.jibx.HasPart;
import eu.europeana.corelib.definitions.jibx.HasType;
import eu.europeana.corelib.definitions.jibx.HasVersion;
import eu.europeana.corelib.definitions.jibx.HasView;
import eu.europeana.corelib.definitions.jibx.Identifier;
import eu.europeana.corelib.definitions.jibx.InScheme;
import eu.europeana.corelib.definitions.jibx.Incorporates;
import eu.europeana.corelib.definitions.jibx.InheritFrom;
import eu.europeana.corelib.definitions.jibx.IsDerivativeOf;
import eu.europeana.corelib.definitions.jibx.IsFormatOf;
import eu.europeana.corelib.definitions.jibx.IsNextInSequence;
import eu.europeana.corelib.definitions.jibx.IsPartOf;
import eu.europeana.corelib.definitions.jibx.IsReferencedBy;
import eu.europeana.corelib.definitions.jibx.IsRelatedTo;
import eu.europeana.corelib.definitions.jibx.IsReplacedBy;
import eu.europeana.corelib.definitions.jibx.IsRepresentationOf;
import eu.europeana.corelib.definitions.jibx.IsRequiredBy;
import eu.europeana.corelib.definitions.jibx.IsShownAt;
import eu.europeana.corelib.definitions.jibx.IsShownBy;
import eu.europeana.corelib.definitions.jibx.IsSimilarTo;
import eu.europeana.corelib.definitions.jibx.IsSuccessorOf;
import eu.europeana.corelib.definitions.jibx.IsVersionOf;
import eu.europeana.corelib.definitions.jibx.Issued;
import eu.europeana.corelib.definitions.jibx.LandingPage;
import eu.europeana.corelib.definitions.jibx.Language;
import eu.europeana.corelib.definitions.jibx.Language1;
import eu.europeana.corelib.definitions.jibx.LanguageCodes;
import eu.europeana.corelib.definitions.jibx.Lat;
import eu.europeana.corelib.definitions.jibx.License;
import eu.europeana.corelib.definitions.jibx.LiteralType;
import eu.europeana.corelib.definitions.jibx.Medium;
import eu.europeana.corelib.definitions.jibx.Name;
import eu.europeana.corelib.definitions.jibx.NarrowMatch;
import eu.europeana.corelib.definitions.jibx.Narrower;
import eu.europeana.corelib.definitions.jibx.Notation;
import eu.europeana.corelib.definitions.jibx.Note;
import eu.europeana.corelib.definitions.jibx.PlaceOfBirth;
import eu.europeana.corelib.definitions.jibx.PlaceOfDeath;
import eu.europeana.corelib.definitions.jibx.PlaceType;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.Preview;
import eu.europeana.corelib.definitions.jibx.ProfessionOrOccupation;
import eu.europeana.corelib.definitions.jibx.Provenance;
import eu.europeana.corelib.definitions.jibx.ProvidedCHOType;
import eu.europeana.corelib.definitions.jibx.Provider;
import eu.europeana.corelib.definitions.jibx.ProxyFor;
import eu.europeana.corelib.definitions.jibx.ProxyIn;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.Publisher;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.References;
import eu.europeana.corelib.definitions.jibx.Related;
import eu.europeana.corelib.definitions.jibx.RelatedMatch;
import eu.europeana.corelib.definitions.jibx.Relation;
import eu.europeana.corelib.definitions.jibx.Replaces;
import eu.europeana.corelib.definitions.jibx.Requires;
import eu.europeana.corelib.definitions.jibx.ResourceOrLiteralType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.jibx.Rights;
import eu.europeana.corelib.definitions.jibx.Rights1;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.jibx.Source;
import eu.europeana.corelib.definitions.jibx.Spatial;
import eu.europeana.corelib.definitions.jibx.Subject;
import eu.europeana.corelib.definitions.jibx.TableOfContents;
import eu.europeana.corelib.definitions.jibx.Temporal;
import eu.europeana.corelib.definitions.jibx.TimeSpanType;
import eu.europeana.corelib.definitions.jibx.Title;
import eu.europeana.corelib.definitions.jibx.Type;
import eu.europeana.corelib.definitions.jibx.Type1;
import eu.europeana.corelib.definitions.jibx.UGCType;
import eu.europeana.corelib.definitions.jibx.Ugc;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.corelib.definitions.jibx.Year;
import eu.europeana.corelib.definitions.jibx._Long;
import eu.europeana.corelib.definitions.jibx._Object;
import eu.europeana.corelib.definitions.solr.entity.EuropeanaAggregation;
import eu.europeana.corelib.definitions.solr.entity.Place;
import eu.europeana.corelib.definitions.solr.entity.Timespan;
import eu.europeana.corelib.definitions.solr.entity.WebResource;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.LicenseImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.ProvidedCHOImpl;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.corelib.utils.StringArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class EdmUtils {
    private static final Logger log = Logger.getLogger(EdmUtils.class.getCanonicalName());
    private static IBindingFactory bfact;
    private static final String SPACE = " ";
    private static final String PREFIX = "http://data.europeana.eu";
    private static String prefix;

    public static synchronized String toEDM(FullBeanImpl fullBean, boolean isUim) {
        if (isUim) {
            prefix = PREFIX;
        }
        RDF rdf = new RDF();
        String type = EdmUtils.getType(fullBean);
        EdmUtils.appendCHO(rdf, fullBean.getProvidedCHOs());
        EdmUtils.appendAggregation(rdf, fullBean.getAggregations());
        EdmUtils.appendProxy(rdf, fullBean.getProxies(), type);
        EdmUtils.appendEuropeanaAggregation(rdf, fullBean);
        EdmUtils.appendAgents(rdf, fullBean.getAgents());
        EdmUtils.appendConcepts(rdf, fullBean.getConcepts());
        EdmUtils.appendPlaces(rdf, fullBean.getPlaces());
        EdmUtils.appendTimespans(rdf, fullBean.getTimespans());
        EdmUtils.appendLicenses(rdf, fullBean.getLicenses());
        try {
            if (bfact == null) {
                bfact = BindingDirectory.getFactory(RDF.class);
            }
            IMarshallingContext marshallingContext = bfact.createMarshallingContext();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            marshallingContext.setOutput((OutputStream)out, null);
            marshallingContext.marshalDocument((Object)rdf, "UTF-8", Boolean.valueOf(true));
            return out.toString("UTF-8");
        }
        catch (JiBXException e) {
            log.severe(((Object)((Object)e)).getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        return null;
    }

    private static void appendLicenses(RDF rdf, List<LicenseImpl> licenses) {
        if (licenses != null) {
            ArrayList<License> licenseList = new ArrayList<License>();
            for (LicenseImpl lic : licenses) {
                License license = new License();
                license.setAbout(lic.getAbout());
                EdmUtils.addAsObject((Object)license, InheritFrom.class, lic.getOdrlInheritFrom());
                DateType date = new DateType();
                date.setDate(new Date(lic.getCcDeprecatedOn().getTime()));
                license.setDeprecatedOn(date);
                licenseList.add(license);
            }
            rdf.setLicenseList(licenseList);
        }
    }

    private static String getType(FullBeanImpl fullBean) {
        for (ProxyImpl prx : fullBean.getProxies()) {
            if (prx.isEuropeanaProxy()) continue;
            return prx.getEdmType().toString();
        }
        return null;
    }

    private static void appendTimespans(RDF rdf, List<TimespanImpl> timespans) {
        if (timespans != null) {
            ArrayList<TimeSpanType> timespanList = new ArrayList<TimeSpanType>();
            for (Timespan timespan : timespans) {
                TimeSpanType timeSpan = new TimeSpanType();
                timeSpan.setAbout(timespan.getAbout());
                EdmUtils.addAsList(timeSpan, AltLabel.class, timespan.getAltLabel());
                EdmUtils.addAsObject((Object)timeSpan, Begin.class, timespan.getBegin());
                EdmUtils.addAsObject((Object)timeSpan, End.class, timespan.getEnd());
                EdmUtils.addAsList(timeSpan, HasPart.class, timespan.getDctermsHasPart());
                EdmUtils.addAsList(timeSpan, IsPartOf.class, timespan.getIsPartOf());
                EdmUtils.addAsList(timeSpan, Note.class, timespan.getNote());
                EdmUtils.addAsList(timeSpan, SameAs.class, timespan.getOwlSameAs(), new String[0]);
                EdmUtils.addAsList(timeSpan, PrefLabel.class, timespan.getPrefLabel());
                timespanList.add(timeSpan);
            }
            rdf.setTimeSpanList(timespanList);
        }
    }

    private static void appendPlaces(RDF rdf, List<PlaceImpl> places) {
        if (places != null) {
            ArrayList<PlaceType> placeList = new ArrayList<PlaceType>();
            for (Place place : places) {
                PlaceType pType = new PlaceType();
                pType.setAbout(place.getAbout());
                if (place.getAltitude() != null && place.getAltitude().floatValue() != 0.0f) {
                    Alt alt = new Alt();
                    alt.setAlt(place.getAltitude());
                    pType.setAlt(alt);
                }
                if (place.getLatitude() != null && place.getLongitude() != null && place.getLatitude().floatValue() != 0.0f && place.getLongitude().floatValue() != 0.0f) {
                    Lat lat = new Lat();
                    lat.setLat(place.getLatitude());
                    pType.setLat(lat);
                    _Long _long = new _Long();
                    _long.setLong(place.getLongitude());
                    pType.setLong(_long);
                }
                EdmUtils.addAsList(pType, AltLabel.class, place.getAltLabel());
                EdmUtils.addAsList(pType, HasPart.class, place.getDcTermsHasPart());
                EdmUtils.addAsList(pType, IsPartOf.class, place.getIsPartOf());
                EdmUtils.addAsList(pType, Note.class, place.getNote());
                EdmUtils.addAsList(pType, PrefLabel.class, place.getPrefLabel());
                EdmUtils.addAsList(pType, SameAs.class, place.getOwlSameAs(), new String[0]);
                placeList.add(pType);
            }
            rdf.setPlaceList(placeList);
        }
    }

    private static void appendConcepts(RDF rdf, List<ConceptImpl> concepts) {
        if (concepts != null) {
            ArrayList<Concept> conceptList = new ArrayList<Concept>();
            for (ConceptImpl concept : concepts) {
                Concept con = new Concept();
                con.setAbout(concept.getAbout());
                ArrayList<Concept.Choice> choices = new ArrayList<Concept.Choice>();
                EdmUtils.addConceptChoice(choices, AltLabel.class, concept.getAltLabel());
                EdmUtils.addConceptChoice(choices, PrefLabel.class, concept.getPrefLabel());
                EdmUtils.addConceptChoice(choices, Notation.class, concept.getNotation());
                EdmUtils.addConceptChoice(choices, Note.class, concept.getNote());
                EdmUtils.addConceptChoice(choices, Broader.class, concept.getBroader());
                EdmUtils.addConceptChoice(choices, BroadMatch.class, concept.getBroadMatch());
                EdmUtils.addConceptChoice(choices, CloseMatch.class, concept.getCloseMatch());
                EdmUtils.addConceptChoice(choices, ExactMatch.class, concept.getExactMatch());
                EdmUtils.addConceptChoice(choices, InScheme.class, concept.getInScheme());
                EdmUtils.addConceptChoice(choices, Narrower.class, concept.getNarrower());
                EdmUtils.addConceptChoice(choices, NarrowMatch.class, concept.getNarrowMatch());
                EdmUtils.addConceptChoice(choices, RelatedMatch.class, concept.getRelatedMatch());
                EdmUtils.addConceptChoice(choices, Related.class, concept.getRelated());
                con.setChoiceList(choices);
                conceptList.add(con);
            }
            rdf.setConceptList(conceptList);
        }
    }

    private static void appendEuropeanaAggregation(RDF rdf, FullBeanImpl fBean) {
        EuropeanaAggregationType aggregation = new EuropeanaAggregationType();
        EuropeanaAggregation europeanaAggregation = fBean.getEuropeanaAggregation();
        if (EdmUtils.isUri(europeanaAggregation.getAbout())) {
            aggregation.setAbout(europeanaAggregation.getAbout());
        } else {
            aggregation.setAbout(PREFIX + europeanaAggregation.getAbout());
        }
        if (!EdmUtils.addAsObject((Object)aggregation, AggregatedCHO.class, europeanaAggregation.getAggregatedCHO())) {
            AggregatedCHO agCHO = new AggregatedCHO();
            if (EdmUtils.isUri(fBean.getProvidedCHOs().get(0).getAbout())) {
                agCHO.setResource(fBean.getProvidedCHOs().get(0).getAbout());
            } else {
                agCHO.setResource(PREFIX + fBean.getProvidedCHOs().get(0).getAbout());
            }
            aggregation.setAggregatedCHO(agCHO);
        }
        EdmUtils.addAsList(aggregation, Aggregates.class, europeanaAggregation.getAggregates(), new String[0]);
        CollectionName collectionName = new CollectionName();
        collectionName.setString(fBean.getEuropeanaCollectionName()[0]);
        aggregation.setCollectionName(collectionName);
        Country country = EdmUtils.convertMapToCountry(europeanaAggregation.getEdmCountry());
        if (country != null) {
            aggregation.setCountry(country);
        }
        EdmUtils.addAsObject((Object)aggregation, Creator.class, europeanaAggregation.getDcCreator());
        EdmUtils.addAsList(aggregation, HasView.class, europeanaAggregation.getEdmHasView(), new String[0]);
        EdmUtils.addAsObject((Object)aggregation, IsShownBy.class, europeanaAggregation.getEdmIsShownBy());
        EdmUtils.addAsObject((Object)aggregation, LandingPage.class, europeanaAggregation.getEdmLandingPage());
        Language1 language = EdmUtils.convertMapToLanguage(europeanaAggregation.getEdmLanguage());
        if (language != null) {
            aggregation.setLanguage(language);
        }
        EdmUtils.addAsObject((Object)aggregation, Preview.class, europeanaAggregation.getEdmPreview());
        EdmUtils.addAsObject((Object)aggregation, Rights1.class, europeanaAggregation.getEdmRights());
        ArrayList<EuropeanaAggregationType> lst = new ArrayList<EuropeanaAggregationType>();
        lst.add(aggregation);
        rdf.setEuropeanaAggregationList(lst);
    }

    private static Language1 convertMapToLanguage(Map<String, List<String>> edmLanguage) {
        if (edmLanguage != null && edmLanguage.size() > 0) {
            Language1 lang = new Language1();
            lang.setLanguage(LanguageCodes.convert((String)edmLanguage.entrySet().iterator().next().getValue().get(0)));
            return lang;
        }
        return null;
    }

    private static Country convertMapToCountry(Map<String, List<String>> edmCountry) {
        if (edmCountry != null && edmCountry.size() > 0) {
            String[] splitCountry;
            Country country = new Country();
            StringBuilder sb = new StringBuilder();
            for (String countryWord : splitCountry = edmCountry.entrySet().iterator().next().getValue().get(0).split(SPACE)) {
                if (StringUtils.equals((String)"and", (String)countryWord)) {
                    sb.append(countryWord);
                } else {
                    sb.append(StringUtils.capitalize((String)countryWord));
                }
                sb.append(SPACE);
            }
            country.setCountry(CountryCodes.convert((String)sb.toString().trim()));
            return country;
        }
        return null;
    }

    private static void appendProxy(RDF rdf, List<ProxyImpl> proxies, String typeStr) {
        ArrayList<ProxyType> proxyList = new ArrayList<ProxyType>();
        for (ProxyImpl prx : proxies) {
            ProxyType proxy = new ProxyType();
            if (EdmUtils.isUri(prx.getAbout())) {
                proxy.setAbout(prx.getAbout());
            } else {
                proxy.setAbout(PREFIX + prx.getAbout());
            }
            EuropeanaProxy europeanaProxy = new EuropeanaProxy();
            europeanaProxy.setEuropeanaProxy(prx.isEuropeanaProxy());
            proxy.setEuropeanaProxy(europeanaProxy);
            ArrayList<IsNextInSequence> nis = null;
            String[] seqArray = prx.getEdmIsNextInSequence();
            if (seqArray != null) {
                nis = new ArrayList<IsNextInSequence>();
                for (int i = 0; i < seqArray.length; ++i) {
                    IsNextInSequence item = new IsNextInSequence();
                    item.setResource(seqArray[i]);
                    nis.add(item);
                }
            }
            if (nis != null) {
                proxy.setIsNextInSequenceList(nis);
            }
            String[] pIn = prx.getProxyIn();
            ArrayList<ProxyIn> pInList = null;
            if (pIn != null) {
                pInList = new ArrayList<ProxyIn>();
                for (int i = 0; i < pIn.length; ++i) {
                    ProxyIn proxyIn = new ProxyIn();
                    if (EdmUtils.isUri(pIn[i])) {
                        proxyIn.setResource(pIn[i]);
                    } else {
                        proxyIn.setResource(PREFIX + pIn[i]);
                    }
                    pInList.add(proxyIn);
                }
            }
            if (pInList != null) {
                proxy.setProxyInList(pInList);
            }
            Type1 type = new Type1();
            type.setType(EdmType.valueOf((String)typeStr.replace("3D", "_3_D")));
            proxy.setType(type);
            EdmUtils.addAsObject((Object)proxy, CurrentLocation.class, prx.getEdmCurrentLocation());
            EdmUtils.addAsList(proxy, HasMet.class, prx.getEdmHasMet());
            EdmUtils.addAsList(proxy, HasType.class, prx.getEdmHasType());
            EdmUtils.addAsList(proxy, Incorporates.class, prx.getEdmIncorporates(), new String[0]);
            EdmUtils.addAsList(proxy, IsDerivativeOf.class, prx.getEdmIsDerivativeOf(), new String[0]);
            EdmUtils.addAsList(proxy, IsRelatedTo.class, prx.getEdmIsRelatedTo());
            EdmUtils.addAsObject((Object)proxy, IsRepresentationOf.class, prx.getEdmIsRepresentationOf());
            EdmUtils.addAsList(proxy, IsSimilarTo.class, prx.getEdmIsSimilarTo(), new String[0]);
            EdmUtils.addAsList(proxy, IsSuccessorOf.class, prx.getEdmIsSuccessorOf(), new String[0]);
            EdmUtils.addAsObject((Object)proxy, ProxyFor.class, PREFIX + prx.getProxyFor());
            EdmUtils.addAsList(proxy, Year.class, prx.getYear());
            ArrayList<EuropeanaType.Choice> dcChoices = new ArrayList<EuropeanaType.Choice>();
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Contributor.class, prx.getDcContributor());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Coverage.class, prx.getDcCoverage());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Creator.class, prx.getDcCreator());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, eu.europeana.corelib.definitions.jibx.Date.class, prx.getDcDate());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Description.class, prx.getDcDescription());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Format.class, prx.getDcFormat());
            EdmUtils.addEuropeanaTypeChoiceLiteral(dcChoices, Identifier.class, prx.getDcIdentifier());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Publisher.class, prx.getDcPublisher());
            EdmUtils.addEuropeanaTypeChoiceLiteral(dcChoices, Language.class, prx.getDcLanguage());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Relation.class, prx.getDcRelation());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Rights.class, prx.getDcRights());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Source.class, prx.getDcSource());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Subject.class, prx.getDcSubject());
            EdmUtils.addEuropeanaTypeChoiceLiteral(dcChoices, Title.class, prx.getDcTitle());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Type.class, prx.getDcType());
            EdmUtils.addEuropeanaTypeChoiceLiteral(dcChoices, Alternative.class, prx.getDctermsAlternative());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, ConformsTo.class, prx.getDctermsConformsTo());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Created.class, prx.getDctermsCreated());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Extent.class, prx.getDctermsExtent());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, HasFormat.class, prx.getDctermsHasFormat());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, HasPart.class, prx.getDctermsHasPart());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, HasVersion.class, prx.getDctermsHasVersion());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsFormatOf.class, prx.getDctermsIsFormatOf());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsPartOf.class, prx.getDctermsIsPartOf());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsReferencedBy.class, prx.getDctermsIsReferencedBy());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsReplacedBy.class, prx.getDctermsIsReplacedBy());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Issued.class, prx.getDctermsIssued());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsRequiredBy.class, prx.getDctermsIsRequiredBy());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, IsVersionOf.class, prx.getDctermsIsVersionOf());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Medium.class, prx.getDctermsMedium());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Provenance.class, prx.getDctermsProvenance());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, References.class, prx.getDctermsReferences());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Replaces.class, prx.getDctermsReplaces());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Requires.class, prx.getDctermsRequires());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Spatial.class, prx.getDctermsSpatial());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, Temporal.class, prx.getDctermsTemporal());
            EdmUtils.addEuropeanaTypeChoice(dcChoices, TableOfContents.class, prx.getDctermsTOC());
            proxy.setChoiceList(dcChoices);
            proxyList.add(proxy);
        }
        rdf.setProxyList(proxyList);
    }

    private static void appendAggregation(RDF rdf, List<AggregationImpl> aggregations) {
        ArrayList<Aggregation> aggregationList = new ArrayList<Aggregation>();
        for (AggregationImpl aggr : aggregations) {
            Aggregation aggregation = new Aggregation();
            if (EdmUtils.isUri(aggr.getAbout())) {
                aggregation.setAbout(aggr.getAbout());
            } else {
                aggregation.setAbout(PREFIX + aggr.getAbout());
            }
            if (!EdmUtils.addAsObject((Object)aggregation, AggregatedCHO.class, aggr.getAggregatedCHO())) {
                AggregatedCHO cho = new AggregatedCHO();
                if (EdmUtils.isUri(((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout())) {
                    cho.setResource(((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout());
                } else {
                    cho.setResource(PREFIX + ((ProvidedCHOType)rdf.getProvidedCHOList().get(0)).getAbout());
                }
                aggregation.setAggregatedCHO(cho);
            }
            if (!EdmUtils.addAsObject((Object)aggregation, DataProvider.class, aggr.getEdmDataProvider())) {
                EdmUtils.addAsObject((Object)aggregation, DataProvider.class, aggr.getEdmProvider());
            }
            EdmUtils.addAsObject((Object)aggregation, IsShownAt.class, aggr.getEdmIsShownAt());
            EdmUtils.addAsObject((Object)aggregation, IsShownBy.class, aggr.getEdmIsShownBy());
            EdmUtils.addAsObject((Object)aggregation, _Object.class, aggr.getEdmObject());
            EdmUtils.addAsObject((Object)aggregation, Provider.class, aggr.getEdmProvider());
            EdmUtils.addAsObject((Object)aggregation, Rights1.class, aggr.getEdmRights());
            if (aggr.getEdmUgc() != null) {
                Ugc ugc = new Ugc();
                ugc.setUgc(UGCType.valueOf((String)StringUtils.upperCase((String)aggr.getEdmUgc())));
                aggregation.setUgc(ugc);
            }
            EdmUtils.addAsList(aggregation, Rights.class, aggr.getDcRights());
            EdmUtils.addAsList(aggregation, HasView.class, aggr.getHasView(), new String[0]);
            EdmUtils.createWebResources(rdf, aggr);
            aggregationList.add(aggregation);
        }
        rdf.setAggregationList(aggregationList);
    }

    private static void createWebResources(RDF rdf, AggregationImpl aggr) {
        ArrayList<WebResourceType> webResources = new ArrayList<WebResourceType>();
        for (WebResource webResource : aggr.getWebResources()) {
            WebResourceType wResource = new WebResourceType();
            wResource.setAbout(webResource.getAbout());
            EdmUtils.addAsList(wResource, ConformsTo.class, webResource.getDctermsConformsTo());
            EdmUtils.addAsList(wResource, Created.class, webResource.getDctermsCreated());
            EdmUtils.addAsList(wResource, Creator.class, webResource.getDcCreator());
            EdmUtils.addAsList(wResource, Description.class, webResource.getDcDescription());
            EdmUtils.addAsList(wResource, Extent.class, webResource.getDctermsExtent());
            EdmUtils.addAsList(wResource, Format.class, webResource.getDcFormat());
            EdmUtils.addAsList(wResource, HasPart.class, webResource.getDctermsHasPart());
            EdmUtils.addAsList(wResource, IsFormatOf.class, webResource.getDctermsIsFormatOf());
            EdmUtils.addAsObject((Object)wResource, IsNextInSequence.class, webResource.getIsNextInSequence());
            EdmUtils.addAsList(wResource, Issued.class, webResource.getDctermsIssued());
            EdmUtils.addAsList(wResource, Rights.class, webResource.getWebResourceDcRights());
            EdmUtils.addAsObject((Object)wResource, Rights1.class, webResource.getWebResourceEdmRights());
            EdmUtils.addAsList(wResource, Source.class, webResource.getDcSource());
            EdmUtils.addAsList(wResource, SameAs.class, webResource.getOwlSameAs(), new String[0]);
            webResources.add(wResource);
        }
        rdf.setWebResourceList(webResources);
    }

    private static void appendCHO(RDF rdf, List<ProvidedCHOImpl> chos) {
        ArrayList<ProvidedCHOType> pChoList = new ArrayList<ProvidedCHOType>();
        for (ProvidedCHOImpl pCho : chos) {
            ProvidedCHOType pChoJibx = new ProvidedCHOType();
            if (EdmUtils.isUri(pCho.getAbout())) {
                pChoJibx.setAbout(pCho.getAbout());
            } else {
                pChoJibx.setAbout(PREFIX + pCho.getAbout());
            }
            EdmUtils.addAsList(pChoJibx, SameAs.class, pCho.getOwlSameAs(), new String[0]);
            pChoList.add(pChoJibx);
        }
        rdf.setProvidedCHOList(pChoList);
    }

    private static void appendAgents(RDF rdf, List<AgentImpl> agents) {
        if (agents != null) {
            ArrayList<AgentType> agentList = new ArrayList<AgentType>();
            for (AgentImpl ag : agents) {
                AgentType agent = new AgentType();
                agent.setAbout(ag.getAbout());
                EdmUtils.addAsList(agent, AltLabel.class, ag.getAltLabel());
                EdmUtils.addAsObject((Object)agent, Begin.class, ag.getBegin());
                EdmUtils.addAsObject((Object)agent, End.class, ag.getEnd());
                EdmUtils.addAsObject((Object)agent, BiographicalInformation.class, ag.getRdaGr2BiographicalInformation());
                EdmUtils.addAsList(agent, eu.europeana.corelib.definitions.jibx.Date.class, ag.getDcDate());
                EdmUtils.addAsObject((Object)agent, DateOfBirth.class, ag.getRdaGr2DateOfBirth());
                EdmUtils.addAsObject((Object)agent, DateOfDeath.class, ag.getRdaGr2DateOfDeath());
                EdmUtils.addAsObject((Object)agent, PlaceOfBirth.class, ag.getRdaGr2PlaceOfBirth());
                EdmUtils.addAsObject((Object)agent, PlaceOfDeath.class, ag.getRdaGr2PlaceOfDeath());
                EdmUtils.addAsObject((Object)agent, DateOfEstablishment.class, ag.getRdaGr2DateOfEstablishment());
                EdmUtils.addAsObject((Object)agent, DateOfTermination.class, ag.getRdaGr2DateOfTermination());
                EdmUtils.addAsObject((Object)agent, Gender.class, ag.getRdaGr2Gender());
                EdmUtils.addAsList(agent, HasMet.class, ag.getEdmHasMet());
                EdmUtils.addAsList(agent, Identifier.class, ag.getDcIdentifier());
                EdmUtils.addAsList(agent, IsRelatedTo.class, ag.getEdmIsRelatedTo());
                EdmUtils.addAsList(agent, Name.class, ag.getFoafName());
                EdmUtils.addAsList(agent, Note.class, ag.getNote());
                EdmUtils.addAsList(agent, PrefLabel.class, ag.getPrefLabel());
                EdmUtils.addAsObject((Object)agent, ProfessionOrOccupation.class, ag.getRdaGr2ProfessionOrOccupation());
                EdmUtils.addAsList(agent, SameAs.class, ag.getOwlSameAs(), new String[0]);
                agentList.add(agent);
            }
            rdf.setAgentList(agentList);
        }
    }

    private static void addConceptChoice(List<Concept.Choice> choices, Class<? extends LiteralType> clazz, Map<String, List<String>> map) {
        if (map != null && !map.isEmpty()) {
            try {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    Method method = Concept.Choice.class.getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                    LiteralType.Lang lang = null;
                    if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)"def", (String)entry.getKey())) {
                        lang = new LiteralType.Lang();
                        lang.setLang(entry.getKey());
                    }
                    for (String str : entry.getValue()) {
                        if (!StringUtils.isNotBlank((String)str)) continue;
                        LiteralType obj = clazz.newInstance();
                        obj.setString(str);
                        obj.setLang(lang);
                        Concept.Choice ch = new Concept.Choice();
                        method.invoke((Object)ch, obj);
                        choices.add(ch);
                    }
                }
            }
            catch (SecurityException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InstantiationException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
        }
    }

    private static void addConceptChoice(List<Concept.Choice> choices, Class<? extends ResourceType> clazz, String[] array) {
        if (StringArrayUtils.isNotBlank((String[])array)) {
            try {
                Method method = Concept.Choice.class.getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                for (String str : array) {
                    if (!StringUtils.isNotBlank((String)str)) continue;
                    ResourceType obj = clazz.newInstance();
                    obj.setResource(str);
                    Concept.Choice ch = new Concept.Choice();
                    method.invoke((Object)ch, obj);
                    choices.add(ch);
                }
            }
            catch (SecurityException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InstantiationException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
        }
    }

    private static void addEuropeanaTypeChoice(List<EuropeanaType.Choice> dcChoices, Class<? extends ResourceOrLiteralType> clazz, Map<String, List<String>> entries) {
        if (entries != null && !entries.isEmpty()) {
            try {
                Method method = EuropeanaType.Choice.class.getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                for (Map.Entry<String, List<String>> entry : entries.entrySet()) {
                    ResourceOrLiteralType.Lang lang = null;
                    if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)"def", (String)entry.getKey())) {
                        lang = new ResourceOrLiteralType.Lang();
                        lang.setLang(entry.getKey());
                    }
                    for (String str : entry.getValue()) {
                        if (!StringUtils.isNotBlank((String)str)) continue;
                        ResourceOrLiteralType obj = clazz.newInstance();
                        if (EdmUtils.isUri(str)) {
                            ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
                            resource.setResource(str);
                            obj.setResource(resource);
                            obj.setString("");
                        } else {
                            obj.setString(str);
                        }
                        obj.setLang(lang);
                        EuropeanaType.Choice ch = new EuropeanaType.Choice();
                        method.invoke((Object)ch, obj);
                        dcChoices.add(ch);
                    }
                }
            }
            catch (SecurityException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InstantiationException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
        }
    }

    private static void addEuropeanaTypeChoiceLiteral(List<EuropeanaType.Choice> dcChoices, Class<? extends LiteralType> clazz, Map<String, List<String>> entries) {
        if (entries != null && !entries.isEmpty()) {
            try {
                Method method = EuropeanaType.Choice.class.getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                for (Map.Entry<String, List<String>> entry : entries.entrySet()) {
                    LiteralType.Lang lang = null;
                    if (StringUtils.isNotBlank((String)entry.getKey()) && !StringUtils.equals((String)"def", (String)entry.getKey())) {
                        lang = new LiteralType.Lang();
                        lang.setLang(entry.getKey());
                    }
                    for (String str : entry.getValue()) {
                        if (!StringUtils.isNotBlank((String)str)) continue;
                        LiteralType obj = clazz.newInstance();
                        obj.setString(str);
                        obj.setLang(lang);
                        EuropeanaType.Choice ch = new EuropeanaType.Choice();
                        method.invoke((Object)ch, obj);
                        dcChoices.add(ch);
                    }
                }
            }
            catch (SecurityException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
            catch (InstantiationException e) {
                log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
            }
        }
    }

    private static boolean addAsObject(Object dest, Class<? extends ResourceType> clazz, String str) {
        try {
            if (StringUtils.isNotBlank((String)str)) {
                Method method = dest.getClass().getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                ResourceType obj = clazz.newInstance();
                if (EdmUtils.isUri(str)) {
                    obj.setResource(str);
                } else {
                    obj.setResource(PREFIX + str);
                }
                method.invoke(dest, obj);
                return true;
            }
        }
        catch (SecurityException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        catch (InstantiationException e) {
            log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
        }
        return false;
    }

    private static <T> boolean addAsObject(Object dest, Class<T> clazz, Map<String, List<String>> map) {
        try {
            T obj;
            if (map != null && !map.isEmpty() && (obj = EdmUtils.convertMapToObj(clazz, map)) != null) {
                Method method = dest.getClass().getMethod(EdmUtils.getSetterMethodName(clazz, false), clazz);
                method.invoke(dest, obj);
                return true;
            }
        }
        catch (SecurityException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        return false;
    }

    private static <T> boolean addAsList(Object dest, Class<T> clazz, Map<String, List<String>> map) {
        try {
            if (map != null && !map.isEmpty()) {
                Method method = dest.getClass().getMethod(EdmUtils.getSetterMethodName(clazz, true), List.class);
                method.invoke(dest, EdmUtils.convertListFromMap(clazz, map));
                return true;
            }
        }
        catch (SecurityException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        return false;
    }

    private static <T> boolean addAsList(Object dest, Class<T> clazz, String[] vals, String ... prefix) {
        try {
            if (StringArrayUtils.isNotBlank((String[])vals)) {
                Method method = dest.getClass().getMethod(EdmUtils.getSetterMethodName(clazz, true), List.class);
                if (prefix.length == 1) {
                    String[] valNew = new String[vals.length];
                    int i = 0;
                    for (String val : vals) {
                        valNew[i] = prefix + val;
                        ++i;
                    }
                    method.invoke(dest, EdmUtils.convertListFromArray(clazz, valNew));
                } else {
                    method.invoke(dest, EdmUtils.convertListFromArray(clazz, vals));
                }
                return true;
            }
        }
        catch (SecurityException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (InvocationTargetException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        return false;
    }

    private static String getSetterMethodName(Class<?> clazz, boolean list) {
        StringBuilder sb = new StringBuilder("set");
        String clazzName = clazz.getSimpleName();
        if (StringUtils.equals((String)"Rights", (String)clazzName) && list) {
            clazzName = "Right";
        }
        if (StringUtils.equals((String)"SameAs", (String)clazzName) && list) {
            clazzName = "SameA";
        }
        if (StringUtils.equals((String)"Aggregates", (String)clazzName) && list) {
            clazzName = "Aggregate";
        }
        if (StringUtils.equals((String)"Incorporates", (String)clazzName) && list) {
            clazzName = "Incorporate";
        }
        clazzName = StringUtils.strip((String)clazzName, (String)"_1");
        clazzName = StringUtils.strip((String)clazzName, (String)"1");
        sb.append(clazzName);
        if (list) {
            sb.append("List");
        }
        return sb.toString();
    }

    private static <T> List<T> convertListFromArray(Class<T> clazz, String[] vals) {
        ArrayList<T> tList = new ArrayList<T>();
        try {
            if (vals != null) {
                for (String str : vals) {
                    T obj = clazz.newInstance();
                    ((ResourceType)obj).setResource(str);
                    tList.add(obj);
                }
                return tList;
            }
        }
        catch (SecurityException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (InstantiationException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        catch (IllegalAccessException e) {
            log.severe(e.getClass().getSimpleName() + SPACE + e.getMessage());
        }
        return null;
    }

    private static <T> List<T> convertListFromMap(Class<T> clazz, Map<String, List<String>> map) {
        if (map != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                try {
                    LiteralType t;
                    LiteralType.Lang lang;
                    if (entry.getValue() == null) continue;
                    if (clazz.getSuperclass().isAssignableFrom(ResourceType.class)) {
                        for (String str : entry.getValue()) {
                            ResourceType t2 = (ResourceType)clazz.newInstance();
                            t2.setResource(str);
                            list.add(t2);
                        }
                        continue;
                    }
                    if (clazz.getSuperclass().isAssignableFrom(LiteralType.class)) {
                        lang = null;
                        if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)entry.getKey(), (String)"def")) {
                            lang = new LiteralType.Lang();
                            lang.setLang(entry.getKey());
                        }
                        for (String str : entry.getValue()) {
                            t = (LiteralType)clazz.newInstance();
                            t.setString(str);
                            t.setLang(lang);
                            list.add(t);
                        }
                        continue;
                    }
                    if (!clazz.getSuperclass().isAssignableFrom(ResourceOrLiteralType.class)) continue;
                    lang = null;
                    if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)entry.getKey(), (String)"def") && !StringUtils.equals((String)entry.getKey(), (String)"eur")) {
                        lang = new ResourceOrLiteralType.Lang();
                        lang.setLang(entry.getKey());
                    }
                    for (String str : entry.getValue()) {
                        t = (ResourceOrLiteralType)clazz.newInstance();
                        ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
                        t.setString("");
                        if (EdmUtils.isUri(str)) {
                            resource.setResource(str);
                            t.setResource(resource);
                        } else {
                            t.setString(str);
                            t.setLang((ResourceOrLiteralType.Lang)lang);
                        }
                        list.add(t);
                    }
                }
                catch (SecurityException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (InstantiationException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
            }
            return list;
        }
        return null;
    }

    private static <T> T convertMapToObj(Class<T> clazz, Map<String, List<String>> map) {
        if (map != null) {
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                try {
                    T t = clazz.newInstance();
                    if (clazz.getSuperclass().isAssignableFrom(ResourceType.class)) {
                        ((ResourceType)t).setResource(entry.getValue().get(0));
                        return t;
                    }
                    if (clazz.getSuperclass().isAssignableFrom(ResourceOrLiteralType.class)) {
                        ResourceOrLiteralType.Lang lang = null;
                        if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)entry.getKey(), (String)"def")) {
                            lang = new ResourceOrLiteralType.Lang();
                            lang.setLang(entry.getKey());
                        }
                        ResourceOrLiteralType obj = (ResourceOrLiteralType)t;
                        ResourceOrLiteralType.Resource resource = new ResourceOrLiteralType.Resource();
                        obj.setString("");
                        for (String str : entry.getValue()) {
                            if (EdmUtils.isUri(str)) {
                                resource.setResource(str);
                                obj.setResource(resource);
                                continue;
                            }
                            obj.setString(str);
                            obj.setLang(lang);
                        }
                        return (T)obj;
                    }
                    if (!clazz.getSuperclass().isAssignableFrom(LiteralType.class)) continue;
                    LiteralType.Lang lang = null;
                    if (StringUtils.isNotEmpty((String)entry.getKey()) && !StringUtils.equals((String)entry.getKey(), (String)"def")) {
                        lang = new LiteralType.Lang();
                        lang.setLang(entry.getKey());
                    }
                    LiteralType obj = (LiteralType)t;
                    obj.setString("");
                    for (String str : entry.getValue()) {
                        obj.setString(str);
                    }
                    obj.setLang(lang);
                    return (T)obj;
                }
                catch (SecurityException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (IllegalArgumentException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
                catch (InstantiationException e) {
                    log.severe(e.getClass().getSimpleName() + "  " + e.getMessage());
                }
            }
        }
        return null;
    }

    private static boolean isUri(String str) {
        return StringUtils.startsWith((String)str, (String)"http://") || StringUtils.startsWith((String)str, (String)"https://") || StringUtils.startsWith((String)str, (String)"urn:") || StringUtils.startsWith((String)str, (String)"#");
    }

    static {
        prefix = "";
    }
}

