/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.jibx.ConformsTo;
import eu.europeana.corelib.definitions.jibx.Created;
import eu.europeana.corelib.definitions.jibx.Creator;
import eu.europeana.corelib.definitions.jibx.Description;
import eu.europeana.corelib.definitions.jibx.Extent;
import eu.europeana.corelib.definitions.jibx.Format;
import eu.europeana.corelib.definitions.jibx.HasPart;
import eu.europeana.corelib.definitions.jibx.IsFormatOf;
import eu.europeana.corelib.definitions.jibx.Issued;
import eu.europeana.corelib.definitions.jibx.Rights;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.jibx.Source;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import org.apache.solr.common.SolrInputDocument;

public final class WebResourcesFieldInput {
    public SolrInputDocument createWebResourceSolrFields(WebResourceType webResource, SolrInputDocument solrInputDocument) throws InstantiationException, IllegalAccessException {
        solrInputDocument.addField(EdmLabel.EDM_WEB_RESOURCE.toString(), (Object)webResource.getAbout());
        solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, webResource.getRights(), EdmLabel.WR_EDM_RIGHTS);
        if (webResource.getRightList() != null) {
            for (Rights dcRights : webResource.getRightList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, dcRights, EdmLabel.WR_DC_RIGHTS);
            }
        }
        if (webResource.getIsNextInSequence() != null) {
            solrInputDocument.addField(EdmLabel.WR_EDM_IS_NEXT_IN_SEQUENCE.toString(), (Object)webResource.getIsNextInSequence().getResource());
        }
        if (webResource.getDescriptionList() != null) {
            for (Description description : webResource.getDescriptionList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, description, EdmLabel.WR_DC_DESCRIPTION);
            }
        }
        if (webResource.getFormatList() != null) {
            for (Format format : webResource.getFormatList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, format, EdmLabel.WR_DC_FORMAT);
            }
        }
        if (webResource.getSourceList() != null) {
            for (Source source : webResource.getSourceList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, source, EdmLabel.WR_DC_SOURCE);
            }
        }
        if (webResource.getConformsToList() != null) {
            for (ConformsTo conformsTo : webResource.getConformsToList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, conformsTo, EdmLabel.WR_DCTERMS_CONFORMSTO);
            }
        }
        if (webResource.getCreatedList() != null) {
            for (Created created : webResource.getCreatedList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, created, EdmLabel.WR_DCTERMS_CREATED);
            }
        }
        if (webResource.getExtentList() != null) {
            for (Extent extent : webResource.getExtentList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, extent, EdmLabel.WR_DCTERMS_EXTENT);
            }
        }
        if (webResource.getHasPartList() != null) {
            for (HasPart hasPart : webResource.getHasPartList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, hasPart, EdmLabel.WR_DCTERMS_HAS_PART);
            }
        }
        if (webResource.getIsFormatOfList() != null) {
            for (IsFormatOf isFormatOf : webResource.getIsFormatOfList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, isFormatOf, EdmLabel.WR_DCTERMS_ISFORMATOF);
            }
        }
        if (webResource.getIssuedList() != null) {
            for (Issued issued : webResource.getIssuedList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, issued, EdmLabel.WR_DCTERMS_ISSUED);
            }
        }
        if (webResource.getCreatorList() != null) {
            for (Creator creator : webResource.getCreatorList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, creator, EdmLabel.WR_DC_CREATOR);
            }
        }
        if (webResource.getSameAList() != null) {
            for (SameAs sameAs : webResource.getSameAList()) {
                solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, sameAs, EdmLabel.WR_OWL_SAMEAS);
            }
        }
        return solrInputDocument;
    }

    public WebResourceImpl createWebResourceMongoField(WebResourceType webResource, MongoServer mongoServer) {
        WebResourceImpl mongoWebResource = new WebResourceImpl();
        mongoWebResource.setAbout(webResource.getAbout());
        mongoWebResource.setWebResourceEdmRights(MongoUtils.createResourceMapFromString(webResource.getRights()));
        mongoWebResource.setWebResourceDcRights(MongoUtils.createResourceOrLiteralMapFromList(webResource.getRightList()));
        mongoWebResource.setDcDescription(MongoUtils.createResourceOrLiteralMapFromList(webResource.getDescriptionList()));
        mongoWebResource.setDcFormat(MongoUtils.createResourceOrLiteralMapFromList(webResource.getFormatList()));
        mongoWebResource.setDcCreator(MongoUtils.createResourceOrLiteralMapFromList(webResource.getCreatorList()));
        mongoWebResource.setDcSource(MongoUtils.createResourceOrLiteralMapFromList(webResource.getSourceList()));
        mongoWebResource.setDctermsConformsTo(MongoUtils.createResourceOrLiteralMapFromList(webResource.getConformsToList()));
        mongoWebResource.setDctermsCreated(MongoUtils.createResourceOrLiteralMapFromList(webResource.getCreatedList()));
        mongoWebResource.setDctermsExtent(MongoUtils.createResourceOrLiteralMapFromList(webResource.getExtentList()));
        mongoWebResource.setDctermsHasPart(MongoUtils.createResourceOrLiteralMapFromList(webResource.getHasPartList()));
        mongoWebResource.setDctermsIsFormatOf(MongoUtils.createResourceOrLiteralMapFromList(webResource.getIsFormatOfList()));
        mongoWebResource.setDctermsIssued(MongoUtils.createResourceOrLiteralMapFromList(webResource.getIssuedList()));
        if (webResource.getIsNextInSequence() != null) {
            mongoWebResource.setIsNextInSequence(webResource.getIsNextInSequence().getResource());
        }
        mongoWebResource.setOwlSameAs(SolrUtils.resourceListToArray(webResource.getSameAList()));
        return mongoWebResource;
    }

    public void deleteWebResourceFromMongo(String about, EdmMongoServer mongoServer) {
        MongoUtils.delete(WebResourceImpl.class, about, mongoServer);
    }
}

