/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.HasPart;
import eu.europeana.corelib.definitions.jibx.IsPartOf;
import eu.europeana.corelib.definitions.jibx.Note;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.TimeSpanType;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.solr.utils.updaters.TimespanUpdater;
import org.apache.solr.common.SolrInputDocument;

public final class TimespanFieldInput {
    public SolrInputDocument createTimespanSolrFields(TimeSpanType timespan, SolrInputDocument solrInputDocument) {
        solrInputDocument.addField(EdmLabel.EDM_TIMESPAN.toString(), (Object)timespan.getAbout());
        if (timespan.getAltLabelList() != null) {
            for (AltLabel altLabel : timespan.getAltLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, altLabel, EdmLabel.TS_SKOS_ALT_LABEL);
            }
        }
        if (timespan.getPrefLabelList() != null) {
            for (PrefLabel prefLabel : timespan.getPrefLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, prefLabel, EdmLabel.TS_SKOS_PREF_LABEL);
            }
        }
        if (timespan.getNoteList() != null) {
            for (Note note : timespan.getNoteList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, note, EdmLabel.TS_SKOS_NOTE);
            }
        }
        if (timespan.getBegin() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, timespan.getBegin(), EdmLabel.TS_EDM_BEGIN);
        }
        if (timespan.getEnd() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, timespan.getEnd(), EdmLabel.TS_EDM_END);
        }
        if (timespan.getIsPartOfList() != null) {
            for (IsPartOf isPartOf : timespan.getIsPartOfList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, isPartOf, EdmLabel.TS_DCTERMS_ISPART_OF);
            }
        }
        if (timespan.getHasPartList() != null) {
            for (HasPart hasPart : timespan.getHasPartList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, hasPart, EdmLabel.PL_DCTERMS_HASPART);
            }
        }
        return solrInputDocument;
    }

    public TimespanImpl createTimespanMongoField(TimeSpanType timeSpan, MongoServer mongoServer) {
        TimespanImpl mongoTimespan = (TimespanImpl)((EdmMongoServer)mongoServer).getDatastore().find(TimespanImpl.class).filter("about", (Object)timeSpan.getAbout()).get();
        if (mongoTimespan == null) {
            mongoTimespan = this.createNewTimespan(timeSpan);
            mongoServer.getDatastore().save((Object)mongoTimespan);
        } else {
            mongoTimespan = this.updateTimespan(mongoTimespan, timeSpan, mongoServer);
        }
        return mongoTimespan;
    }

    private TimespanImpl updateTimespan(TimespanImpl mongoTimespan, TimeSpanType timeSpan, MongoServer mongoServer) {
        TimespanUpdater timespanUpdater = new TimespanUpdater();
        timespanUpdater.update(mongoTimespan, timeSpan, mongoServer);
        return (TimespanImpl)((EdmMongoServer)mongoServer).getDatastore().find(TimespanImpl.class).filter("about", (Object)timeSpan.getAbout()).get();
    }

    public TimespanImpl createNewTimespan(TimeSpanType timeSpan) {
        TimespanImpl mongoTimespan = new TimespanImpl();
        mongoTimespan.setAbout(timeSpan.getAbout());
        mongoTimespan.setNote(MongoUtils.createLiteralMapFromList(timeSpan.getNoteList()));
        mongoTimespan.setPrefLabel(MongoUtils.createLiteralMapFromList(timeSpan.getPrefLabelList()));
        mongoTimespan.setAltLabel(MongoUtils.createLiteralMapFromList(timeSpan.getAltLabelList()));
        mongoTimespan.setIsPartOf(MongoUtils.createResourceOrLiteralMapFromList(timeSpan.getIsPartOfList()));
        mongoTimespan.setDctermsHasPart(MongoUtils.createResourceOrLiteralMapFromList(timeSpan.getHasPartList()));
        mongoTimespan.setOwlSameAs(SolrUtils.resourceListToArray(timeSpan.getSameAList()));
        mongoTimespan.setBegin(MongoUtils.createLiteralMapFromString(timeSpan.getBegin()));
        mongoTimespan.setEnd(MongoUtils.createLiteralMapFromString(timeSpan.getEnd()));
        return mongoTimespan;
    }
}

