/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.EuropeanaAggregationType;
import eu.europeana.corelib.definitions.jibx.EuropeanaType;
import eu.europeana.corelib.definitions.jibx.HasType;
import eu.europeana.corelib.definitions.jibx.IsNextInSequence;
import eu.europeana.corelib.definitions.jibx.ProxyType;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.jibx.Year;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.solr.utils.updaters.ProxyUpdater;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;

public final class ProxyFieldInput {
    public SolrInputDocument createProxySolrFields(ProxyType proxy, SolrInputDocument solrInputDocument) throws InstantiationException, IllegalAccessException, MalformedURLException, IOException {
        List europeanaTypeList;
        solrInputDocument.addField(EdmLabel.ORE_PROXY.toString(), (Object)proxy.getAbout());
        solrInputDocument.addField(EdmLabel.PROVIDER_EDM_TYPE.toString(), (Object)SolrUtils.exists(String.class, proxy.getType().getType().xmlValue()).toString());
        solrInputDocument.addField(EdmLabel.PROXY_EDM_CURRENT_LOCATION.toString(), (Object)((ResourceType)SolrUtils.exists(ResourceType.class, proxy.getCurrentLocation())).getResource());
        List seqList = proxy.getIsNextInSequenceList();
        if (seqList != null) {
            for (IsNextInSequence val : seqList) {
                solrInputDocument.addField(EdmLabel.PROXY_EDM_IS_NEXT_IN_SEQUENCE.toString(), (Object)val.getResource());
            }
        }
        solrInputDocument.addField(EdmLabel.PROXY_ORE_PROXY_FOR.toString(), (Object)((ResourceType)SolrUtils.exists(ResourceType.class, proxy.getProxyFor())).getResource());
        solrInputDocument.addField(EdmLabel.PROXY_ORE_PROXY_IN.toString(), (Object)SolrUtils.resourceListToArray(proxy.getProxyInList()));
        if (proxy.getEuropeanaProxy() != null) {
            solrInputDocument.addField(EdmLabel.EDM_ISEUROPEANA_PROXY.toString(), (Object)proxy.getEuropeanaProxy().isEuropeanaProxy());
        }
        if (proxy.getYearList() != null) {
            for (Year year : proxy.getYearList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, year, EdmLabel.PROXY_EDM_YEAR);
            }
        }
        if (proxy.getHasTypeList() != null) {
            for (HasType ht : proxy.getHasTypeList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, ht, EdmLabel.PROXY_EDM_HAS_TYPE);
            }
        }
        if (proxy.getHasMetList() != null) {
            for (HasType ht : proxy.getHasMetList()) {
                solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, ht, EdmLabel.PROXY_EDM_HAS_MET);
            }
        }
        if ((europeanaTypeList = proxy.getChoiceList()) != null) {
            for (EuropeanaType.Choice choice : europeanaTypeList) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, choice.getAlternative(), EdmLabel.PROXY_DCTERMS_ALTERNATIVE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getConformsTo(), EdmLabel.PROXY_DCTERMS_CONFORMS_TO);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getCreated(), EdmLabel.PROXY_DCTERMS_CREATED);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getExtent(), EdmLabel.PROXY_DCTERMS_EXTENT);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getHasFormat(), EdmLabel.PROXY_DCTERMS_HAS_FORMAT);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getHasPart(), EdmLabel.PROXY_DCTERMS_HAS_PART);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getHasVersion(), EdmLabel.PROXY_DCTERMS_HAS_VERSION);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsFormatOf(), EdmLabel.PROXY_DCTERMS_IS_FORMAT_OF);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsPartOf(), EdmLabel.PROXY_DCTERMS_IS_PART_OF);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsReferencedBy(), EdmLabel.PROXY_DCTERMS_IS_REFERENCED_BY);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsReplacedBy(), EdmLabel.PROXY_DCTERMS_IS_REPLACED_BY);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsRequiredBy(), EdmLabel.PROXY_DCTERMS_IS_REQUIRED_BY);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIssued(), EdmLabel.PROXY_DCTERMS_ISSUED);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getIsVersionOf(), EdmLabel.PROXY_DCTERMS_IS_VERSION_OF);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getMedium(), EdmLabel.PROXY_DCTERMS_MEDIUM);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getProvenance(), EdmLabel.PROXY_DCTERMS_PROVENANCE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getReferences(), EdmLabel.PROXY_DCTERMS_REFERENCES);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getReplaces(), EdmLabel.PROXY_DCTERMS_REPLACES);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getRequires(), EdmLabel.PROXY_DCTERMS_REQUIRES);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getSpatial(), EdmLabel.PROXY_DCTERMS_SPATIAL);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getTableOfContents(), EdmLabel.PROXY_DCTERMS_TABLE_OF_CONTENTS);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getTemporal(), EdmLabel.PROXY_DCTERMS_TEMPORAL);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getContributor(), EdmLabel.PROXY_DC_CONTRIBUTOR);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getCoverage(), EdmLabel.PROXY_DC_COVERAGE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getCreator(), EdmLabel.PROXY_DC_CREATOR);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getDate(), EdmLabel.PROXY_DC_DATE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getDescription(), EdmLabel.PROXY_DC_DESCRIPTION);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getFormat(), EdmLabel.PROXY_DC_FORMAT);
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, choice.getIdentifier(), EdmLabel.PROXY_DC_IDENTIFIER);
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, choice.getLanguage(), EdmLabel.PROXY_DC_LANGUAGE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getPublisher(), EdmLabel.PROXY_DC_PUBLISHER);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getRelation(), EdmLabel.PROXY_DC_RELATION);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getRights(), EdmLabel.PROXY_DC_RIGHTS);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getSource(), EdmLabel.PROXY_DC_SOURCE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getSubject(), EdmLabel.PROXY_DC_SUBJECT);
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, choice.getTitle(), EdmLabel.PROXY_DC_TITLE);
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, choice.getType(), EdmLabel.PROXY_DC_TYPE);
            }
        }
        return solrInputDocument;
    }

    public ProxyImpl createProxyMongoFields(ProxyImpl mongoProxy, ProxyType proxy, MongoServer mongoServer) throws InstantiationException, IllegalAccessException, MalformedURLException, IOException {
        ProxyImpl retProxy;
        mongoProxy.setAbout(proxy.getAbout());
        if (proxy.getEuropeanaProxy() != null) {
            mongoProxy.setEuropeanaProxy(proxy.getEuropeanaProxy().isEuropeanaProxy());
        }
        mongoProxy.setEdmCurrentLocation(((ResourceType)SolrUtils.exists(ResourceType.class, proxy.getCurrentLocation())).getResource());
        List seqList = proxy.getIsNextInSequenceList();
        if (seqList != null) {
            String[] seqarray = new String[seqList.size()];
            for (int i = 0; i < seqarray.length; ++i) {
                seqarray[i] = ((IsNextInSequence)seqList.get(i)).getResource();
            }
            mongoProxy.setEdmIsNextInSequence(seqarray);
        }
        String docType = SolrUtils.exists(String.class, proxy.getType().getType().xmlValue()).toString();
        mongoProxy.setEdmType(DocType.safeValueOf((String)docType));
        mongoProxy.setProxyFor(SolrUtils.exists(String.class, proxy.getProxyFor().getResource()));
        mongoProxy.setProxyIn(SolrUtils.resourceListToArray(proxy.getProxyInList()));
        mongoProxy.setEdmHasMet(MongoUtils.createResourceMapFromList(proxy.getHasMetList()));
        mongoProxy.setYear(MongoUtils.createLiteralMapFromList(proxy.getYearList()));
        mongoProxy.setEdmHasType(MongoUtils.createResourceOrLiteralMapFromList(proxy.getHasTypeList()));
        mongoProxy.setEdmIncorporates(SolrUtils.resourceListToArray(proxy.getIncorporateList()));
        mongoProxy.setEdmIsDerivativeOf(SolrUtils.resourceListToArray(proxy.getIsDerivativeOfList()));
        mongoProxy.setEdmIsRelatedTo(MongoUtils.createResourceOrLiteralMapFromList(proxy.getIsRelatedToList()));
        if (proxy.getIsRepresentationOf() != null) {
            mongoProxy.setEdmIsRepresentationOf(proxy.getIsRepresentationOf().getResource());
        }
        mongoProxy.setEdmIsSimilarTo(SolrUtils.resourceListToArray(proxy.getIsSimilarToList()));
        mongoProxy.setEdmRealizes(SolrUtils.resourceListToArray(proxy.getRealizeList()));
        mongoProxy.setEdmIsSuccessorOf(SolrUtils.resourceListToArray(proxy.getIsSuccessorOfList()));
        List europeanaTypeList = proxy.getChoiceList();
        if (europeanaTypeList != null) {
            for (EuropeanaType.Choice europeanaType : europeanaTypeList) {
                List<String> values;
                Map<String, List<String>> retMap;
                Map<String, List<String>> tempMap;
                if (europeanaType.ifAlternative()) {
                    if (mongoProxy.getDctermsAlternative() == null) {
                        mongoProxy.setDctermsAlternative(MongoUtils.createLiteralMapFromString(europeanaType.getAlternative()));
                    } else {
                        tempMap = mongoProxy.getDctermsAlternative();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getAlternative());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsAlternative(tempMap);
                    }
                }
                if (europeanaType.ifConformsTo()) {
                    if (mongoProxy.getDctermsConformsTo() == null) {
                        mongoProxy.setDctermsConformsTo(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getConformsTo()));
                    } else {
                        tempMap = mongoProxy.getDctermsConformsTo();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getConformsTo());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsConformsTo(tempMap);
                    }
                }
                if (europeanaType.ifCreated()) {
                    if (mongoProxy.getDctermsCreated() == null) {
                        mongoProxy.setDctermsCreated(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreated()));
                    } else {
                        tempMap = mongoProxy.getDctermsCreated();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreated());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsCreated(tempMap);
                    }
                }
                if (europeanaType.ifExtent()) {
                    if (mongoProxy.getDctermsExtent() == null) {
                        mongoProxy.setDctermsExtent(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getExtent()));
                    } else {
                        tempMap = mongoProxy.getDctermsExtent();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getExtent());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsExtent(tempMap);
                    }
                }
                if (europeanaType.ifHasFormat()) {
                    if (mongoProxy.getDctermsHasFormat() == null) {
                        mongoProxy.setDctermsHasFormat(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasFormat()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasFormat();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasFormat());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasFormat(tempMap);
                    }
                }
                if (europeanaType.ifHasPart()) {
                    if (mongoProxy.getDctermsHasPart() == null) {
                        mongoProxy.setDctermsHasPart(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasPart()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasPart();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasPart());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasPart(tempMap);
                    }
                }
                if (europeanaType.ifHasVersion()) {
                    if (mongoProxy.getDctermsHasVersion() == null) {
                        mongoProxy.setDctermsHasVersion(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasVersion()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasVersion();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasVersion());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasVersion(tempMap);
                    }
                }
                if (europeanaType.ifIsFormatOf()) {
                    if (mongoProxy.getDctermsIsFormatOf() == null) {
                        mongoProxy.setDctermsIsFormatOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsFormatOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsFormatOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsFormatOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsFormatOf(tempMap);
                    }
                }
                if (europeanaType.ifIsPartOf()) {
                    if (mongoProxy.getDctermsIsPartOf() == null) {
                        mongoProxy.setDctermsIsPartOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsPartOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsPartOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsPartOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsPartOf(tempMap);
                    }
                }
                if (europeanaType.ifIsReferencedBy()) {
                    if (mongoProxy.getDctermsIsReferencedBy() == null) {
                        mongoProxy.setDctermsIsReferencedBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReferencedBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsReferencedBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReferencedBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsReferencedBy(tempMap);
                    }
                }
                if (europeanaType.ifIsReplacedBy()) {
                    if (mongoProxy.getDctermsIsReplacedBy() == null) {
                        mongoProxy.setDctermsIsReplacedBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReplacedBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsReplacedBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReplacedBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsReplacedBy(tempMap);
                    }
                }
                if (europeanaType.ifIsRequiredBy()) {
                    if (mongoProxy.getDctermsIsRequiredBy() == null) {
                        mongoProxy.setDctermsIsRequiredBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsRequiredBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsRequiredBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsRequiredBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsRequiredBy(tempMap);
                    }
                }
                if (europeanaType.ifIssued()) {
                    if (mongoProxy.getDctermsIssued() == null) {
                        mongoProxy.setDctermsIssued(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIssued()));
                    } else {
                        tempMap = mongoProxy.getDctermsIssued();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIssued());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIssued(tempMap);
                    }
                }
                if (europeanaType.ifIsVersionOf()) {
                    if (mongoProxy.getDctermsIsVersionOf() == null) {
                        mongoProxy.setDctermsIsVersionOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsVersionOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsVersionOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsVersionOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsVersionOf(tempMap);
                    }
                }
                if (europeanaType.ifMedium()) {
                    if (mongoProxy.getDctermsMedium() == null) {
                        mongoProxy.setDctermsMedium(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getMedium()));
                    } else {
                        tempMap = mongoProxy.getDctermsMedium();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getMedium());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsMedium(tempMap);
                    }
                }
                if (europeanaType.ifProvenance()) {
                    if (mongoProxy.getDctermsProvenance() == null) {
                        mongoProxy.setDctermsProvenance(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getProvenance()));
                    } else {
                        tempMap = mongoProxy.getDctermsProvenance();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getProvenance());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsProvenance(tempMap);
                    }
                }
                if (europeanaType.ifReferences()) {
                    if (mongoProxy.getDctermsReferences() == null) {
                        mongoProxy.setDctermsReferences(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReferences()));
                    } else {
                        tempMap = mongoProxy.getDctermsReferences();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReferences());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsReferences(tempMap);
                    }
                }
                if (europeanaType.ifReplaces()) {
                    if (mongoProxy.getDctermsReplaces() == null) {
                        mongoProxy.setDctermsReplaces(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReplaces()));
                    } else {
                        tempMap = mongoProxy.getDctermsReplaces();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReplaces());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsReplaces(tempMap);
                    }
                }
                if (europeanaType.ifRequires()) {
                    if (mongoProxy.getDctermsRequires() == null) {
                        mongoProxy.setDctermsRequires(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRequires()));
                    } else {
                        tempMap = mongoProxy.getDctermsRequires();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRequires());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsRequires(tempMap);
                    }
                }
                if (europeanaType.ifSpatial()) {
                    if (mongoProxy.getDctermsSpatial() == null) {
                        mongoProxy.setDctermsSpatial(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSpatial()));
                    } else {
                        tempMap = mongoProxy.getDctermsSpatial();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSpatial());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsSpatial(tempMap);
                    }
                }
                if (europeanaType.ifTableOfContents()) {
                    if (mongoProxy.getDctermsTOC() == null) {
                        mongoProxy.setDctermsTOC(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTableOfContents()));
                    } else {
                        tempMap = mongoProxy.getDctermsTOC();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTableOfContents());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsTOC(tempMap);
                    }
                }
                if (europeanaType.ifTemporal()) {
                    if (mongoProxy.getDctermsTemporal() == null) {
                        mongoProxy.setDctermsTemporal(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTemporal()));
                    } else {
                        tempMap = mongoProxy.getDctermsTemporal();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTemporal());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsTemporal(tempMap);
                    }
                }
                if (europeanaType.ifContributor()) {
                    if (mongoProxy.getDcContributor() == null) {
                        mongoProxy.setDcContributor(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getContributor()));
                    } else {
                        tempMap = mongoProxy.getDcContributor();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getContributor());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcContributor(tempMap);
                    }
                }
                if (europeanaType.ifCoverage()) {
                    if (mongoProxy.getDcCoverage() == null) {
                        mongoProxy.setDcCoverage(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCoverage()));
                    } else {
                        tempMap = mongoProxy.getDcCoverage();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCoverage());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcCoverage(tempMap);
                    }
                }
                if (europeanaType.ifCreator()) {
                    if (mongoProxy.getDcCreator() == null) {
                        mongoProxy.setDcCreator(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreator()));
                    } else {
                        tempMap = mongoProxy.getDcCreator();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreator());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcCreator(tempMap);
                    }
                }
                if (europeanaType.ifDate()) {
                    if (mongoProxy.getDcDate() == null) {
                        mongoProxy.setDcDate(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDate()));
                    } else {
                        tempMap = mongoProxy.getDcDate();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDate());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcDate(tempMap);
                    }
                }
                if (europeanaType.ifDescription()) {
                    if (mongoProxy.getDcDescription() == null) {
                        mongoProxy.setDcDescription(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDescription()));
                    } else {
                        tempMap = mongoProxy.getDcDescription();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDescription());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcDescription(tempMap);
                    }
                }
                if (europeanaType.ifFormat()) {
                    if (mongoProxy.getDcFormat() == null) {
                        mongoProxy.setDcFormat(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getFormat()));
                    } else {
                        tempMap = mongoProxy.getDcFormat();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getFormat());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcFormat(tempMap);
                    }
                }
                if (europeanaType.ifIdentifier()) {
                    if (mongoProxy.getDcIdentifier() == null) {
                        mongoProxy.setDcIdentifier(MongoUtils.createLiteralMapFromString(europeanaType.getIdentifier()));
                    } else {
                        tempMap = mongoProxy.getDcIdentifier();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getIdentifier());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcIdentifier(tempMap);
                    }
                }
                if (europeanaType.ifLanguage()) {
                    if (mongoProxy.getDcLanguage() == null) {
                        mongoProxy.setDcLanguage(MongoUtils.createLiteralMapFromString(europeanaType.getLanguage()));
                    } else {
                        tempMap = mongoProxy.getDcLanguage();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getLanguage());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcLanguage(tempMap);
                    }
                }
                if (europeanaType.ifPublisher()) {
                    if (mongoProxy.getDcPublisher() == null) {
                        mongoProxy.setDcPublisher(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getPublisher()));
                    } else {
                        tempMap = mongoProxy.getDcPublisher();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getPublisher());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcPublisher(tempMap);
                    }
                }
                if (europeanaType.ifRelation()) {
                    if (mongoProxy.getDcRelation() == null) {
                        mongoProxy.setDcRelation(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRelation()));
                    } else {
                        tempMap = mongoProxy.getDcRelation();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRelation());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcRelation(tempMap);
                    }
                }
                if (europeanaType.ifRights()) {
                    if (mongoProxy.getDcRights() == null) {
                        mongoProxy.setDcRights(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRights()));
                    } else {
                        tempMap = mongoProxy.getDcRights();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRights());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcRights(tempMap);
                    }
                }
                if (europeanaType.ifSource()) {
                    if (mongoProxy.getDcSource() == null) {
                        mongoProxy.setDcSource(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSource()));
                    } else {
                        tempMap = mongoProxy.getDcSource();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSource());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcSource(tempMap);
                    }
                }
                if (europeanaType.ifSubject()) {
                    if (mongoProxy.getDcSubject() == null) {
                        mongoProxy.setDcSubject(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSubject()));
                    } else {
                        tempMap = mongoProxy.getDcSubject();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSubject());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcSubject(tempMap);
                    }
                }
                if (europeanaType.ifTitle()) {
                    if (mongoProxy.getDcTitle() == null) {
                        mongoProxy.setDcTitle(MongoUtils.createLiteralMapFromString(europeanaType.getTitle()));
                    } else {
                        tempMap = mongoProxy.getDcTitle();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getTitle());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcTitle(tempMap);
                    }
                }
                if (!europeanaType.ifType()) continue;
                if (mongoProxy.getDcType() == null) {
                    mongoProxy.setDcType(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getType()));
                    continue;
                }
                tempMap = mongoProxy.getDcType();
                retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getType());
                for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                    if (tempMap.containsKey(entry.getKey())) {
                        values = tempMap.get(entry.getKey());
                        values.addAll((Collection<String>)retMap.get(entry.getKey()));
                        continue;
                    }
                    tempMap.put(entry.getKey(), entry.getValue());
                }
                mongoProxy.setDcType(tempMap);
            }
        }
        if ((retProxy = (ProxyImpl)((EdmMongoServer)mongoServer).getDatastore().find(ProxyImpl.class).filter("about", (Object)proxy.getAbout()).get()) != null) {
            ProxyUpdater proxyUpdater = new ProxyUpdater();
            proxyUpdater.update(retProxy, mongoProxy, mongoServer);
        } else {
            mongoServer.getDatastore().save((Object)mongoProxy);
        }
        return retProxy != null ? retProxy : mongoProxy;
    }

    public ProxyImpl addProxyForMongo(ProxyImpl proxy, Aggregation aggregation, MongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        if (proxy.getProxyIn() == null) {
            proxy.setProxyIn(new String[]{SolrUtils.exists(String.class, aggregation.getAbout())});
        } else {
            String[] tempProxy = proxy.getProxyIn();
            ArrayList<String> tempList = new ArrayList<String>(Arrays.asList(tempProxy));
            tempList.add(SolrUtils.exists(String.class, aggregation.getAbout()));
            proxy.setProxyIn(tempList.toArray(new String[tempList.size()]));
            proxy.setProxyFor("/item" + aggregation.getAggregatedCHO().getResource());
        }
        proxy.setEuropeanaProxy(false);
        return proxy;
    }

    public ProxyImpl addEuropeanaProxyForMongo(ProxyImpl proxy, EuropeanaAggregationType aggregation, MongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        proxy.setProxyFor("/item" + aggregation.getAggregatedCHO().getResource());
        proxy.setProxyIn(new String[]{SolrUtils.exists(String.class, aggregation.getAbout())});
        proxy.setEuropeanaProxy(true);
        proxy.setAbout("/proxy/europeana/" + aggregation.getAbout());
        mongoServer.getDatastore().save((Object)proxy);
        return proxy;
    }

    public SolrInputDocument addProxyForSolr(Aggregation aggregation, SolrInputDocument solrInputDocument) throws InstantiationException, IllegalAccessException {
        solrInputDocument.addField(EdmLabel.PROXY_ORE_PROXY_IN.toString(), (Object)SolrUtils.exists(String.class, aggregation.getAbout()));
        solrInputDocument.addField(EdmLabel.EDM_ISEUROPEANA_PROXY.toString(), (Object)false);
        return solrInputDocument;
    }

    public SolrInputDocument addProxyForSolr(EuropeanaAggregationType aggregation, SolrInputDocument solrInputDocument) throws InstantiationException, IllegalAccessException {
        solrInputDocument.addField(EdmLabel.PROXY_ORE_PROXY_IN.toString(), (Object)SolrUtils.exists(String.class, aggregation.getAbout()));
        solrInputDocument.addField(EdmLabel.EDM_ISEUROPEANA_PROXY.toString(), (Object)true);
        return solrInputDocument;
    }

    public void deleteProxyFromMongo(String about, EdmMongoServer mongoServer) {
        MongoUtils.delete(ProxyImpl.class, about, mongoServer);
    }

    public ProxyImpl createProxyMongoFields(ProxyImpl mongoProxy, ProxyType proxy) throws InstantiationException, IllegalAccessException, MalformedURLException, IOException {
        mongoProxy.setAbout(proxy.getAbout());
        if (proxy.getEuropeanaProxy() != null) {
            mongoProxy.setEuropeanaProxy(proxy.getEuropeanaProxy().isEuropeanaProxy());
        }
        mongoProxy.setEdmCurrentLocation(((ResourceType)SolrUtils.exists(ResourceType.class, proxy.getCurrentLocation())).getResource());
        List seqList = proxy.getIsNextInSequenceList();
        if (seqList != null) {
            String[] seqarray = new String[seqList.size()];
            for (int i = 0; i < seqarray.length; ++i) {
                seqarray[i] = ((IsNextInSequence)seqList.get(i)).getResource();
            }
            mongoProxy.setEdmIsNextInSequence(seqarray);
        }
        String docType = SolrUtils.exists(String.class, proxy.getType().getType().xmlValue()).toString();
        mongoProxy.setEdmType(DocType.safeValueOf((String)docType));
        mongoProxy.setProxyFor(SolrUtils.exists(String.class, proxy.getProxyFor().getResource()));
        mongoProxy.setProxyIn(SolrUtils.resourceListToArray(proxy.getProxyInList()));
        mongoProxy.setEdmHasMet(MongoUtils.createResourceMapFromList(proxy.getHasMetList()));
        mongoProxy.setYear(MongoUtils.createLiteralMapFromList(proxy.getYearList()));
        mongoProxy.setEdmHasType(MongoUtils.createResourceOrLiteralMapFromList(proxy.getHasTypeList()));
        mongoProxy.setEdmHasType(MongoUtils.createResourceMapFromList(proxy.getHasMetList()));
        mongoProxy.setEdmIncorporates(SolrUtils.resourceListToArray(proxy.getIncorporateList()));
        mongoProxy.setEdmIsDerivativeOf(SolrUtils.resourceListToArray(proxy.getIsDerivativeOfList()));
        mongoProxy.setEdmIsRelatedTo(MongoUtils.createResourceOrLiteralMapFromList(proxy.getIsRelatedToList()));
        if (proxy.getIsRepresentationOf() != null) {
            mongoProxy.setEdmIsRepresentationOf(proxy.getIsRepresentationOf().getResource());
        }
        mongoProxy.setEdmIsSimilarTo(SolrUtils.resourceListToArray(proxy.getIsSimilarToList()));
        mongoProxy.setEdmRealizes(SolrUtils.resourceListToArray(proxy.getRealizeList()));
        mongoProxy.setEdmIsSuccessorOf(SolrUtils.resourceListToArray(proxy.getIsSuccessorOfList()));
        List europeanaTypeList = proxy.getChoiceList();
        if (europeanaTypeList != null) {
            for (EuropeanaType.Choice europeanaType : europeanaTypeList) {
                List<String> values;
                Map<String, List<String>> retMap;
                Map<String, List<String>> tempMap;
                if (europeanaType.ifAlternative()) {
                    if (mongoProxy.getDctermsAlternative() == null) {
                        mongoProxy.setDctermsAlternative(MongoUtils.createLiteralMapFromString(europeanaType.getAlternative()));
                    } else {
                        tempMap = mongoProxy.getDctermsAlternative();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getAlternative());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsAlternative(tempMap);
                    }
                }
                if (europeanaType.ifConformsTo()) {
                    if (mongoProxy.getDctermsConformsTo() == null) {
                        mongoProxy.setDctermsConformsTo(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getConformsTo()));
                    } else {
                        tempMap = mongoProxy.getDctermsConformsTo();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getConformsTo());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsConformsTo(tempMap);
                    }
                }
                if (europeanaType.ifCreated()) {
                    if (mongoProxy.getDctermsCreated() == null) {
                        mongoProxy.setDctermsCreated(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreated()));
                    } else {
                        tempMap = mongoProxy.getDctermsCreated();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreated());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsCreated(tempMap);
                    }
                }
                if (europeanaType.ifExtent()) {
                    if (mongoProxy.getDctermsExtent() == null) {
                        mongoProxy.setDctermsExtent(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getExtent()));
                    } else {
                        tempMap = mongoProxy.getDctermsExtent();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getExtent());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsExtent(tempMap);
                    }
                }
                if (europeanaType.ifHasFormat()) {
                    if (mongoProxy.getDctermsHasFormat() == null) {
                        mongoProxy.setDctermsHasFormat(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasFormat()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasFormat();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasFormat());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasFormat(tempMap);
                    }
                }
                if (europeanaType.ifHasPart()) {
                    if (mongoProxy.getDctermsHasPart() == null) {
                        mongoProxy.setDctermsHasPart(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasPart()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasPart();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasPart());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasPart(tempMap);
                    }
                }
                if (europeanaType.ifHasVersion()) {
                    if (mongoProxy.getDctermsHasVersion() == null) {
                        mongoProxy.setDctermsHasVersion(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasVersion()));
                    } else {
                        tempMap = mongoProxy.getDctermsHasVersion();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getHasVersion());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsHasVersion(tempMap);
                    }
                }
                if (europeanaType.ifIsFormatOf()) {
                    if (mongoProxy.getDctermsIsFormatOf() == null) {
                        mongoProxy.setDctermsIsFormatOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsFormatOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsFormatOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsFormatOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsFormatOf(tempMap);
                    }
                }
                if (europeanaType.ifIsPartOf()) {
                    if (mongoProxy.getDctermsIsPartOf() == null) {
                        mongoProxy.setDctermsIsPartOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsPartOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsPartOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsPartOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsPartOf(tempMap);
                    }
                }
                if (europeanaType.ifIsReferencedBy()) {
                    if (mongoProxy.getDctermsIsReferencedBy() == null) {
                        mongoProxy.setDctermsIsReferencedBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReferencedBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsReferencedBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReferencedBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsReferencedBy(tempMap);
                    }
                }
                if (europeanaType.ifIsReplacedBy()) {
                    if (mongoProxy.getDctermsIsReplacedBy() == null) {
                        mongoProxy.setDctermsIsReplacedBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReplacedBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsReplacedBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsReplacedBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsReplacedBy(tempMap);
                    }
                }
                if (europeanaType.ifIsRequiredBy()) {
                    if (mongoProxy.getDctermsIsRequiredBy() == null) {
                        mongoProxy.setDctermsIsRequiredBy(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsRequiredBy()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsRequiredBy();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsRequiredBy());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsRequiredBy(tempMap);
                    }
                }
                if (europeanaType.ifIssued()) {
                    if (mongoProxy.getDctermsIssued() == null) {
                        mongoProxy.setDctermsIssued(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIssued()));
                    } else {
                        tempMap = mongoProxy.getDctermsIssued();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIssued());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIssued(tempMap);
                    }
                }
                if (europeanaType.ifIsVersionOf()) {
                    if (mongoProxy.getDctermsIsVersionOf() == null) {
                        mongoProxy.setDctermsIsVersionOf(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsVersionOf()));
                    } else {
                        tempMap = mongoProxy.getDctermsIsVersionOf();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getIsVersionOf());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsIsVersionOf(tempMap);
                    }
                }
                if (europeanaType.ifMedium()) {
                    if (mongoProxy.getDctermsMedium() == null) {
                        mongoProxy.setDctermsMedium(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getMedium()));
                    } else {
                        tempMap = mongoProxy.getDctermsMedium();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getMedium());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsMedium(tempMap);
                    }
                }
                if (europeanaType.ifProvenance()) {
                    if (mongoProxy.getDctermsProvenance() == null) {
                        mongoProxy.setDctermsProvenance(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getProvenance()));
                    } else {
                        tempMap = mongoProxy.getDctermsProvenance();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getProvenance());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsProvenance(tempMap);
                    }
                }
                if (europeanaType.ifReferences()) {
                    if (mongoProxy.getDctermsReferences() == null) {
                        mongoProxy.setDctermsReferences(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReferences()));
                    } else {
                        tempMap = mongoProxy.getDctermsReferences();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReferences());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsReferences(tempMap);
                    }
                }
                if (europeanaType.ifReplaces()) {
                    if (mongoProxy.getDctermsReplaces() == null) {
                        mongoProxy.setDctermsReplaces(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReplaces()));
                    } else {
                        tempMap = mongoProxy.getDctermsReplaces();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getReplaces());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsReplaces(tempMap);
                    }
                }
                if (europeanaType.ifRequires()) {
                    if (mongoProxy.getDctermsRequires() == null) {
                        mongoProxy.setDctermsRequires(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRequires()));
                    } else {
                        tempMap = mongoProxy.getDctermsRequires();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRequires());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsRequires(tempMap);
                    }
                }
                if (europeanaType.ifSpatial()) {
                    if (mongoProxy.getDctermsSpatial() == null) {
                        mongoProxy.setDctermsSpatial(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSpatial()));
                    } else {
                        tempMap = mongoProxy.getDctermsSpatial();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSpatial());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsSpatial(tempMap);
                    }
                }
                if (europeanaType.ifTableOfContents()) {
                    if (mongoProxy.getDctermsTOC() == null) {
                        mongoProxy.setDctermsTOC(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTableOfContents()));
                    } else {
                        tempMap = mongoProxy.getDctermsTOC();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTableOfContents());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsTOC(tempMap);
                    }
                }
                if (europeanaType.ifTemporal()) {
                    if (mongoProxy.getDctermsTemporal() == null) {
                        mongoProxy.setDctermsTemporal(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTemporal()));
                    } else {
                        tempMap = mongoProxy.getDctermsTemporal();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getTemporal());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDctermsTemporal(tempMap);
                    }
                }
                if (europeanaType.ifContributor()) {
                    if (mongoProxy.getDcContributor() == null) {
                        mongoProxy.setDcContributor(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getContributor()));
                    } else {
                        tempMap = mongoProxy.getDcContributor();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getContributor());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcContributor(tempMap);
                    }
                }
                if (europeanaType.ifCoverage()) {
                    if (mongoProxy.getDcCoverage() == null) {
                        mongoProxy.setDcCoverage(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCoverage()));
                    } else {
                        tempMap = mongoProxy.getDcCoverage();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCoverage());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcCoverage(tempMap);
                    }
                }
                if (europeanaType.ifCreator()) {
                    if (mongoProxy.getDcCreator() == null) {
                        mongoProxy.setDcCreator(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreator()));
                    } else {
                        tempMap = mongoProxy.getDcCreator();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getCreator());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcCreator(tempMap);
                    }
                }
                if (europeanaType.ifDate()) {
                    if (mongoProxy.getDcDate() == null) {
                        mongoProxy.setDcDate(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDate()));
                    } else {
                        tempMap = mongoProxy.getDcDate();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDate());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcDate(tempMap);
                    }
                }
                if (europeanaType.ifDescription()) {
                    if (mongoProxy.getDcDescription() == null) {
                        mongoProxy.setDcDescription(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDescription()));
                    } else {
                        tempMap = mongoProxy.getDcDescription();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getDescription());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcDescription(tempMap);
                    }
                }
                if (europeanaType.ifFormat()) {
                    if (mongoProxy.getDcFormat() == null) {
                        mongoProxy.setDcFormat(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getFormat()));
                    } else {
                        tempMap = mongoProxy.getDcFormat();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getFormat());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcFormat(tempMap);
                    }
                }
                if (europeanaType.ifIdentifier()) {
                    if (mongoProxy.getDcIdentifier() == null) {
                        mongoProxy.setDcIdentifier(MongoUtils.createLiteralMapFromString(europeanaType.getIdentifier()));
                    } else {
                        tempMap = mongoProxy.getDcIdentifier();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getIdentifier());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcIdentifier(tempMap);
                    }
                }
                if (europeanaType.ifLanguage()) {
                    if (mongoProxy.getDcLanguage() == null) {
                        mongoProxy.setDcLanguage(MongoUtils.createLiteralMapFromString(europeanaType.getLanguage()));
                    } else {
                        tempMap = mongoProxy.getDcLanguage();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getLanguage());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcLanguage(tempMap);
                    }
                }
                if (europeanaType.ifPublisher()) {
                    if (mongoProxy.getDcPublisher() == null) {
                        mongoProxy.setDcPublisher(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getPublisher()));
                    } else {
                        tempMap = mongoProxy.getDcPublisher();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getPublisher());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcPublisher(tempMap);
                    }
                }
                if (europeanaType.ifRelation()) {
                    if (mongoProxy.getDcRelation() == null) {
                        mongoProxy.setDcRelation(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRelation()));
                    } else {
                        tempMap = mongoProxy.getDcRelation();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRelation());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcRelation(tempMap);
                    }
                }
                if (europeanaType.ifRights()) {
                    if (mongoProxy.getDcRights() == null) {
                        mongoProxy.setDcRights(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRights()));
                    } else {
                        tempMap = mongoProxy.getDcRights();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getRights());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcRights(tempMap);
                    }
                }
                if (europeanaType.ifSource()) {
                    if (mongoProxy.getDcSource() == null) {
                        mongoProxy.setDcSource(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSource()));
                    } else {
                        tempMap = mongoProxy.getDcSource();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSource());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcSource(tempMap);
                    }
                }
                if (europeanaType.ifSubject()) {
                    if (mongoProxy.getDcSubject() == null) {
                        mongoProxy.setDcSubject(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSubject()));
                    } else {
                        tempMap = mongoProxy.getDcSubject();
                        retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getSubject());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcSubject(tempMap);
                    }
                }
                if (europeanaType.ifTitle()) {
                    if (mongoProxy.getDcTitle() == null) {
                        mongoProxy.setDcTitle(MongoUtils.createLiteralMapFromString(europeanaType.getTitle()));
                    } else {
                        tempMap = mongoProxy.getDcTitle();
                        retMap = MongoUtils.createLiteralMapFromString(europeanaType.getTitle());
                        for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                            if (tempMap.containsKey(entry.getKey())) {
                                values = tempMap.get(entry.getKey());
                                values.addAll((Collection<String>)retMap.get(entry.getKey()));
                                continue;
                            }
                            tempMap.put(entry.getKey(), entry.getValue());
                        }
                        mongoProxy.setDcTitle(tempMap);
                    }
                }
                if (!europeanaType.ifType()) continue;
                if (mongoProxy.getDcType() == null) {
                    mongoProxy.setDcType(MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getType()));
                    continue;
                }
                tempMap = mongoProxy.getDcType();
                retMap = MongoUtils.createResourceOrLiteralMapFromString(europeanaType.getType());
                for (Map.Entry<String, List<String>> entry : retMap.entrySet()) {
                    if (tempMap.containsKey(entry.getKey())) {
                        values = tempMap.get(entry.getKey());
                        values.addAll((Collection<String>)retMap.get(entry.getKey()));
                        continue;
                    }
                    tempMap.put(entry.getKey(), entry.getValue());
                }
                mongoProxy.setDcType(tempMap);
            }
        }
        return mongoProxy;
    }
}

