/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.jibx.ProvidedCHOType;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.entity.ProvidedCHOImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public final class ProvidedCHOFieldInput {
    public SolrInputDocument createProvidedCHOFields(ProvidedCHOType providedCHO, SolrInputDocument solrInputDocument) throws InstantiationException, IllegalAccessException {
        solrInputDocument.addField(EdmLabel.EUROPEANA_ID.toString(), (Object)providedCHO.getAbout());
        if (providedCHO.getSameAList() != null) {
            for (SameAs sameAs : providedCHO.getSameAList()) {
                solrInputDocument.addField(EdmLabel.PROXY_OWL_SAMEAS.toString(), (Object)sameAs.getResource());
            }
        }
        solrInputDocument.addField(EdmLabel.EUROPEANA_COLLECTIONNAME.toString(), (Object)StringUtils.substringBetween((String)providedCHO.getAbout(), (String)"/", (String)"/"));
        return solrInputDocument;
    }

    public ProvidedCHOImpl createProvidedCHOMongoFields(ProvidedCHOType providedCHO, EdmMongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        ProvidedCHOImpl mongoProvidedCHO = (ProvidedCHOImpl)mongoServer.getDatastore().find(ProvidedCHOImpl.class).filter("about", (Object)("/item" + providedCHO.getAbout())).get();
        if (mongoProvidedCHO == null) {
            mongoProvidedCHO = new ProvidedCHOImpl();
            mongoProvidedCHO.setAbout("/item" + providedCHO.getAbout());
            mongoProvidedCHO.setOwlSameAs(SolrUtils.resourceListToArray(providedCHO.getSameAList()));
            mongoServer.getDatastore().save((Object)mongoProvidedCHO);
        } else {
            ArrayList<String> owlSameAsList = null;
            if (providedCHO.getSameAList() != null) {
                owlSameAsList = new ArrayList<String>();
                for (SameAs sameAs : providedCHO.getSameAList()) {
                    owlSameAsList.add(sameAs.getResource());
                }
                Query query = mongoServer.getDatastore().createQuery(ProvidedCHOImpl.class).filter("about", (Object)providedCHO.getAbout());
                UpdateOperations ops = mongoServer.getDatastore().createUpdateOperations(ProvidedCHOImpl.class);
                ops.set("owlSameAs", owlSameAsList);
                mongoServer.getDatastore().update(query, ops);
            }
        }
        return mongoProvidedCHO;
    }

    public void deleteProvideCHOFromMongo(String about, EdmMongoServer mongoServer) {
        MongoUtils.delete(ProvidedCHOImpl.class, about, mongoServer);
    }

    public ProvidedCHOImpl createProvidedCHOMongoFields(ProvidedCHOType providedCHO) throws InstantiationException, IllegalAccessException {
        ProvidedCHOImpl mongoProvidedCHO = new ProvidedCHOImpl();
        mongoProvidedCHO.setAbout("/item" + providedCHO.getAbout());
        mongoProvidedCHO.setOwlSameAs(SolrUtils.resourceListToArray(providedCHO.getSameAList()));
        return mongoProvidedCHO;
    }
}

