/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.HasPart;
import eu.europeana.corelib.definitions.jibx.IsPartOf;
import eu.europeana.corelib.definitions.jibx.Note;
import eu.europeana.corelib.definitions.jibx.PlaceType;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.solr.utils.updaters.PlaceUpdater;
import org.apache.solr.common.SolrInputDocument;

public final class PlaceFieldInput {
    public SolrInputDocument createPlaceSolrFields(PlaceType place, SolrInputDocument solrInputDocument) {
        solrInputDocument.addField(EdmLabel.EDM_PLACE.toString(), (Object)place.getAbout());
        if (place.getAltLabelList() != null) {
            for (AltLabel altLabel : place.getAltLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, altLabel, EdmLabel.PL_SKOS_ALT_LABEL);
            }
        }
        if (place.getPrefLabelList() != null) {
            for (PrefLabel prefLabel : place.getPrefLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, prefLabel, EdmLabel.PL_SKOS_PREF_LABEL);
            }
        }
        if (place.getIsPartOfList() != null) {
            for (IsPartOf isPartOf : place.getIsPartOfList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, isPartOf, EdmLabel.PL_DCTERMS_ISPART_OF);
            }
        }
        if (place.getNoteList() != null) {
            for (Note note : place.getNoteList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, note, EdmLabel.PL_SKOS_NOTE);
            }
        }
        if (place.getLong() != null && place.getLat() != null) {
            solrInputDocument.addField(EdmLabel.PL_WGS84_POS_LAT_LONG.toString(), (Object)(place.getLat().getLat() + "," + place.getLong().getLong()));
            solrInputDocument.addField(EdmLabel.PL_WGS84_POS_LAT.toString(), (Object)place.getLat().getLat());
            solrInputDocument.addField(EdmLabel.PL_WGS84_POS_LONG.toString(), (Object)place.getLong().getLong());
        }
        if (place.getAlt() != null) {
            solrInputDocument.addField(EdmLabel.PL_WGS84_POS_ALT.toString(), (Object)place.getAlt().getAlt());
        }
        if (place.getHasPartList() != null) {
            for (HasPart hasPart : place.getHasPartList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, hasPart, EdmLabel.PL_DCTERMS_HASPART);
            }
        }
        if (place.getSameAList() != null) {
            for (SameAs sameAs : place.getSameAList()) {
                solrInputDocument.addField(EdmLabel.PL_OWL_SAMEAS.toString(), (Object)sameAs.getResource());
            }
        }
        return solrInputDocument;
    }

    public PlaceImpl createPlaceMongoFields(PlaceType placeType, MongoServer mongoServer) {
        PlaceImpl place = (PlaceImpl)((EdmMongoServer)mongoServer).getDatastore().find(PlaceImpl.class).filter("about", (Object)placeType.getAbout()).get();
        if (place == null) {
            place = this.createNewPlace(placeType);
            try {
                mongoServer.getDatastore().save((Object)place);
            }
            catch (Exception e) {
                PlaceImpl placeSec = (PlaceImpl)((EdmMongoServer)mongoServer).getDatastore().find(PlaceImpl.class).filter("about", (Object)placeType.getAbout()).get();
                place = this.updatePlace(placeSec, placeType, mongoServer);
            }
        } else {
            place = this.updatePlace(place, placeType, mongoServer);
        }
        return place;
    }

    private PlaceImpl updatePlace(PlaceImpl place, PlaceType placeType, MongoServer mongoServer) {
        PlaceUpdater placeUpdater = new PlaceUpdater();
        placeUpdater.update(place, placeType, mongoServer);
        return (PlaceImpl)((EdmMongoServer)mongoServer).getDatastore().find(PlaceImpl.class).filter("about", (Object)placeType.getAbout()).get();
    }

    public PlaceImpl createNewPlace(PlaceType placeType) {
        PlaceImpl place = new PlaceImpl();
        place.setAbout(placeType.getAbout());
        if (placeType.getLat() != null) {
            place.setLatitude(placeType.getLat().getLat());
        }
        if (placeType.getLong() != null) {
            place.setLongitude(placeType.getLong().getLong());
        }
        place.setNote(MongoUtils.createLiteralMapFromList(placeType.getNoteList()));
        place.setPrefLabel(MongoUtils.createLiteralMapFromList(placeType.getPrefLabelList()));
        place.setAltLabel(MongoUtils.createLiteralMapFromList(placeType.getAltLabelList()));
        place.setIsPartOf(MongoUtils.createResourceOrLiteralMapFromList(placeType.getIsPartOfList()));
        if (placeType.getAlt() != null) {
            place.setAltitude(placeType.getAlt().getAlt());
        }
        place.setDcTermsHasPart(MongoUtils.createResourceOrLiteralMapFromList(placeType.getHasPartList()));
        place.setOwlSameAs(SolrUtils.resourceListToArray(placeType.getSameAList()));
        return place;
    }
}

