/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.entity.License;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.LicenseImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.updaters.LicenseUpdater;
import org.apache.solr.common.SolrInputDocument;

public class LicenseFieldInput {
    public SolrInputDocument createLicenseSolrFields(eu.europeana.corelib.definitions.jibx.License license, SolrInputDocument solrInputDocument, boolean isAggregation) {
        if (isAggregation) {
            solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_CC_LICENSE.toString(), (Object)license.getAbout());
            solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_CC_DEPRECATED_ON.toString(), (Object)license.getDeprecatedOn().getDate());
            solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_ODRL_INHERITED_FROM.toString(), (Object)license.getInheritFrom().getResource());
        } else {
            solrInputDocument.addField(EdmLabel.WR_CC_LICENSE.toString(), (Object)license.getAbout());
            solrInputDocument.addField(EdmLabel.WR_CC_DEPRECATED_ON.toString(), (Object)license.getDeprecatedOn().getDate());
            solrInputDocument.addField(EdmLabel.WR_ODRL_INHERITED_FROM.toString(), (Object)license.getInheritFrom().getResource());
        }
        return solrInputDocument;
    }

    public LicenseImpl createLicenseMongoFields(eu.europeana.corelib.definitions.jibx.License jibxLicense) {
        LicenseImpl mongoLicense = new LicenseImpl();
        mongoLicense.setAbout(jibxLicense.getAbout());
        mongoLicense.setCcDeprecatedOn(jibxLicense.getDeprecatedOn().getDate());
        mongoLicense.setOdrlInheritFrom(jibxLicense.getInheritFrom().getResource());
        return mongoLicense;
    }

    public LicenseImpl createLicenseMongoFields(eu.europeana.corelib.definitions.jibx.License jibxLicense, MongoServer mongoServer) {
        LicenseImpl mongoLicense = (LicenseImpl)((EdmMongoServer)mongoServer).getDatastore().find(LicenseImpl.class).filter("about", (Object)jibxLicense.getAbout()).get();
        if (mongoLicense == null) {
            mongoLicense = this.createLicenseMongoFields(jibxLicense);
            try {
                mongoServer.getDatastore().save((Object)mongoLicense);
            }
            catch (Exception e) {
                mongoLicense = this.updateLicense(mongoLicense, jibxLicense, mongoServer);
            }
        } else {
            mongoLicense = this.updateLicense(mongoLicense, jibxLicense, mongoServer);
        }
        return mongoLicense;
    }

    private LicenseImpl updateLicense(License mongoLicense, eu.europeana.corelib.definitions.jibx.License jibxLicense, MongoServer mongoServer) {
        new LicenseUpdater().update(mongoLicense, jibxLicense, mongoServer);
        return (LicenseImpl)((EdmMongoServer)mongoServer).getDatastore().find(LicenseImpl.class).filter("about", (Object)jibxLicense.getAbout()).get();
    }
}

