/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.jibx.AggregatedCHO;
import eu.europeana.corelib.definitions.jibx.Aggregates;
import eu.europeana.corelib.definitions.jibx.EuropeanaAggregationType;
import eu.europeana.corelib.definitions.jibx.HasView;
import eu.europeana.corelib.definitions.jibx.IsShownBy;
import eu.europeana.corelib.definitions.jibx.LandingPage;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.entity.EuropeanaAggregation;
import eu.europeana.corelib.definitions.solr.entity.WebResource;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.EuropeanaAggregationImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public final class EuropeanaAggregationFieldInput {
    private static final String EUROPEANA_URI = "http://www.europeana.eu/portal/record";
    private static final String EDM_PREVIEW_PREFIX = "http://europeanastatic.eu/api/image?uri=";
    private static final String EDM_PREVIEW_SUFFIX = "&size=LARGE&type=";

    public SolrInputDocument createAggregationSolrFields(EuropeanaAggregationType aggregation, SolrInputDocument solrInputDocument, String previewUrl) throws InstantiationException, IllegalAccessException {
        solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, aggregation.getCreator(), EdmLabel.EUROPEANA_AGGREGATION_DC_CREATOR);
        solrInputDocument = SolrUtils.addFieldFromEnum(solrInputDocument, aggregation.getCountry().getCountry().xmlValue(), EdmLabel.EUROPEANA_AGGREGATION_EDM_COUNTRY);
        solrInputDocument.addField(EdmLabel.EDM_EUROPEANA_AGGREGATION.toString(), (Object)aggregation.getAbout());
        if (aggregation.getHasViewList() != null) {
            for (HasView hasView : aggregation.getHasViewList()) {
                solrInputDocument.addField(EdmLabel.EUROPEANA_AGGREGATION_EDM_HASVIEW.toString(), (Object)hasView.getResource());
            }
        }
        solrInputDocument.addField(EdmLabel.EUROPEANA_AGGREGATION_EDM_ISSHOWNBY.toString(), aggregation.getIsShownBy() != null ? aggregation.getIsShownBy().getResource() : null);
        solrInputDocument.addField(EdmLabel.EUROPEANA_AGGREGATION_EDM_LANDINGPAGE.toString(), (Object)(EUROPEANA_URI + aggregation.getAggregatedCHO().getResource() + ".html"));
        solrInputDocument = SolrUtils.addFieldFromEnum(solrInputDocument, aggregation.getLanguage().getLanguage().xmlValue(), EdmLabel.EUROPEANA_AGGREGATION_EDM_LANGUAGE);
        solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, aggregation.getRights(), EdmLabel.EUROPEANA_AGGREGATION_EDM_RIGHTS);
        solrInputDocument.addField(EdmLabel.EUROPEANA_AGGREGATION_ORE_AGGREGATEDCHO.toString(), aggregation.getAggregatedCHO() != null ? aggregation.getAggregatedCHO().getResource() : null);
        if (aggregation.getAggregateList() != null) {
            for (Aggregates aggregates : aggregation.getAggregateList()) {
                solrInputDocument.addField(EdmLabel.EUROPEANA_AGGREGATION_ORE_AGGREGATES.toString(), (Object)aggregates.getResource());
            }
        }
        return solrInputDocument;
    }

    public EuropeanaAggregation appendWebResource(EuropeanaAggregation aggregation, WebResourceImpl webResource, MongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        if (this.belongsTo(aggregation, webResource)) {
            List webResources;
            List list = webResources = aggregation.getWebResources() != null ? aggregation.getWebResources() : new ArrayList();
            if (!this.webResourceExists(webResources, webResource)) {
                aggregation.setWebResources(webResources);
                if (aggregation.getAbout() != null) {
                    MongoUtils.update(EuropeanaAggregationImpl.class, aggregation.getAbout(), mongoServer, "webResources", webResources);
                } else {
                    mongoServer.getDatastore().save((Object)aggregation);
                }
            }
        }
        return aggregation;
    }

    private boolean webResourceExists(List<WebResource> webResources, WebResourceImpl webResource) {
        for (WebResource wr : webResources) {
            if (!StringUtils.equals((String)wr.getAbout(), (String)webResource.getAbout())) continue;
            return true;
        }
        return false;
    }

    public EuropeanaAggregation appendWebResource(EuropeanaAggregation aggregation, List<WebResource> webResources, MongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        aggregation.setWebResources(webResources);
        if (aggregation.getAbout() != null) {
            MongoUtils.update(EuropeanaAggregationImpl.class, aggregation.getAbout(), mongoServer, "webResources", webResources);
        } else {
            mongoServer.getDatastore().save((Object)aggregation);
        }
        return aggregation;
    }

    public EuropeanaAggregationImpl createAggregationMongoFields(EuropeanaAggregationType aggregation, MongoServer mongoServer, String previewUrl) throws InstantiationException, IllegalAccessException {
        EuropeanaAggregationImpl mongoAggregation = new EuropeanaAggregationImpl();
        UpdateOperations ops = mongoServer.getDatastore().createUpdateOperations(EuropeanaAggregationImpl.class);
        mongoAggregation.setAbout(aggregation.getAbout());
        Map<String, List<String>> creator = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getCreator());
        if (creator != null) {
            ops.set("dcCreator", creator);
            mongoAggregation.setDcCreator(creator);
        } else {
            ops.unset("dcCreator");
        }
        Map<String, List<String>> country = MongoUtils.createLiteralMapFromString(aggregation.getCountry().getCountry().xmlValue().toLowerCase());
        if (country != null) {
            mongoAggregation.setEdmCountry(country);
            ops.set("edmCountry", country);
        } else {
            ops.unset("edmCountry");
        }
        String isShownBy = SolrUtils.exists(IsShownBy.class, aggregation.getIsShownBy()).getResource();
        if (isShownBy != null) {
            mongoAggregation.setEdmIsShownBy(isShownBy);
            ops.set("edmIsShownBy", (Object)isShownBy);
        } else {
            ops.unset("edmIsShownBy");
        }
        String landingPage = SolrUtils.exists(LandingPage.class, aggregation.getLandingPage()).getResource();
        mongoAggregation.setEdmLandingPage(EUROPEANA_URI + aggregation.getAggregatedCHO().getResource() + ".html");
        ops.set("edmLandingPage", (Object)(EUROPEANA_URI + aggregation.getAggregatedCHO().getResource() + ".html"));
        Map<String, List<String>> language = MongoUtils.createLiteralMapFromString(aggregation.getLanguage().getLanguage().xmlValue().toLowerCase());
        mongoAggregation.setEdmLanguage(language);
        ops.set("edmLanguage", language);
        String agCHO = SolrUtils.exists(AggregatedCHO.class, aggregation.getAggregatedCHO()).getResource();
        mongoAggregation.setAggregatedCHO(agCHO);
        ops.set("aggregatedCHO", (Object)agCHO);
        Map<String, List<String>> edmRights = MongoUtils.createResourceMapFromString(aggregation.getRights());
        if (edmRights != null) {
            mongoAggregation.setEdmRights(edmRights);
            ops.set("edmRights", edmRights);
        } else {
            ops.unset("edmRights");
        }
        String[] aggregates = SolrUtils.resourceListToArray(aggregation.getAggregateList());
        if (aggregates != null) {
            mongoAggregation.setAggregates(aggregates);
            ops.set("aggregates", (Object)aggregates);
        } else {
            ops.unset("edmHasView");
        }
        String[] hasViewList = SolrUtils.resourceListToArray(aggregation.getHasViewList());
        mongoAggregation.setEdmHasView(hasViewList);
        ops.set("edmHasView", (Object)hasViewList);
        EuropeanaAggregationImpl retrievedAggregation = (EuropeanaAggregationImpl)mongoServer.getDatastore().find(EuropeanaAggregationImpl.class).filter("about", (Object)aggregation.getAbout()).get();
        if (retrievedAggregation == null) {
            mongoServer.getDatastore().save((Object)mongoAggregation);
        } else {
            mongoServer.getDatastore().update((Object)retrievedAggregation, ops);
        }
        return retrievedAggregation != null ? retrievedAggregation : mongoAggregation;
    }

    private boolean belongsTo(EuropeanaAggregation aggregation, WebResource webResource) {
        if (aggregation.getEdmHasView() != null) {
            for (String hasView : aggregation.getEdmHasView()) {
                if (!StringUtils.equals((String)hasView, (String)webResource.getAbout())) continue;
                return true;
            }
        }
        return aggregation.getEdmIsShownBy() != null && StringUtils.equals((String)aggregation.getEdmIsShownBy(), (String)webResource.getAbout());
    }

    private String generateEdmPreview(String url) {
        try {
            return EDM_PREVIEW_PREFIX + URLEncoder.encode(url, "UTF-8").replaceAll("\\%28", "(").replaceAll("\\%29", ")").replaceAll("\\+", "%20").replaceAll("\\%27", "'").replaceAll("\\%21", "!").replaceAll("\\%7E", "~") + EDM_PREVIEW_SUFFIX;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public EuropeanaAggregationImpl createAggregationMongoFields(EuropeanaAggregationType aggregation, String previewUrl) throws InstantiationException, IllegalAccessException {
        EuropeanaAggregationImpl mongoAggregation = new EuropeanaAggregationImpl();
        mongoAggregation.setAbout(aggregation.getAbout());
        Map<String, List<String>> creator = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getCreator());
        mongoAggregation.setDcCreator(creator);
        Map<String, List<String>> country = MongoUtils.createLiteralMapFromString(aggregation.getCountry().getCountry().xmlValue().toLowerCase());
        mongoAggregation.setEdmCountry(country);
        String isShownBy = SolrUtils.exists(IsShownBy.class, aggregation.getIsShownBy()).getResource();
        mongoAggregation.setEdmIsShownBy(isShownBy);
        mongoAggregation.setEdmLandingPage(EUROPEANA_URI + aggregation.getAggregatedCHO().getResource() + ".html");
        Map<String, List<String>> language = MongoUtils.createLiteralMapFromString(aggregation.getLanguage().getLanguage().xmlValue().toLowerCase());
        mongoAggregation.setEdmLanguage(language);
        String agCHO = SolrUtils.exists(AggregatedCHO.class, aggregation.getAggregatedCHO()).getResource();
        mongoAggregation.setAggregatedCHO(agCHO);
        Map<String, List<String>> edmRights = MongoUtils.createResourceMapFromString(aggregation.getRights());
        mongoAggregation.setEdmRights(edmRights);
        String[] aggregates = SolrUtils.resourceListToArray(aggregation.getAggregateList());
        mongoAggregation.setAggregates(aggregates);
        String[] hasViewList = SolrUtils.resourceListToArray(aggregation.getHasViewList());
        mongoAggregation.setEdmHasView(hasViewList);
        return mongoAggregation;
    }
}

