/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.BroadMatch;
import eu.europeana.corelib.definitions.jibx.Broader;
import eu.europeana.corelib.definitions.jibx.CloseMatch;
import eu.europeana.corelib.definitions.jibx.Concept;
import eu.europeana.corelib.definitions.jibx.ExactMatch;
import eu.europeana.corelib.definitions.jibx.NarrowMatch;
import eu.europeana.corelib.definitions.jibx.Narrower;
import eu.europeana.corelib.definitions.jibx.Notation;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.RDF;
import eu.europeana.corelib.definitions.jibx.Related;
import eu.europeana.corelib.definitions.jibx.RelatedMatch;
import eu.europeana.corelib.definitions.jibx.ResourceType;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.solr.utils.updaters.ConceptUpdater;
import eu.europeana.corelib.utils.StringArrayUtils;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrInputDocument;

public final class ConceptFieldInput {
    public SolrInputDocument createConceptSolrFields(Concept concept, SolrInputDocument solrInputDocument) {
        solrInputDocument.addField(EdmLabel.SKOS_CONCEPT.toString(), (Object)concept.getAbout());
        if (concept.getChoiceList() != null) {
            for (Concept.Choice choice : concept.getChoiceList()) {
                if (choice.ifAltLabel()) {
                    AltLabel altLabel = choice.getAltLabel();
                    solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, altLabel, EdmLabel.CC_SKOS_ALT_LABEL);
                }
                if (choice.ifPrefLabel()) {
                    PrefLabel prefLabel = choice.getPrefLabel();
                    solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, prefLabel, EdmLabel.CC_SKOS_PREF_LABEL);
                }
                if (choice.ifBroader()) {
                    Broader broader = choice.getBroader();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_BROADER.toString(), (Object)broader.getResource());
                }
                if (choice.ifNote()) {
                    solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, choice.getNote(), EdmLabel.CC_SKOS_NOTE);
                }
                if (choice.ifBroadMatch()) {
                    BroadMatch broadMatch = choice.getBroadMatch();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_BROADMATCH.toString(), (Object)broadMatch.getResource());
                }
                if (choice.ifCloseMatch()) {
                    CloseMatch closeMatch = choice.getCloseMatch();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_CLOSEMATCH.toString(), (Object)closeMatch.getResource());
                }
                if (choice.ifExactMatch()) {
                    ExactMatch exactMatch = choice.getExactMatch();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_EXACTMATCH.toString(), (Object)exactMatch.getResource());
                }
                if (choice.ifNarrower()) {
                    Narrower narrower = choice.getNarrower();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_NARROWER.toString(), (Object)narrower.getResource());
                }
                if (choice.ifNarrowMatch()) {
                    NarrowMatch narrowMatch = choice.getNarrowMatch();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_NARROWMATCH.toString(), (Object)narrowMatch.getResource());
                }
                if (choice.ifRelatedMatch()) {
                    RelatedMatch relatedMatch = choice.getRelatedMatch();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_RELATEDMATCH.toString(), (Object)relatedMatch.getResource());
                }
                if (choice.ifRelated()) {
                    Related related = choice.getRelated();
                    solrInputDocument.addField(EdmLabel.CC_SKOS_RELATED.toString(), (Object)related.getResource());
                }
                if (!choice.ifNotation()) continue;
                Notation notation = choice.getNotation();
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, notation, EdmLabel.CC_SKOS_NOTATIONS);
            }
        }
        return solrInputDocument;
    }

    public ConceptImpl createConceptMongoFields(Concept concept, MongoServer mongoServer, RDF rdf) {
        ConceptImpl conceptMongo = (ConceptImpl)((EdmMongoServer)mongoServer).getDatastore().find(ConceptImpl.class).filter("about", (Object)concept.getAbout()).get();
        if (conceptMongo == null) {
            conceptMongo = this.createNewConcept(concept);
            try {
                mongoServer.getDatastore().save((Object)conceptMongo);
            }
            catch (Exception e) {
                conceptMongo = this.updateConcept(conceptMongo, concept, mongoServer);
            }
        } else {
            conceptMongo = this.updateConcept(conceptMongo, concept, mongoServer);
        }
        return conceptMongo;
    }

    private ConceptImpl updateConcept(ConceptImpl conceptMongo, Concept concept, MongoServer mongoServer) {
        ConceptUpdater conceptUpdater = new ConceptUpdater();
        conceptUpdater.update(conceptMongo, concept, mongoServer);
        return (ConceptImpl)((EdmMongoServer)mongoServer).getDatastore().find(ConceptImpl.class).filter("about", (Object)concept.getAbout()).get();
    }

    public ConceptImpl createNewConcept(Concept concept) {
        ConceptImpl conceptMongo = new ConceptImpl();
        conceptMongo.setAbout(concept.getAbout());
        if (concept.getChoiceList() != null) {
            for (Concept.Choice choice : concept.getChoiceList()) {
                Map<String, List<String>> tempMap;
                if (choice.ifNote()) {
                    if (conceptMongo.getNote() == null) {
                        conceptMongo.setNote(MongoUtils.createLiteralMapFromString(choice.getNote()));
                    } else {
                        tempMap = conceptMongo.getNote();
                        tempMap.putAll(MongoUtils.createLiteralMapFromString(choice.getNote()));
                        conceptMongo.setNote(tempMap);
                    }
                }
                if (choice.ifBroader()) {
                    conceptMongo.setBroader(StringArrayUtils.addToArray((String[])conceptMongo.getBroader(), (String)SolrUtils.getResourceString((ResourceType)choice.getBroader())));
                }
                if (choice.ifBroadMatch()) {
                    conceptMongo.setBroadMatch(StringArrayUtils.addToArray((String[])conceptMongo.getBroadMatch(), (String)SolrUtils.getResourceString((ResourceType)choice.getBroadMatch())));
                }
                if (choice.ifCloseMatch()) {
                    conceptMongo.setCloseMatch(StringArrayUtils.addToArray((String[])conceptMongo.getCloseMatch(), (String)SolrUtils.getResourceString((ResourceType)choice.getCloseMatch())));
                }
                if (choice.ifExactMatch()) {
                    conceptMongo.setExactMatch(StringArrayUtils.addToArray((String[])conceptMongo.getExactMatch(), (String)SolrUtils.getResourceString((ResourceType)choice.getExactMatch())));
                }
                if (choice.ifNarrower()) {
                    conceptMongo.setNarrower(StringArrayUtils.addToArray((String[])conceptMongo.getNarrower(), (String)SolrUtils.getResourceString((ResourceType)choice.getNarrower())));
                }
                if (choice.ifNarrowMatch()) {
                    conceptMongo.setNarrowMatch(StringArrayUtils.addToArray((String[])conceptMongo.getNarrowMatch(), (String)SolrUtils.getResourceString((ResourceType)choice.getNarrowMatch())));
                }
                if (choice.ifNotation()) {
                    if (conceptMongo.getNotation() == null) {
                        conceptMongo.setNotation(MongoUtils.createLiteralMapFromString(choice.getNotation()));
                    } else {
                        tempMap = conceptMongo.getNotation();
                        tempMap.putAll(MongoUtils.createLiteralMapFromString(choice.getNotation()));
                        conceptMongo.setNotation(tempMap);
                    }
                }
                if (choice.ifRelated()) {
                    conceptMongo.setRelated(StringArrayUtils.addToArray((String[])conceptMongo.getRelated(), (String)SolrUtils.getResourceString((ResourceType)choice.getRelated())));
                }
                if (choice.ifRelatedMatch()) {
                    conceptMongo.setCloseMatch(StringArrayUtils.addToArray((String[])conceptMongo.getRelatedMatch(), (String)SolrUtils.getResourceString((ResourceType)choice.getRelatedMatch())));
                }
                if (choice.ifPrefLabel()) {
                    if (conceptMongo.getPrefLabel() == null) {
                        conceptMongo.setPrefLabel(MongoUtils.createLiteralMapFromString(choice.getPrefLabel()));
                    } else {
                        tempMap = conceptMongo.getPrefLabel();
                        tempMap.putAll(MongoUtils.createLiteralMapFromString(choice.getPrefLabel()));
                        conceptMongo.setPrefLabel(tempMap);
                    }
                }
                if (!choice.ifAltLabel()) continue;
                if (conceptMongo.getAltLabel() == null) {
                    conceptMongo.setAltLabel(MongoUtils.createLiteralMapFromString(choice.getAltLabel()));
                    continue;
                }
                tempMap = conceptMongo.getAltLabel();
                tempMap.putAll(MongoUtils.createLiteralMapFromString(choice.getAltLabel()));
                conceptMongo.setAltLabel(tempMap);
            }
        }
        return conceptMongo;
    }
}

