/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import eu.europeana.corelib.definitions.jibx.AggregatedCHO;
import eu.europeana.corelib.definitions.jibx.Aggregation;
import eu.europeana.corelib.definitions.jibx.HasView;
import eu.europeana.corelib.definitions.jibx.IsShownAt;
import eu.europeana.corelib.definitions.jibx.IsShownBy;
import eu.europeana.corelib.definitions.jibx.License;
import eu.europeana.corelib.definitions.jibx.Rights;
import eu.europeana.corelib.definitions.jibx.WebResourceType;
import eu.europeana.corelib.definitions.jibx._Object;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.definitions.solr.entity.WebResource;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.common.SolrInputDocument;

public final class AggregationFieldInput {
    public List<WebResourceImpl> createWebResources(List<WebResourceType> wResources, EdmMongoServer mongoServer) {
        ArrayList<WebResourceImpl> webResources = new ArrayList<WebResourceImpl>();
        for (WebResourceType wResourceType : wResources) {
            Map<String, List<String>> edmRightsMap;
            Map<String, List<String>> rightMap;
            Map<String, List<String>> issuedMap;
            Map<String, List<String>> isFormatOfMap;
            Map<String, List<String>> hasPartMap;
            Map<String, List<String>> extentMap;
            Map<String, List<String>> createdMap;
            Map<String, List<String>> conformsToMap;
            Map<String, List<String>> sourceMap;
            Map<String, List<String>> forMap;
            if (this.containsWebResource(webResources, wResourceType.getAbout())) continue;
            boolean update = false;
            WebResourceImpl webResource = new WebResourceImpl();
            webResource.setAbout(wResourceType.getAbout());
            WebResourceImpl retWebResource = mongoServer.searchByAbout(WebResourceImpl.class, webResource.getAbout());
            Query updateQuery = (Query)mongoServer.getDatastore().createQuery(WebResourceImpl.class).field("about").equal((Object)webResource.getAbout());
            UpdateOperations ups = mongoServer.getDatastore().createUpdateOperations(WebResourceImpl.class);
            Map<String, List<String>> desMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getDescriptionList());
            if (desMap != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDcDescription(), desMap)) {
                    ups.set("dcDescription", desMap);
                    retWebResource.setDcDescription(desMap);
                    update = true;
                }
                webResource.setDcDescription(desMap);
            }
            if ((forMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getFormatList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDcFormat(), forMap)) {
                    ups.set("dcFormat", forMap);
                    retWebResource.setDcFormat(forMap);
                    update = true;
                }
                webResource.setDcFormat(forMap);
            }
            if ((sourceMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getSourceList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDcSource(), sourceMap)) {
                    ups.set("dcSource", sourceMap);
                    retWebResource.setDcSource(sourceMap);
                    update = true;
                }
                webResource.setDcSource(sourceMap);
            }
            if ((conformsToMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getConformsToList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsConformsTo(), webResource.getDctermsConformsTo())) {
                    ups.set("dctermsConformsTo", conformsToMap);
                    retWebResource.setDctermsConformsTo(conformsToMap);
                    update = true;
                }
                webResource.setDctermsConformsTo(conformsToMap);
            }
            if ((createdMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getCreatedList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsCreated(), createdMap)) {
                    ups.set("dctermsCreated", createdMap);
                    retWebResource.setDctermsCreated(createdMap);
                    update = true;
                }
                webResource.setDctermsCreated(createdMap);
            }
            if ((extentMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getExtentList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsExtent(), extentMap)) {
                    ups.set("dctermsExtent", extentMap);
                    retWebResource.setDctermsExtent(extentMap);
                    update = true;
                }
                webResource.setDctermsExtent(extentMap);
            }
            if ((hasPartMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getHasPartList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsHasPart(), hasPartMap)) {
                    ups.set("dctermsHasPart", hasPartMap);
                    retWebResource.setDctermsHasPart(hasPartMap);
                    update = true;
                }
                webResource.setDctermsHasPart(hasPartMap);
            }
            if ((isFormatOfMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getIsFormatOfList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsIsFormatOf(), hasPartMap)) {
                    ups.set("isFormatOf", isFormatOfMap);
                    retWebResource.setDctermsIsFormatOf(isFormatOfMap);
                    update = true;
                }
                webResource.setDctermsIsFormatOf(isFormatOfMap);
            }
            if ((issuedMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getIssuedList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getDctermsIssued(), issuedMap)) {
                    ups.set("dctermsIssued", issuedMap);
                    retWebResource.setDctermsIssued(issuedMap);
                    update = true;
                }
                webResource.setDctermsIssued(issuedMap);
            }
            if ((rightMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getRightList())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getWebResourceDcRights(), rightMap)) {
                    ups.set("webResourceDcRights", rightMap);
                    retWebResource.setWebResourceDcRights(rightMap);
                    update = true;
                }
                webResource.setWebResourceDcRights(rightMap);
            }
            if ((edmRightsMap = MongoUtils.createResourceMapFromString(wResourceType.getRights())) != null) {
                if (retWebResource != null && !MongoUtils.mapEquals(retWebResource.getWebResourceEdmRights(), edmRightsMap)) {
                    ups.set("webResourceEdmRights", edmRightsMap);
                    retWebResource.setWebResourceEdmRights(edmRightsMap);
                    update = true;
                }
                webResource.setWebResourceEdmRights(edmRightsMap);
            }
            if (wResourceType.getIsNextInSequence() != null) {
                webResource.setIsNextInSequence(wResourceType.getIsNextInSequence().getResource());
                if (!(retWebResource == null || retWebResource.getIsNextInSequence() != null && retWebResource.getIsNextInSequence().equals(wResourceType.getIsNextInSequence().getResource()))) {
                    ups.set("isNextInSequence", (Object)wResourceType.getIsNextInSequence().getResource());
                    retWebResource.setIsNextInSequence(wResourceType.getIsNextInSequence().getResource());
                    update = true;
                }
            }
            if (retWebResource != null && update) {
                mongoServer.getDatastore().update(updateQuery, ups);
            } else {
                mongoServer.getDatastore().save((Object)webResource);
            }
            webResources.add(retWebResource != null ? retWebResource : webResource);
        }
        return webResources;
    }

    public List<WebResourceImpl> createWebResources(List<WebResourceType> wResources) {
        ArrayList<WebResourceImpl> webResources = new ArrayList<WebResourceImpl>();
        for (WebResourceType wResourceType : wResources) {
            if (this.containsWebResource(webResources, wResourceType.getAbout())) continue;
            WebResourceImpl webResource = new WebResourceImpl();
            webResource.setAbout(wResourceType.getAbout());
            Map<String, List<String>> desMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getDescriptionList());
            webResource.setDcDescription(desMap);
            Map<String, List<String>> forMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getFormatList());
            webResource.setDcFormat(forMap);
            Map<String, List<String>> sourceMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getSourceList());
            webResource.setDcSource(sourceMap);
            Map<String, List<String>> conformsToMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getConformsToList());
            webResource.setDctermsConformsTo(conformsToMap);
            Map<String, List<String>> createdMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getCreatedList());
            webResource.setDctermsCreated(createdMap);
            Map<String, List<String>> extentMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getExtentList());
            webResource.setDctermsExtent(extentMap);
            Map<String, List<String>> hasPartMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getHasPartList());
            webResource.setDctermsHasPart(hasPartMap);
            Map<String, List<String>> isFormatOfMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getIsFormatOfList());
            webResource.setDctermsIsFormatOf(isFormatOfMap);
            Map<String, List<String>> issuedMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getIssuedList());
            webResource.setDctermsIssued(issuedMap);
            Map<String, List<String>> rightMap = MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getRightList());
            webResource.setWebResourceDcRights(rightMap);
            Map<String, List<String>> edmRightsMap = MongoUtils.createResourceMapFromString(wResourceType.getRights());
            webResource.setWebResourceEdmRights(edmRightsMap);
            if (wResourceType.getIsNextInSequence() != null) {
                webResource.setIsNextInSequence(wResourceType.getIsNextInSequence().getResource());
            }
            webResource.setOwlSameAs(SolrUtils.resourceListToArray(wResourceType.getSameAList()));
            webResource.setDcCreator(MongoUtils.createResourceOrLiteralMapFromList(wResourceType.getCreatorList()));
            webResources.add(webResource);
        }
        return webResources;
    }

    private boolean containsWebResource(List<WebResourceImpl> webResources, String about) {
        for (WebResourceImpl wr : webResources) {
            if (!StringUtils.equals((String)wr.getAbout(), (String)about)) continue;
            return true;
        }
        return false;
    }

    public SolrInputDocument createAggregationSolrFields(Aggregation aggregation, SolrInputDocument solrInputDocument, List<License> licenses) throws InstantiationException, IllegalAccessException {
        solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_ORE_AGGREGATION.toString(), (Object)aggregation.getAbout());
        solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_EDM_AGGREGATED_CHO.toString(), (Object)SolrUtils.exists(AggregatedCHO.class, aggregation.getAggregatedCHO()).getResource());
        solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_EDM_OBJECT.toString(), (Object)SolrUtils.exists(_Object.class, aggregation.getObject()).getResource());
        solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, aggregation.getDataProvider(), EdmLabel.PROVIDER_AGGREGATION_EDM_DATA_PROVIDER);
        solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, aggregation.getProvider(), EdmLabel.PROVIDER_AGGREGATION_EDM_PROVIDER);
        solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_EDM_IS_SHOWN_AT.toString(), (Object)SolrUtils.exists(IsShownAt.class, aggregation.getIsShownAt()).getResource());
        solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_EDM_IS_SHOWN_BY.toString(), (Object)SolrUtils.exists(IsShownBy.class, aggregation.getIsShownBy()).getResource());
        boolean saveRights = true;
        if (licenses != null) {
            String rights = aggregation.getRights().getResource();
            for (License lic : licenses) {
                if (!StringUtils.equals((String)rights, (String)lic.getAbout())) continue;
                saveRights = false;
                break;
            }
        }
        if (saveRights) {
            solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, aggregation.getRights(), EdmLabel.PROVIDER_AGGREGATION_EDM_RIGHTS);
        }
        if (aggregation.getUgc() != null) {
            solrInputDocument.addField(EdmLabel.EDM_UGC.toString(), (Object)aggregation.getUgc().getUgc().toString().toLowerCase());
        }
        if (aggregation.getRightList() != null) {
            for (Rights rights : aggregation.getRightList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, rights, EdmLabel.PROVIDER_AGGREGATION_DC_RIGHTS);
            }
        }
        if (aggregation.getHasViewList() != null) {
            for (HasView hasView : aggregation.getHasViewList()) {
                solrInputDocument.addField(EdmLabel.PROVIDER_AGGREGATION_EDM_HASVIEW.toString(), (Object)hasView.getResource());
            }
        }
        return solrInputDocument;
    }

    public AggregationImpl appendWebResource(List<AggregationImpl> aggregations, WebResourceImpl webResource, EdmMongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        AggregationImpl aggregation = this.findAggregation(aggregations, webResource);
        if (aggregation != null) {
            ArrayList<WebResource> webResources;
            ArrayList<WebResource> arrayList = webResources = aggregation.getWebResources() != null ? aggregation.getWebResources() : new ArrayList<WebResource>();
            if (!this.webResourceExists(webResources, webResource)) {
                mongoServer.getDatastore().save((Object)webResource);
                webResources.add(webResource);
                aggregation.setWebResources(webResources);
                MongoUtils.update(AggregationImpl.class, aggregation.getAbout(), mongoServer, "webResources", webResources);
            }
        }
        return aggregation;
    }

    public AggregationImpl appendWebResource(List<AggregationImpl> aggregations, List<WebResource> webResource, EdmMongoServer mongoServer) throws InstantiationException, IllegalAccessException {
        AggregationImpl aggregation = this.findAggregation(aggregations, webResource.get(0));
        for (WebResource wr : this.cleanWebResources(webResource)) {
            mongoServer.getDatastore().save((Object)wr);
        }
        aggregation.setWebResources(webResource);
        MongoUtils.update(AggregationImpl.class, aggregation.getAbout(), mongoServer, "webResources", webResource);
        return aggregation;
    }

    private List<WebResource> cleanWebResources(List<WebResource> webResource) {
        ArrayList<WebResource> webResources = new ArrayList<WebResource>();
        for (WebResource wr : webResources) {
            if (this.webResourceExists(webResources, wr)) continue;
            webResources.add(wr);
        }
        return webResources;
    }

    private AggregationImpl findAggregation(List<AggregationImpl> aggregations, WebResource webResource) {
        for (AggregationImpl aggregation : aggregations) {
            if (aggregation.getHasView() != null) {
                for (String hasView : aggregation.getHasView()) {
                    if (!StringUtils.equals((String)hasView, (String)webResource.getAbout())) continue;
                    return aggregation;
                }
            }
            if (aggregation.getEdmIsShownAt() != null && StringUtils.equals((String)aggregation.getEdmIsShownAt(), (String)webResource.getAbout())) {
                return aggregation;
            }
            if (aggregation.getEdmIsShownBy() != null && StringUtils.equals((String)aggregation.getEdmIsShownBy(), (String)webResource.getAbout())) {
                return aggregation;
            }
            if (aggregation.getEdmObject() == null || !StringUtils.equals((String)aggregation.getEdmObject(), (String)webResource.getAbout())) continue;
            return aggregation;
        }
        return null;
    }

    public AggregationImpl createAggregationMongoFields(Aggregation aggregation, EdmMongoServer mongoServer, List<WebResourceImpl> webResources) throws InstantiationException, IllegalAccessException {
        AggregationImpl mongoAggregation = new AggregationImpl();
        AggregationImpl retAggr = (AggregationImpl)mongoServer.getDatastore().find(AggregationImpl.class).filter("about", (Object)aggregation.getAbout()).get();
        boolean update = false;
        if (retAggr != null) {
            update = true;
            mongoAggregation = retAggr;
        }
        mongoAggregation.setAbout(aggregation.getAbout());
        Map<String, List<String>> dp = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getDataProvider());
        mongoAggregation.setEdmDataProvider(dp);
        UpdateOperations ups = mongoServer.getDatastore().createUpdateOperations(AggregationImpl.class);
        ups.set("edmDataProvider", dp);
        String isShownAt = SolrUtils.exists(IsShownAt.class, aggregation.getIsShownAt()).getResource();
        mongoAggregation.setEdmIsShownAt(isShownAt);
        if (isShownAt != null) {
            mongoAggregation.setEdmIsShownAt(isShownAt.trim());
            ups.set("edmIsShownAt", (Object)isShownAt.trim());
        } else {
            ups.unset("edmIsShownAt");
        }
        String isShownBy = SolrUtils.exists(IsShownBy.class, aggregation.getIsShownBy()).getResource();
        mongoAggregation.setEdmIsShownBy(isShownBy);
        if (isShownBy != null) {
            mongoAggregation.setEdmIsShownBy(isShownBy.trim());
            ups.set("edmIsShownBy", (Object)isShownBy.trim());
        } else {
            ups.unset("edmIsShownBy");
        }
        String object = SolrUtils.exists(_Object.class, aggregation.getObject()).getResource();
        mongoAggregation.setEdmObject(object);
        if (object != null) {
            mongoAggregation.setEdmObject(object.trim());
            ups.set("edmObject", (Object)object.trim());
        } else {
            ups.unset("edmObject");
        }
        Map<String, List<String>> prov = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getProvider());
        if (prov != null) {
            mongoAggregation.setEdmProvider(prov);
            ups.set("edmProvider", prov);
        } else {
            ups.unset("edmProvider");
        }
        Map<String, List<String>> rights = MongoUtils.createResourceMapFromString(aggregation.getRights());
        mongoAggregation.setEdmRights(rights);
        if (rights != null) {
            ups.set("edmRights", rights);
        } else {
            ups.unset("edmRights");
        }
        if (aggregation.getUgc() != null) {
            mongoAggregation.setEdmUgc(aggregation.getUgc().getUgc().toString().toLowerCase());
        } else {
            mongoAggregation.setEdmUgc(null);
        }
        String agCHO = SolrUtils.exists(AggregatedCHO.class, aggregation.getAggregatedCHO()).getResource();
        mongoAggregation.setAggregatedCHO(agCHO);
        ups.set("aggregatedCHO", (Object)agCHO);
        Map<String, List<String>> rights1 = MongoUtils.createResourceOrLiteralMapFromList(aggregation.getRightList());
        mongoAggregation.setDcRights(rights1);
        if (rights1 != null) {
            ups.set("dcRights", rights1);
        } else {
            ups.unset("dcRights");
        }
        if (aggregation.getHasViewList() != null) {
            ArrayList<String> hasViewList = new ArrayList<String>();
            for (HasView hasView : aggregation.getHasViewList()) {
                hasViewList.add(hasView.getResource().trim());
            }
            mongoAggregation.setHasView(hasViewList.toArray(new String[hasViewList.size()]));
            ups.set("hasView", (Object)hasViewList.toArray(new String[hasViewList.size()]));
        } else {
            mongoAggregation.setHasView(null);
            ups.unset("hasView");
        }
        if (webResources != null) {
            mongoAggregation.setWebResources(webResources);
        }
        if (update) {
            mongoServer.getDatastore().update((Object)mongoAggregation, ups);
        } else {
            mongoServer.getDatastore().save((Object)mongoAggregation);
        }
        return mongoAggregation;
    }

    public void deleteAggregationFromMongo(String about, EdmMongoServer mongoServer) {
        MongoUtils.delete(Aggregation.class, about, mongoServer);
    }

    private boolean webResourceExists(List<WebResource> webResources, WebResource webResource) {
        for (WebResource wr : webResources) {
            if (!StringUtils.equals((String)wr.getAbout(), (String)webResource.getAbout())) continue;
            return true;
        }
        return false;
    }

    public AggregationImpl createAggregationMongoFields(Aggregation aggregation, List<WebResourceImpl> webResources) throws InstantiationException, IllegalAccessException {
        AggregationImpl mongoAggregation = new AggregationImpl();
        mongoAggregation.setAbout(aggregation.getAbout());
        Map<String, List<String>> dp = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getDataProvider());
        mongoAggregation.setEdmDataProvider(dp);
        String isShownAt = SolrUtils.exists(IsShownAt.class, aggregation.getIsShownAt()).getResource();
        mongoAggregation.setEdmIsShownAt(isShownAt != null ? isShownAt.trim() : null);
        String isShownBy = SolrUtils.exists(IsShownBy.class, aggregation.getIsShownBy()).getResource();
        mongoAggregation.setEdmIsShownBy(isShownBy != null ? isShownBy.trim() : null);
        String object = SolrUtils.exists(_Object.class, aggregation.getObject()).getResource();
        mongoAggregation.setEdmObject(object != null ? object.trim() : null);
        Map<String, List<String>> prov = MongoUtils.createResourceOrLiteralMapFromString(aggregation.getProvider());
        mongoAggregation.setEdmProvider(prov);
        Map<String, List<String>> rights = MongoUtils.createResourceMapFromString(aggregation.getRights());
        mongoAggregation.setEdmRights(rights);
        if (aggregation.getUgc() != null) {
            mongoAggregation.setEdmUgc(aggregation.getUgc().getUgc().toString().toLowerCase());
        } else {
            mongoAggregation.setEdmUgc(null);
        }
        String agCHO = SolrUtils.exists(AggregatedCHO.class, aggregation.getAggregatedCHO()).getResource();
        mongoAggregation.setAggregatedCHO(agCHO);
        Map<String, List<String>> rights1 = MongoUtils.createResourceOrLiteralMapFromList(aggregation.getRightList());
        mongoAggregation.setDcRights(rights1);
        if (aggregation.getHasViewList() != null) {
            ArrayList<String> hasViewList = new ArrayList<String>();
            for (HasView hasView : aggregation.getHasViewList()) {
                hasViewList.add(hasView.getResource().trim());
            }
            mongoAggregation.setHasView(hasViewList.toArray(new String[hasViewList.size()]));
        } else {
            mongoAggregation.setHasView(null);
        }
        if (webResources != null) {
            mongoAggregation.setWebResources(webResources);
        }
        return mongoAggregation;
    }
}

