/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.importer.util;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.query.Query;
import eu.europeana.corelib.definitions.jibx.AgentType;
import eu.europeana.corelib.definitions.jibx.AltLabel;
import eu.europeana.corelib.definitions.jibx.Date;
import eu.europeana.corelib.definitions.jibx.HasMet;
import eu.europeana.corelib.definitions.jibx.Identifier;
import eu.europeana.corelib.definitions.jibx.IsRelatedTo;
import eu.europeana.corelib.definitions.jibx.Note;
import eu.europeana.corelib.definitions.jibx.PrefLabel;
import eu.europeana.corelib.definitions.jibx.SameAs;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.solr.utils.MongoUtils;
import eu.europeana.corelib.solr.utils.SolrUtils;
import eu.europeana.corelib.solr.utils.updaters.AgentUpdater;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.solr.common.SolrInputDocument;

public final class AgentFieldInput {
    public SolrInputDocument createAgentSolrFields(AgentType agentType, SolrInputDocument solrInputDocument) {
        solrInputDocument.addField(EdmLabel.EDM_AGENT.toString(), (Object)agentType.getAbout());
        if (agentType.getAltLabelList() != null) {
            for (AltLabel altLabel : agentType.getAltLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, altLabel, EdmLabel.AG_SKOS_ALT_LABEL);
            }
        }
        if (agentType.getPrefLabelList() != null) {
            for (PrefLabel prefLabel : agentType.getPrefLabelList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, prefLabel, EdmLabel.AG_SKOS_PREF_LABEL);
            }
        }
        if (agentType.getNoteList() != null) {
            for (Note note : agentType.getNoteList()) {
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, note, EdmLabel.AG_SKOS_NOTE);
            }
        }
        if (agentType.getBegin() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getBegin(), EdmLabel.AG_EDM_BEGIN);
        }
        if (agentType.getEnd() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getEnd(), EdmLabel.AG_EDM_END);
        }
        if (agentType.getDateList() != null) {
            for (Date date : agentType.getDateList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, date, EdmLabel.AG_DC_DATE);
            }
        }
        if (agentType.getIdentifierList() != null) {
            for (Identifier identifier : agentType.getIdentifierList()) {
                if (identifier.getString() == null) continue;
                solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, identifier, EdmLabel.AG_DC_IDENTIFIER);
            }
        }
        if (agentType.getHasMetList() != null) {
            for (HasMet hasMet : agentType.getHasMetList()) {
                solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, hasMet, EdmLabel.AG_EDM_HASMET);
            }
        }
        if (agentType.getSameAList() != null) {
            for (SameAs sameAs : agentType.getSameAList()) {
                solrInputDocument = SolrUtils.addFieldFromResource(solrInputDocument, sameAs, EdmLabel.AG_OWL_SAMEAS);
            }
        }
        if (agentType.getIsRelatedToList() != null) {
            for (IsRelatedTo isRelatedTo : agentType.getIsRelatedToList()) {
                solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, isRelatedTo, EdmLabel.AG_EDM_ISRELATEDTO);
            }
        }
        if (agentType.getBiographicalInformation() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getBiographicalInformation(), EdmLabel.AG_RDAGR2_BIOGRAPHICALINFORMATION);
        }
        if (agentType.getDateOfBirth() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getDateOfBirth(), EdmLabel.AG_RDAGR2_DATEOFBIRTH);
        }
        if (agentType.getDateOfDeath() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getDateOfDeath(), EdmLabel.AG_RDAGR2_DATEOFDEATH);
        }
        if (agentType.getPlaceOfBirth() != null) {
            solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, agentType.getPlaceOfBirth(), EdmLabel.AG_RDAGR2_PLACEOFBIRTH);
        }
        if (agentType.getPlaceOfDeath() != null) {
            solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, agentType.getPlaceOfDeath(), EdmLabel.AG_RDAGR2_PLACEOFDEATH);
        }
        if (agentType.getDateOfEstablishment() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getDateOfEstablishment(), EdmLabel.AG_RDAGR2_DATEOFESTABLISHMENT);
        }
        if (agentType.getDateOfTermination() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getDateOfTermination(), EdmLabel.AG_RDAGR2_DATEOFTERMINATION);
        }
        if (agentType.getGender() != null) {
            solrInputDocument = SolrUtils.addFieldFromLiteral(solrInputDocument, agentType.getGender(), EdmLabel.AG_RDAGR2_GENDER);
        }
        if (agentType.getProfessionOrOccupation() != null) {
            solrInputDocument = SolrUtils.addFieldFromResourceOrLiteral(solrInputDocument, agentType.getProfessionOrOccupation(), EdmLabel.AG_RDAGR2_PROFESSIONOROCCUPATION);
        }
        return solrInputDocument;
    }

    public AgentImpl createAgentMongoEntity(AgentType agentType, MongoServer mongoServer) throws MalformedURLException, IOException {
        Datastore ds = ((EdmMongoServer)mongoServer).getDatastore();
        Query query = ds.find(AgentImpl.class);
        AgentImpl agent = (AgentImpl)query.filter("about", (Object)agentType.getAbout()).get();
        if (agent == null) {
            agent = this.createNewAgent(agentType);
            try {
                mongoServer.getDatastore().save((Object)agent);
            }
            catch (Exception e) {
                AgentImpl agentSec = (AgentImpl)((EdmMongoServer)mongoServer).getDatastore().find(AgentImpl.class).filter("about", (Object)agentType.getAbout()).get();
                agent = this.updateMongoAgent(agentSec, agentType, mongoServer);
            }
        } else {
            agent = this.updateMongoAgent(agent, agentType, mongoServer);
        }
        return agent;
    }

    private AgentImpl updateMongoAgent(AgentImpl agent, AgentType agentType, MongoServer mongoServer) {
        AgentUpdater updater = new AgentUpdater();
        updater.update(agent, agentType, mongoServer);
        return (AgentImpl)((EdmMongoServer)mongoServer).getDatastore().find(AgentImpl.class).filter("about", (Object)agentType.getAbout()).get();
    }

    public AgentImpl createNewAgent(AgentType agentType) throws MalformedURLException, IOException {
        AgentImpl agent = new AgentImpl();
        agent.setAbout(agentType.getAbout());
        agent.setDcDate(MongoUtils.createResourceOrLiteralMapFromList(agentType.getDateList()));
        agent.setDcIdentifier(MongoUtils.createLiteralMapFromList(agentType.getIdentifierList()));
        agent.setEdmHasMet(MongoUtils.createResourceMapFromList(agentType.getHasMetList()));
        agent.setEdmIsRelatedTo(MongoUtils.createResourceOrLiteralMapFromList(agentType.getIsRelatedToList()));
        agent.setFoafName(MongoUtils.createLiteralMapFromList(agentType.getNameList()));
        agent.setRdaGr2BiographicalInformation(MongoUtils.createLiteralMapFromString(agentType.getBiographicalInformation()));
        agent.setRdaGr2DateOfBirth(MongoUtils.createLiteralMapFromString(agentType.getDateOfBirth()));
        agent.setRdaGr2DateOfDeath(MongoUtils.createLiteralMapFromString(agentType.getDateOfDeath()));
        agent.setRdaGr2PlaceOfBirth(MongoUtils.createResourceOrLiteralMapFromString(agentType.getPlaceOfBirth()));
        agent.setRdaGr2PlaceOfDeath(MongoUtils.createResourceOrLiteralMapFromString(agentType.getPlaceOfDeath()));
        agent.setRdaGr2DateOfEstablishment(MongoUtils.createLiteralMapFromString(agentType.getDateOfEstablishment()));
        agent.setRdaGr2DateOfTermination(MongoUtils.createLiteralMapFromString(agentType.getDateOfTermination()));
        agent.setRdaGr2Gender(MongoUtils.createLiteralMapFromString(agentType.getGender()));
        agent.setRdaGr2ProfessionOrOccupation(MongoUtils.createResourceOrLiteralMapFromString(agentType.getProfessionOrOccupation()));
        agent.setNote(MongoUtils.createLiteralMapFromList(agentType.getNoteList()));
        agent.setPrefLabel(MongoUtils.createLiteralMapFromList(agentType.getPrefLabelList()));
        agent.setAltLabel(MongoUtils.createLiteralMapFromList(agentType.getAltLabelList()));
        agent.setBegin(MongoUtils.createLiteralMapFromString(agentType.getBegin()));
        agent.setEnd(MongoUtils.createLiteralMapFromString(agentType.getEnd()));
        agent.setOwlSameAs(SolrUtils.resourceListToArray(agentType.getSameAList()));
        return agent;
    }
}

