/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.impl;

import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.neo4j.entity.CustomResponse;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.IndexObject;
import eu.europeana.corelib.neo4j.entity.RelType;
import eu.europeana.corelib.neo4j.entity.Relation;
import eu.europeana.corelib.solr.server.Neo4jServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.springframework.util.StringUtils;

public class Neo4jServerImpl
implements Neo4jServer {
    Logger log = Logger.getLogger((String)Neo4jServerImpl.class.getCanonicalName());
    private RestGraphDatabase graphDb;
    private RestIndex<Node> index;
    private HttpClient client;
    private String customPath;
    private String serverPath;
    private static final Relation edmIsNextInSequenceRelation = new Relation(RelType.EDM_ISNEXTINSEQUENCE.getRelType());
    private static final Relation isFirstInSequenceRelation = new Relation(RelType.ISFIRSTINSEQUENCE.getRelType());
    private static final Relation dctermsIsPartOfRelation = new Relation(RelType.DCTERMS_ISPARTOF.getRelType());
    private static final Relation dctermsHasPartRelation = new Relation(RelType.DCTERMS_HASPART.getRelType());

    public Neo4jServerImpl(String serverPath, String index, String customPath) {
        this.graphDb = new RestGraphDatabase(serverPath);
        this.index = this.graphDb.getRestAPI().getIndex(index);
        this.client = new HttpClient((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.customPath = customPath;
        this.serverPath = serverPath;
    }

    public Neo4jServerImpl() {
    }

    @Override
    public Node getNode(String id) {
        IndexHits nodes = this.index.get("rdf_about", (Object)id);
        if (nodes.size() > 0 && (((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{dctermsIsPartOfRelation}) || ((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{dctermsHasPartRelation}))) {
            return (Node)nodes.getSingle();
        }
        return null;
    }

    @Override
    public boolean isHierarchy(String id) {
        return this.getNode(id) != null;
    }

    @Override
    public List<Node> getChildren(Node id, int offset, int limit) {
        ArrayList<Node> children = new ArrayList<Node>();
        RestTraversal traversal = (RestTraversal)this.graphDb.traversalDescription();
        traversal.evaluator(Evaluators.excludeStartPosition());
        traversal.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
        traversal.breadthFirst();
        traversal.maxDepth(1);
        traversal.relationships((RelationshipType)isFirstInSequenceRelation, Direction.INCOMING);
        Traverser tr = traversal.traverse(id);
        for (Node node : tr.nodes()) {
            if (node == null) continue;
            if (offset == 0) {
                children.add(node);
                children.addAll(this.getFollowingSiblings(node, limit - 1, 0));
                continue;
            }
            children.addAll(this.getFollowingSiblings(node, limit, offset));
        }
        return children;
    }

    @Override
    public Node getParent(Node id) {
        List<Node> nodes = this.getRelatedNodes(id, 1, 0, Direction.OUTGOING, dctermsIsPartOfRelation);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    @Override
    public List<Node> getFollowingSiblings(Node id, int limit) {
        return this.getFollowingSiblings(id, limit, 0);
    }

    private List<Node> getFollowingSiblings(Node id, int limit, int offset) {
        return this.getRelatedNodes(id, limit, offset, Direction.INCOMING, edmIsNextInSequenceRelation);
    }

    @Override
    public List<Node> getPreceedingSiblings(Node id, int limit) {
        return this.getPreceedingSiblings(id, limit, 0);
    }

    private List<Node> getPreceedingSiblings(Node id, int limit, int offset) {
        return this.getRelatedNodes(id, limit, offset, Direction.OUTGOING, edmIsNextInSequenceRelation);
    }

    private List<Node> getRelatedNodes(Node id, int limit, int offset, Direction direction, Relation relType) {
        ArrayList<Node> children = new ArrayList<Node>();
        Transaction tx = this.graphDb.beginTx();
        RestTraversal traversal = (RestTraversal)this.graphDb.traversalDescription();
        traversal.evaluator(Evaluators.excludeStartPosition());
        traversal.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
        traversal.breadthFirst();
        traversal.maxDepth(offset + limit);
        traversal.relationships((RelationshipType)relType, direction);
        Traverser tr = traversal.traverse(id);
        ResourceIterator resIter = tr.nodes().iterator();
        int i = 1;
        while (resIter.hasNext()) {
            Node node = (Node)resIter.next();
            if (i >= offset) {
                if (children.size() <= limit) {
                    children.add(node);
                }
                if (children.size() == limit) break;
            }
            ++i;
        }
        tx.success();
        tx.finish();
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChildrenCount(Node id) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        ArrayNode statements = JsonNodeFactory.instance.arrayNode();
        obj.put("statements", (JsonNode)statements);
        ObjectNode statement = JsonNodeFactory.instance.objectNode();
        statement.put("statement", "start n = node:edmsearch2(rdf_about={from}) match (n)-[:`dcterms:hasPart`]->(part) RETURN COUNT(part) as children");
        ObjectNode parameters = statement.with("parameters");
        statements.add((JsonNode)statement);
        parameters.put("from", (String)id.getProperty("rdf:about"));
        PostMethod httpMethod = new PostMethod(this.serverPath + "transaction/commit");
        try {
            String str = new ObjectMapper().writeValueAsString((Object)obj);
            httpMethod.setRequestBody(str);
            httpMethod.setRequestHeader("content-type", "application/json");
            this.client.executeMethod((HttpMethod)httpMethod);
            CustomResponse cr = (CustomResponse)new ObjectMapper().readValue(httpMethod.getResponseBodyAsStream(), CustomResponse.class);
            if (cr.getResults() != null && cr.getResults().size() > 0 && cr.getResults().get(0) != null && cr.getResults().get(0).getData() != null && cr.getResults().get(0).getData().get(0) != null && cr.getResults().get(0).getData().get(0).get("row") != null && cr.getResults().get(0).getData().get(0).get("row").size() > 0) {
                long l = Long.parseLong(cr.getResults().get(0).getData().get(0).get("row").get(0));
                return l;
            }
        }
        catch (Exception e) {
            this.log.error("error: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
        finally {
            httpMethod.releaseConnection();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeIndex(Node node) {
        GetMethod method = new GetMethod(this.customPath + "/europeana/hierarchycount/nodeId/" + node.getId());
        try {
            this.client.executeMethod((HttpMethod)method);
            IndexObject obj = (IndexObject)new ObjectMapper().readValue(method.getResponseBodyAsStream(), IndexObject.class);
            long l = obj.getLength();
            return l;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hierarchy getInitialStruct(String id) {
        if (!this.isHierarchy(id)) {
            return null;
        }
        GetMethod method = new GetMethod(this.customPath + "/initial/startup/nodeId/" + StringUtils.replace((String)id, (String)"/", (String)"%2F"));
        this.log.info("path: " + method.getPath());
        try {
            Hierarchy obj;
            this.client.executeMethod((HttpMethod)method);
            ObjectMapper mapper = new ObjectMapper();
            Hierarchy hierarchy = obj = (Hierarchy)mapper.readValue(method.getResponseBodyAsStream(), Hierarchy.class);
            return hierarchy;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public String getCustomPath() {
        return this.customPath;
    }
}

