/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.server.impl;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.mapping.MappingException;
import com.google.code.morphia.query.Query;
import com.mongodb.Mongo;
import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.definitions.solr.beans.FullBean;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.entity.AgentImpl;
import eu.europeana.corelib.solr.entity.AggregationImpl;
import eu.europeana.corelib.solr.entity.BasicProxyImpl;
import eu.europeana.corelib.solr.entity.ConceptImpl;
import eu.europeana.corelib.solr.entity.ConceptSchemeImpl;
import eu.europeana.corelib.solr.entity.EuropeanaAggregationImpl;
import eu.europeana.corelib.solr.entity.EventImpl;
import eu.europeana.corelib.solr.entity.PhysicalThingImpl;
import eu.europeana.corelib.solr.entity.PlaceImpl;
import eu.europeana.corelib.solr.entity.ProvidedCHOImpl;
import eu.europeana.corelib.solr.entity.ProxyImpl;
import eu.europeana.corelib.solr.entity.TimespanImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.solr.exceptions.MongoDBException;
import eu.europeana.corelib.solr.server.EdmMongoServer;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class EdmMongoServerImpl
implements EdmMongoServer {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Mongo mongoServer;
    private String databaseName;
    private String username;
    private String password;
    private Datastore datastore;
    private Morphia morphia;
    EuropeanaIdMongoServer europeanaIdMongoServer;
    private static final String RESOLVE_PREFIX = "http://www.europeana.eu/resolve/record";
    private static final String PORTAL_PREFIX = "http://www.europeana.eu/portal/record";

    public EdmMongoServerImpl(Mongo mongoServer, String databaseName, String username, String password) throws MongoDBException {
        this.log.info("EDMMongoServer is instantiated");
        this.mongoServer = mongoServer;
        this.mongoServer.getMongoOptions().socketKeepAlive = true;
        this.mongoServer.getMongoOptions().autoConnectRetry = true;
        this.mongoServer.getMongoOptions().connectionsPerHost = 10;
        this.mongoServer.getMongoOptions().connectTimeout = 5000;
        this.mongoServer.getMongoOptions().socketTimeout = 6000;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.createDatastore();
    }

    @Override
    public void setEuropeanaIdMongoServer(EuropeanaIdMongoServer europeanaIdMongoServer) {
        this.europeanaIdMongoServer = europeanaIdMongoServer;
    }

    public EdmMongoServerImpl() {
    }

    private void createDatastore() {
        this.morphia = new Morphia();
        this.morphia.map(new Class[]{FullBeanImpl.class});
        this.morphia.map(new Class[]{ProvidedCHOImpl.class});
        this.morphia.map(new Class[]{AgentImpl.class});
        this.morphia.map(new Class[]{AggregationImpl.class});
        this.morphia.map(new Class[]{ConceptImpl.class});
        this.morphia.map(new Class[]{ProxyImpl.class});
        this.morphia.map(new Class[]{PlaceImpl.class});
        this.morphia.map(new Class[]{TimespanImpl.class});
        this.morphia.map(new Class[]{WebResourceImpl.class});
        this.morphia.map(new Class[]{EuropeanaAggregationImpl.class});
        this.morphia.map(new Class[]{EventImpl.class});
        this.morphia.map(new Class[]{PhysicalThingImpl.class});
        this.morphia.map(new Class[]{ConceptSchemeImpl.class});
        this.morphia.map(new Class[]{BasicProxyImpl.class});
        this.datastore = this.morphia.createDatastore(this.mongoServer, this.databaseName);
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            this.datastore.getDB().authenticate(this.username, this.password.toCharArray());
        }
        this.datastore.ensureIndexes();
        this.log.info("EDMMongoServer datastore is created");
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    @Override
    public FullBean getFullBean(String id) throws MongoDBException {
        try {
            return (FullBean)((Query)this.datastore.find(FullBeanImpl.class).field("about").equal((Object)id)).get();
        }
        catch (RuntimeException re) {
            if (re.getCause() != null && re.getCause() instanceof MappingException) {
                throw new MongoDBException(ProblemType.RECORD_RETRIEVAL_ERROR);
            }
            throw re;
        }
    }

    @Override
    public FullBean resolve(String id) {
        EuropeanaId newId = this.europeanaIdMongoServer.retrieveEuropeanaIdFromOld(id);
        if (newId != null) {
            this.europeanaIdMongoServer.updateTime(newId.getNewId(), id);
            FullBeanImpl fBean = (FullBeanImpl)((Query)this.datastore.find(FullBeanImpl.class).field("about").equal((Object)newId.getNewId())).get();
            return fBean;
        }
        newId = this.europeanaIdMongoServer.retrieveEuropeanaIdFromOld(RESOLVE_PREFIX + id);
        if (newId != null) {
            this.europeanaIdMongoServer.updateTime(newId.getNewId(), id);
            return (FullBean)((Query)this.datastore.find(FullBeanImpl.class).field("about").equal((Object)newId.getNewId())).get();
        }
        newId = this.europeanaIdMongoServer.retrieveEuropeanaIdFromOld(PORTAL_PREFIX + id);
        if (newId != null) {
            this.europeanaIdMongoServer.updateTime(newId.getNewId(), id);
            return (FullBean)((Query)this.datastore.find(FullBeanImpl.class).field("about").equal((Object)newId.getNewId())).get();
        }
        this.log.info(String.format("Unresolvable Europeana ID: %s", id));
        return null;
    }

    public String toString() {
        System.out.println(this.databaseName);
        return "MongoDB: [Host: " + this.mongoServer.getAddress().getHost() + "]\n" + "[Port: " + this.mongoServer.getAddress().getPort() + "]\n" + "[DB: " + this.databaseName + "]\n";
    }

    @Override
    public <T> T searchByAbout(Class<T> clazz, String about) {
        return (T)this.datastore.find(clazz).filter("about", (Object)about).get();
    }

    public void close() {
        this.log.info("EDMMongoServer is closed");
        this.mongoServer.close();
    }
}

