/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.solr.bean.impl;

import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.definitions.solr.beans.BriefBean;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.web.service.impl.EuropeanaUrlServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.beans.Field;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize(include=JsonSerialize.Inclusion.NON_EMPTY)
public class BriefBeanImpl
extends IdBeanImpl
implements BriefBean {
    @Field(value="timestamp")
    protected Date timestamp;
    @Field(value="PROVIDER")
    protected String[] provider;
    @Field(value="provider_aggregation_edm_dataProvider")
    protected String[] edmDataProvider;
    @Field(value="provider_aggregation_edm_object")
    protected String[] edmObject;
    @Field(value="COMPLETENESS")
    protected String europeanaCompleteness;
    @Field(value="TYPE")
    protected String[] docType;
    @Field(value="LANGUAGE")
    protected String[] language;
    @Field(value="YEAR")
    protected String[] year;
    @Field(value="RIGHTS")
    protected String[] rights;
    @Field(value="title")
    protected String[] title;
    @Field(value="proxy_dc_creator")
    protected String[] dcCreator;
    @Field(value="proxy_dc_contributor")
    protected String[] dcContributor;
    @Field(value="edm_place")
    protected String[] edmPlace;
    @Field(value="pl_skos_prefLabel")
    protected List<Map<String, String>> edmPlacePrefLabel;
    @Field(value="pl_skos_prefLabel.*")
    protected Map<String, List<String>> edmPlaceLabelLangAware;
    @Field(value="pl_wgs84_pos_lat")
    protected List<String> edmPlaceLatitude;
    @Field(value="pl_wgs84_pos_long")
    protected List<String> edmPlaceLongitude;
    @Field(value="edm_timespan")
    protected String[] edmTimespan;
    @Field(value="ts_skos_prefLabel")
    protected List<Map<String, String>> edmTimespanLabel;
    @Field(value="ts_skos_prefLabel.*")
    protected Map<String, List<String>> edmTimespanLabelLangAware;
    @Field(value="ts_edm_begin")
    protected String[] edmTimespanBegin;
    @Field(value="ts_edm_end")
    protected String[] edmTimespanEnd;
    @Field(value="edm_agent")
    protected String[] edmAgentTerm;
    @Field(value="ag_skos_prefLabel")
    protected List<Map<String, String>> edmAgentLabel;
    @Field(value="ag_skos_prefLabel.*")
    protected Map<String, List<String>> edmAgentLabelLangAware;
    @Field(value="proxy_dcterms_hasPart")
    protected String[] dctermsHasPart;
    @Field(value="proxy_dcterms_spatial")
    protected String[] dctermsSpatial;
    @Field(value="europeana_aggregation_edm_preview")
    protected String[] edmPreview;
    @Field(value="proxy_dc_title")
    protected String[] proxyDcTitle;
    @Field(value="description")
    protected String[] description;
    @Field(value="score")
    protected Float score;
    @Field(value="provider_aggregation_edm_isShownAt")
    protected String[] edmIsShownAt;

    public String[] getEdmPreview() {
        ArrayList<String> previews = new ArrayList<String>();
        if (this.edmObject != null) {
            for (String str : this.edmObject) {
                if (!StringUtils.isNotBlank((String)str)) continue;
                previews.add(EuropeanaUrlServiceImpl.getBeanInstance().getThumbnailUrl(str, this.getType()).toString());
            }
        }
        return previews.toArray(new String[previews.size()]);
    }

    public String[] getTitle() {
        if (this.title != null) {
            return (String[])this.title.clone();
        }
        if (this.proxyDcTitle != null) {
            return (String[])this.proxyDcTitle.clone();
        }
        if (this.description != null) {
            return (String[])this.description.clone();
        }
        return null;
    }

    public String[] getEdmObject() {
        return this.edmObject != null ? (String[])this.edmObject.clone() : null;
    }

    public String[] getDcCreator() {
        return this.dcCreator != null ? (String[])this.dcCreator.clone() : null;
    }

    public String[] getDcContributor() {
        return this.dcContributor != null ? (String[])this.dcContributor.clone() : null;
    }

    public String[] getYear() {
        return this.year != null ? (String[])this.year.clone() : null;
    }

    public String[] getProvider() {
        return this.provider != null ? (String[])this.provider.clone() : null;
    }

    public String[] getLanguage() {
        return this.language != null ? (String[])this.language.clone() : null;
    }

    public DocType getType() {
        return this.docType != null ? DocType.safeValueOf((String[])this.docType) : null;
    }

    public String[] getRights() {
        return this.rights != null ? (String[])this.rights.clone() : null;
    }

    public String[] getDataProvider() {
        return this.edmDataProvider != null ? (String[])this.edmDataProvider.clone() : null;
    }

    public int getEuropeanaCompleteness() {
        return !StringUtils.isBlank((String)this.europeanaCompleteness) ? Integer.parseInt(this.europeanaCompleteness) : 0;
    }

    public String[] getEdmPlace() {
        return this.edmPlace != null ? (String[])this.edmPlace.clone() : null;
    }

    public List<Map<String, String>> getEdmPlaceLabel() {
        if (this.edmPlacePrefLabel != null && this.edmPlacePrefLabel.size() > 0) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            int max = this.edmPlacePrefLabel.size();
            for (int i = 0; i < max; ++i) {
                Map<String, String> label = this.edmPlacePrefLabel.get(i);
                if (label.getClass().getName() == "java.lang.String") {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("def", (String)((Object)label));
                    list.add(map);
                    continue;
                }
                list.add(label);
            }
            return list;
        }
        return this.edmPlacePrefLabel;
    }

    public List<String> getEdmPlaceLatitude() {
        return this.edmPlaceLatitude != null ? this.edmPlaceLatitude : null;
    }

    public List<String> getEdmPlaceLongitude() {
        return this.edmPlaceLongitude != null ? this.edmPlaceLongitude : null;
    }

    public String[] getEdmTimespan() {
        return this.edmTimespan != null ? (String[])this.edmTimespan.clone() : null;
    }

    public List<Map<String, String>> getEdmTimespanLabel() {
        if (this.edmTimespanLabel != null && this.edmTimespanLabel.size() > 0) {
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            int max = this.edmTimespanLabel.size();
            for (int i = 0; i < max; ++i) {
                Map<String, String> label = this.edmTimespanLabel.get(i);
                if (label.getClass().getName() == "java.lang.String") {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("def", (String)((Object)label));
                    list.add(map);
                    continue;
                }
                list.add(label);
            }
            return list;
        }
        return this.edmTimespanLabel;
    }

    public String[] getEdmTimespanBegin() {
        return this.edmTimespanBegin != null ? (String[])this.edmTimespanBegin.clone() : null;
    }

    public String[] getEdmTimespanEnd() {
        return this.edmTimespanEnd != null ? (String[])this.edmTimespanEnd.clone() : null;
    }

    public String[] getEdmAgent() {
        return this.edmAgentTerm != null ? (String[])this.edmAgentTerm.clone() : null;
    }

    public List<Map<String, String>> getEdmAgentLabel() {
        return this.edmAgentLabel;
    }

    public String[] getDctermsHasPart() {
        return this.dctermsHasPart != null ? (String[])this.dctermsHasPart.clone() : null;
    }

    public String[] getDctermsSpatial() {
        return this.dctermsSpatial != null ? (String[])this.dctermsSpatial.clone() : null;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public float getScore() {
        return this.score != null ? this.score.floatValue() : 0.0f;
    }

    public String[] getEdmIsShownAt() {
        return this.edmIsShownAt != null ? (String[])this.edmIsShownAt.clone() : null;
    }

    public Map<String, List<String>> getEdmPlaceLabelLangAware() {
        if (this.edmPlaceLabelLangAware != null) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (String key : this.edmPlaceLabelLangAware.keySet()) {
                retMap.put(StringUtils.substringAfter((String)key, (String)"."), this.edmPlaceLabelLangAware.get(key));
            }
            return retMap;
        }
        return null;
    }

    public Map<String, List<String>> getEdmTimespanLabelLangAware() {
        if (this.edmTimespanLabelLangAware != null) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (String key : this.edmTimespanLabelLangAware.keySet()) {
                retMap.put(StringUtils.substringAfter((String)key, (String)"."), this.edmTimespanLabelLangAware.get(key));
            }
            return retMap;
        }
        return null;
    }

    public Map<String, List<String>> getEdmAgentLabelLangAware() {
        if (this.edmAgentLabelLangAware != null) {
            HashMap<String, List<String>> retMap = new HashMap<String, List<String>>();
            for (String key : this.edmAgentLabelLangAware.keySet()) {
                retMap.put(StringUtils.substringAfter((String)key, (String)"."), this.edmAgentLabelLangAware.get(key));
            }
            return retMap;
        }
        return null;
    }
}

