/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.publication;

import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.server.impl.EdmMongoServerImpl;
import eu.europeana.corelib.solr.utils.construct.FullBeanHandler;
import eu.europeana.corelib.solr.utils.construct.SolrDocumentHandler;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.impl.EuropeanaIdMongoServerImpl;
import eu.europeana.publication.common.ICollection;
import eu.europeana.publication.common.IDocument;
import eu.europeana.publication.common.State;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.solr.client.solrj.impl.HttpSolrServer;

public class CollectionBridge
implements ICollection {
    @Resource
    EdmMongoServerImpl mongoServer;
    @Resource
    EuropeanaIdMongoServerImpl europeanaIdServer;
    @Resource
    HttpSolrServer solrServer;

    public IDocument getDocumentById(String id) {
        Iterator<ICollection> i$ = this.getCollectionHandlers(id.getClass()).iterator();
        if (i$.hasNext()) {
            ICollection collection = i$.next();
            return collection.getDocumentById(id);
        }
        return null;
    }

    public void insertDocument(IDocument document) {
        for (ICollection collection : this.getCollectionHandlers(document.getClass())) {
            collection.insertDocument(document);
        }
    }

    public void updateDocumentUsingId(IDocument document) {
        for (ICollection collection : this.getCollectionHandlers(document.getClass())) {
            collection.updateDocumentUsingId(document);
        }
    }

    public void cloneDocument(IDocument originalDocument, IDocument clonedDocument) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<IDocument> getDocumentsByStatesUsingBatch(List<State> stateVlues, Map<String, List<String>> queryChoices, int batchSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private List<ICollection> getCollectionHandlers(Class<?> clazz) {
        ArrayList<ICollection> collectionHandlers = new ArrayList<ICollection>();
        if (clazz.isAssignableFrom(FullBeanImpl.class)) {
            collectionHandlers.add(new FullBeanHandler(this.mongoServer));
            collectionHandlers.add(new SolrDocumentHandler(this.solrServer));
        } else if (clazz.isAssignableFrom(EuropeanaId.class)) {
            collectionHandlers.add((ICollection)this.europeanaIdServer);
        }
        return collectionHandlers;
    }

    public void deleteDocument(IDocument id) {
        for (ICollection collection : this.getCollectionHandlers(id.getClass())) {
            collection.deleteDocument(id);
        }
    }

    public void commit() throws Exception {
    }
}

