/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.tools.lookuptable.impl;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.mongodb.Mongo;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdRegistry;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdRegistryMongoServer;
import eu.europeana.corelib.tools.lookuptable.FailedRecord;
import eu.europeana.corelib.tools.lookuptable.LookupResult;
import eu.europeana.corelib.tools.lookuptable.LookupState;
import eu.europeana.corelib.tools.lookuptable.impl.EuropeanaIdMongoServerImpl;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;

public class EuropeanaIdRegistryMongoServerImpl
implements MongoServer,
EuropeanaIdRegistryMongoServer {
    private Mongo mongoServer;
    private String databaseName;
    private Datastore datastore;
    private static final String EID = "eid";
    private static final String ORID = "orid";
    private static final String DATE = "last_checked";
    private static final String SESSION = "sessionID";
    private static final String CID = "cid";
    private static final String XMLCHECKSUM = "xmlchecksum";
    private static final String ISDELETED = "deleted";
    private EuropeanaIdMongoServer europeanaIdMongoServer;

    public EuropeanaIdRegistryMongoServerImpl(Mongo mongoServer, String databaseName) {
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.europeanaIdMongoServer = new EuropeanaIdMongoServerImpl(mongoServer, databaseName, "", "");
        this.createDatastore();
    }

    public EuropeanaIdRegistryMongoServerImpl(Mongo mongoServer, String databaseName, String username, String password) {
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.europeanaIdMongoServer = new EuropeanaIdMongoServerImpl(mongoServer, databaseName, "", "");
    }

    @Override
    public EuropeanaIdMongoServer getEuropeanaIdMongoServer() {
        return this.europeanaIdMongoServer;
    }

    private void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{EuropeanaIdRegistry.class});
        morphia.map(new Class[]{FailedRecord.class});
        this.datastore = morphia.createDatastore(this.mongoServer, this.databaseName);
        this.datastore.ensureIndexes();
    }

    @Override
    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        this.mongoServer.close();
    }

    @Override
    public LookupResult lookupUiniqueId(String origID, String collectionID, String xml, String sessionID) {
        String xmlChecksum = this.generatechecksum(xml);
        LookupResult lookupresult = new LookupResult();
        String europeanaIDString = EuropeanaUriUtils.createEuropeanaId((String)collectionID, (String)origID);
        lookupresult.setEuropeanaID(europeanaIDString);
        EuropeanaIdRegistry constructedeuropeanaId = new EuropeanaIdRegistry();
        constructedeuropeanaId.setCid(collectionID);
        constructedeuropeanaId.setEid(europeanaIDString);
        constructedeuropeanaId.setOrid(origID);
        constructedeuropeanaId.setLast_checked(new Date());
        constructedeuropeanaId.setSessionID(sessionID);
        constructedeuropeanaId.setXmlchecksum(xmlChecksum);
        constructedeuropeanaId.setDeleted(false);
        EuropeanaIdRegistry retrievedeuropeanaID = this.retrieveEuropeanaIdFromNew(europeanaIDString);
        UpdateOperations updateops = this.datastore.createUpdateOperations(EuropeanaIdRegistry.class);
        if (retrievedeuropeanaID == null) {
            if (!this.checkForChangedCollection(constructedeuropeanaId)) {
                this.datastore.save((Object)constructedeuropeanaId);
                lookupresult.setState(LookupState.ID_REGISTERED);
                lookupresult.setEuropeanaID(europeanaIDString);
                return lookupresult;
            }
            updateops.set(EID, (Object)constructedeuropeanaId.getEid());
            updateops.set(CID, (Object)collectionID);
            return lookupresult;
        }
        constructedeuropeanaId.setId(retrievedeuropeanaID.getId());
        if (constructedeuropeanaId.getCid().equals(retrievedeuropeanaID.getCid()) && constructedeuropeanaId.getEid().equals(retrievedeuropeanaID.getEid()) && constructedeuropeanaId.getOrid().equals(retrievedeuropeanaID.getOrid()) && !constructedeuropeanaId.getXmlchecksum().equals(retrievedeuropeanaID.getXmlchecksum())) {
            if (constructedeuropeanaId.getSessionID().equals(retrievedeuropeanaID.getSessionID())) {
                this.generateFailedRecord(constructedeuropeanaId, xml, null, LookupState.DUPLICATE_INCOLLECTION);
                lookupresult.setState(LookupState.DUPLICATE_INCOLLECTION);
                updateops.set(XMLCHECKSUM, (Object)xmlChecksum);
                retrievedeuropeanaID.setSessionID(constructedeuropeanaId.getSessionID());
            } else {
                retrievedeuropeanaID.setSessionID(constructedeuropeanaId.getSessionID());
                lookupresult.setState(LookupState.UPDATE);
                updateops.set(XMLCHECKSUM, (Object)xmlChecksum);
            }
            return this.processlookupresult(retrievedeuropeanaID, (UpdateOperations<EuropeanaIdRegistry>)updateops, lookupresult, sessionID);
        }
        if (constructedeuropeanaId.getCid().equals(retrievedeuropeanaID.getCid()) && constructedeuropeanaId.getEid().equals(retrievedeuropeanaID.getEid()) && constructedeuropeanaId.getOrid().equals(retrievedeuropeanaID.getOrid()) && constructedeuropeanaId.getXmlchecksum().equals(retrievedeuropeanaID.getXmlchecksum())) {
            if (constructedeuropeanaId.getSessionID().equals(retrievedeuropeanaID.getSessionID())) {
                lookupresult.setState(LookupState.DUPLICATE_INCOLLECTION);
                this.generateFailedRecord(constructedeuropeanaId, xml, null, LookupState.DUPLICATE_INCOLLECTION);
                retrievedeuropeanaID.setSessionID(constructedeuropeanaId.getSessionID());
            } else if (!constructedeuropeanaId.getSessionID().equals(retrievedeuropeanaID.getSessionID())) {
                lookupresult.setState(LookupState.IDENTICAL);
                retrievedeuropeanaID.setSessionID(constructedeuropeanaId.getSessionID());
            }
            return this.processlookupresult(retrievedeuropeanaID, (UpdateOperations<EuropeanaIdRegistry>)updateops, lookupresult, sessionID);
        }
        if (!constructedeuropeanaId.getCid().equals(retrievedeuropeanaID.getCid()) && constructedeuropeanaId.getEid().equals(retrievedeuropeanaID.getEid()) && constructedeuropeanaId.getOrid().equals(retrievedeuropeanaID.getOrid()) && constructedeuropeanaId.getXmlchecksum().equals(retrievedeuropeanaID.getXmlchecksum())) {
            lookupresult.setState(LookupState.DUPLICATE_RECORD_ACROSS_COLLECTIONS);
            String message = "Duplicate record exists between collections:" + constructedeuropeanaId.getCid() + " and " + retrievedeuropeanaID.getCid();
            this.generateFailedRecord(constructedeuropeanaId, xml, message, LookupState.DUPLICATE_RECORD_ACROSS_COLLECTIONS);
            return this.processlookupresult(retrievedeuropeanaID, (UpdateOperations<EuropeanaIdRegistry>)updateops, lookupresult, sessionID);
        }
        if (!constructedeuropeanaId.getCid().equals(retrievedeuropeanaID.getCid()) && constructedeuropeanaId.getEid().equals(retrievedeuropeanaID.getEid()) && constructedeuropeanaId.getOrid().equals(retrievedeuropeanaID.getOrid()) && !constructedeuropeanaId.getXmlchecksum().equals(retrievedeuropeanaID.getXmlchecksum())) {
            lookupresult.setState(LookupState.DUPLICATE_IDENTIFIER_ACROSS_COLLECTIONS);
            String message = "Record with duplicate identifier exists between collections:" + constructedeuropeanaId.getCid() + " and " + retrievedeuropeanaID.getCid();
            this.generateFailedRecord(constructedeuropeanaId, xml, message, LookupState.DUPLICATE_IDENTIFIER_ACROSS_COLLECTIONS);
            return this.processlookupresult(retrievedeuropeanaID, (UpdateOperations<EuropeanaIdRegistry>)updateops, lookupresult, sessionID);
        }
        if (constructedeuropeanaId.getCid().equals(retrievedeuropeanaID.getCid()) && constructedeuropeanaId.getEid().equals(retrievedeuropeanaID.getEid()) && !constructedeuropeanaId.getOrid().equals(retrievedeuropeanaID.getOrid()) && !constructedeuropeanaId.getXmlchecksum().equals(retrievedeuropeanaID.getXmlchecksum())) {
            lookupresult.setState(LookupState.DERIVED_DUPLICATE_INCOLLECTION);
            String message = "Records " + constructedeuropeanaId.getOrid() + " and " + retrievedeuropeanaID.getOrid() + " resulted in the creation of a common identifier during Europeana UUID generation (" + constructedeuropeanaId.getEid() + ")";
            this.generateFailedRecord(constructedeuropeanaId, xml, message, LookupState.DERIVED_DUPLICATE_INCOLLECTION);
        }
        return lookupresult;
    }

    private LookupResult processlookupresult(EuropeanaIdRegistry retrievedeuropeanaID, UpdateOperations<EuropeanaIdRegistry> updateops, LookupResult lookupresult, String sessionID) {
        updateops.set(DATE, (Object)new Date());
        updateops.set(SESSION, (Object)sessionID);
        this.datastore.update((Object)retrievedeuropeanaID, updateops);
        return lookupresult;
    }

    private boolean checkForChangedCollection(EuropeanaIdRegistry constructedeuropeanaId) {
        EuropeanaIdRegistry retrievedId = this.retrieveFromOriginalXML(constructedeuropeanaId.getOrid(), constructedeuropeanaId.getXmlchecksum());
        if (retrievedId != null) {
            EuropeanaId eurId = new EuropeanaId();
            eurId.setNewId(constructedeuropeanaId.getEid());
            eurId.setOldId(retrievedId.getEid());
            eurId.setTimestamp(new Date().getTime());
            this.europeanaIdMongoServer.saveEuropeanaId(eurId);
            return true;
        }
        return false;
    }

    private void generateFailedRecord(EuropeanaIdRegistry eurId, String xml, String message, LookupState lookupState) {
        FailedRecord failedRecord = (FailedRecord)this.datastore.find(FailedRecord.class).filter("originalId", (Object)eurId.getOrid()).filter("collectionId", (Object)eurId.getCid()).get();
        System.out.println("Generating failed Record " + eurId + ", Reason: " + lookupState.toString());
        if (failedRecord == null) {
            failedRecord = new FailedRecord();
            failedRecord.setCollectionId(eurId.getCid());
            failedRecord.setEuropeanaId(eurId.getEid());
            failedRecord.setOriginalId(eurId.getOrid());
            failedRecord.setXml(xml);
            failedRecord.setLookupState(lookupState);
            failedRecord.setDate(new Date());
            if (message != null) {
                failedRecord.setMessage(message);
            }
            this.datastore.save((Object)failedRecord);
        } else {
            UpdateOperations updateops = this.datastore.createUpdateOperations(FailedRecord.class);
            updateops.set("xml", (Object)xml);
            updateops.set("lookupState", (Object)lookupState);
            updateops.set("date", (Object)new Date());
            this.datastore.update((Object)failedRecord, updateops);
        }
    }

    @Override
    public void createFailedRecord(LookupState state, String collectionID, String oldID, String newId, String xml) {
        FailedRecord failedRecord = (FailedRecord)this.datastore.find(FailedRecord.class).filter("originalId", (Object)oldID).filter("collectionId", (Object)collectionID).get();
        if (failedRecord == null) {
            failedRecord = new FailedRecord();
            failedRecord.setCollectionId(collectionID);
            failedRecord.setEuropeanaId(newId);
            failedRecord.setOriginalId(oldID);
            failedRecord.setXml(xml);
            failedRecord.setLookupState(state);
            failedRecord.setDate(new Date());
            this.datastore.save((Object)failedRecord);
        } else {
            UpdateOperations updateops = this.datastore.createUpdateOperations(FailedRecord.class);
            updateops.set("xml", (Object)xml);
            updateops.set("lookupState", (Object)state);
            updateops.set("date", (Object)new Date());
            this.datastore.update((Object)failedRecord, updateops);
        }
    }

    @Override
    public void deleteFailedRecord(String europeanaId, String collectionID) {
        Query deleteQuery = (Query)((Query)this.datastore.createQuery(FailedRecord.class).field("europeanaId").equal((Object)europeanaId)).field("collectionId").equal((Object)collectionID);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteFailedRecords(String collectionID) {
        Query deleteQuery = (Query)this.datastore.createQuery(FailedRecord.class).field("collectionId").equal((Object)collectionID);
        this.datastore.findAndDelete(deleteQuery);
    }

    private String generatechecksum(String xml) {
        return DigestUtils.shaHex((String)xml);
    }

    @Override
    public List<EuropeanaIdRegistry> retrieveEuropeanaIdFromOriginal(String originalId, String collectionid) {
        ArrayList<EuropeanaIdRegistry> retlist = new ArrayList<EuropeanaIdRegistry>();
        List list = ((Query)this.datastore.find(EuropeanaIdRegistry.class).field(ORID).equal((Object)originalId)).asList();
        for (EuropeanaIdRegistry entry : list) {
            if (entry.isDeleted()) continue;
            retlist.add(entry);
        }
        return retlist;
    }

    @Override
    public EuropeanaIdRegistry retrieveEuropeanaIdFromNew(String newId) {
        List retrList = ((Query)this.datastore.find(EuropeanaIdRegistry.class).field(EID).equal((Object)newId)).asList();
        if (retrList.isEmpty()) {
            return null;
        }
        for (EuropeanaIdRegistry entry : retrList) {
            if (entry.isDeleted()) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean oldIdExists(String newId) {
        return ((Query)this.datastore.find(EuropeanaIdRegistry.class).field(EID).equal((Object)newId)).get() != null;
    }

    @Override
    public EuropeanaIdRegistry retrieveFromOriginalXML(String orId, String xml) {
        return (EuropeanaIdRegistry)this.datastore.find(EuropeanaIdRegistry.class).filter(XMLCHECKSUM, (Object)xml).filter(ORID, (Object)orId).get();
    }

    @Override
    public boolean newIdExists(String oldId) {
        return ((Query)this.datastore.find(EuropeanaIdRegistry.class).field(ORID).equal((Object)oldId)).get() != null;
    }

    @Override
    public void deleteEuropeanaIdFromOld(String oldId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteEuropeanaIdFromNew(String newId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("newId").equal((Object)newId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void updateTime(String newId, String oldId) {
        Query updateQuery = (Query)((Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId)).field("newId").equal((Object)newId);
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("timestamp", (Object)new Date().getTime());
        this.datastore.update(updateQuery, ops);
    }

    @Override
    public List<Map<String, String>> getFailedRecords(String collectionId) {
        ArrayList<Map<String, String>> failedRecords = new ArrayList<Map<String, String>>();
        for (FailedRecord failedRecord : this.datastore.find(FailedRecord.class).filter("collectionId", (Object)collectionId).asList()) {
            HashMap<String, String> record = new HashMap<String, String>();
            record.put("collectionId", failedRecord.getCollectionId());
            record.put("originalId", failedRecord.getOriginalId());
            record.put("europeanaId", failedRecord.getEuropeanaId());
            record.put("edm", failedRecord.getXml());
            record.put("lookupState", failedRecord.getLookupState().toString());
            record.put("date", failedRecord.getDate().toString());
            if (failedRecord.getMessage() != null) {
                record.put("message", failedRecord.getMessage());
            }
            failedRecords.add(record);
        }
        return failedRecords;
    }

    @Override
    public void markdeleted(String europeanaID, boolean isdeleted) {
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaIdRegistry.class).set(ISDELETED, (Object)isdeleted);
        Query query = (Query)this.datastore.createQuery(EuropeanaIdRegistry.class).field(EID).equal((Object)europeanaID);
        this.datastore.findAndModify(query, ops);
    }

    @Override
    public boolean isdeleted(String europeanaID) {
        Query query = (Query)this.datastore.createQuery(EuropeanaIdRegistry.class).field(EID).equal((Object)europeanaID);
        EuropeanaIdRegistry idr = (EuropeanaIdRegistry)this.datastore.find(EuropeanaIdRegistry.class).filter(EID, (Object)europeanaID).get();
        return idr.isDeleted();
    }

    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }
}

