/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.tools.lookuptable.impl;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.mongodb.Mongo;
import eu.europeana.corelib.solr.MongoServer;
import eu.europeana.corelib.tools.lookuptable.Collection;
import eu.europeana.corelib.tools.lookuptable.CollectionMongoServer;
import java.util.List;

public class CollectionMongoServerImpl
implements MongoServer,
CollectionMongoServer {
    private Mongo mongoServer;
    private String databaseName;
    private Datastore datastore;

    public CollectionMongoServerImpl(Mongo mongoServer, String databaseName) {
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.createDatastore();
    }

    public CollectionMongoServerImpl() {
    }

    private void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{Collection.class});
        this.datastore = morphia.createDatastore(this.mongoServer, this.databaseName);
        this.datastore.ensureIndexes();
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        this.mongoServer.close();
    }

    @Override
    public String findNewCollectionId(String oldCollectionId) {
        return ((Query)this.datastore.find(Collection.class).field("oldCollectionId").equal((Object)oldCollectionId)).get() != null ? ((Collection)((Query)this.datastore.find(Collection.class).field("oldCollectionId").equal((Object)oldCollectionId)).get()).getNewCollectionId() : null;
    }

    @Override
    public String findOldCollectionId(String newCollectionId) {
        return ((Query)this.datastore.find(Collection.class).field("newCollectionId").equal((Object)newCollectionId)).get() != null ? ((Collection)((Query)this.datastore.find(Collection.class).field("newCollectionId").equal((Object)newCollectionId)).get()).getOldCollectionId() : null;
    }

    @Override
    public void saveCollection(Collection collection) {
        this.datastore.save((Object)collection);
    }

    @Override
    public List<Collection> retrieveAllCollections() {
        return this.datastore.find(Collection.class).asList();
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }
}

