/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.definitions.edm.entity.WebResource;
import eu.europeana.corelib.edm.model.metainfo.WebResourceMetaInfoImpl;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebMetaInfo {
    private static final Logger LOG = LogManager.getLogger(WebMetaInfo.class);
    private static final HashFunction hf = Hashing.md5();

    private WebMetaInfo() {
    }

    public static void injectWebMetaInfoBatch(FullBean fullBean, EdmMongoServer mongoServer, Boolean manifestAddUrl, String api2BaseUrl) {
        if (fullBean == null || fullBean.getAggregations() == null || fullBean.getAggregations().isEmpty()) {
            return;
        }
        Aggregation aggregationFix = (Aggregation)fullBean.getAggregations().get(0);
        if (aggregationFix.getEdmIsShownBy() != null) {
            String isShownBy = aggregationFix.getEdmIsShownBy();
            WebMetaInfo.generateWebResource(aggregationFix, isShownBy);
        }
        if (aggregationFix.getEdmIsShownAt() != null) {
            String isShownAt = aggregationFix.getEdmIsShownAt();
            WebMetaInfo.generateWebResource(aggregationFix, isShownAt);
        }
        if (aggregationFix.getEdmObject() != null) {
            String edmObject = aggregationFix.getEdmObject();
            WebMetaInfo.generateWebResource(aggregationFix, edmObject);
        }
        if (aggregationFix.getHasView() != null) {
            for (String hasView : aggregationFix.getHasView()) {
                WebMetaInfo.generateWebResource(aggregationFix, hasView);
            }
        }
        fullBean.getAggregations().set(0, aggregationFix);
        WebMetaInfo.fillAggregations(fullBean, mongoServer);
        WebMetaInfo.addReferencedByIIIF(fullBean, manifestAddUrl, api2BaseUrl);
    }

    private static void fillAggregations(FullBean fullBean, EdmMongoServer mongoServer) {
        Map<String, WebResource> webResourceHashCodes = WebMetaInfo.prepareWebResourceHashCodes(fullBean);
        Map metaInfos = mongoServer.retrieveWebMetaInfos(new ArrayList<String>(webResourceHashCodes.keySet()));
        for (Map.Entry metaInfo : metaInfos.entrySet()) {
            WebResource webResource = webResourceHashCodes.get(metaInfo.getKey());
            if (webResource == null || metaInfo.getValue() == null) continue;
            ((WebResourceImpl)webResource).setWebResourceMetaInfo((WebResourceMetaInfoImpl)metaInfo.getValue());
        }
    }

    private static Map<String, WebResource> prepareWebResourceHashCodes(FullBean fullBean) {
        HashMap<String, WebResource> hashCodes = new HashMap<String, WebResource>();
        for (WebResource webResource : fullBean.getEuropeanaAggregation().getWebResources()) {
            if (webResource.getAbout() != null) {
                String hashCodeAbout = WebMetaInfo.generateHashCode(webResource.getAbout(), fullBean.getAbout());
                hashCodes.put(hashCodeAbout, webResource);
            }
            if (hashCodes.containsValue(webResource) || fullBean.getEuropeanaAggregation().getEdmIsShownBy() == null) continue;
            String hashCodeIsShownBy = WebMetaInfo.generateHashCode(fullBean.getEuropeanaAggregation().getEdmIsShownBy(), fullBean.getAbout());
            hashCodes.put(hashCodeIsShownBy, webResource);
        }
        for (Aggregation aggregation : fullBean.getAggregations()) {
            HashSet<String> urls = new HashSet<String>();
            if (StringUtils.isNotEmpty((CharSequence)aggregation.getEdmIsShownBy())) {
                urls.add(aggregation.getEdmIsShownBy());
            }
            if (StringUtils.isNotEmpty((CharSequence)aggregation.getEdmIsShownAt())) {
                urls.add(aggregation.getEdmIsShownAt());
            }
            if (null != aggregation.getHasView()) {
                urls.addAll(Arrays.asList(aggregation.getHasView()));
            }
            if (null != aggregation.getEdmObject()) {
                urls.add(aggregation.getEdmObject());
            }
            for (WebResource webResource : aggregation.getWebResources()) {
                if (!urls.contains(webResource.getAbout().trim())) continue;
                if (webResource.getAbout() != null) {
                    String hashCodeAbout = WebMetaInfo.generateHashCode(webResource.getAbout(), fullBean.getAbout());
                    hashCodes.put(hashCodeAbout, webResource);
                }
                if (!hashCodes.containsValue(webResource) && aggregation.getEdmIsShownBy() != null) {
                    String hashCodeIsShownBy = WebMetaInfo.generateHashCode(aggregation.getEdmIsShownBy(), aggregation.getAbout());
                    hashCodes.put(hashCodeIsShownBy, webResource);
                }
                if (hashCodes.containsValue(webResource) || aggregation.getEdmIsShownAt() == null) continue;
                String hashCodeIsShownAt = WebMetaInfo.generateHashCode(aggregation.getEdmIsShownAt(), aggregation.getAbout());
                hashCodes.put(hashCodeIsShownAt, webResource);
            }
        }
        return hashCodes;
    }

    private static void generateWebResource(Aggregation aggregation, String about) {
        ArrayList<WebResourceImpl> wResources;
        WebResourceImpl wr2;
        if (aggregation.getWebResources() != null) {
            for (WebResourceImpl wr2 : aggregation.getWebResources()) {
                if (!StringUtils.equals((CharSequence)about, (CharSequence)wr2.getAbout())) continue;
                return;
            }
        }
        if ((wResources = aggregation.getWebResources()) == null) {
            wResources = new ArrayList<WebResourceImpl>();
        }
        wr2 = new WebResourceImpl();
        wr2.setAbout(about);
        wResources.add(wr2);
        aggregation.setWebResources(wResources);
    }

    private static String generateHashCode(String wrId, String recordId) {
        return hf.newHasher().putString((CharSequence)wrId, Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)recordId, Charsets.UTF_8).hash().toString();
    }

    private static void addReferencedByIIIF(FullBean bean, Boolean manifestAddUrl, String api2BaseUrl) {
        long start = System.nanoTime();
        if (WebMetaInfo.isNewsPaperRecord(bean) && !WebMetaInfo.hasReferencedBy(bean) && bean.getAggregations() != null) {
            for (Aggregation a : bean.getAggregations()) {
                for (WebResource wr : a.getWebResources()) {
                    String iiifId = "https://iiif.europeana.eu/presentation" + bean.getAbout() + "/manifest";
                    if (manifestAddUrl != null && manifestAddUrl.equals(Boolean.TRUE)) {
                        iiifId = iiifId + "?recordApi=" + api2BaseUrl;
                    }
                    wr.setDctermsIsReferencedBy(new String[]{iiifId});
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AddReferencedByIIIF took {} ns", (Object)(System.nanoTime() - start));
        }
    }

    public static boolean isNewsPaperRecord(FullBean bean) {
        boolean result = false;
        if (bean.getProxies() != null) {
            for (Proxy proxy : bean.getProxies()) {
                Map langMap = proxy.getDcType();
                if (langMap != null) {
                    List langValues;
                    Iterator iterator = langMap.values().iterator();
                    while (iterator.hasNext() && !(result = (langValues = (List)iterator.next()).contains("http://schema.org/PublicationIssue") || langValues.contains("https://schema.org/PublicationIssue"))) {
                    }
                }
                if (!result) continue;
                break;
            }
        }
        LOG.debug("isNewsPaperRecord = {}", (Object)result);
        return result;
    }

    public static boolean hasReferencedBy(FullBean bean) {
        if (bean.getAggregations() != null) {
            for (Aggregation a : bean.getAggregations()) {
                for (WebResource wr : a.getWebResources()) {
                    if (wr.getDctermsIsReferencedBy() == null || wr.getDctermsIsReferencedBy().length <= 0) continue;
                    LOG.debug("hasReferencedBy = true");
                    return true;
                }
            }
        }
        LOG.debug("hasReferencedBy = false");
        return false;
    }
}

