/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.entity.Node2Neo4jBeanConverter;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.neo4j.server.Neo4jServer;
import eu.europeana.corelib.search.Neo4jSearchService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.neo4j.graphdb.Node;

public class Neo4jSearchServiceImpl
implements Neo4jSearchService {
    @Resource(name="corelib_solr_neo4jServer")
    protected Neo4jServer neo4jServer;

    @PostConstruct
    private void init() {
        LogManager.getLogger(Neo4jSearchServiceImpl.class).info("Connected to {}", (Object)this.neo4jServer.getServerPath());
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout, int offset, int limit) {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        long startIndex = offset;
        List children = this.neo4jServer.getChildren(rdfAbout, offset, limit);
        for (CustomNode child : children) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)child, (long)(++startIndex)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout, int offset) {
        return this.getChildren(rdfAbout, offset, 10);
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout) {
        return this.getChildren(rdfAbout, 0, 10);
    }

    private Node getNode(String rdfAbout) throws Neo4JException {
        return this.neo4jServer.getNode(rdfAbout);
    }

    @Override
    public Neo4jBean getHierarchicalBean(String rdfAbout) throws Neo4JException {
        Node node = this.getNode(rdfAbout);
        if (node != null) {
            return Node2Neo4jBeanConverter.toNeo4jBean((Node)node, (long)this.neo4jServer.getNodeIndex(node));
        }
        return null;
    }

    @Override
    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout, int offset, int limit) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List precedingSiblings = this.neo4jServer.getPrecedingSiblings(rdfAbout, offset, limit);
        long startIndex = this.neo4jServer.getNodeIndexByRdfAbout(rdfAbout) - (long)offset;
        for (CustomNode precedingSibling : precedingSiblings) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)precedingSibling, (long)(--startIndex)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout, int limit) throws Neo4JException {
        return this.getPrecedingSiblings(rdfAbout, 0, 10);
    }

    @Override
    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout) throws Neo4JException {
        return this.getPrecedingSiblings(rdfAbout, 10);
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String rdfAbout, int offset, int limit) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List followingSiblings = this.neo4jServer.getFollowingSiblings(rdfAbout, offset, limit);
        long startIndex = this.neo4jServer.getNodeIndexByRdfAbout(rdfAbout) + (long)offset;
        for (CustomNode followingSibling : followingSiblings) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)followingSibling, (long)(++startIndex)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String rdfAbout, int limit) throws Neo4JException {
        return this.getFollowingSiblings(rdfAbout, 0, 10);
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String rdfAbout) throws Neo4JException {
        return this.getFollowingSiblings(rdfAbout, 10);
    }

    @Override
    public long getChildrenCount(String rdfAbout) throws Neo4JException {
        return this.neo4jServer.getChildrenCount(this.getNode(rdfAbout));
    }

    @Override
    public Neo4jStructBean getInitialStruct(String nodeId) throws Neo4JException {
        return this.addParentNodeIndex(Node2Neo4jBeanConverter.toNeo4jStruct((Hierarchy)this.neo4jServer.getInitialStruct(nodeId), (long)this.neo4jServer.getNodeIndex(this.getNode(nodeId))));
    }

    private Neo4jStructBean addParentNodeIndex(Neo4jStructBean struct) throws Neo4JException {
        if (!struct.getParents().isEmpty()) {
            for (Neo4jBean parent : struct.getParents()) {
                parent.setIndex(Long.valueOf(this.neo4jServer.getNodeIndex(this.getNode(parent.getId()))));
            }
        }
        return struct;
    }
}

