/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.definitions.solr.model.QuerySort;
import eu.europeana.corelib.definitions.solr.model.Term;
import eu.europeana.corelib.edm.exceptions.BadDataException;
import eu.europeana.corelib.edm.exceptions.MongoDBException;
import eu.europeana.corelib.edm.exceptions.MongoRuntimeException;
import eu.europeana.corelib.edm.exceptions.SolrIOException;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.impl.WebMetaInfo;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.query.MoreLikeThis;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.springframework.beans.factory.annotation.Value;

public class SearchServiceImpl
implements SearchService {
    @Deprecated
    private static final int DEFAULT_MLT_COUNT = 10;
    private static final String UNION_FACETS_FORMAT = "'{'!ex={0}'}'{0}";
    private static final int TIME_ALLOWED = 30000;
    private static final List<String> SPELL_FIELDS = Arrays.asList("who", "what", "where", "when", "title");
    private static final String RESOLVE_PREFIX = "http://www.europeana.eu/resolve/record";
    private static final String PORTAL_PREFIX = "http://www.europeana.eu/portal/record";
    private static final Logger LOG = LogManager.getLogger(SearchServiceImpl.class);
    @Resource(name="corelib_solr_mongoServer")
    protected EdmMongoServer mongoServer;
    @Resource(name="corelib_solr_mongoServer_id")
    protected EuropeanaIdMongoServer idServer;
    private SolrClient solrClient;
    @Value(value="#{europeanaProperties['solr.facetLimit']}")
    private int facetLimit;
    @Value(value="#{europeanaProperties['solr.username']}")
    private String username;
    @Value(value="#{europeanaProperties['solr.password']}")
    private String password;
    @Value(value="#{europeanaProperties['solr.searchLimit']}")
    private int searchLimit;
    @Deprecated
    private String mltFields;
    private boolean debug = false;

    @Override
    public FullBean findById(String collectionId, String recordId, boolean similarItems) throws MongoRuntimeException, MongoDBException {
        return this.findById(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    @Override
    public FullBean findById(String europeanaObjectId, boolean similarItems) throws MongoRuntimeException, MongoDBException {
        FullBean fullBean = this.mongoServer.getFullBean(europeanaObjectId);
        if (fullBean != null) {
            WebMetaInfo.injectWebMetaInfoBatch(fullBean, this.mongoServer);
            if (similarItems) {
                try {
                    fullBean.setSimilarItems(this.findMoreLikeThis(europeanaObjectId));
                }
                catch (EuropeanaException e) {
                    LOG.error("Error trying to retrieve similar items", (Throwable)e);
                }
            }
            if (fullBean.getAggregations() != null && !fullBean.getAggregations().isEmpty()) {
                ((FullBeanImpl)fullBean).setAsParent();
                for (Aggregation agg : fullBean.getAggregations()) {
                    if (agg.getWebResources() == null || agg.getWebResources().isEmpty()) continue;
                    for (WebResourceImpl wRes : agg.getWebResources()) {
                        wRes.initAttributionSnippet();
                    }
                }
            }
        }
        return fullBean;
    }

    @Override
    public FullBean resolve(String collectionId, String recordId, boolean similarItems) throws SolrTypeException {
        return this.resolve(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    @Override
    public FullBean resolve(String europeanaObjectId, boolean similarItems) throws SolrTypeException {
        FullBean fullBean;
        FullBean fullBeanNew = fullBean = this.resolveInternal(europeanaObjectId, similarItems);
        if (fullBean != null) {
            while (fullBeanNew != null) {
                if ((fullBeanNew = this.resolveInternal(fullBeanNew.getAbout(), similarItems)) == null) continue;
                fullBean = fullBeanNew;
            }
        }
        return fullBean;
    }

    private FullBean resolveInternal(String europeanaObjectId, boolean similarItems) throws SolrTypeException {
        this.mongoServer.setEuropeanaIdMongoServer(this.idServer);
        FullBean fullBean = this.mongoServer.resolve(europeanaObjectId);
        if (fullBean != null) {
            WebMetaInfo.injectWebMetaInfoBatch(fullBean, this.mongoServer);
            if (similarItems) {
                try {
                    fullBean.setSimilarItems(this.findMoreLikeThis(fullBean.getAbout()));
                }
                catch (EuropeanaException e) {
                    LOG.error("SolrServerException", (Throwable)e);
                }
            }
        }
        return fullBean;
    }

    @Override
    public String resolveId(String europeanaObjectId) throws BadDataException {
        String lastId;
        ArrayList<String> idsSeen = new ArrayList<String>();
        String newId = lastId = this.resolveIdInternal(europeanaObjectId, idsSeen);
        while (newId != null) {
            if ((newId = this.resolveIdInternal(newId, idsSeen)) == null) continue;
            lastId = newId;
        }
        return lastId;
    }

    @Override
    public String resolveId(String collectionId, String recordId) throws BadDataException {
        return this.resolveId(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId));
    }

    private String resolveIdInternal(String europeanaObjectId, List<String> europeanaObjectIdsSeen) throws BadDataException {
        EuropeanaId newId;
        europeanaObjectIdsSeen.add(europeanaObjectId);
        ArrayList<String> idsToCheck = new ArrayList<String>();
        idsToCheck.add(europeanaObjectId);
        idsToCheck.add(RESOLVE_PREFIX + europeanaObjectId);
        idsToCheck.add(PORTAL_PREFIX + europeanaObjectId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Trying to resolve ids {}", idsToCheck);
        }
        if ((newId = this.idServer.retrieveEuropeanaIdFromOld(idsToCheck)) != null) {
            String result = newId.getNewId();
            if (result != null && europeanaObjectIdsSeen.contains(result)) {
                europeanaObjectIdsSeen.add(result);
                String message = "Cannot resolve record-id because a circular id reference was found! " + europeanaObjectIdsSeen;
                LOG.error(message);
                throw new BadDataException(ProblemType.INCONSISTENT_DATA, message + " The data team will be notified of the problem.");
            }
            return result;
        }
        return null;
    }

    @Override
    @Deprecated
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId) throws EuropeanaException {
        return this.findMoreLikeThis(europeanaObjectId, 10);
    }

    @Override
    @Deprecated
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId, int count) throws EuropeanaException {
        String query = "europeana_id:\"" + europeanaObjectId + "\"";
        SolrQuery solrQuery = new SolrQuery().setQuery(query);
        solrQuery.set("mlt", true);
        if (this.mltFields == null) {
            ArrayList<String> fields = new ArrayList<String>();
            for (MoreLikeThis mltField : MoreLikeThis.values()) {
                fields.add(mltField.toString());
            }
            this.mltFields = ClientUtils.escapeQueryChars((String)StringUtils.join(fields, (String)","));
        }
        solrQuery.set("mlt.fl", new String[]{this.mltFields});
        solrQuery.set("mlt.mintf", 1);
        solrQuery.set("mlt.match.include", new String[]{"false"});
        solrQuery.set("mlt.count", count);
        solrQuery.set("rows", 1);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        if (LOG.isDebugEnabled()) {
            LOG.debug(solrQuery.toString());
        }
        try {
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            NamedList moreLikeThisList = (NamedList)response.getResponse().get("moreLikeThis");
            ArrayList<BriefBean> beans = new ArrayList<BriefBean>();
            if (moreLikeThisList.size() > 0) {
                List docs = (List)moreLikeThisList.getVal(0);
                for (SolrDocument doc : docs) {
                    beans.add((BriefBean)this.solrClient.getBinder().getBean(BriefBeanImpl.class, doc));
                }
            }
            return beans;
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error querying solr", e);
            throw new SolrIOException(e, ProblemType.SOLR_UNREACHABLE);
        }
    }

    @Override
    public <T extends IdBean> ResultSet<T> search(Class<T> beanInterface, Query query, boolean debug) throws EuropeanaException {
        this.debug = debug;
        return this.search(beanInterface, query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends IdBean> ResultSet<T> search(Class<T> beanInterface, Query query) throws EuropeanaException {
        if (query.getStart() != null && query.getStart() + query.getPageSize() > this.searchLimit) {
            throw new SolrTypeException(ProblemType.PAGINATION_LIMIT_REACHED);
        }
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        if (!this.isValidBeanClass(beanClazz)) throw new SolrTypeException(ProblemType.INVALIDCLASS, "Bean class: " + beanClazz);
        String[] refinements = query.getRefinements(true);
        if (!SearchUtils.checkTypeFacet(refinements)) throw new SolrTypeException(ProblemType.INVALIDARGUMENTS);
        SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery(true));
        if (refinements != null) {
            solrQuery.addFilterQuery(refinements);
        }
        solrQuery.setRows(Integer.valueOf(query.getPageSize()));
        solrQuery.setStart(query.getStart());
        this.setSortAndCursor(query, resultSet, solrQuery);
        if (query.getParameterMap() != null) {
            Map parameters = query.getParameterMap();
            for (String key : parameters.keySet()) {
                solrQuery.setParam(key, new String[]{(String)parameters.get(key)});
            }
        }
        if (query.areFacetsAllowed()) {
            solrQuery.setFacet(true);
            List filteredFacets = query.getFacetsUsedInRefinements();
            boolean hasFacetRefinements = filteredFacets != null && !filteredFacets.isEmpty();
            for (String facetToAdd : query.getSolrFacets()) {
                if (query.doProduceFacetUnion() && hasFacetRefinements && filteredFacets.contains(facetToAdd)) {
                    facetToAdd = MessageFormat.format(UNION_FACETS_FORMAT, facetToAdd);
                }
                solrQuery.addFacetField(new String[]{facetToAdd});
            }
            solrQuery.setFacetLimit(this.facetLimit);
        }
        if (query.isSpellcheckAllowed() && (solrQuery.getStart() == null || solrQuery.getStart() <= 1)) {
            solrQuery.setParam("spellcheck", new String[]{"on"});
            solrQuery.setParam("spellcheck.collate", new String[]{"true"});
            solrQuery.setParam("spellcheck.extendedResults", new String[]{"true"});
            solrQuery.setParam("spellcheck.onlyMorePopular", new String[]{"true"});
            solrQuery.setParam("spellcheck.q", new String[]{query.getQuery()});
        }
        if (query.getQueryFacets() != null) {
            for (String facetQuery : query.getQueryFacets()) {
                solrQuery.addFacetQuery(facetQuery);
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Solr query is: " + solrQuery);
            }
            query.setExecutedQuery(solrQuery.toString());
            QueryResponse queryResponse = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            resultSet.setResults(queryResponse.getBeans(beanClazz));
            resultSet.setFacetFields(queryResponse.getFacetFields());
            resultSet.setResultSize(queryResponse.getResults().getNumFound());
            resultSet.setSearchTime(queryResponse.getElapsedTime());
            resultSet.setSpellcheck(queryResponse.getSpellCheckResponse());
            resultSet.setNextCursorMark(queryResponse.getNextCursorMark());
            if (this.debug) {
                resultSet.setSolrQueryString(query.getExecutedQuery());
            }
            if (queryResponse.getFacetQuery() == null) return resultSet;
            resultSet.setQueryFacets(queryResponse.getFacetQuery());
            return resultSet;
        }
        catch (IOException e) {
            LOG.error("Error querying solr", (Throwable)e);
            throw new SolrIOException((Throwable)e, ProblemType.SOLR_UNREACHABLE);
        }
        catch (SolrServerException e) {
            LOG.error("SolrServerException - query = {} ", (Object)solrQuery, (Object)e);
            if (!StringUtils.contains((String)e.getCause().toString(), (String)"Collection")) throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            throw new SolrTypeException((Throwable)e, ProblemType.INVALID_THEME);
        }
        catch (SolrException e) {
            LOG.error("SolrException - query = {} ", (Object)solrQuery, (Object)e);
            if (!e.getMessage().toLowerCase().contains("cursorMark".toLowerCase())) throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            throw new SolrTypeException((Throwable)e, ProblemType.UNABLE_TO_PARSE_CURSORMARK);
        }
    }

    private <T extends IdBean> void setSortAndCursor(Query query, ResultSet<T> resultSet, SolrQuery solrQuery) {
        boolean defaultSort;
        boolean bl = defaultSort = query.getSorts().size() == 0;
        if (defaultSort) {
            solrQuery.setSort("has_media", SolrQuery.ORDER.desc);
            solrQuery.addSort("score", SolrQuery.ORDER.desc);
            solrQuery.addSort("timestamp_update", SolrQuery.ORDER.desc);
            solrQuery.addSort("europeana_completeness", SolrQuery.ORDER.desc);
        } else {
            solrQuery.clearSorts();
            for (QuerySort userSort : query.getSorts()) {
                solrQuery.addSort(userSort.getSortField(), userSort.getSortOrder() == 1 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
        }
        if (query.getCurrentCursorMark() != null) {
            solrQuery.set("cursorMark", new String[]{query.getCurrentCursorMark()});
            if (defaultSort && !solrQuery.getSortField().contains("europeana_id")) {
                solrQuery.addSort("europeana_id", SolrQuery.ORDER.asc);
            }
        } else {
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
        }
        resultSet.setSortField(solrQuery.getSortField());
        resultSet.setCurrentCursorMark(query.getCurrentCursorMark());
    }

    @Deprecated
    private boolean isFieldQuery(String query) {
        String subquery = StringUtils.substringBefore((String)query, (String)"filter_tags");
        String queryWithoutTags = StringUtils.substringBefore((String)subquery, (String)"facet_tags");
        return !StringUtils.contains((String)queryWithoutTags, (String)"who:") && !StringUtils.contains((String)queryWithoutTags, (String)"what:") && !StringUtils.contains((String)queryWithoutTags, (String)"where:") && !StringUtils.contains((String)queryWithoutTags, (String)"when:") && !StringUtils.contains((String)queryWithoutTags, (String)"title:") && StringUtils.contains((String)queryWithoutTags, (String)":") && (!StringUtils.contains((String)queryWithoutTags.trim(), (String)" ") || !StringUtils.contains((String)queryWithoutTags.trim(), (String)"\""));
    }

    private boolean isValidBeanClass(Class<? extends IdBeanImpl> beanClazz) {
        return beanClazz == BriefBeanImpl.class || beanClazz == ApiBeanImpl.class || beanClazz == RichBeanImpl.class;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize) throws SolrTypeException {
        return this.suggestions(query, pageSize, null);
    }

    @Override
    public List<FacetField.Count> createCollections(String facetFieldName, String queryString, String ... refinements) throws EuropeanaException {
        Query query = new Query(queryString).setParameter("rows", "0").setParameter("facet", "true").setRefinements(refinements).setParameter("facet.mincount", "1").setParameter("facet.limit", "750").setSpellcheckAllowed(false);
        query.setSolrFacet(facetFieldName);
        ResultSet<BriefBean> response = this.search(BriefBean.class, query);
        for (FacetField facetField : response.getFacetFields()) {
            if (!facetField.getName().equalsIgnoreCase(facetFieldName)) continue;
            return facetField.getValues();
        }
        return new ArrayList<FacetField.Count>();
    }

    @Override
    public Map<String, Integer> seeAlso(List<String> queries) {
        return this.queryFacetSearch("*:*", null, queries);
    }

    @Override
    public Map<String, Integer> queryFacetSearch(String query, String[] qf, List<String> queries) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(query);
        if (qf != null) {
            solrQuery.addFilterQuery(qf);
        }
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        for (String queryFacet : queries) {
            solrQuery.addFacetQuery(queryFacet);
        }
        Map queryFacets = null;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Solr query is: " + solrQuery.toString());
            }
            QueryResponse response = this.solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            queryFacets = response.getFacetQuery();
        }
        catch (SolrServerException e) {
            LOG.error("SolrServerException - query = {} ", (Object)solrQuery, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Exception - class = {}, query = {}", (Object)e.getClass().getCanonicalName(), (Object)solrQuery, (Object)e);
        }
        return queryFacets;
    }

    private List<Term> getSuggestions(String query, String field, String rHandler) {
        ArrayList<Term> results = new ArrayList<Term>();
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/" + rHandler});
            params.set("q", new String[]{field + ":" + query});
            params.set("rows", 0);
            params.set("timeAllowed", 30000);
            QueryResponse queryResponse = this.solrClient.query((SolrParams)params, SolrRequest.METHOD.POST);
            SpellCheckResponse spellcheckResponse = queryResponse.getSpellCheckResponse();
            if (spellcheckResponse != null && !spellcheckResponse.getSuggestions().isEmpty() && spellcheckResponse.getCollatedResults() != null) {
                for (SpellCheckResponse.Collation collation : spellcheckResponse.getCollatedResults()) {
                    StringBuilder termResult = new StringBuilder();
                    for (SpellCheckResponse.Correction cor : collation.getMisspellingsAndCorrections()) {
                        String[] terms;
                        for (String term : terms = cor.getCorrection().trim().replaceAll("  ", " ").split(" ")) {
                            if (StringUtils.isBlank((String)term) || StringUtils.contains((String)termResult.toString(), (String)term)) continue;
                            termResult.append(term).append(" ");
                        }
                    }
                    Term term = new Term(termResult.toString().trim(), collation.getNumberOfHits(), SuggestionTitle.getMappedTitle(field), SearchUtils.escapeFacet(field, termResult.toString()));
                    results.add(term);
                }
            }
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error querying solr", e);
        }
        return results;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize, String field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s, %d, %s", query, pageSize, field));
        }
        ArrayList<Term> results = new ArrayList<Term>();
        long start = new Date().getTime();
        if (StringUtils.isBlank((String)field) || !SPELL_FIELDS.contains(field)) {
            results.addAll(this.getSuggestions(query, "title", "suggestTitle"));
            results.addAll(this.getSuggestions(query, "who", "suggestWho"));
            results.addAll(this.getSuggestions(query, "what", "suggestWhat"));
            results.addAll(this.getSuggestions(query, "where", "suggestWhere"));
            results.addAll(this.getSuggestions(query, "when", "suggestWhen"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.TITLE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestTitle"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PERSON.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWho"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.SUBJECT.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhat"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PLACE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhere"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.DATE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhen"));
        }
        Collections.sort(results);
        this.logTime("suggestions", new Date().getTime() - start);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Returned %d results in %d ms", results.size() > pageSize ? pageSize : results.size(), new Date().getTime() - start));
        }
        return results.size() > pageSize ? results.subList(0, pageSize) : results;
    }

    public void setSolrClient(SolrClient solrClient) {
        this.solrClient = this.setClient(solrClient);
    }

    private SolrClient setClient(SolrClient solrClient) {
        if (solrClient instanceof HttpSolrClient) {
            HttpSolrClient server = new HttpSolrClient(((HttpSolrClient)solrClient).getBaseURL());
            AbstractHttpClient client = (AbstractHttpClient)server.getHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)new PreEmptiveBasicAuthenticator(this.username, this.password));
            return server;
        }
        return solrClient;
    }

    @Override
    public Date getLastSolrUpdate() throws EuropeanaException {
        long t0 = new Date().getTime();
        try {
            NamedList namedList = this.solrClient.request((SolrRequest)new LukeRequest());
            NamedList index = (NamedList)namedList.get("index");
            if (LOG.isInfoEnabled()) {
                LOG.info("spent: " + (new Date().getTime() - t0));
            }
            return (Date)index.get("lastModified");
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error querying solr", e);
            return null;
        }
    }

    public void logTime(String type, long time) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("elapsed time (%s): %d", type, time));
        }
    }

    private static class PreEmptiveBasicAuthenticator
    implements HttpRequestInterceptor {
        private final UsernamePasswordCredentials credentials;

        public PreEmptiveBasicAuthenticator(String user, String pass) {
            this.credentials = new UsernamePasswordCredentials(user, pass);
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(BasicScheme.authenticate((Credentials)this.credentials, (String)"US-ASCII", (boolean)false));
        }
    }

    private static enum SuggestionTitle {
        TITLE("title", "Title"),
        DATE("when", "Time/Period"),
        PLACE("where", "Place"),
        PERSON("who", "Creator"),
        SUBJECT("what", "Subject");

        private String title;
        private String mappedTitle;

        private SuggestionTitle(String title, String mappedTitle) {
            this.title = title;
            this.mappedTitle = mappedTitle;
        }

        public static String getMappedTitle(String title) {
            for (SuggestionTitle st : SuggestionTitle.values()) {
                if (!StringUtils.equals((String)title, (String)st.title)) continue;
                return st.mappedTitle;
            }
            return null;
        }
    }
}

