/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import com.google.common.base.Charsets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.definitions.edm.entity.WebResource;
import eu.europeana.corelib.edm.model.metainfo.WebResourceMetaInfoImpl;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebMetaInfo {
    private static final Logger LOG = LogManager.getLogger(WebMetaInfo.class);
    private static final HashFunction hf = Hashing.md5();

    private WebMetaInfo() {
    }

    public static void injectWebMetaInfo(FullBean fullBean, EdmMongoServer mongoServer) {
        if (fullBean == null) {
            return;
        }
        if (fullBean.getAggregations() == null || fullBean.getAggregations().isEmpty()) {
            return;
        }
        Aggregation aggregationFix = (Aggregation)fullBean.getAggregations().get(0);
        if (aggregationFix.getEdmIsShownBy() != null) {
            String isShownBy = aggregationFix.getEdmIsShownBy();
            WebMetaInfo.generateWebResource(aggregationFix, isShownBy);
        }
        if (aggregationFix.getEdmObject() != null) {
            String edmObject = aggregationFix.getEdmObject();
            WebMetaInfo.generateWebResource(aggregationFix, edmObject);
        }
        if (aggregationFix.getHasView() != null) {
            for (String hasView : aggregationFix.getHasView()) {
                WebMetaInfo.generateWebResource(aggregationFix, hasView);
            }
        }
        fullBean.getAggregations().set(0, aggregationFix);
        for (WebResource webResource : fullBean.getEuropeanaAggregation().getWebResources()) {
            WebResourceMetaInfoImpl webMetaInfo = null;
            if (webResource.getAbout() != null) {
                String hashCodeAbout = WebMetaInfo.generateHashCode(webResource.getAbout(), fullBean.getAbout());
                webMetaInfo = WebMetaInfo.getMetaInfo(mongoServer, hashCodeAbout);
            }
            if (webMetaInfo == null && fullBean.getEuropeanaAggregation().getEdmIsShownBy() != null) {
                String hashCodeIsShownBy = WebMetaInfo.generateHashCode(fullBean.getEuropeanaAggregation().getEdmIsShownBy(), fullBean.getAbout());
                webMetaInfo = WebMetaInfo.getMetaInfo(mongoServer, hashCodeIsShownBy);
            }
            if (webMetaInfo == null) continue;
            ((WebResourceImpl)webResource).setWebResourceMetaInfo(webMetaInfo);
        }
        for (Aggregation aggregation : fullBean.getAggregations()) {
            HashSet<String> urls = new HashSet<String>();
            if (StringUtils.isNotEmpty((String)aggregation.getEdmIsShownBy())) {
                urls.add(aggregation.getEdmIsShownBy());
            }
            if (null != aggregation.getHasView()) {
                urls.addAll(Arrays.asList(aggregation.getHasView()));
            }
            for (WebResource webResource : aggregation.getWebResources()) {
                if (!urls.contains(webResource.getAbout().trim())) continue;
                WebResourceMetaInfoImpl webMetaInfo = null;
                if (webResource.getAbout() != null) {
                    String hashCodeAbout = WebMetaInfo.generateHashCode(webResource.getAbout(), fullBean.getAbout());
                    webMetaInfo = WebMetaInfo.getMetaInfo(mongoServer, hashCodeAbout);
                }
                if (webMetaInfo == null && aggregation.getEdmIsShownBy() != null) {
                    String hashCodeIsShownBy = WebMetaInfo.generateHashCode(aggregation.getEdmIsShownBy(), aggregation.getAbout());
                    webMetaInfo = WebMetaInfo.getMetaInfo(mongoServer, hashCodeIsShownBy);
                }
                if (webMetaInfo == null) continue;
                ((WebResourceImpl)webResource).setWebResourceMetaInfo(webMetaInfo);
            }
        }
        WebMetaInfo.addReferencedByIIIF(fullBean);
    }

    private static void generateWebResource(Aggregation aggregation, String about) {
        boolean containsWr = false;
        if (aggregation.getWebResources() != null) {
            for (WebResource wr : aggregation.getWebResources()) {
                if (!StringUtils.equals((String)about, (String)wr.getAbout())) continue;
                containsWr = true;
            }
        }
        if (!containsWr) {
            WebResource wr;
            ArrayList<WebResource> wResources = aggregation.getWebResources();
            if (wResources == null) {
                wResources = new ArrayList<WebResource>();
            }
            wr = new WebResourceImpl();
            wr.setAbout(about);
            wResources.add(wr);
            aggregation.setWebResources(wResources);
        }
    }

    private static String generateHashCode(String wrId, String recordId) {
        return hf.newHasher().putString((CharSequence)wrId, Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)recordId, Charsets.UTF_8).hash().toString();
    }

    private static WebResourceMetaInfoImpl getMetaInfo(EdmMongoServer mongoServer, String webResourceMetaInfoId) {
        DB db = mongoServer.getDatastore().getDB();
        DBCollection webResourceMetaInfoColl = db.getCollection("WebResourceMetaInfo");
        BasicDBObject query = new BasicDBObject("_id", (Object)webResourceMetaInfoId);
        DBCursor cursor = webResourceMetaInfoColl.find((DBObject)query);
        Type type = new TypeToken<WebResourceMetaInfoImpl>(){}.getType();
        if (cursor.hasNext()) {
            return (WebResourceMetaInfoImpl)new Gson().fromJson(cursor.next().toString(), type);
        }
        return null;
    }

    private static void addReferencedByIIIF(FullBean bean) {
        long start = System.nanoTime();
        if (WebMetaInfo.isNewsPaperRecord(bean) && !WebMetaInfo.hasReferencedBy(bean) && bean.getAggregations() != null) {
            for (Aggregation a : bean.getAggregations()) {
                for (WebResource wr : a.getWebResources()) {
                    String iiifId = "https://iiif.europeana.eu/presentation" + bean.getAbout() + "/manifest";
                    wr.setDctermsIsReferencedBy(new String[]{iiifId});
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("AddReferencedByIIIF took {} ns", (Object)(System.nanoTime() - start));
        }
    }

    public static boolean isNewsPaperRecord(FullBean bean) {
        if (bean.getProxies() != null) {
            for (Proxy proxy : bean.getProxies()) {
                Iterator iterator;
                Map langMap = proxy.getDcType();
                if (langMap == null || !(iterator = langMap.values().iterator()).hasNext()) continue;
                List langValues = (List)iterator.next();
                boolean result = langValues.contains("http://schema.org/PublicationIssue") || langValues.contains("https://schema.org/PublicationIssue");
                LOG.debug("isNewsPaperRecord = {}", (Object)result);
                return result;
            }
        }
        LOG.debug("isNewsPaperRecord = false");
        return false;
    }

    public static boolean hasReferencedBy(FullBean bean) {
        if (bean.getAggregations() != null) {
            for (Aggregation a : bean.getAggregations()) {
                for (WebResource wr : a.getWebResources()) {
                    if (wr.getDctermsIsReferencedBy() == null || wr.getDctermsIsReferencedBy().length <= 0) continue;
                    LOG.debug("hasReferencedBy = true");
                    return true;
                }
            }
        }
        LOG.debug("hasReferencedBy = false");
        return false;
    }
}

