/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import com.google.common.base.Charsets;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.definitions.edm.entity.WebResource;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.definitions.solr.model.Term;
import eu.europeana.corelib.edm.exceptions.BadDataException;
import eu.europeana.corelib.edm.exceptions.MongoDBException;
import eu.europeana.corelib.edm.exceptions.MongoRuntimeException;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.edm.model.metainfo.WebResourceMetaInfoImpl;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.entity.Node2Neo4jBeanConverter;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.neo4j.server.Neo4jServer;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.impl.PreEmptiveBasicAuthenticator;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.query.MoreLikeThis;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.FullBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.neo4j.graphdb.Node;
import org.springframework.beans.factory.annotation.Value;

public class SearchServiceImpl
implements SearchService {
    private static final Logger LOG = Logger.getLogger(SearchServiceImpl.class);
    private static final int DEFAULT_MLT_COUNT = 10;
    private static final String UNION_FACETS_FORMAT = "'{'!ex={0}'}'{0}";
    private static final int TIME_ALLOWED = 30000;
    private int neo4Jtimeoutmillis = 4000;
    private static final List<String> SPELL_FIELDS = Arrays.asList("who", "what", "where", "when", "title");
    private static final String RESOLVE_PREFIX = "http://www.europeana.eu/resolve/record";
    private static final String PORTAL_PREFIX = "http://www.europeana.eu/portal/record";
    private static final HashFunction hf = Hashing.md5();
    protected static Logger log = Logger.getLogger(SearchServiceImpl.class);
    @Resource(name="corelib_solr_mongoServer")
    protected EdmMongoServer mongoServer;
    @Resource(name="corelib_solr_mongoServer_id")
    protected EuropeanaIdMongoServer idServer;
    @Resource(name="corelib_solr_neo4jServer")
    protected Neo4jServer neo4jServer;
    private SolrServer solrServer;
    @Value(value="#{europeanaProperties['solr.facetLimit']}")
    private int facetLimit;
    @Value(value="#{europeanaProperties['solr.username']}")
    private String username;
    @Value(value="#{europeanaProperties['solr.password']}")
    private String password;
    @Value(value="#{europeanaProperties['solr.searchLimit']}")
    private int searchLimit;
    private String mltFields;
    private boolean debug = false;
    @Resource(name="corelib_solr_mongoServer_metainfo")
    protected EdmMongoServer metainfoMongoServer;

    @Override
    public void setNeo4jTimeoutMillis(int neo4jTimeoutMillis) {
        this.neo4Jtimeoutmillis = neo4jTimeoutMillis;
    }

    @Override
    public FullBean findById(String collectionId, String recordId, boolean similarItems) throws MongoRuntimeException, MongoDBException, Neo4JException {
        return this.findById(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    private void injectWebMetaInfo(FullBean fullBean) {
        List<Object> wResources;
        WebResource wr2;
        int containsWr;
        String isShownBy;
        if (fullBean == null) {
            return;
        }
        if (fullBean.getAggregations() == null || fullBean.getAggregations().isEmpty()) {
            return;
        }
        Aggregation aggregationFix = (Aggregation)fullBean.getAggregations().get(0);
        if (aggregationFix.getEdmIsShownBy() != null) {
            isShownBy = ((Aggregation)fullBean.getAggregations().get(0)).getEdmIsShownBy();
            containsWr = 0;
            if (aggregationFix.getWebResources() != null) {
                for (WebResource wr2 : aggregationFix.getWebResources()) {
                    if (!StringUtils.equals((String)isShownBy, (String)wr2.getAbout())) continue;
                    containsWr = 1;
                }
            }
            if (containsWr == 0) {
                wResources = aggregationFix.getWebResources();
                if (wResources == null) {
                    wResources = new ArrayList<WebResource>();
                }
                wr2 = new WebResourceImpl();
                wr2.setAbout(isShownBy);
                wResources.add(wr2);
                aggregationFix.setWebResources(wResources);
            }
        }
        if (aggregationFix.getEdmObject() != null) {
            isShownBy = ((Aggregation)fullBean.getAggregations().get(0)).getEdmObject();
            containsWr = 0;
            if (aggregationFix.getWebResources() != null) {
                for (WebResource wr2 : aggregationFix.getWebResources()) {
                    if (!StringUtils.equals((String)isShownBy, (String)wr2.getAbout())) continue;
                    containsWr = 1;
                }
            }
            if (containsWr == 0) {
                wResources = aggregationFix.getWebResources();
                if (wResources == null) {
                    wResources = new ArrayList();
                }
                wr2 = new WebResourceImpl();
                wr2.setAbout(isShownBy);
                wResources.add(wr2);
                aggregationFix.setWebResources(wResources);
            }
        }
        if (aggregationFix.getHasView() != null) {
            for (String hasView : aggregationFix.getHasView()) {
                WebResource wr32;
                boolean containsWr2 = false;
                if (aggregationFix.getWebResources() != null) {
                    for (WebResource wr32 : aggregationFix.getWebResources()) {
                        if (!StringUtils.equals((String)hasView, (String)wr32.getAbout())) continue;
                        containsWr2 = true;
                    }
                }
                if (containsWr2) continue;
                ArrayList<WebResource> wResources2 = aggregationFix.getWebResources();
                if (wResources2 == null) {
                    wResources2 = new ArrayList<WebResource>();
                }
                wr32 = new WebResourceImpl();
                wr32.setAbout(hasView);
                wResources2.add(wr32);
                aggregationFix.setWebResources(wResources2);
            }
        }
        fullBean.getAggregations().set(0, aggregationFix);
        for (WebResource webResource : fullBean.getEuropeanaAggregation().getWebResources()) {
            String webMetaInfoId;
            WebResourceMetaInfoImpl webMetaInfo = null;
            if (webResource.getAbout() != null) {
                HashCode hashCodeAbout = hf.newHasher().putString((CharSequence)webResource.getAbout(), Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)fullBean.getAbout(), Charsets.UTF_8).hash();
                webMetaInfoId = hashCodeAbout.toString();
                webMetaInfo = this.getMetaInfo(webMetaInfoId);
            }
            if (webMetaInfo == null && fullBean.getEuropeanaAggregation().getEdmIsShownBy() != null) {
                HashCode hashCodeIsShownBy = hf.newHasher().putString((CharSequence)fullBean.getEuropeanaAggregation().getEdmIsShownBy(), Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)fullBean.getAbout(), Charsets.UTF_8).hash();
                webMetaInfoId = hashCodeIsShownBy.toString();
                webMetaInfo = this.getMetaInfo(webMetaInfoId);
            }
            if (webMetaInfo == null) continue;
            ((WebResourceImpl)webResource).setWebResourceMetaInfo(webMetaInfo);
        }
        for (Aggregation aggregation : fullBean.getAggregations()) {
            HashSet<String> urls = new HashSet<String>();
            if (StringUtils.isNotEmpty((String)aggregation.getEdmIsShownBy())) {
                urls.add(aggregation.getEdmIsShownBy());
            }
            if (null != aggregation.getHasView()) {
                urls.addAll(Arrays.asList(aggregation.getHasView()));
            }
            for (WebResource webResource : aggregation.getWebResources()) {
                String webMetaInfoId;
                if (!urls.contains(webResource.getAbout().trim())) continue;
                WebResourceMetaInfoImpl webMetaInfo = null;
                if (webResource.getAbout() != null) {
                    HashCode hashCodeAbout = hf.newHasher().putString((CharSequence)webResource.getAbout(), Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)fullBean.getAbout(), Charsets.UTF_8).hash();
                    webMetaInfoId = hashCodeAbout.toString();
                    webMetaInfo = this.getMetaInfo(webMetaInfoId);
                }
                if (webMetaInfo == null && aggregation.getEdmIsShownBy() != null) {
                    HashCode hashCodeIsShownBy = hf.newHasher().putString((CharSequence)aggregation.getEdmIsShownBy(), Charsets.UTF_8).putString((CharSequence)"-", Charsets.UTF_8).putString((CharSequence)aggregation.getAbout(), Charsets.UTF_8).hash();
                    webMetaInfoId = hashCodeIsShownBy.toString();
                    webMetaInfo = this.getMetaInfo(webMetaInfoId);
                }
                if (webMetaInfo == null) continue;
                ((WebResourceImpl)webResource).setWebResourceMetaInfo(webMetaInfo);
            }
        }
    }

    @Override
    public FullBean findById(String europeanaObjectId, boolean similarItems) throws MongoRuntimeException, MongoDBException {
        FullBean fullBean = this.mongoServer.getFullBean(europeanaObjectId);
        if (fullBean != null) {
            this.injectWebMetaInfo(fullBean);
            boolean isHierarchy = false;
            try {
                isHierarchy = this.isHierarchy(fullBean.getAbout());
            }
            catch (Neo4JException e) {
                log.error((Object)("Neo4JException: Could not establish Hierarchical status for object with Europeana ID: " + europeanaObjectId + ", reason: " + e.getMessage()));
            }
            if (isHierarchy) {
                for (Proxy prx : fullBean.getProxies()) {
                    prx.setDctermsHasPart(null);
                }
            }
            if (similarItems) {
                try {
                    fullBean.setSimilarItems(this.findMoreLikeThis(europeanaObjectId));
                }
                catch (SolrServerException e) {
                    log.error((Object)("SolrServerException: " + e.getMessage()));
                }
            }
            if (fullBean.getAggregations() != null && !fullBean.getAggregations().isEmpty()) {
                ((FullBeanImpl)fullBean).setAsParent();
                for (Aggregation agg : fullBean.getAggregations()) {
                    if (agg.getWebResources() == null || agg.getWebResources().isEmpty()) continue;
                    for (WebResourceImpl wRes : agg.getWebResources()) {
                        wRes.initAttributionSnippet();
                    }
                }
            }
        }
        return fullBean;
    }

    @Override
    public FullBean resolve(String collectionId, String recordId, boolean similarItems) throws SolrTypeException {
        return this.resolve(EuropeanaUriUtils.createResolveEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    @Override
    public FullBean resolve(String europeanaObjectId, boolean similarItems) throws SolrTypeException {
        FullBean fullBean;
        FullBean fullBeanNew = fullBean = this.resolveInternal(europeanaObjectId);
        if (fullBean != null) {
            while (fullBeanNew != null) {
                if ((fullBeanNew = this.resolveInternal(fullBeanNew.getAbout())) == null) continue;
                fullBean = fullBeanNew;
            }
        }
        return fullBean;
    }

    private FullBean resolveInternal(String europeanaObjectId) throws SolrTypeException {
        this.mongoServer.setEuropeanaIdMongoServer(this.idServer);
        FullBean fullBean = this.mongoServer.resolve(europeanaObjectId);
        this.injectWebMetaInfo(fullBean);
        if (fullBean != null) {
            try {
                fullBean.setSimilarItems(this.findMoreLikeThis(fullBean.getAbout()));
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage()));
            }
        }
        return fullBean;
    }

    @Override
    public String resolveId(String europeanaObjectId) throws BadDataException {
        String lastId;
        ArrayList<String> idsSeen = new ArrayList<String>();
        String newId = lastId = this.resolveIdInternal(europeanaObjectId, idsSeen);
        while (newId != null) {
            if ((newId = this.resolveIdInternal(newId, idsSeen)) == null) continue;
            lastId = newId;
        }
        return lastId;
    }

    @Override
    public String resolveId(String collectionId, String recordId) throws BadDataException {
        return this.resolveId(EuropeanaUriUtils.createResolveEuropeanaId((String)collectionId, (String)recordId));
    }

    private String resolveIdInternal(String europeanaObjectId, List<String> europeanaObjectIdsSeen) throws BadDataException {
        EuropeanaId newId;
        europeanaObjectIdsSeen.add(europeanaObjectId);
        ArrayList<String> idsToCheck = new ArrayList<String>();
        idsToCheck.add(europeanaObjectId);
        idsToCheck.add(RESOLVE_PREFIX + europeanaObjectId);
        idsToCheck.add(PORTAL_PREFIX + europeanaObjectId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to resolve ids " + idsToCheck));
        }
        if ((newId = this.idServer.retrieveEuropeanaIdFromOld(idsToCheck)) != null) {
            String result = newId.getNewId();
            if (result != null && europeanaObjectIdsSeen.contains(result)) {
                europeanaObjectIdsSeen.add(result);
                String message = "Cannot resolve record-id because a circular id reference was found! " + europeanaObjectIdsSeen;
                log.error((Object)message);
                throw new BadDataException(ProblemType.INCONSISTENT_DATA, message + " The data team will be notified of the problem.");
            }
            return result;
        }
        return null;
    }

    @Override
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId) throws SolrServerException {
        return this.findMoreLikeThis(europeanaObjectId, 10);
    }

    @Override
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId, int count) throws SolrServerException {
        String query = "europeana_id:\"" + europeanaObjectId + "\"";
        SolrQuery solrQuery = new SolrQuery().setQuery(query);
        solrQuery.set("mlt", true);
        if (this.mltFields == null) {
            ArrayList<String> fields = new ArrayList<String>();
            for (MoreLikeThis mltField : MoreLikeThis.values()) {
                fields.add(mltField.toString());
            }
            this.mltFields = ClientUtils.escapeQueryChars((String)StringUtils.join(fields, (String)","));
        }
        solrQuery.set("mlt.fl", new String[]{this.mltFields});
        solrQuery.set("mlt.mintf", 1);
        solrQuery.set("mlt.match.include", new String[]{"false"});
        solrQuery.set("mlt.count", count);
        solrQuery.set("rows", 1);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        if (log.isDebugEnabled()) {
            log.debug((Object)solrQuery.toString());
        }
        QueryResponse response = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
        NamedList moreLikeThisList = (NamedList)response.getResponse().get("moreLikeThis");
        ArrayList<BriefBean> beans = new ArrayList<BriefBean>();
        if (moreLikeThisList.size() > 0) {
            List docs = (List)moreLikeThisList.getVal(0);
            for (SolrDocument doc : docs) {
                beans.add((BriefBean)this.solrServer.getBinder().getBean(BriefBeanImpl.class, doc));
            }
        }
        return beans;
    }

    @Override
    public <T extends IdBean> ResultSet<T> search(Class<T> beanInterface, Query query, boolean debug) throws SolrTypeException {
        this.debug = debug;
        return this.search(beanInterface, query);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends IdBean> ResultSet<T> search(Class<T> beanInterface, Query query) throws SolrTypeException {
        if (query.getStart() != null && query.getStart() + query.getPageSize() > this.searchLimit) {
            throw new SolrTypeException(ProblemType.SEARCH_LIMIT_REACHED);
        }
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        if (!this.isValidBeanClass(beanClazz)) throw new SolrTypeException(ProblemType.INVALIDCLASS, "Bean class: " + beanClazz);
        String[] refinements = query.getRefinements(true);
        if (!SearchUtils.checkTypeFacet(refinements)) throw new SolrTypeException(ProblemType.INVALIDARGUMENTS);
        SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery(true));
        if (refinements != null) {
            solrQuery.addFilterQuery(refinements);
        }
        solrQuery.setRows(Integer.valueOf(query.getPageSize()));
        solrQuery.setStart(query.getStart());
        if (query.getCurrentCursorMark() != null) {
            solrQuery.set("cursorMark", new String[]{query.getCurrentCursorMark()});
        } else {
            if (!this.isFieldQuery(solrQuery.getQuery())) {
                solrQuery.setSort("score", SolrQuery.ORDER.desc);
            }
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
        }
        if (!StringUtils.isBlank((String)query.getSort())) {
            solrQuery.setSort(query.getSort(), query.getSortOrder() == 1 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
        solrQuery.addSort("europeana_id", SolrQuery.ORDER.desc);
        resultSet.setSortField(solrQuery.getSortField());
        if (query.getParameterMap() != null) {
            Map parameters = query.getParameterMap();
            for (String key : parameters.keySet()) {
                solrQuery.setParam(key, new String[]{(String)parameters.get(key)});
            }
        }
        if (query.areFacetsAllowed()) {
            solrQuery.setFacet(true);
            List filteredFacets = query.getFacetsUsedInRefinements();
            boolean hasFacetRefinements = filteredFacets != null && filteredFacets.size() > 0;
            for (String facetToAdd : query.getSolrFacets()) {
                if (query.doProduceFacetUnion() && hasFacetRefinements && filteredFacets.contains(facetToAdd)) {
                    facetToAdd = MessageFormat.format(UNION_FACETS_FORMAT, facetToAdd);
                }
                solrQuery.addFacetField(new String[]{facetToAdd});
            }
            solrQuery.setFacetLimit(this.facetLimit);
        }
        if (query.isSpellcheckAllowed() && (solrQuery.getStart() == null || solrQuery.getStart() <= 1)) {
            solrQuery.setParam("spellcheck", new String[]{"on"});
            solrQuery.setParam("spellcheck.collate", new String[]{"true"});
            solrQuery.setParam("spellcheck.extendedResults", new String[]{"true"});
            solrQuery.setParam("spellcheck.onlyMorePopular", new String[]{"true"});
            solrQuery.setParam("spellcheck.q", new String[]{query.getQuery()});
        }
        if (query.getQueryFacets() != null) {
            for (String facetQuery : query.getQueryFacets()) {
                solrQuery.addFacetQuery(facetQuery);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Solr query is: " + solrQuery));
            }
            query.setExecutedQuery(solrQuery.toString());
            QueryResponse queryResponse = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            resultSet.setResults(queryResponse.getBeans(beanClazz));
            resultSet.setFacetFields(queryResponse.getFacetFields());
            resultSet.setResultSize(queryResponse.getResults().getNumFound());
            resultSet.setSearchTime(queryResponse.getElapsedTime());
            resultSet.setSpellcheck(queryResponse.getSpellCheckResponse());
            resultSet.setCurrentCursorMark(query.getCurrentCursorMark());
            resultSet.setNextCursorMark(queryResponse.getNextCursorMark());
            if (this.debug) {
                resultSet.setSolrQueryString(query.getExecutedQuery());
            }
            if (queryResponse.getFacetQuery() == null) return resultSet;
            resultSet.setQueryFacets(queryResponse.getFacetQuery());
            return resultSet;
        }
        catch (SolrServerException e) {
            log.error((Object)("SolrServerException: " + e.getMessage() + " The query was: " + solrQuery));
            throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
        }
        catch (SolrException e) {
            log.error((Object)("SolrException: " + e.getMessage() + " The query was: " + solrQuery));
            if (!e.getMessage().toLowerCase().contains("cursorMark".toLowerCase())) throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            throw new SolrTypeException((Throwable)e, ProblemType.UNABLE_TO_PARSE_CURSORMARK);
        }
    }

    private boolean isFieldQuery(String query) {
        String subquery = StringUtils.substringBefore((String)query, (String)"filter_tags");
        String queryWithoutTags = StringUtils.substringBefore((String)subquery, (String)"facet_tags");
        return !StringUtils.contains((String)queryWithoutTags, (String)"who:") && !StringUtils.contains((String)queryWithoutTags, (String)"what:") && !StringUtils.contains((String)queryWithoutTags, (String)"where:") && !StringUtils.contains((String)queryWithoutTags, (String)"when:") && !StringUtils.contains((String)queryWithoutTags, (String)"title:") && StringUtils.contains((String)queryWithoutTags, (String)":") && (!StringUtils.contains((String)queryWithoutTags.trim(), (String)" ") || !StringUtils.contains((String)queryWithoutTags.trim(), (String)"\""));
    }

    private boolean isValidBeanClass(Class<? extends IdBeanImpl> beanClazz) {
        return beanClazz == BriefBeanImpl.class || beanClazz == ApiBeanImpl.class || beanClazz == RichBeanImpl.class;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize) throws SolrTypeException {
        return this.suggestions(query, pageSize, null);
    }

    @Override
    public List<FacetField.Count> createCollections(String facetFieldName, String queryString, String ... refinements) throws SolrTypeException {
        Query query = new Query(queryString).setParameter("rows", "0").setParameter("facet", "true").setRefinements(refinements).setParameter("facet.mincount", "1").setParameter("facet.limit", "750").setSpellcheckAllowed(false);
        query.setSolrFacet(facetFieldName);
        ResultSet<BriefBean> response = this.search(BriefBean.class, query);
        for (FacetField facetField : response.getFacetFields()) {
            if (!facetField.getName().equalsIgnoreCase(facetFieldName)) continue;
            return facetField.getValues();
        }
        return new ArrayList<FacetField.Count>();
    }

    @Override
    public Map<String, Integer> seeAlso(List<String> queries) {
        return this.queryFacetSearch("*:*", null, queries);
    }

    @Override
    public Map<String, Integer> queryFacetSearch(String query, String[] qf, List<String> queries) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(query);
        if (qf != null) {
            solrQuery.addFilterQuery(qf);
        }
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        for (String queryFacet : queries) {
            solrQuery.addFacetQuery(queryFacet);
        }
        Map queryFacets = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Solr query is: " + solrQuery.toString()));
            }
            QueryResponse response = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            queryFacets = response.getFacetQuery();
        }
        catch (SolrServerException e) {
            log.error((Object)("SolrServerException: " + e.getMessage() + " for query " + solrQuery.toString()), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getClass().getCanonicalName() + " " + e.getMessage() + " for query " + solrQuery.toString()), (Throwable)e);
        }
        return queryFacets;
    }

    @Override
    public <T extends IdBean> ResultSet<T> sitemap(Class<T> beanInterface, Query query) throws SolrTypeException {
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        String[] refinements = query.getRefinements(true);
        if (SearchUtils.checkTypeFacet(refinements)) {
            SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery());
            if (refinements != null) {
                solrQuery.addFilterQuery(refinements);
            }
            solrQuery.setFacet(false);
            solrQuery.setRows(Integer.valueOf(query.getPageSize()));
            solrQuery.setStart(query.getStart());
            solrQuery.setSortField("COMPLETENESS", SolrQuery.ORDER.desc);
            solrQuery.setSortField("score", SolrQuery.ORDER.desc);
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
            if (query.getParameterMap() != null) {
                Map parameters = query.getParameterMap();
                for (String key : parameters.keySet()) {
                    solrQuery.setParam(key, new String[]{(String)parameters.get(key)});
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Solr query is: " + solrQuery));
                }
                QueryResponse queryResponse = this.solrServer.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
                resultSet.setResults(queryResponse.getBeans(beanClazz));
                resultSet.setResultSize(queryResponse.getResults().getNumFound());
                resultSet.setSearchTime(queryResponse.getElapsedTime());
                if (solrQuery.getBool("facet", false)) {
                    resultSet.setFacetFields(queryResponse.getFacetFields());
                }
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage()));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
            catch (SolrException e) {
                log.error((Object)("SolrException: " + e.getMessage()));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
        }
        return resultSet;
    }

    private List<Term> getSuggestions(String query, String field, String rHandler) {
        ArrayList<Term> results = new ArrayList<Term>();
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/" + rHandler});
            params.set("q", new String[]{field + ":" + query});
            params.set("rows", 0);
            params.set("timeAllowed", 30000);
            QueryResponse queryResponse = this.solrServer.query((SolrParams)params, SolrRequest.METHOD.POST);
            SpellCheckResponse spellcheckResponse = queryResponse.getSpellCheckResponse();
            if (spellcheckResponse != null && !spellcheckResponse.getSuggestions().isEmpty() && spellcheckResponse.getCollatedResults() != null) {
                for (SpellCheckResponse.Collation collation : spellcheckResponse.getCollatedResults()) {
                    StringBuilder termResult = new StringBuilder();
                    for (SpellCheckResponse.Correction cor : collation.getMisspellingsAndCorrections()) {
                        String[] terms;
                        for (String term : terms = cor.getCorrection().trim().replaceAll("  ", " ").split(" ")) {
                            if (StringUtils.isBlank((String)term) || StringUtils.contains((String)termResult.toString(), (String)term)) continue;
                            termResult.append(term).append(" ");
                        }
                    }
                    Term term = new Term(termResult.toString().trim(), collation.getNumberOfHits(), SuggestionTitle.getMappedTitle(field), SearchUtils.escapeFacet(field, termResult.toString()));
                    results.add(term);
                }
            }
        }
        catch (SolrServerException e) {
            log.error((Object)("Exception :" + e.getMessage()));
        }
        return results;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize, String field) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s, %d, %s", query, pageSize, field));
        }
        ArrayList<Term> results = new ArrayList<Term>();
        long start = new Date().getTime();
        if (StringUtils.isBlank((String)field) || !SPELL_FIELDS.contains(field)) {
            results.addAll(this.getSuggestions(query, "title", "suggestTitle"));
            results.addAll(this.getSuggestions(query, "who", "suggestWho"));
            results.addAll(this.getSuggestions(query, "what", "suggestWhat"));
            results.addAll(this.getSuggestions(query, "where", "suggestWhere"));
            results.addAll(this.getSuggestions(query, "when", "suggestWhen"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.TITLE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestTitle"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PERSON.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWho"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.SUBJECT.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhat"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PLACE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhere"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.DATE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhen"));
        }
        Collections.sort(results);
        this.logTime("suggestions", new Date().getTime() - start);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returned %d results in %d ms", results.size() > pageSize ? pageSize : results.size(), new Date().getTime() - start));
        }
        return results.size() > pageSize ? results.subList(0, pageSize) : results;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = this.setServer(solrServer);
    }

    private SolrServer setServer(SolrServer solrServer) {
        if (solrServer instanceof HttpSolrServer) {
            HttpSolrServer server = new HttpSolrServer(((HttpSolrServer)solrServer).getBaseURL());
            AbstractHttpClient client = (AbstractHttpClient)server.getHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)new PreEmptiveBasicAuthenticator(this.username, this.password));
            return server;
        }
        return solrServer;
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout, int offset, int limit) {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        long startIndex = offset;
        List children = this.neo4jServer.getChildren(rdfAbout, offset, limit);
        for (CustomNode child : children) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)child, (long)(++startIndex)));
        }
        return beans;
    }

    @Override
    public boolean isHierarchy(String rdfAbout) throws Neo4JException {
        boolean result = false;
        long startTime = System.nanoTime();
        try {
            result = this.neo4jServer.isHierarchyTimeLimited(rdfAbout, this.neo4Jtimeoutmillis);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn((Object)(e.getClass().getSimpleName() + " retrieving isHierarchy information"));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Requesting hierarchy information took " + (System.nanoTime() - startTime) / 1000000L + "ms, max time = " + this.neo4Jtimeoutmillis));
        }
        return result;
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout, int offset) {
        return this.getChildren(rdfAbout, offset, 10);
    }

    @Override
    public List<Neo4jBean> getChildren(String rdfAbout) {
        return this.getChildren(rdfAbout, 0, 10);
    }

    private Node getNode(String rdfAbout) throws Neo4JException {
        return this.neo4jServer.getNode(rdfAbout);
    }

    @Override
    public Neo4jBean getHierarchicalBean(String rdfAbout) throws Neo4JException {
        Node node = this.getNode(rdfAbout);
        if (node != null) {
            return Node2Neo4jBeanConverter.toNeo4jBean((Node)node, (long)this.neo4jServer.getNodeIndex(node));
        }
        return null;
    }

    @Override
    public Date getLastSolrUpdate() throws SolrServerException, IOException {
        long t0 = new Date().getTime();
        NamedList namedList = this.solrServer.request((SolrRequest)new LukeRequest());
        NamedList index = (NamedList)namedList.get("index");
        if (log.isInfoEnabled()) {
            log.info((Object)("spent: " + (new Date().getTime() - t0)));
        }
        return (Date)index.get("lastModified");
    }

    public void logTime(String type, long time) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("elapsed time (%s): %d", type, time));
        }
    }

    @Override
    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout, int limit) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List precedingSiblings = this.neo4jServer.getPrecedingSiblings(rdfAbout, limit);
        long startIndex = this.neo4jServer.getNodeIndexByRdfAbout(rdfAbout);
        for (CustomNode precedingSibling : precedingSiblings) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)precedingSibling, (long)(--startIndex)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout) throws Neo4JException {
        return this.getPrecedingSiblings(rdfAbout, 10);
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String rdfAbout, int limit) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List followingSiblings = this.neo4jServer.getFollowingSiblings(rdfAbout, limit);
        long startIndex = this.neo4jServer.getNodeIndexByRdfAbout(rdfAbout);
        for (CustomNode followingSibling : followingSiblings) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((CustomNode)followingSibling, (long)(++startIndex)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String rdfAbout) throws Neo4JException {
        return this.getFollowingSiblings(rdfAbout, 10);
    }

    @Override
    public long getChildrenCount(String rdfAbout) throws Neo4JException {
        return this.neo4jServer.getChildrenCount(this.getNode(rdfAbout));
    }

    @Override
    public Neo4jStructBean getInitialStruct(String nodeId) throws Neo4JException {
        return this.addParentNodeIndex(Node2Neo4jBeanConverter.toNeo4jStruct((Hierarchy)this.neo4jServer.getInitialStruct(nodeId), (long)this.neo4jServer.getNodeIndex(this.getNode(nodeId))));
    }

    private Neo4jStructBean addParentNodeIndex(Neo4jStructBean struct) throws Neo4JException {
        if (!struct.getParents().isEmpty()) {
            for (Neo4jBean parent : struct.getParents()) {
                parent.setIndex(Long.valueOf(this.neo4jServer.getNodeIndex(this.getNode(parent.getId()))));
            }
        }
        return struct;
    }

    private WebResourceMetaInfoImpl getMetaInfo(String webResourceMetaInfoId) {
        DB db = this.metainfoMongoServer.getDatastore().getDB();
        DBCollection webResourceMetaInfoColl = db.getCollection("WebResourceMetaInfo");
        BasicDBObject query = new BasicDBObject("_id", (Object)webResourceMetaInfoId);
        DBCursor cursor = webResourceMetaInfoColl.find((DBObject)query);
        Type type = new TypeToken<WebResourceMetaInfoImpl>(){}.getType();
        if (cursor.hasNext()) {
            return (WebResourceMetaInfoImpl)new Gson().fromJson(cursor.next().toString(), type);
        }
        return null;
    }

    private static enum SuggestionTitle {
        TITLE("title", "Title"),
        DATE("when", "Time/Period"),
        PLACE("where", "Place"),
        PERSON("who", "Creator"),
        SUBJECT("what", "Subject");

        String title;
        String mappedTitle;

        private SuggestionTitle(String title, String mappedTitle) {
            this.title = title;
            this.mappedTitle = mappedTitle;
        }

        public static String getMappedTitle(String title) {
            for (SuggestionTitle st : SuggestionTitle.values()) {
                if (!StringUtils.equals((String)title, (String)st.title)) continue;
                return st.mappedTitle;
            }
            return null;
        }
    }
}

