/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.utils;

import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.definitions.solr.model.QueryTranslation;
import eu.europeana.corelib.edm.utils.FieldMapping;
import eu.europeana.corelib.search.queryextractor.QueryExtractor;
import eu.europeana.corelib.search.queryextractor.QueryModification;
import eu.europeana.corelib.search.queryextractor.QueryNormalizer;
import eu.europeana.corelib.search.queryextractor.QueryToken;
import eu.europeana.corelib.search.queryextractor.QueryType;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.utils.model.LanguageVersion;
import eu.europeana.corelib.web.service.WikipediaApiService;
import eu.europeana.corelib.web.service.impl.WikipediaApiServiceImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.util.ClientUtils;

public class SearchUtils {
    private static WikipediaApiService wikipediaApiService;
    private static final Pattern ID_PATTERN;

    public static boolean checkTypeFacet(String[] refinements) {
        if (refinements != null) {
            for (String refinement : refinements) {
                if (!StringUtils.contains((String)refinement, (String)"TYPE:") || StringUtils.contains((String)refinement, (String)" OR ") || DocType.safeValueOf((String)StringUtils.substringAfter((String)refinement, (String)"TYPE:")) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static Class<? extends IdBeanImpl> getImplementationClass(Class<? extends IdBean> interfaze) {
        if (interfaze != null) {
            if (interfaze == RichBean.class) {
                return RichBeanImpl.class;
            }
            if (interfaze == ApiBean.class) {
                return ApiBeanImpl.class;
            }
            if (interfaze == BriefBean.class) {
                return BriefBeanImpl.class;
            }
            if (interfaze == IdBean.class) {
                return IdBeanImpl.class;
            }
        }
        return null;
    }

    public static String rewriteQueryFields(String query) {
        if (!query.contains(":")) {
            return query;
        }
        if (query.equals("title:*:*")) {
            return "title:*";
        }
        if (query.equals("who:*:*")) {
            return "who:*";
        }
        if (query.equals("what:*:*")) {
            return "what:*";
        }
        if (query.equals("where:*:*")) {
            return "where:*";
        }
        if (query.equals("when:*:*")) {
            return "when:*";
        }
        for (FieldMapping field : FieldMapping.values()) {
            if (!query.contains(field.getEseField() + ":")) continue;
            query = query.replaceAll("\\b" + field.getEseField() + ":", field.getEdmField() + ":");
        }
        return query;
    }

    public static String escapeQuery(String query) {
        return ClientUtils.escapeQueryChars((String)query).replace("\\ ", " ").replace("\\-", "-");
    }

    public static String escapeFacet(String field, String query) {
        if (StringUtils.isNotBlank((String)field) && StringUtils.isNotBlank((String)query)) {
            query = SearchUtils.escapeQuery(StringUtils.trim((String)query));
            return StringUtils.trim((String)field) + ":\"" + query + "\"";
        }
        return null;
    }

    public static List<FacetField> extractQueryFacets(Map<String, Integer> queryFacets) {
        HashMap<String, FacetField> map = new HashMap<String, FacetField>();
        for (String query : queryFacets.keySet()) {
            Matcher matcher = ID_PATTERN.matcher(query);
            if (!matcher.find()) continue;
            String field = matcher.group(1);
            String value = matcher.group(2);
            if (!map.containsKey(field)) {
                map.put(field, new FacetField(field));
            }
            ((FacetField)map.get(field)).add(value, (long)queryFacets.get(query).intValue());
        }
        return new ArrayList<FacetField>(map.values());
    }

    public static QueryTranslation translateQuery(String query, List<String> languages) {
        QueryTranslation queryTranslation = new QueryTranslation();
        if (wikipediaApiService == null) {
            wikipediaApiService = WikipediaApiServiceImpl.getBeanInstance();
        }
        QueryExtractor queryExtractor = new QueryExtractor(query);
        List<QueryToken> queryTokens = queryExtractor.extractInfo(true);
        ArrayList<QueryModification> queryModifications = new ArrayList<QueryModification>();
        for (QueryToken token : queryTokens) {
            QueryModification queryModification;
            List languageVersions;
            if (token.getType().equals((Object)QueryType.TERMRANGE) || (languageVersions = wikipediaApiService.getVersionsInMultiLanguage(token.getTerm(), languages)).size() <= 0) continue;
            queryTranslation.addLanguageVersions(token.getExtendedPosition(), languageVersions);
            List<String> alternatives = SearchUtils.extractLanguageVersions(languageVersions);
            if (alternatives.size() <= 0 || (queryModification = token.createModification(query, alternatives)) == null) continue;
            queryModifications.add(queryModification);
        }
        queryTranslation.sortLanguageVersions();
        queryTranslation.setModifiedQuery(queryExtractor.rewrite(queryModifications));
        return queryTranslation;
    }

    private static List<String> extractLanguageVersions(List<LanguageVersion> languageVersions) {
        ArrayList<String> termsList = new ArrayList<String>();
        HashSet<String> terms = new HashSet<String>();
        for (LanguageVersion languageVersion : languageVersions) {
            String text = languageVersion.getText();
            if (!StringUtils.isNotBlank((String)text)) continue;
            terms.add(languageVersion.getText());
        }
        termsList.addAll(terms);
        return termsList;
    }

    public static boolean isSimpleQuery(String queryTerm) {
        return SearchUtils.isNotFieldQuery(queryTerm) && (SearchUtils.isTermQuery(queryTerm) || SearchUtils.containsNoneSearchOperators(queryTerm));
    }

    public static boolean isTermQuery(String queryTerm) {
        StandardQueryParser queryParserHelper = new StandardQueryParser();
        Query query = null;
        try {
            query = queryParserHelper.parse(queryTerm, "text");
        }
        catch (QueryNodeException queryNodeException) {
            // empty catch block
        }
        return query != null && query instanceof TermQuery;
    }

    private static boolean containsNoneSearchOperators(String queryTerm) {
        return !StringUtils.contains((String)queryTerm, (String)" AND ") && !StringUtils.contains((String)queryTerm, (String)" NOT ") && !StringUtils.contains((String)queryTerm, (String)" OR ") && !StringUtils.contains((String)queryTerm, (String)"*");
    }

    private static boolean isNotFieldQuery(String queryTerm) {
        return !StringUtils.contains((String)queryTerm, (String)":");
    }

    public static String normalizeBooleans(String query) {
        return QueryNormalizer.normalizeBooleans(query);
    }

    public static void translateQuery(String rawQueryString, QueryTranslation translatedQueries) {
        Map languageVersionMap = translatedQueries.getSortedMap();
        int lastPart = 0;
        String rewritten = "";
        for (String key : languageVersionMap.keySet()) {
            String[] parts = key.split(":", 2);
            int start = Integer.parseInt(parts[0]);
            int end = Integer.parseInt(parts[1]);
            rewritten = rewritten + rawQueryString.substring(lastPart, start);
            String query = rawQueryString.substring(start, end);
            lastPart = end;
            List<String> languageVersions = SearchUtils.extractLanguageVersions((List)languageVersionMap.get(key));
            if (languageVersions == null || languageVersions.size() <= 0) continue;
            if (!(query.startsWith("\"") && query.endsWith("\"") && query.contains(" "))) {
                query = "(" + query + ")";
            }
            String modification = "(" + query + " OR \"" + StringUtils.join(languageVersions, (String)"\" OR \"") + "\")";
            rewritten = rewritten + modification;
        }
        if (lastPart < rawQueryString.length()) {
            rewritten = rewritten + rawQueryString.substring(lastPart);
        }
        translatedQueries.setModifiedQuery(rewritten);
    }

    static {
        ID_PATTERN = Pattern.compile("^\\{!id=([^:]+):([^:]+) ex=(.*?)\\}");
    }
}

