/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.utils;

import eu.europeana.corelib.definitions.model.facets.inverseLogic.MediaTypeEncoding;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.TagEncoding;
import eu.europeana.corelib.definitions.model.facets.logic.CommonTagExtractor;
import eu.europeana.corelib.definitions.model.facets.logic.ImageOrientation;
import eu.europeana.corelib.definitions.model.facets.logic.ImageTagExtractor;
import eu.europeana.corelib.definitions.model.facets.logic.SoundTagExtractor;
import eu.europeana.corelib.definitions.model.facets.logic.VideoTagExtractor;
import java.util.ArrayList;
import java.util.List;

public class FakeTagsUtils {
    public static List<Integer> imageFilterTags(List<String> mimeTypes, List<String> imageSizes, List<Boolean> imageColors, List<Boolean> imageGrayScales, List<String> imageAspectRatios) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        Integer i = 0;
        do {
            String mimeType = null;
            if (mimeTypes.size() != 0) {
                mimeType = mimeTypes.get(i);
            }
            Integer j = 0;
            do {
                String imageSize = null;
                if (imageSizes.size() != 0) {
                    imageSize = imageSizes.get(j);
                }
                Integer k = 0;
                do {
                    Boolean imageColor = null;
                    if (imageColors.size() != 0) {
                        imageColor = imageColors.get(k);
                    }
                    Integer l = 0;
                    do {
                        Boolean imageGrayScale = null;
                        if (imageGrayScales.size() != 0) {
                            imageGrayScale = imageGrayScales.get(l);
                        }
                        Integer m = 0;
                        do {
                            String imageAspectRatio = null;
                            if (imageAspectRatios.size() != 0) {
                                imageAspectRatio = imageAspectRatios.get(m);
                            }
                            Integer filterTag = FakeTagsUtils.calculateTag(1, mimeType, imageSize, imageColor, imageGrayScale, imageAspectRatio, null, null, null, null, null);
                            filterTags.add(filterTag);
                        } while ((m = Integer.valueOf(m + 1)) < imageAspectRatios.size());
                    } while ((l = Integer.valueOf(l + 1)) < imageGrayScales.size());
                } while ((k = Integer.valueOf(k + 1)) < imageColors.size());
            } while ((j = Integer.valueOf(j + 1)) < imageSizes.size());
        } while ((i = Integer.valueOf(i + 1)) < mimeTypes.size());
        return filterTags;
    }

    public static List<Integer> soundFilterTags(List<String> mimeTypes, List<Boolean> soundHQs, List<String> soundDurations) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        Integer i = 0;
        do {
            String mimeType = null;
            if (mimeTypes.size() != 0) {
                mimeType = mimeTypes.get(i);
            }
            Integer j = 0;
            do {
                Boolean soundHQ = null;
                if (soundHQs.size() != 0) {
                    soundHQ = soundHQs.get(j);
                }
                Integer k = 0;
                do {
                    String soundDuration = null;
                    if (soundDurations.size() != 0) {
                        soundDuration = soundDurations.get(k);
                    }
                    Integer filterTag = FakeTagsUtils.calculateTag(2, mimeType, null, null, null, null, null, soundHQ, soundDuration, null, null);
                    filterTags.add(filterTag);
                } while ((k = Integer.valueOf(k + 1)) < soundDurations.size());
            } while ((j = Integer.valueOf(j + 1)) < soundHQs.size());
        } while ((i = Integer.valueOf(i + 1)) < mimeTypes.size());
        return filterTags;
    }

    public static List<Integer> videoFilterTags(List<String> mimeTypes, List<Boolean> videoHQs, List<String> videoDurations) {
        ArrayList<Integer> filterTags = new ArrayList<Integer>();
        Integer i = 0;
        do {
            String mimeType = null;
            if (mimeTypes.size() != 0) {
                mimeType = mimeTypes.get(i);
            }
            Integer j = 0;
            do {
                Boolean videoHQ = null;
                if (videoHQs.size() != 0) {
                    videoHQ = videoHQs.get(j);
                }
                Integer k = 0;
                do {
                    String videoDuration = null;
                    if (videoDurations.size() != 0) {
                        videoDuration = videoDurations.get(k);
                    }
                    Integer filterTag = FakeTagsUtils.calculateTag(3, mimeType, null, null, null, null, null, null, null, videoHQ, videoDuration);
                    filterTags.add(filterTag);
                } while ((k = Integer.valueOf(k + 1)) < videoDurations.size());
            } while ((j = Integer.valueOf(j + 1)) < videoHQs.size());
        } while ((i = Integer.valueOf(i + 1)) < mimeTypes.size());
        return filterTags;
    }

    public static Integer calculateTag(Integer mediaType, String mimeType, String imageSize, Boolean imageColor, Boolean imageGrayScale, String imageAspectRatio, String imageColorPalette, Boolean soundHQ, String soundDuration, Boolean videoHQ, String videoDuration) {
        Integer tag = 0;
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        if (imageSize != null) {
            imageSize = imageSize.toLowerCase();
        }
        if (imageAspectRatio != null) {
            imageAspectRatio = imageAspectRatio.toLowerCase();
        }
        if (imageColorPalette != null) {
            imageColorPalette = imageColorPalette.toUpperCase();
        }
        if (soundDuration != null) {
            soundDuration = soundDuration.toLowerCase();
        }
        if (videoDuration != null) {
            videoDuration = videoDuration.toLowerCase();
        }
        switch (mediaType) {
            case 1: {
                tag = FakeTagsUtils.calculateImageTag(mimeType, imageSize, imageColor, imageGrayScale, imageAspectRatio, imageColorPalette);
                break;
            }
            case 2: {
                tag = FakeTagsUtils.calculateSoundTag(mimeType, soundHQ, soundDuration);
                break;
            }
            case 3: {
                tag = FakeTagsUtils.calculateVideoTag(mimeType, videoHQ, videoDuration);
            }
        }
        return tag;
    }

    public static Integer calculateImageTag(String mimeType, String imageSize, Boolean imageColor, Boolean imageGrayScale, String imageAspectRatio, String imageColorPalette) {
        ImageOrientation imageOrientation = null;
        if (imageAspectRatio != null) {
            if (imageAspectRatio.equals("portrait")) {
                imageOrientation = ImageOrientation.PORTRAIT;
            }
            if (imageAspectRatio.equals("landscape")) {
                imageOrientation = ImageOrientation.LANDSCAPE;
            }
        }
        Integer mediaTypeCode = MediaTypeEncoding.IMAGE.getEncodedValue();
        Integer mimeTypeCode = CommonTagExtractor.getMimeTypeCode((String)mimeType);
        Integer fileSizeCode = ImageTagExtractor.getSizeCode((String)imageSize);
        Integer colorSpaceCode = ImageTagExtractor.getColorSpaceCode((Boolean)imageColor, (Boolean)imageGrayScale);
        Integer aspectRatioCode = ImageTagExtractor.getAspectRatioCode((ImageOrientation)imageOrientation);
        Integer colorCode = ImageTagExtractor.getColorCode((String)imageColorPalette);
        Integer tag = mediaTypeCode | mimeTypeCode << TagEncoding.MIME_TYPE.getBitPos() | fileSizeCode << TagEncoding.IMAGE_SIZE.getBitPos() | colorSpaceCode << TagEncoding.IMAGE_COLOURSPACE.getBitPos() | aspectRatioCode << TagEncoding.IMAGE_ASPECTRATIO.getBitPos() | colorCode << TagEncoding.IMAGE_COLOUR.getBitPos();
        return tag;
    }

    public static Integer calculateSoundTag(String mimeType, Boolean soundHQ, String duration) {
        Integer mediaTypeCode = MediaTypeEncoding.SOUND.getEncodedValue();
        Integer mimeTypeCode = CommonTagExtractor.getMimeTypeCode((String)mimeType);
        Integer qualityCode = SoundTagExtractor.getQualityCode((Boolean)soundHQ);
        Integer durationCode = SoundTagExtractor.getDurationCode((String)duration);
        return mediaTypeCode | mimeTypeCode << TagEncoding.MIME_TYPE.getBitPos() | qualityCode << TagEncoding.SOUND_QUALITY.getBitPos() | durationCode << TagEncoding.SOUND_DURATION.getBitPos();
    }

    public static Integer calculateVideoTag(String mimeType, Boolean videoQuality, String duration) {
        Integer mediaTypeCode = MediaTypeEncoding.VIDEO.getEncodedValue();
        Integer mimeTypeCode = CommonTagExtractor.getMimeTypeCode((String)mimeType);
        Integer qualityCode = VideoTagExtractor.getQualityCode((Boolean)videoQuality);
        Integer durationCode = VideoTagExtractor.getDurationCode((String)duration);
        return mediaTypeCode | mimeTypeCode << TagEncoding.MIME_TYPE.getBitPos() | qualityCode << TagEncoding.VIDEO_QUALITY.getBitPos() | durationCode << TagEncoding.VIDEO_DURATION.getBitPos();
    }
}

