/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.service.impl;

import eu.europeana.corelib.definitions.model.facets.inverseLogic.CommonPropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.ImagePropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.MediaTypeEncoding;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.SoundPropertyExtractor;
import eu.europeana.corelib.definitions.model.facets.inverseLogic.VideoPropertyExtractor;

public class FacetLabelExtractor {
    public static String getFacetLabel(Integer tag) {
        MediaTypeEncoding mediaType = CommonPropertyExtractor.getType((Integer)tag);
        String mimeType = CommonPropertyExtractor.getMimeType((Integer)tag);
        if (null != mimeType && !mimeType.trim().isEmpty()) {
            return mimeType;
        }
        switch (mediaType) {
            case IMAGE: {
                String label = ImagePropertyExtractor.getAspectRatio((int)tag);
                if (!label.equals("")) {
                    return label;
                }
                label = ImagePropertyExtractor.getColor((int)tag);
                if (!label.equals("")) {
                    return label;
                }
                label = ImagePropertyExtractor.getColorSpace((int)tag);
                if (!label.equals("")) {
                    return label;
                }
                label = ImagePropertyExtractor.getSize((int)tag);
                return label;
            }
            case SOUND: {
                String label = SoundPropertyExtractor.getDuration((Integer)tag);
                if (!label.equals("")) {
                    return label;
                }
                label = SoundPropertyExtractor.getQuality((Integer)tag);
                return label;
            }
            case VIDEO: {
                String label = VideoPropertyExtractor.getDuration((Integer)tag);
                if (!label.equals("")) {
                    return label;
                }
                label = VideoPropertyExtractor.getQuality((Integer)tag);
                return label;
            }
        }
        return "";
    }
}

