/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.utils;

import eu.europeana.corelib.utils.ComparatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CachingRefinementUtils {
    private static final Set<String> cachingFields = Set.of("filter_tags");
    private static String fieldValuesRegex = "(^\\w*:\\(.*\\))";
    private static final Pattern fieldValuesPattern = Pattern.compile(fieldValuesRegex);
    private static String tag = "(^\\{!tag=.*\\})";
    private static final Pattern tagPattern = Pattern.compile(tag);

    public static boolean ifBooleanFiltersPresent(String value) {
        return StringUtils.containsAny((CharSequence)value, (CharSequence[])new CharSequence[]{"OR", "AND"});
    }

    public static boolean isBooleanParameter(String value) {
        return StringUtils.equalsAny((CharSequence)value.trim(), (CharSequence[])new CharSequence[]{"OR", "AND"});
    }

    public static boolean isFieldValuesPattern(String value) {
        return fieldValuesPattern.matcher(value).find();
    }

    public static String[] getCachedRefinements(String[] refinements) {
        ArrayList<String> cachedRefinements = new ArrayList<String>(refinements.length);
        Map<String, String> cachingFieldsMap = CachingRefinementUtils.getFilterClauseRefinement(CachingRefinementUtils.getValuesForCaching(refinements));
        if (!cachingFieldsMap.isEmpty()) {
            for (String refinement : refinements) {
                boolean added = false;
                for (Map.Entry<String, String> entry : cachingFieldsMap.entrySet()) {
                    if (!StringUtils.contains((CharSequence)refinement, (CharSequence)entry.getKey())) continue;
                    cachedRefinements.add(StringUtils.replace((String)refinement, (String)entry.getKey(), (String)entry.getValue()));
                    added = true;
                }
                if (added) continue;
                cachedRefinements.add(refinement);
            }
            return cachedRefinements.toArray(new String[0]);
        }
        return refinements;
    }

    private static Map<String, String> getValuesForCaching(String[] refinements) {
        LinkedHashMap<String, String> cachingFieldsMap = new LinkedHashMap<String, String>();
        for (String refinement : refinements) {
            String keyToAdd = CachingRefinementUtils.getValueWithoutTag(refinement);
            for (String cachingField : cachingFields) {
                if (!StringUtils.contains((CharSequence)keyToAdd, (CharSequence)cachingField) || !CachingRefinementUtils.ifBooleanFiltersPresent(keyToAdd)) continue;
                cachingFieldsMap.put(keyToAdd, null);
            }
        }
        return cachingFieldsMap;
    }

    private static String getValueWithoutTag(String valueWithTag) {
        Matcher m = tagPattern.matcher(valueWithTag);
        if (m.find()) {
            return StringUtils.substringAfter((String)valueWithTag, (String)m.group());
        }
        return valueWithTag;
    }

    private static Map<String, String> getFilterClauseRefinement(Map<String, String> cachingFieldsMap) {
        for (Map.Entry<String, String> entry : cachingFieldsMap.entrySet()) {
            String key = entry.getKey();
            if (CachingRefinementUtils.isFieldValuesPattern(key)) {
                entry.setValue("filter(" + key + ")");
                continue;
            }
            key = ComparatorUtils.stripParenthesis((String)key);
            List<String> values = Arrays.asList(StringUtils.splitByWholeSeparator((String)key, (String)" "));
            StringBuilder mapValue = new StringBuilder();
            for (String value : values) {
                if (CachingRefinementUtils.isBooleanParameter(value)) {
                    mapValue.append(" " + value + " ");
                    continue;
                }
                mapValue.append("filter(").append(value).append(")");
            }
            entry.setValue(mapValue.toString());
        }
        cachingFieldsMap.values().removeIf(Objects::isNull);
        return cachingFieldsMap;
    }
}

