/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.config;

import eu.europeana.corelib.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SolrConfigLoader {
    private static final String URL_PROP = "url";
    private static final String CORE_PROP = "core";
    private static final String ZOOKEEPER_URL_PROP = "zookeeper.url";
    private static final String ID_PROP = "id";
    private final Properties properties;
    private final List<SolrConfigProperty> solrInstances = new ArrayList<SolrConfigProperty>();

    public SolrConfigLoader(@Autowired @Qualifier(value="europeanaProperties") Properties properties) {
        this.properties = properties;
    }

    @PostConstruct
    void loadConfig() {
        int solrInstanceNo = 1;
        while (ConfigUtils.containsKeyPrefix((Properties)this.properties, (String)("solr" + solrInstanceNo))) {
            String basePath = "solr" + solrInstanceNo + ".";
            SolrConfigProperty solrConfig = new SolrConfigProperty(this.properties.getProperty(basePath + ID_PROP), this.properties.getProperty(basePath + URL_PROP), this.properties.getProperty(basePath + CORE_PROP), this.properties.getProperty(basePath + ZOOKEEPER_URL_PROP));
            this.solrInstances.add(solrConfig);
            ++solrInstanceNo;
        }
    }

    public List<SolrConfigProperty> getSolrInstances() {
        return Collections.unmodifiableList(this.solrInstances);
    }

    public SolrConfigProperty getInstance(int index) {
        return this.solrInstances.get(index);
    }

    static class SolrConfigProperty {
        private final String id;
        private final String url;
        private final String coreCollection;
        private final String zookeeperUrl;

        public SolrConfigProperty(String id, String url, String coreCollection, String zookeeperUrl) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{id, url}) || StringUtils.isBlank((CharSequence)zookeeperUrl) ^ StringUtils.isBlank((CharSequence)coreCollection)) {
                throw new IllegalArgumentException(String.format("Invalid Solr config: id=%s, url=%s, core=%s, zookeeperUrl=%s", id, url, coreCollection, zookeeperUrl));
            }
            this.id = id;
            this.url = url;
            this.coreCollection = coreCollection;
            this.zookeeperUrl = zookeeperUrl;
        }

        public String getId() {
            return this.id;
        }

        public String getUrl() {
            return this.url;
        }

        public Optional<String> getCoreCollection() {
            return Optional.ofNullable(this.coreCollection).filter(Predicate.not(StringUtils::isEmpty));
        }

        public Optional<String> getZookeeperUrl() {
            return Optional.ofNullable(this.zookeeperUrl).filter(Predicate.not(StringUtils::isEmpty));
        }
    }
}

