/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.utils;

import eu.europeana.corelib.definitions.edm.beans.ApiBean;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.beans.RichBean;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.edm.utils.FieldMapping;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.util.ClientUtils;

public class SearchUtils {
    private static final Pattern ID_PATTERN = Pattern.compile("^\\{!id=([^:]+):([^:]+) ex=(.*?)\\}");
    private static final Pattern SOLR_BUG_PATTERN = Pattern.compile("(proxy_dc_creator|proxy_dc_contributor|who)(:\"https?+:.*?\")", 2);

    @Deprecated
    public static boolean checkTypeFacet(String[] refinements) {
        if (refinements != null) {
            for (String refinement : refinements) {
                if (!StringUtils.contains((CharSequence)refinement, (CharSequence)"TYPE:") || StringUtils.contains((CharSequence)refinement, (CharSequence)" OR ") || DocType.safeValueOf((String)StringUtils.substringAfter((String)refinement, (String)"TYPE:")) != null) continue;
                return false;
            }
        }
        return true;
    }

    public static Class<? extends IdBeanImpl> getImplementationClass(Class<? extends IdBean> interfaze) {
        if (interfaze != null) {
            if (interfaze == RichBean.class) {
                return RichBeanImpl.class;
            }
            if (interfaze == ApiBean.class) {
                return ApiBeanImpl.class;
            }
            if (interfaze == BriefBean.class) {
                return BriefBeanImpl.class;
            }
            if (interfaze == IdBean.class) {
                return IdBeanImpl.class;
            }
        }
        return null;
    }

    public static String rewriteQueryFields(String query) {
        if (!query.contains(":")) {
            return query;
        }
        if (query.equals("title:*:*")) {
            return "title:*";
        }
        if (query.equals("who:*:*")) {
            return "who:*";
        }
        if (query.equals("what:*:*")) {
            return "what:*";
        }
        if (query.equals("where:*:*")) {
            return "where:*";
        }
        if (query.equals("when:*:*")) {
            return "when:*";
        }
        for (FieldMapping field : FieldMapping.values()) {
            if (!query.contains(field.getEseField() + ":")) continue;
            query = query.replaceAll("\\b" + field.getEseField() + ":", field.getEdmField() + ":");
        }
        return query;
    }

    public static String escapeQuery(String query) {
        return ClientUtils.escapeQueryChars((String)query).replace("\\ ", " ").replace("\\-", "-");
    }

    public static String escapeFacet(String field, String query) {
        if (StringUtils.isNotBlank((CharSequence)field) && StringUtils.isNotBlank((CharSequence)query)) {
            query = SearchUtils.escapeQuery(StringUtils.trim((String)query));
            return StringUtils.trim((String)field) + ":\"" + query + "\"";
        }
        return null;
    }

    public static List<FacetField> extractQueryFacets(Map<String, Integer> queryFacets) {
        HashMap<String, FacetField> map = new HashMap<String, FacetField>();
        for (String query : queryFacets.keySet()) {
            Matcher matcher = ID_PATTERN.matcher(query);
            if (!matcher.find()) continue;
            String field = matcher.group(1);
            String value = matcher.group(2);
            if (!map.containsKey(field)) {
                map.put(field, new FacetField(field));
            }
            ((FacetField)map.get(field)).add(value, (long)queryFacets.get(query).intValue());
        }
        return new ArrayList<FacetField>(map.values());
    }

    public static boolean isSimpleQuery(String queryTerm) {
        return SearchUtils.isNotFieldQuery(queryTerm) && (SearchUtils.isTermQuery(queryTerm) || SearchUtils.containsNoneSearchOperators(queryTerm));
    }

    public static boolean isTermQuery(String queryTerm) {
        StandardQueryParser queryParserHelper = new StandardQueryParser();
        Query query = null;
        try {
            query = queryParserHelper.parse(queryTerm, "text");
        }
        catch (QueryNodeException queryNodeException) {
            // empty catch block
        }
        return query != null && query instanceof TermQuery;
    }

    private static boolean containsNoneSearchOperators(String queryTerm) {
        return !StringUtils.contains((CharSequence)queryTerm, (CharSequence)" AND ") && !StringUtils.contains((CharSequence)queryTerm, (CharSequence)" NOT ") && !StringUtils.contains((CharSequence)queryTerm, (CharSequence)" OR ") && !StringUtils.contains((CharSequence)queryTerm, (CharSequence)"*");
    }

    private static boolean isNotFieldQuery(String queryTerm) {
        return !StringUtils.contains((CharSequence)queryTerm, (CharSequence)":");
    }

    public static String fixBuggySolrIndex(String queryString) {
        return SearchUtils.fixBuggySolrIndex("", queryString);
    }

    private static String fixBuggySolrIndex(String processed, String queryString) {
        Matcher bugMatcher;
        if (queryString.length() > 0 && (bugMatcher = SOLR_BUG_PATTERN.matcher(queryString)).find()) {
            switch (bugMatcher.group(1)) {
                case "proxy_dc_creator": {
                    return SearchUtils.fixBuggySolrIndex(processed + queryString.substring(0, bugMatcher.start()) + "(proxy_dc_creator" + bugMatcher.group(2) + " AND CREATOR" + bugMatcher.group(2) + ")", queryString.substring(bugMatcher.end()));
                }
                case "proxy_dc_contributor": {
                    return SearchUtils.fixBuggySolrIndex(processed + queryString.substring(0, bugMatcher.start()) + "(proxy_dc_contributor" + bugMatcher.group(2) + " AND CONTRIBUTOR" + bugMatcher.group(2) + ")", queryString.substring(bugMatcher.end()));
                }
                case "who": {
                    return SearchUtils.fixBuggySolrIndex(processed + queryString.substring(0, bugMatcher.start()) + "(who" + bugMatcher.group(2) + " AND (CREATOR" + bugMatcher.group(2) + " OR CONTRIBUTOR" + bugMatcher.group(2) + "))", queryString.substring(bugMatcher.end()));
                }
            }
        }
        return processed + queryString;
    }
}

