/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.config;

import eu.europeana.corelib.search.config.SolrConfigLoader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchServerConfig {
    private static final Logger LOG = LogManager.getLogger(SearchServerConfig.class);
    @Value(value="#{europeanaProperties['solr.zk.connect.timeout']}")
    private int zkConnectTimeout;
    @Value(value="#{europeanaProperties['solr.zk.connect.timeout']}")
    private int solrTimeout;
    @Value(value="#{europeanaProperties['solr.connect.timeout']}")
    private int solrConnectTimeout;
    @Value(value="#{europeanaProperties['solr.so.timeout']}")
    private int solrSocketTimeout;
    @Value(value="#{europeanaProperties['solr.username']}")
    private String username;
    @Value(value="#{europeanaProperties['solr.password']}")
    private String password;
    private final Map<String, SolrClient> solrClientById = new HashMap<String, SolrClient>();
    private final SolrConfigLoader configLoader;

    public SearchServerConfig(@Autowired SolrConfigLoader configLoader) {
        this.configLoader = configLoader;
    }

    @PostConstruct
    private void setupSolrConnections() {
        for (SolrConfigLoader.SolrConfigProperty instance : this.configLoader.getSolrInstances()) {
            if (instance.getZookeeperUrl().isEmpty() || instance.getCoreCollection().isEmpty()) {
                HttpSolrClient.Builder builder = new HttpSolrClient.Builder();
                ((HttpSolrClient.Builder)((HttpSolrClient.Builder)builder.withBaseSolrUrl(instance.getUrl()).withConnectionTimeout(this.solrConnectTimeout)).withSocketTimeout(this.solrSocketTimeout)).allowCompression(true);
                HttpSolrClient singleSolrClient = builder.build();
                LOG.info("Registered single SolrClient without zookeeper - id:{}, url: {}", (Object)instance.getId(), (Object)instance.getUrl());
                this.solrClientById.put(instance.getId(), (SolrClient)singleSolrClient);
                continue;
            }
            CloudSolrClient zkClient = ((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(Arrays.asList(instance.getZookeeperUrl().get().split(",")), Optional.empty()).withConnectionTimeout(this.zkConnectTimeout)).withSocketTimeout(this.solrSocketTimeout)).build();
            zkClient.setDefaultCollection(instance.getCoreCollection().get());
            LOG.info("Registered SolrClient with zookeeper - id:{}, url:{}, zookeeperUrl:{}, core:{}", (Object)instance.getId(), (Object)instance.getUrl(), (Object)instance.getZookeeperUrl().get(), (Object)instance.getCoreCollection().get());
            this.solrClientById.put(instance.getId(), (SolrClient)zkClient);
        }
    }

    public Optional<SolrClient> getSolrClientById(String id) {
        return Optional.ofNullable(this.solrClientById.get(id));
    }

    @PreDestroy
    private void closeConnections() {
        LOG.info("Closing Solr connections...");
        this.solrClientById.values().forEach(solrClient -> {
            try {
                solrClient.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing Solr connection...", (Throwable)e);
            }
        });
    }

    private static class PreEmptiveBasicAuthenticator
    implements HttpRequestInterceptor {
        private final UsernamePasswordCredentials credentials;

        public PreEmptiveBasicAuthenticator(String user, String pass) {
            this.credentials = new UsernamePasswordCredentials(user, pass);
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            request.addHeader(BasicScheme.authenticate((Credentials)this.credentials, (String)"US-ASCII", (boolean)false));
        }
    }
}

