/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.definitions.solr.model.QuerySort;
import eu.europeana.corelib.edm.exceptions.SolrIOException;
import eu.europeana.corelib.edm.exceptions.SolrQueryException;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.web.exception.EuropeanaException;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.springframework.beans.factory.annotation.Value;

public class SearchServiceImpl
implements SearchService {
    private static final Logger LOG = LogManager.getLogger(SearchServiceImpl.class);
    private static final String UNION_FACETS_FORMAT = "'{'!ex={0}'}'{0}";
    private static final int TIME_ALLOWED = 30000;
    @Value(value="#{europeanaProperties['solr.facetLimit']}")
    private int facetLimit;
    @Value(value="#{europeanaProperties['solr.searchLimit']}")
    private int searchLimit;

    @Override
    public <T extends IdBean> ResultSet<T> search(SolrClient solrClient, Class<T> beanInterface, Query query) throws EuropeanaException {
        return this.search(solrClient, beanInterface, query, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends IdBean> ResultSet<T> search(SolrClient solrClient, Class<T> beanInterface, Query query, boolean debug) throws EuropeanaException {
        if (query.getStart() != null && query.getStart() + query.getPageSize() > this.searchLimit) {
            throw new SolrQueryException(ProblemType.SEARCH_PAGE_LIMIT_REACHED, "It is not possible to paginate beyond the first 1000 search results. Please use cursor-based pagination instead");
        }
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        if (!this.isValidBeanClass(beanClazz)) throw new SolrTypeException(ProblemType.INVALIDCLASS, "Unknown bean class: " + beanClazz);
        Object[] refinements = query.getRefinements(true);
        SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery(true));
        if (ArrayUtils.isNotEmpty((Object[])refinements)) {
            solrQuery.addFilterQuery((String[])refinements);
        }
        solrQuery.setRows(Integer.valueOf(query.getPageSize()));
        solrQuery.setStart(query.getStart());
        this.setSortAndCursor(query, resultSet, solrQuery);
        if (query.getParameterMap() != null) {
            Map parameters = query.getParameterMap();
            for (Map.Entry entry : parameters.entrySet()) {
                solrQuery.setParam((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
        }
        if (query.areFacetsAllowed()) {
            solrQuery.setFacet(true);
            List filteredFacets = query.getFacetsUsedInRefinements();
            boolean hasFacetRefinements = filteredFacets != null && !filteredFacets.isEmpty();
            for (String facetToAdd : query.getSolrFacets()) {
                if (query.doProduceFacetUnion() && hasFacetRefinements && filteredFacets.contains(facetToAdd)) {
                    facetToAdd = MessageFormat.format(UNION_FACETS_FORMAT, facetToAdd);
                }
                solrQuery.addFacetField(new String[]{facetToAdd});
            }
            solrQuery.setFacetLimit(this.facetLimit);
        }
        if (query.isSpellcheckAllowed() && (solrQuery.getStart() == null || solrQuery.getStart() <= 1)) {
            solrQuery.setParam("spellcheck", new String[]{"on"});
            solrQuery.setParam("spellcheck.collate", new String[]{"true"});
            solrQuery.setParam("spellcheck.extendedResults", new String[]{"true"});
            solrQuery.setParam("spellcheck.onlyMorePopular", new String[]{"true"});
            solrQuery.setParam("spellcheck.q", new String[]{query.getQuery()});
        }
        if (query.getQueryFacets() != null) {
            for (String facetQuery : query.getQueryFacets()) {
                solrQuery.addFacetQuery(facetQuery);
            }
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Solr query is: {}", (Object)solrQuery);
            }
            query.setExecutedQuery(solrQuery.toString());
            QueryResponse queryResponse = solrClient.query((SolrParams)solrQuery, SolrRequest.METHOD.POST);
            resultSet.setResults(queryResponse.getBeans(beanClazz));
            resultSet.setFacetFields(queryResponse.getFacetFields());
            if (query.areRangeFacetsRequested()) {
                resultSet.setRangeFacets(queryResponse.getFacetRanges());
            }
            resultSet.setResultSize(queryResponse.getResults().getNumFound());
            resultSet.setSearchTime(queryResponse.getElapsedTime());
            resultSet.setSpellcheck(queryResponse.getSpellCheckResponse());
            resultSet.setNextCursorMark(queryResponse.getNextCursorMark());
            if (debug) {
                resultSet.setSolrQueryString(query.getExecutedQuery());
            }
            if (queryResponse.getFacetQuery() != null) {
                resultSet.setQueryFacets(queryResponse.getFacetQuery());
            }
            if (queryResponse.getHighlighting() == null) return resultSet;
            resultSet.setHighlighting(queryResponse.getHighlighting());
            return resultSet;
        }
        catch (IOException e) {
            throw new SolrIOException(ProblemType.CANT_CONNECT_SOLR, (Throwable)e);
        }
        catch (SolrServerException e) {
            if (StringUtils.containsIgnoreCase((CharSequence)e.getCause().toString(), (CharSequence)"Timeout")) {
                throw new SolrQueryException(ProblemType.TIMEOUT_SOLR, (Throwable)e);
            }
            if (!StringUtils.containsIgnoreCase((CharSequence)e.getCause().toString(), (CharSequence)"Collection")) throw new SolrQueryException(ProblemType.SEARCH_QUERY_INVALID, (Throwable)e);
            throw new SolrQueryException(ProblemType.SEARCH_THEME_UNKNOWN);
        }
        catch (SolrException e) {
            String msg = e.getMessage().toLowerCase(Locale.GERMAN);
            if (msg.contains("cursormark")) {
                throw new SolrQueryException(ProblemType.SEARCH_CURSORMARK_INVALID, "Please make sure you encode the cursor value before sending it to the API.");
            }
            if (!msg.contains("connect")) throw new SolrQueryException(ProblemType.SEARCH_QUERY_INVALID, (Throwable)e);
            if (!msg.contains("zookeeper")) throw new SolrIOException(ProblemType.CANT_CONNECT_SOLR, "Cannot connect to Solr", (Throwable)e);
            throw new SolrIOException(ProblemType.CANT_CONNECT_SOLR, "Cannot connect to Zookeeper", (Throwable)e);
        }
    }

    private <T extends IdBean> void setSortAndCursor(Query query, ResultSet<T> resultSet, SolrQuery solrQuery) {
        boolean defaultSort = query.getSorts().isEmpty();
        if (defaultSort) {
            solrQuery.setSort("has_media", SolrQuery.ORDER.desc);
            solrQuery.addSort("score", SolrQuery.ORDER.desc);
            solrQuery.addSort("timestamp_update", SolrQuery.ORDER.desc);
            solrQuery.addSort("europeana_completeness", SolrQuery.ORDER.desc);
            solrQuery.addSort("europeana_id", SolrQuery.ORDER.asc);
        } else {
            solrQuery.clearSorts();
            for (QuerySort userSort : query.getSorts()) {
                solrQuery.addSort(userSort.getSortField(), userSort.getSortOrder() == 1 ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
            }
        }
        if (query.getCurrentCursorMark() != null) {
            solrQuery.set("cursorMark", new String[]{query.getCurrentCursorMark()});
            if (defaultSort) {
                solrQuery.removeSort("score");
                if (!solrQuery.getSortField().contains("europeana_id")) {
                    solrQuery.addSort("europeana_id", SolrQuery.ORDER.asc);
                }
            }
        } else {
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
        }
        resultSet.setSortField(solrQuery.getSortField());
        resultSet.setCurrentCursorMark(query.getCurrentCursorMark());
    }

    private boolean isValidBeanClass(Class<? extends IdBeanImpl> beanClazz) {
        return beanClazz == BriefBeanImpl.class || beanClazz == ApiBeanImpl.class || beanClazz == RichBeanImpl.class;
    }

    @Override
    public Date getLastSolrUpdate(SolrClient solrClient) throws EuropeanaException {
        long t0 = new Date().getTime();
        try {
            NamedList namedList = solrClient.request((SolrRequest)new LukeRequest());
            NamedList index = (NamedList)namedList.get("index");
            if (LOG.isInfoEnabled()) {
                LOG.info("spent: " + (new Date().getTime() - t0));
            }
            return (Date)index.get("lastModified");
        }
        catch (IOException | SolrServerException e) {
            LOG.error("Error querying solr", e);
            return null;
        }
    }
}

