/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.queryextractor;

import eu.europeana.corelib.search.queryextractor.QueryModification;
import eu.europeana.corelib.search.queryextractor.QueryTermPosition;
import eu.europeana.corelib.search.queryextractor.QueryType;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

public class QueryToken {
    private Stack<QueryType> typeStack;
    private String normalizedQueryTerm;
    private QueryTermPosition position;
    private int group;

    public QueryToken() {
    }

    public QueryToken(String normalizedQueryTerm, Stack<QueryType> typeStack, int group) {
        this.normalizedQueryTerm = normalizedQueryTerm;
        this.typeStack = (Stack)typeStack.clone();
        this.group = group;
    }

    public void setPosition(QueryTermPosition position) {
        this.position = position;
    }

    public Stack<QueryType> getTypeStack() {
        return this.typeStack;
    }

    public String getNormalizedQueryTerm() {
        return this.normalizedQueryTerm;
    }

    public QueryTermPosition getPosition() {
        return this.position;
    }

    public int getGroup() {
        return this.group;
    }

    public QueryType getType() {
        return this.typeStack.peek();
    }

    public String getTerm() {
        if (this.position == null) {
            return this.normalizedQueryTerm;
        }
        return this.position.getOriginal();
    }

    protected QueryToken clone() throws CloneNotSupportedException {
        QueryToken cloned = new QueryToken();
        cloned.position = this.getPosition() == null ? null : this.getPosition().clone();
        cloned.normalizedQueryTerm = this.normalizedQueryTerm;
        cloned.typeStack = (Stack)this.typeStack.clone();
        cloned.group = this.group;
        return cloned;
    }

    public void merge(QueryToken other, String rawQueryString) {
        this.normalizedQueryTerm = this.normalizedQueryTerm + " " + other.normalizedQueryTerm;
        if (other.getPosition() != null) {
            this.getPosition().setEnd(other.getPosition().getEnd());
            this.getPosition().setOriginal(rawQueryString.substring(this.position.getStart(), this.position.getEnd()));
        }
    }

    public QueryModification createModification(String rawQueryString, List<String> alternatives) {
        Object query;
        if (alternatives.size() == 0 || this.getType().equals((Object)QueryType.TERMRANGE)) {
            return null;
        }
        int start = this.position.getStart();
        int end = this.position.getEnd();
        if (this.getType().equals((Object)QueryType.PHRASE)) {
            --start;
            ++end;
        }
        if (((String)(query = rawQueryString.substring(start, end))).contains(" ") && !this.getType().equals((Object)QueryType.PHRASE)) {
            query = "(" + (String)query + ")";
        }
        String replacement = (String)query + " OR \"" + StringUtils.join(alternatives, (String)"\" OR \"") + "\"";
        if (start != 0 || end != rawQueryString.length()) {
            replacement = "(" + replacement + ")";
        }
        return new QueryModification(start, end, replacement);
    }

    public String getExtendedPosition() {
        if (this.position == null) {
            return null;
        }
        int start = this.position.getStart();
        int end = this.position.getEnd();
        if (this.getType().equals((Object)QueryType.PHRASE)) {
            --start;
            ++end;
        }
        return String.format("%d:%d", start, end);
    }
}

