/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.search.impl;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import eu.europeana.corelib.definitions.edm.beans.BriefBean;
import eu.europeana.corelib.definitions.edm.beans.FullBean;
import eu.europeana.corelib.definitions.edm.beans.IdBean;
import eu.europeana.corelib.definitions.edm.entity.Aggregation;
import eu.europeana.corelib.definitions.edm.entity.Proxy;
import eu.europeana.corelib.definitions.edm.entity.WebResource;
import eu.europeana.corelib.definitions.exception.ProblemType;
import eu.europeana.corelib.definitions.solr.model.Query;
import eu.europeana.corelib.definitions.solr.model.Term;
import eu.europeana.corelib.edm.exceptions.MongoDBException;
import eu.europeana.corelib.edm.exceptions.SolrTypeException;
import eu.europeana.corelib.mongo.server.EdmMongoServer;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.entity.Node2Neo4jBeanConverter;
import eu.europeana.corelib.neo4j.server.Neo4jServer;
import eu.europeana.corelib.search.SearchService;
import eu.europeana.corelib.search.impl.PreEmptiveBasicAuthenticator;
import eu.europeana.corelib.search.model.ResultSet;
import eu.europeana.corelib.search.query.MoreLikeThis;
import eu.europeana.corelib.search.utils.SearchUtils;
import eu.europeana.corelib.solr.bean.impl.ApiBeanImpl;
import eu.europeana.corelib.solr.bean.impl.BriefBeanImpl;
import eu.europeana.corelib.solr.bean.impl.IdBeanImpl;
import eu.europeana.corelib.solr.bean.impl.RichBeanImpl;
import eu.europeana.corelib.solr.entity.WebResourceImpl;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import eu.europeana.corelib.utils.EuropeanaUriUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.LukeRequest;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.SpellCheckResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.neo4j.graphdb.Node;
import org.springframework.beans.factory.annotation.Value;

public class SearchServiceImpl
implements SearchService {
    private static final int DEFAULT_MLT_COUNT = 10;
    private static final String UNION_FACETS_FORMAT = "'{'!ex={0}'}'{0}";
    private static final int TIME_ALLOWED = 30000;
    private static final List<String> SPELL_FIELDS = Arrays.asList("who", "what", "where", "when", "title");
    private static final String RESOLVE_PREFIX = "http://www.europeana.eu/resolve/record";
    private static final String PORTAL_PREFIX = "http://www.europeana.eu/portal/record";
    private static final HashFunction hf = Hashing.md5();
    protected static Logger log = Logger.getLogger(SearchServiceImpl.class);
    private static boolean STARTED = false;
    @Resource(name="corelib_solr_mongoServer")
    protected EdmMongoServer mongoServer;
    @Resource(name="corelib_solr_mongoServer_id")
    protected EuropeanaIdMongoServer idServer;
    @Resource(name="corelib_solr_neo4jServer")
    protected Neo4jServer neo4jServer;
    private Map<String, Long> total = new HashMap<String, Long>();
    private SolrServer solrServer;
    @Value(value="#{europeanaProperties['solr.facetLimit']}")
    private int facetLimit;
    @Value(value="#{europeanaProperties['solr.username']}")
    private String username;
    @Value(value="#{europeanaProperties['solr.password']}")
    private String password;
    private String mltFields;

    @Override
    public FullBean findById(String collectionId, String recordId, boolean similarItems) throws MongoDBException {
        return this.findById(EuropeanaUriUtils.createEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    private void injectWebMetaInfo(FullBean fullBean) {
        List<Object> wResources;
        WebResource wr2;
        boolean containsWr;
        String isShownBy;
        Aggregation aggregationFix = (Aggregation)fullBean.getAggregations().get(0);
        if (aggregationFix.getEdmIsShownBy() != null) {
            isShownBy = ((Aggregation)fullBean.getAggregations().get(0)).getEdmIsShownBy();
            containsWr = false;
            if (aggregationFix.getWebResources() != null) {
                for (WebResource wr2 : aggregationFix.getWebResources()) {
                    if (!StringUtils.equals((String)isShownBy, (String)wr2.getAbout())) continue;
                    containsWr = true;
                }
            }
            if (!containsWr) {
                wResources = aggregationFix.getWebResources();
                if (wResources == null) {
                    wResources = new ArrayList<WebResource>();
                }
                wr2 = new WebResourceImpl();
                wr2.setAbout(isShownBy);
                wResources.add(wr2);
                aggregationFix.setWebResources(wResources);
            }
        }
        if (aggregationFix.getEdmObject() != null) {
            isShownBy = ((Aggregation)fullBean.getAggregations().get(0)).getEdmObject();
            containsWr = false;
            if (aggregationFix.getWebResources() != null) {
                for (WebResource wr2 : aggregationFix.getWebResources()) {
                    if (!StringUtils.equals((String)isShownBy, (String)wr2.getAbout())) continue;
                    containsWr = true;
                }
            }
            if (!containsWr) {
                wResources = aggregationFix.getWebResources();
                if (wResources == null) {
                    wResources = new ArrayList();
                }
                wr2 = new WebResourceImpl();
                wr2.setAbout(isShownBy);
                wResources.add(wr2);
                aggregationFix.setWebResources(wResources);
            }
        }
        if (aggregationFix.getHasView() != null) {
            for (String hasView : aggregationFix.getHasView()) {
                WebResource wr32;
                boolean containsWr2 = false;
                if (aggregationFix.getWebResources() != null) {
                    for (WebResource wr32 : aggregationFix.getWebResources()) {
                        if (!StringUtils.equals((String)hasView, (String)wr32.getAbout())) continue;
                        containsWr2 = true;
                    }
                }
                if (containsWr2) continue;
                ArrayList<WebResource> wResources2 = aggregationFix.getWebResources();
                if (wResources2 == null) {
                    wResources2 = new ArrayList<WebResource>();
                }
                wr32 = new WebResourceImpl();
                wr32.setAbout(hasView);
                wResources2.add(wr32);
                aggregationFix.setWebResources(wResources2);
            }
        }
        fullBean.getAggregations().set(0, aggregationFix);
    }

    @Override
    public FullBean findById(String europeanaObjectId, boolean similarItems) throws MongoDBException {
        long t0 = new Date().getTime();
        FullBean fullBean = this.mongoServer.getFullBean(europeanaObjectId);
        this.injectWebMetaInfo(fullBean);
        if (fullBean != null && this.isHierarchy(fullBean.getAbout())) {
            for (Proxy prx : fullBean.getProxies()) {
                prx.setDctermsHasPart(null);
            }
        }
        this.logTime("mongo findById", new Date().getTime() - t0);
        if (fullBean != null && similarItems) {
            try {
                fullBean.setSimilarItems(this.findMoreLikeThis(europeanaObjectId));
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage()));
            }
        }
        return fullBean;
    }

    @Override
    public FullBean resolve(String collectionId, String recordId, boolean similarItems) throws SolrTypeException {
        return this.resolve(EuropeanaUriUtils.createResolveEuropeanaId((String)collectionId, (String)recordId), similarItems);
    }

    @Override
    public FullBean resolve(String europeanaObjectId, boolean similarItems) throws SolrTypeException {
        FullBean fullBean;
        FullBean fullBeanNew = fullBean = this.resolveInternal(europeanaObjectId);
        if (fullBean != null) {
            while (fullBeanNew != null) {
                if ((fullBeanNew = this.resolveInternal(fullBeanNew.getAbout())) == null) continue;
                fullBean = fullBeanNew;
            }
        }
        return fullBean;
    }

    private FullBean resolveInternal(String europeanaObjectId) throws SolrTypeException {
        long t0 = new Date().getTime();
        if (!STARTED) {
            this.idServer.createDatastore();
            STARTED = true;
        }
        this.mongoServer.setEuropeanaIdMongoServer(this.idServer);
        FullBean fullBean = this.mongoServer.resolve(europeanaObjectId);
        this.injectWebMetaInfo(fullBean);
        this.logTime("mongo resolve", new Date().getTime() - t0);
        if (fullBean != null) {
            try {
                fullBean.setSimilarItems(this.findMoreLikeThis(fullBean.getAbout()));
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage()));
            }
        }
        return fullBean;
    }

    @Override
    public String resolveId(String europeanaObjectId) {
        String lastId;
        String newId = lastId = this.resolveIdInternal(europeanaObjectId);
        if (lastId != null) {
            while (newId != null) {
                if ((newId = this.resolveIdInternal(newId)) == null) continue;
                lastId = newId;
            }
        }
        return lastId;
    }

    @Override
    public String resolveId(String collectionId, String recordId) {
        return this.resolveId(EuropeanaUriUtils.createResolveEuropeanaId((String)collectionId, (String)recordId));
    }

    private String resolveIdInternal(String europeanaObjectId) {
        EuropeanaId newId;
        if (!STARTED) {
            this.idServer.createDatastore();
            STARTED = true;
        }
        if ((newId = this.idServer.retrieveEuropeanaIdFromOld(europeanaObjectId)) != null) {
            this.idServer.updateTime(newId.getNewId(), europeanaObjectId);
            return newId.getNewId();
        }
        newId = this.idServer.retrieveEuropeanaIdFromOld(RESOLVE_PREFIX + europeanaObjectId);
        if (newId != null) {
            this.idServer.updateTime(newId.getNewId(), RESOLVE_PREFIX + europeanaObjectId);
            return newId.getNewId();
        }
        newId = this.idServer.retrieveEuropeanaIdFromOld(PORTAL_PREFIX + europeanaObjectId);
        if (newId != null) {
            this.idServer.updateTime(newId.getNewId(), PORTAL_PREFIX + europeanaObjectId);
            return newId.getNewId();
        }
        return null;
    }

    @Override
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId) throws SolrServerException {
        return this.findMoreLikeThis(europeanaObjectId, 10);
    }

    @Override
    public List<BriefBean> findMoreLikeThis(String europeanaObjectId, int count) throws SolrServerException {
        String query = "europeana_id:\"" + europeanaObjectId + "\"";
        SolrQuery solrQuery = new SolrQuery().setQuery(query);
        solrQuery.set("mlt", true);
        if (this.mltFields == null) {
            ArrayList<String> fields = new ArrayList<String>();
            for (MoreLikeThis mltField : MoreLikeThis.values()) {
                fields.add(mltField.toString());
            }
            this.mltFields = StringUtils.join(fields, (String)",");
        }
        solrQuery.set("mlt.fl", new String[]{this.mltFields});
        solrQuery.set("mlt.mintf", 1);
        solrQuery.set("mlt.match.include", new String[]{"false"});
        solrQuery.set("mlt.count", count);
        solrQuery.set("rows", 1);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        if (log.isDebugEnabled()) {
            log.debug((Object)solrQuery.toString());
        }
        QueryResponse response = this.solrServer.query((SolrParams)solrQuery);
        this.logTime("MoreLikeThis", response.getElapsedTime());
        NamedList moreLikeThisList = (NamedList)response.getResponse().get("moreLikeThis");
        ArrayList<BriefBean> beans = new ArrayList<BriefBean>();
        if (moreLikeThisList.size() > 0) {
            List docs = (List)moreLikeThisList.getVal(0);
            for (SolrDocument doc : docs) {
                beans.add((BriefBean)this.solrServer.getBinder().getBean(BriefBeanImpl.class, doc));
            }
        }
        return beans;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T extends IdBean> ResultSet<T> search(Class<T> beanInterface, Query query) throws SolrTypeException {
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        if (this.isValidBeanClass(beanClazz)) {
            String[] refinements = query.getRefinements(true);
            if (!SearchUtils.checkTypeFacet(refinements)) throw new SolrTypeException(ProblemType.INVALIDARGUMENTS);
            SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery(true));
            if (refinements != null) {
                solrQuery.addFilterQuery(refinements);
            }
            solrQuery.setRows(Integer.valueOf(query.getPageSize()));
            solrQuery.setStart(query.getStart());
            solrQuery.setSortField("score", SolrQuery.ORDER.desc);
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
            if (query.getParameters() != null) {
                Map parameters = query.getParameters();
                for (String key : parameters.keySet()) {
                    solrQuery.setParam(key, new String[]{(String)parameters.get(key)});
                }
            }
            if (query.isAllowFacets()) {
                solrQuery.setFacet(true);
                List filteredFacets = query.getFilteredFacets();
                boolean hasFacetRefinements = filteredFacets != null && filteredFacets.size() > 0;
                for (String facetToAdd : query.getFacets()) {
                    if (query.isProduceFacetUnion() && hasFacetRefinements && filteredFacets.contains(facetToAdd)) {
                        facetToAdd = MessageFormat.format(UNION_FACETS_FORMAT, facetToAdd);
                    }
                    solrQuery.addFacetField(new String[]{facetToAdd});
                }
                solrQuery.setFacetLimit(this.facetLimit);
            }
            if (query.isAllowSpellcheck() && (solrQuery.getStart() == null || solrQuery.getStart() <= 1)) {
                solrQuery.setParam("spellcheck", new String[]{"on"});
                solrQuery.setParam("spellcheck.collate", new String[]{"true"});
                solrQuery.setParam("spellcheck.extendedResults", new String[]{"true"});
                solrQuery.setParam("spellcheck.onlyMorePopular", new String[]{"true"});
                solrQuery.setParam("spellcheck.q", new String[]{query.getQuery()});
            }
            if (query.getFacetQueries() != null) {
                for (String facetQuery : query.getFacetQueries()) {
                    solrQuery.addFacetQuery(facetQuery);
                    System.out.println("Facet Query: " + facetQuery);
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Solr query is: " + solrQuery));
                }
                query.setExecutedQuery(solrQuery.toString());
                System.out.println("Solr query: " + solrQuery);
                QueryResponse queryResponse = this.solrServer.query((SolrParams)solrQuery);
                this.logTime("search", queryResponse.getElapsedTime());
                resultSet.setResults(queryResponse.getBeans(beanClazz));
                resultSet.setFacetFields(queryResponse.getFacetFields());
                resultSet.setResultSize(queryResponse.getResults().getNumFound());
                resultSet.setSearchTime(queryResponse.getElapsedTime());
                resultSet.setSpellcheck(queryResponse.getSpellCheckResponse());
                if (queryResponse.getFacetQuery() == null) return resultSet;
                resultSet.setQueryFacets(queryResponse.getFacetQuery());
                return resultSet;
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage() + " The query was: " + solrQuery));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
            catch (SolrException e) {
                log.error((Object)("SolrException: " + e.getMessage() + " The query was: " + solrQuery));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
        } else {
            ProblemType type = ProblemType.INVALIDCLASS;
            type.appendMessage("Bean class: " + beanClazz);
            throw new SolrTypeException(type);
        }
    }

    private boolean isValidBeanClass(Class<? extends IdBeanImpl> beanClazz) {
        return beanClazz == BriefBeanImpl.class || beanClazz == ApiBeanImpl.class || beanClazz == RichBeanImpl.class;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize) throws SolrTypeException {
        return this.suggestions(query, pageSize, null);
    }

    @Override
    public List<FacetField.Count> createCollections(String facetFieldName, String queryString, String ... refinements) throws SolrTypeException {
        Query query = new Query(queryString).setParameter("rows", "0").setParameter("facet", "true").setRefinements(refinements).setParameter("facet.mincount", "1").setParameter("facet.limit", "750").setAllowSpellcheck(false);
        query.setFacet(facetFieldName);
        ResultSet<BriefBean> response = this.search(BriefBean.class, query);
        for (FacetField facetField : response.getFacetFields()) {
            if (!facetField.getName().equalsIgnoreCase(facetFieldName)) continue;
            return facetField.getValues();
        }
        return new ArrayList<FacetField.Count>();
    }

    @Override
    public Map<String, Integer> seeAlso(List<String> queries) {
        return this.queryFacetSearch("*:*", null, queries);
    }

    @Override
    public Map<String, Integer> queryFacetSearch(String query, String[] qf, List<String> queries) {
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setQuery(query);
        if (qf != null) {
            solrQuery.addFilterQuery(qf);
        }
        solrQuery.setRows(Integer.valueOf(0));
        solrQuery.setFacet(true);
        solrQuery.setTimeAllowed(Integer.valueOf(30000));
        for (String queryFacet : queries) {
            solrQuery.addFacetQuery(queryFacet);
        }
        Map queryFacets = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Solr query is: " + solrQuery.toString()));
            }
            QueryResponse response = this.solrServer.query((SolrParams)solrQuery);
            this.logTime("queryFacetSearch", response.getElapsedTime());
            queryFacets = response.getFacetQuery();
        }
        catch (SolrServerException e) {
            log.error((Object)("SolrServerException: " + e.getMessage() + " for query " + solrQuery.toString()));
            e.printStackTrace();
        }
        catch (Exception e) {
            log.error((Object)("Exception: " + e.getClass().getCanonicalName() + " " + e.getMessage() + " for query " + solrQuery.toString()));
            e.printStackTrace();
        }
        return queryFacets;
    }

    @Override
    public <T extends IdBean> ResultSet<T> sitemap(Class<T> beanInterface, Query query) throws SolrTypeException {
        ResultSet resultSet = new ResultSet();
        Class<? extends IdBeanImpl> beanClazz = SearchUtils.getImplementationClass(beanInterface);
        String[] refinements = query.getRefinements(true);
        if (SearchUtils.checkTypeFacet(refinements)) {
            SolrQuery solrQuery = new SolrQuery().setQuery(query.getQuery());
            if (refinements != null) {
                solrQuery.addFilterQuery(refinements);
            }
            solrQuery.setFacet(false);
            solrQuery.setRows(Integer.valueOf(query.getPageSize()));
            solrQuery.setStart(query.getStart());
            solrQuery.setSortField("COMPLETENESS", SolrQuery.ORDER.desc);
            solrQuery.setSortField("score", SolrQuery.ORDER.desc);
            solrQuery.setTimeAllowed(Integer.valueOf(30000));
            if (query.getParameters() != null) {
                Map parameters = query.getParameters();
                for (String key : parameters.keySet()) {
                    solrQuery.setParam(key, new String[]{(String)parameters.get(key)});
                }
            }
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Solr query is: " + solrQuery));
                }
                QueryResponse queryResponse = this.solrServer.query((SolrParams)solrQuery);
                this.logTime("search", queryResponse.getElapsedTime());
                resultSet.setResults(queryResponse.getBeans(beanClazz));
                resultSet.setResultSize(queryResponse.getResults().getNumFound());
                resultSet.setSearchTime(queryResponse.getElapsedTime());
                if (solrQuery.getBool("facet", false)) {
                    resultSet.setFacetFields(queryResponse.getFacetFields());
                }
            }
            catch (SolrServerException e) {
                log.error((Object)("SolrServerException: " + e.getMessage()));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
            catch (SolrException e) {
                log.error((Object)("SolrException: " + e.getMessage()));
                throw new SolrTypeException((Throwable)e, ProblemType.MALFORMED_QUERY);
            }
        }
        return resultSet;
    }

    private List<Term> getSuggestions(String query, String field, String rHandler) {
        ArrayList<Term> results = new ArrayList<Term>();
        try {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/" + rHandler});
            params.set("q", new String[]{field + ":" + query});
            params.set("rows", 0);
            params.set("timeAllowed", 30000);
            QueryResponse queryResponse = this.solrServer.query((SolrParams)params);
            SpellCheckResponse spellcheckResponse = queryResponse.getSpellCheckResponse();
            if (spellcheckResponse != null && !spellcheckResponse.getSuggestions().isEmpty() && spellcheckResponse.getCollatedResults() != null) {
                for (SpellCheckResponse.Collation collation : spellcheckResponse.getCollatedResults()) {
                    StringBuilder termResult = new StringBuilder();
                    for (SpellCheckResponse.Correction cor : collation.getMisspellingsAndCorrections()) {
                        String[] terms;
                        for (String term : terms = cor.getCorrection().trim().replaceAll("  ", " ").split(" ")) {
                            if (StringUtils.isBlank((String)term) || StringUtils.contains((String)termResult.toString(), (String)term)) continue;
                            termResult.append(term).append(" ");
                        }
                    }
                    Term term = new Term(termResult.toString().trim(), collation.getNumberOfHits(), SuggestionTitle.getMappedTitle(field), SearchUtils.escapeFacet(field, termResult.toString()));
                    results.add(term);
                }
            }
        }
        catch (SolrServerException e) {
            log.error((Object)("Exception :" + e.getMessage()));
        }
        return results;
    }

    @Override
    public List<Term> suggestions(String query, int pageSize, String field) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s, %d, %s", query, pageSize, field));
        }
        ArrayList<Term> results = new ArrayList<Term>();
        long start = new Date().getTime();
        this.total.put(query, 0L);
        if (StringUtils.isBlank((String)field) || !SPELL_FIELDS.contains(field)) {
            results.addAll(this.getSuggestions(query, "title", "suggestTitle"));
            results.addAll(this.getSuggestions(query, "who", "suggestWho"));
            results.addAll(this.getSuggestions(query, "what", "suggestWhat"));
            results.addAll(this.getSuggestions(query, "where", "suggestWhere"));
            results.addAll(this.getSuggestions(query, "when", "suggestWhen"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.TITLE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestTitle"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PERSON.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWho"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.SUBJECT.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhat"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.PLACE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhere"));
        } else if (StringUtils.equals((String)field, (String)SuggestionTitle.DATE.title)) {
            results.addAll(this.getSuggestions(query, field, "suggestWhen"));
        }
        Collections.sort(results);
        this.logTime("suggestions", new Date().getTime() - start);
        this.total.remove(query);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returned %d results in %d ms", results.size() > pageSize ? pageSize : results.size(), new Date().getTime() - start));
        }
        return results.size() > pageSize ? results.subList(0, pageSize) : results;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = this.setServer(solrServer);
    }

    private SolrServer setServer(SolrServer solrServer) {
        if (solrServer instanceof HttpSolrServer) {
            HttpSolrServer server = new HttpSolrServer(((HttpSolrServer)solrServer).getBaseURL());
            AbstractHttpClient client = (AbstractHttpClient)server.getHttpClient();
            client.addRequestInterceptor((HttpRequestInterceptor)new PreEmptiveBasicAuthenticator(this.username, this.password));
            return server;
        }
        return solrServer;
    }

    @Override
    public List<Neo4jBean> getChildren(String nodeId, int offset, int limit) {
        List children = this.neo4jServer.getChildren(this.getNode(nodeId), offset, limit);
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        for (Node child : children) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((Node)child, (long)this.getNodeId(child)));
        }
        return beans;
    }

    @Override
    public boolean isHierarchy(String nodeId) {
        return this.neo4jServer.isHierarchy(nodeId);
    }

    @Override
    public List<Neo4jBean> getChildren(String nodeId, int offset) {
        return this.getChildren(nodeId, offset, 10);
    }

    @Override
    public List<Neo4jBean> getChildren(String nodeId) {
        return this.getChildren(nodeId, 0, 10);
    }

    private Node getNode(String id) {
        return this.neo4jServer.getNode(id);
    }

    @Override
    public Neo4jBean getHierarchicalBean(String nodeId) {
        Node node = this.getNode(nodeId);
        if (node != null) {
            return Node2Neo4jBeanConverter.toNeo4jBean((Node)node, (long)this.getNodeId(node));
        }
        return null;
    }

    @Override
    public Date getLastSolrUpdate() throws SolrServerException, IOException {
        long t0 = new Date().getTime();
        NamedList namedList = this.solrServer.request((SolrRequest)new LukeRequest());
        NamedList index = (NamedList)namedList.get("index");
        if (log.isInfoEnabled()) {
            log.info((Object)("spent: " + (new Date().getTime() - t0)));
        }
        return (Date)index.get("lastModified");
    }

    public void logTime(String type, long time) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("elapsed time (%s): %d", type, time));
        }
    }

    @Override
    public List<Neo4jBean> getPreceedingSiblings(String nodeId, int limit) {
        List children = this.neo4jServer.getPreceedingSiblings(this.getNode(nodeId), limit);
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        for (Node child : children) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((Node)child, (long)this.getNodeId(child)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getPreceedingSiblings(String nodeId) {
        return this.getPreceedingSiblings(nodeId, 10);
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String nodeId, int limit) {
        List children = this.neo4jServer.getFollowingSiblings(this.getNode(nodeId), limit);
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        for (Node child : children) {
            beans.add(Node2Neo4jBeanConverter.toNeo4jBean((Node)child, (long)this.getNodeId(child)));
        }
        return beans;
    }

    @Override
    public List<Neo4jBean> getFollowingSiblings(String nodeId) {
        return this.getFollowingSiblings(nodeId, 10);
    }

    @Override
    public long getChildrenCount(String nodeId) {
        return this.neo4jServer.getChildrenCount(this.getNode(nodeId));
    }

    private long getNodeId(Node nodeId) {
        return this.neo4jServer.getNodeIndex(nodeId);
    }

    @Override
    public Neo4jStructBean getInitialStruct(String nodeId) {
        return Node2Neo4jBeanConverter.toNeo4jStruct((Hierarchy)this.neo4jServer.getInitialStruct(nodeId));
    }

    private static enum SuggestionTitle {
        TITLE("title", "Title"),
        DATE("when", "Time/Period"),
        PLACE("where", "Place"),
        PERSON("who", "Creator"),
        SUBJECT("what", "Subject");

        String title;
        String mappedTitle;

        private SuggestionTitle(String title, String mappedTitle) {
            this.title = title;
            this.mappedTitle = mappedTitle;
        }

        public static String getMappedTitle(String title) {
            for (SuggestionTitle st : SuggestionTitle.values()) {
                if (!StringUtils.equals((String)title, (String)st.title)) continue;
                return st.mappedTitle;
            }
            return null;
        }
    }
}

