/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.lookup.impl;

import com.mongodb.MongoClient;
import eu.europeana.corelib.storage.MongoServer;
import eu.europeana.corelib.storage.impl.MongoProviderImpl;
import eu.europeana.corelib.tools.lookuptable.Collection;
import eu.europeana.corelib.tools.lookuptable.CollectionMongoServer;
import java.util.List;
import java.util.logging.Logger;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.Query;

public class CollectionMongoServerImpl
implements MongoServer,
CollectionMongoServer {
    private static final Logger log = Logger.getLogger(CollectionMongoServerImpl.class.getName());
    private MongoClient mongoClient;
    private String databaseName;
    private Datastore datastore;

    public CollectionMongoServerImpl(MongoClient mongoClient, String databaseName) {
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.createDatastore();
    }

    public CollectionMongoServerImpl(Datastore datastore) {
        this.mongoClient = datastore.getMongo();
        this.databaseName = datastore.getCollection(Collection.class).getName();
        this.datastore = datastore;
    }

    public CollectionMongoServerImpl(String host, int port, String databaseName, String username, String password) {
        this.mongoClient = new MongoProviderImpl(host, String.valueOf(port), databaseName, username, password).getMongo();
        this.databaseName = databaseName;
        this.createDatastore();
    }

    private void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{Collection.class});
        this.datastore = morphia.createDatastore(this.mongoClient, this.databaseName);
        this.datastore.ensureIndexes();
        log.info("CollectionMongoServer datastore is created");
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        if (this.mongoClient != null) {
            log.info("Closing MongoClient for CollectionMongoServer");
            this.mongoClient.close();
        }
    }

    @Override
    public String findNewCollectionId(String oldCollectionId) {
        return ((Query)this.datastore.find(Collection.class).field("oldCollectionId").equal((Object)oldCollectionId)).get() != null ? ((Collection)((Query)this.datastore.find(Collection.class).field("oldCollectionId").equal((Object)oldCollectionId)).get()).getNewCollectionId() : null;
    }

    @Override
    public String findOldCollectionId(String newCollectionId) {
        return ((Query)this.datastore.find(Collection.class).field("newCollectionId").equal((Object)newCollectionId)).get() != null ? ((Collection)((Query)this.datastore.find(Collection.class).field("newCollectionId").equal((Object)newCollectionId)).get()).getOldCollectionId() : null;
    }

    @Override
    public void saveCollection(Collection collection) {
        this.datastore.save((Object)collection);
    }

    @Override
    public List<Collection> retrieveAllCollections() {
        return this.datastore.find(Collection.class).asList();
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }
}

