/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.lookup.impl;

import com.mongodb.MongoClient;
import eu.europeana.corelib.storage.MongoServer;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public class EuropeanaIdMongoServerImpl
implements MongoServer,
EuropeanaIdMongoServer {
    private static final Logger LOG = Logger.getLogger(EuropeanaIdMongoServerImpl.class);
    private static final String OLD_ID = "oldId";
    private static final String NEW_ID = "newId";
    protected MongoClient mongoClient;
    protected String databaseName;
    protected Datastore datastore;

    public EuropeanaIdMongoServerImpl(MongoClient mongoClient, String databaseName) {
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
    }

    @Override
    public void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{EuropeanaId.class});
        this.datastore = morphia.createDatastore(this.mongoClient, this.databaseName);
        this.datastore.ensureIndexes();
        LOG.info((Object)"EuropeanaIdMongoServer datastore is created");
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        LOG.info((Object)"Closing MongoClient for EuropeanaIdMongoServer");
        this.mongoClient.close();
    }

    @Override
    public EuropeanaId retrieveEuropeanaIdFromOld(String oldId) {
        try {
            return (EuropeanaId)((Query)this.datastore.find(EuropeanaId.class).field(OLD_ID).equal((Object)oldId)).get();
        }
        catch (Exception e) {
            LOG.error((Object)"Error retrieving europeanaId", (Throwable)e);
            return null;
        }
    }

    @Override
    public EuropeanaId retrieveEuropeanaIdFromOld(List<String> oldIds) {
        return (EuropeanaId)((Query)this.datastore.find(EuropeanaId.class).field(OLD_ID).hasAnyOf(oldIds)).get();
    }

    @Override
    public List<EuropeanaId> retrieveEuropeanaIdFromNew(String newId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field(NEW_ID).equal((Object)newId)).asList();
    }

    @Override
    public boolean oldIdExists(String newId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field(NEW_ID).equal((Object)newId)).get() != null;
    }

    @Override
    public boolean newIdExists(String oldId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field(OLD_ID).equal((Object)oldId)).get() != null;
    }

    @Override
    public void setLastAccessed(String oldId) {
        EuropeanaId oldEuropeanaId = this.retrieveEuropeanaIdFromOld(oldId);
        oldEuropeanaId.setLastAccess(new Date().getTime());
        Query updateQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field(OLD_ID).equal((Object)oldId);
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("lastAccess", (Object)oldEuropeanaId.getLastAccess());
        this.datastore.update(updateQuery, ops);
    }

    @Override
    public void saveEuropeanaId(EuropeanaId europeanaId) {
        EuropeanaId oldEuropeanaId = this.retrieveEuropeanaIdFromOld(europeanaId.getOldId());
        if (oldEuropeanaId != null) {
            oldEuropeanaId.setNewId(europeanaId.getNewId());
            Query updateQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field(OLD_ID).equal((Object)europeanaId.getOldId());
            UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set(NEW_ID, (Object)oldEuropeanaId.getNewId());
            this.datastore.update(updateQuery, ops);
        } else {
            this.datastore.save((Object)europeanaId);
        }
    }

    @Override
    public void deleteEuropeanaId(String oldId, String newId) {
        Query deleteQuery = (Query)((Query)this.datastore.createQuery(EuropeanaId.class).field(OLD_ID).equal((Object)oldId)).field(NEW_ID).equal((Object)newId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteEuropeanaIdFromOld(String oldId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field(OLD_ID).equal((Object)oldId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteEuropeanaIdFromNew(String newId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field(NEW_ID).equal((Object)newId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void updateTime(String newId, String oldId) {
        Query updateQuery = (Query)((Query)this.datastore.createQuery(EuropeanaId.class).field(OLD_ID).equal((Object)oldId)).field(NEW_ID).equal((Object)newId);
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("timestamp", (Object)new Date().getTime());
        this.datastore.update(updateQuery, ops);
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    @Override
    public EuropeanaId find() {
        return (EuropeanaId)this.datastore.find(EuropeanaId.class).get();
    }

    @Override
    public EuropeanaId findOne(String oldId) {
        return (EuropeanaId)this.datastore.find(EuropeanaId.class, OLD_ID, (Object)oldId).get();
    }
}

