/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.lookup.utils;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtils {
    static final String HEX_STRING = "0123456789ABCDEF";
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};

    public static String createHash(String field) {
        StringBuilder hash = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            hash = new StringBuilder();
            byte[] byArray = digest.digest(field.getBytes());
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                Byte b = byArray[i];
                hash.append(HEX_STRING.charAt((b & 0xF0) >> 4)).append(HEX_STRING.charAt((int)(b & 0xF)));
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return hash.toString();
    }

    public static String createHashSHA256(String uri) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] raw = digest.digest(uri.getBytes("UTF-8"));
            byte[] hex = new byte[2 * raw.length];
            int index = 0;
            for (byte b : raw) {
                int v = b & 0xFF;
                hex[index++] = HEX_CHAR_TABLE[v >>> 4];
                hex[index++] = HEX_CHAR_TABLE[v & 0xF];
            }
            return new String(hex, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }
}

