/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.lookup.impl;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.query.Query;
import com.google.code.morphia.query.UpdateOperations;
import com.mongodb.Mongo;
import eu.europeana.corelib.storage.MongoServer;
import eu.europeana.corelib.tools.lookuptable.EuropeanaId;
import eu.europeana.corelib.tools.lookuptable.EuropeanaIdMongoServer;
import eu.europeana.publication.common.IDocument;
import eu.europeana.publication.common.State;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EuropeanaIdMongoServerImpl
implements MongoServer,
EuropeanaIdMongoServer {
    protected Mongo mongoServer;
    protected String databaseName;
    protected Datastore datastore;
    protected String username;
    protected String password;

    public EuropeanaIdMongoServerImpl(Mongo mongoServer, String databaseName, String username, String password) {
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
    }

    @Override
    public void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{EuropeanaId.class});
        this.datastore = morphia.createDatastore(this.mongoServer, this.databaseName);
        if (StringUtils.isNotBlank((String)this.username) && StringUtils.isNotBlank((String)this.password)) {
            this.datastore.getDB().authenticate(this.username, this.password.toCharArray());
        }
        this.datastore.ensureIndexes();
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        this.mongoServer.close();
    }

    @Override
    public EuropeanaId retrieveEuropeanaIdFromOld(String oldId) {
        if (this.datastore == null) {
            this.createDatastore();
        }
        try {
            EuropeanaId id = (EuropeanaId)((Query)this.datastore.find(EuropeanaId.class).field("oldId").equal((Object)oldId)).get();
            return id;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List<EuropeanaId> retrieveEuropeanaIdFromNew(String newId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field("newId").equal((Object)newId)).asList();
    }

    @Override
    public boolean oldIdExists(String newId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field("newId").equal((Object)newId)).get() != null;
    }

    @Override
    public boolean newIdExists(String oldId) {
        return ((Query)this.datastore.find(EuropeanaId.class).field("oldId").equal((Object)oldId)).get() != null;
    }

    @Override
    public void setLastAccessed(String oldId) {
        EuropeanaId oldEuropeanaId = this.retrieveEuropeanaIdFromOld(oldId);
        oldEuropeanaId.setLastAccess(new Date().getTime());
        Query updateQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId);
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("lastAccess", (Object)oldEuropeanaId.getLastAccess());
        this.datastore.update(updateQuery, ops);
    }

    @Override
    public void saveEuropeanaId(EuropeanaId europeanaId) {
        EuropeanaId oldEuropeanaId = this.retrieveEuropeanaIdFromOld(europeanaId.getOldId());
        if (oldEuropeanaId != null) {
            oldEuropeanaId.setNewId(europeanaId.getNewId());
            Query updateQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)europeanaId.getOldId());
            UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("newId", (Object)oldEuropeanaId.getNewId());
            this.datastore.update(updateQuery, ops);
        } else {
            this.datastore.save((Object)europeanaId);
        }
    }

    @Override
    public void deleteEuropeanaId(String oldId, String newId) {
        Query deleteQuery = (Query)((Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId)).field("newId").equal((Object)newId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteEuropeanaIdFromOld(String oldId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void deleteEuropeanaIdFromNew(String newId) {
        Query deleteQuery = (Query)this.datastore.createQuery(EuropeanaId.class).field("newId").equal((Object)newId);
        this.datastore.findAndDelete(deleteQuery);
    }

    @Override
    public void updateTime(String newId, String oldId) {
        Query updateQuery = (Query)((Query)this.datastore.createQuery(EuropeanaId.class).field("oldId").equal((Object)oldId)).field("newId").equal((Object)newId);
        UpdateOperations ops = this.datastore.createUpdateOperations(EuropeanaId.class).set("timestamp", (Object)new Date().getTime());
        this.datastore.update(updateQuery, ops);
    }

    @Override
    public void setDatastore(Datastore datastore) {
        this.datastore = datastore;
    }

    @Override
    public EuropeanaId find() {
        return (EuropeanaId)this.datastore.find(EuropeanaId.class).get();
    }

    @Override
    public EuropeanaId findOne(String oldId) {
        return (EuropeanaId)this.datastore.find(EuropeanaId.class, "oldId", (Object)oldId).get();
    }

    public List<IDocument> getDocumentsByStatesUsingBatch(List<State> stateVlues, Map<String, List<String>> queryChoices, int batchSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IDocument getDocumentById(String id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertDocument(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void updateDocumentUsingId(IDocument document) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cloneDocument(IDocument originalDocument, IDocument clonedDocument) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void deleteDocument(IDocument id) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void commit() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

