/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.logging.injector;

import eu.europeana.corelib.logging.Log;
import eu.europeana.corelib.logging.Logger;
import java.lang.reflect.Field;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

public class LogInjector
implements BeanPostProcessor,
Ordered {
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessBeforeInitialization(final Object bean, String beanName) throws BeansException {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                ReflectionUtils.makeAccessible((Field)field);
                Log log = field.getAnnotation(Log.class);
                if (log != null) {
                    if (StringUtils.isNotBlank((String)log.value())) {
                        field.set(bean, Logger.getLogger(log.value()));
                    } else {
                        field.set(bean, Logger.getLogger(bean.getClass()));
                    }
                }
            }
        });
        return bean;
    }
}

