/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.neo4j.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Selfington;
import eu.europeana.corelib.neo4j.entity.Siblington;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class Neo4jService {
    private static final Logger LOG = LogManager.getLogger(Neo4jService.class);
    private final String pluginPath;
    private String neo4jUser;
    private String neo4jPassword;
    private HttpClient client;
    private boolean authenticated = true;

    public Neo4jService(String pluginPath, String user, String password) {
        this.pluginPath = pluginPath;
        this.neo4jUser = user;
        this.neo4jPassword = password;
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
    }

    public Neo4jService(String pluginPath) {
        this.authenticated = false;
        this.pluginPath = pluginPath;
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
    }

    public String getServerPath() {
        return this.pluginPath;
    }

    public List<CustomNode> getSingleNode(String rdfAbout) throws Neo4JException {
        HttpGet request = new HttpGet(this.fixTrailingSlash(this.pluginPath) + "fetch/self/rdfAbout/" + StringUtils.replace((String)(rdfAbout + ""), (String)"/", (String)"%2F"));
        if (this.authenticated) {
            this.addAuthHeader(request);
        }
        try {
            HttpResponse resp = this.executeRequest(request, rdfAbout);
            ObjectMapper mapper = new ObjectMapper();
            Selfington selfington = (Selfington)mapper.readValue(resp.getEntity().getContent(), Selfington.class);
            List<CustomNode> list = selfington.getSelf();
            return list;
        }
        catch (IOException e) {
            throw new Neo4JException(ProblemType.NEO4J_503_CONNECTION, e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public List<CustomNode> getChildren(String rdfAbout, int offset, int limit) throws Neo4JException {
        return this.nodeFetcher("children", rdfAbout, offset, limit);
    }

    public List<CustomNode> getFollowingSiblings(String rdfAbout, int offset, int limit) throws Neo4JException {
        return this.nodeFetcher("following", rdfAbout, offset, limit);
    }

    public List<CustomNode> getPrecedingSiblings(String rdfAbout, int offset, int limit) throws Neo4JException {
        return this.nodeFetcher("preceding", rdfAbout, offset, limit);
    }

    private List<CustomNode> nodeFetcher(String path, String rdfAbout, int offset, int limit) throws Neo4JException {
        HttpGet request = new HttpGet(this.fixTrailingSlash(this.pluginPath) + "fetch/" + path + "/rdfAbout/" + StringUtils.replace((String)(rdfAbout + ""), (String)"/", (String)"%2F") + "?offset=" + offset + "&limit=" + limit);
        if (this.authenticated) {
            this.addAuthHeader(request);
        }
        try {
            HttpResponse resp = this.executeRequest(request, rdfAbout);
            ObjectMapper mapper = new ObjectMapper();
            Siblington siblington = (Siblington)mapper.readValue(resp.getEntity().getContent(), Siblington.class);
            List<CustomNode> list = siblington.getSiblings();
            return list;
        }
        catch (IOException e) {
            throw new Neo4JException(ProblemType.NEO4J_503_CONNECTION, e);
        }
        finally {
            request.releaseConnection();
        }
    }

    public Hierarchy getInitialStruct(String rdfAbout) throws Neo4JException {
        HttpGet request = new HttpGet(this.fixTrailingSlash(this.pluginPath) + "fetch/hierarchy/rdfAbout/" + StringUtils.replace((String)rdfAbout, (String)"/", (String)"%2F"));
        LOG.debug("path: {}", (Object)request.getURI());
        if (this.authenticated) {
            this.addAuthHeader(request);
        }
        try {
            HttpResponse resp = this.executeRequest(request, rdfAbout);
            ObjectMapper mapper = new ObjectMapper();
            Hierarchy hierarchy = (Hierarchy)mapper.readValue(resp.getEntity().getContent(), Hierarchy.class);
            return hierarchy;
        }
        catch (IOException e) {
            throw new Neo4JException(ProblemType.NEO4J_503_CONNECTION, e);
        }
        finally {
            request.releaseConnection();
        }
    }

    private HttpResponse executeRequest(HttpGet request, String rdfAbout) throws Neo4JException, IOException {
        HttpResponse resp = this.client.execute((HttpUriRequest)request);
        if (resp.getStatusLine().getStatusCode() == 404) {
            throw new Neo4JException(ProblemType.NEO4J_404, rdfAbout);
        }
        if (resp.getStatusLine().getStatusCode() == 502) {
            throw new Neo4JException(ProblemType.NEO4J_502_BAD_DATA, rdfAbout);
        }
        if (resp.getStatusLine().getStatusCode() == 500) {
            throw new Neo4JException(ProblemType.NEO4J_500, rdfAbout);
        }
        return resp;
    }

    private void addAuthHeader(HttpGet httpGet) {
        String auth = this.neo4jUser + ":" + this.neo4jPassword;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.ISO_8859_1));
        String authHeader = "Basic " + new String(encodedAuth);
        httpGet.setHeader("Authorization", authHeader);
    }

    private String fixTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }
}

