/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.neo4j;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.TextNode;
import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.neo4j.server.Neo4jService;
import eu.europeana.corelib.web.exception.ProblemType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.springframework.context.annotation.Lazy;

@Lazy
public class Neo4jSearchService {
    private static final String KEYXMLLANG = "_xml:lang_";
    private static final String RDFABOUT = "rdf:about";
    private static final String EDMTYPE = "edm:type";
    private static final String HASCHILDREN = "hasChildren";
    private static final String HASPARENT = "hasParent";
    private static final String TRUE = "true";
    private static final String CHILDRENCOUNT = "childrenCount";
    private static final String RELBEFORE = "relBefore";
    private static final String INDEX = "index";
    private static final String NULL = "(null)";
    @Resource(name="corelib_neo4j_service")
    protected Neo4jService neo4jService;

    @PostConstruct
    private void init() {
        LogManager.getLogger(Neo4jSearchService.class).info("Connected to {}", (Object)this.neo4jService.getServerPath());
    }

    public Neo4jBean getSingle(String rdfAbout) throws Neo4JException {
        List<CustomNode> selfList = this.neo4jService.getSingleNode(rdfAbout);
        if (!selfList.isEmpty()) {
            return this.toNeo4jBean(selfList.get(0), -1L);
        }
        throw new Neo4JException(ProblemType.NEO4J_404, " \n\n... can't find node with ID: " + rdfAbout);
    }

    public List<Neo4jBean> getChildren(String rdfAbout, int offset, int limit) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        long startIndex = offset;
        List<CustomNode> children = this.neo4jService.getChildren(rdfAbout, offset, limit);
        for (CustomNode child : children) {
            beans.add(this.toNeo4jBean(child, ++startIndex));
        }
        return beans;
    }

    public List<Neo4jBean> getPrecedingSiblings(String rdfAbout, int offset, int limit, long selfIndex) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List<CustomNode> precedingSiblings = this.neo4jService.getPrecedingSiblings(rdfAbout, offset, limit);
        long startIndex = selfIndex - (long)offset;
        for (CustomNode precedingSibling : precedingSiblings) {
            beans.add(this.toNeo4jBean(precedingSibling, --startIndex));
        }
        return beans;
    }

    public List<Neo4jBean> getFollowingSiblings(String rdfAbout, int offset, int limit, long selfIndex) throws Neo4JException {
        ArrayList<Neo4jBean> beans = new ArrayList<Neo4jBean>();
        List<CustomNode> followingSiblings = this.neo4jService.getFollowingSiblings(rdfAbout, offset, limit);
        long startIndex = selfIndex + (long)offset;
        for (CustomNode followingSibling : followingSiblings) {
            beans.add(this.toNeo4jBean(followingSibling, ++startIndex));
        }
        return beans;
    }

    public Neo4jStructBean getInitialStruct(String rdfAbout, long selfIndex) throws Neo4JException {
        return Objects.requireNonNull(this.toNeo4jStruct(this.neo4jService.getInitialStruct(rdfAbout), selfIndex));
    }

    private Neo4jBean toNeo4jBean(CustomNode node, long selfIndex) {
        if (node != null) {
            Neo4jBean neo4jBean = new Neo4jBean();
            neo4jBean.setId(((TextNode)node.getProperty(RDFABOUT)).asText());
            neo4jBean.setType(DocType.safeValueOf((String)node.getProperty(EDMTYPE).toString().replace("\"", "")));
            neo4jBean.setHasChildren(node.hasProperty(HASCHILDREN));
            if (node.hasProperty(HASCHILDREN) && node.hasProperty(CHILDRENCOUNT)) {
                IntNode childrenCount = (IntNode)node.getProperty(CHILDRENCOUNT);
                neo4jBean.setChildrenCount(childrenCount.asLong());
            }
            this.setLangAwareProperties(neo4jBean, node);
            if (node.hasProperty(HASPARENT)) {
                neo4jBean.setParent(StringUtils.replace((String)node.getProperty(HASPARENT).toString(), (String)"\"", (String)""));
            }
            if (selfIndex > 0L) {
                neo4jBean.setIndex(selfIndex);
            } else if (node.hasProperty(INDEX)) {
                IntNode index = (IntNode)node.getProperty(INDEX);
                neo4jBean.setIndex(index.asLong());
            } else {
                neo4jBean.setIndex(0L);
            }
            if (node.hasProperty(RELBEFORE)) {
                neo4jBean.setRelBefore(Boolean.parseBoolean(node.getProperty(RELBEFORE).toString()));
            }
            return neo4jBean;
        }
        return null;
    }

    private void addLangAwareProperties(String key, String lang, Map<String, List<String>> langAwareProperties, CustomNode customnode) {
        List<Object> langAwareValues;
        List<Object> list = langAwareValues = langAwareProperties.get(lang) != null ? langAwareProperties.get(lang) : new ArrayList();
        if (customnode.getProperty(key) instanceof ArrayNode) {
            langAwareValues.addAll(this.extractArrayNode(customnode, key));
        } else {
            langAwareValues.addAll((List)customnode.getProperty(key));
        }
        langAwareProperties.put(lang, langAwareValues);
    }

    private void setLangAwareProperties(Neo4jBean bean, CustomNode customnode) {
        HashMap<String, List<String>> titles = new HashMap<String, List<String>>();
        HashMap<String, List<String>> descriptions = new HashMap<String, List<String>>();
        for (String key : customnode.getPropertyKeys()) {
            if (key.startsWith("dc:description")) {
                this.addLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:description_xml:lang_"), descriptions, customnode);
                continue;
            }
            if (!key.startsWith("dc:title")) continue;
            this.addLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:title_xml:lang_"), titles, customnode);
        }
        bean.setTitle(titles);
        bean.setDescription(descriptions);
    }

    private List<String> extractArrayNode(CustomNode node, String key) {
        ArrayList<String> values = new ArrayList<String>();
        int size = ((ArrayNode)node.getProperty(key)).size();
        for (int i = 0; i < size; ++i) {
            values.add(((ArrayNode)node.getProperty(key)).get(i).asText());
        }
        return values;
    }

    private Neo4jStructBean toNeo4jStruct(Hierarchy hierarchy, long index) {
        Neo4jStructBean struct = new Neo4jStructBean();
        if (hierarchy == null || hierarchy.getParents().isEmpty()) {
            return null;
        }
        List<CustomNode> parentNodes = hierarchy.getParents();
        List<CustomNode> pSiblingNodes = hierarchy.getPrecedingSiblings();
        List<CustomNode> fSiblingNodes = hierarchy.getFollowingSiblings();
        List<CustomNode> psChildNodes = hierarchy.getPrecedingSiblingChildren();
        List<CustomNode> fsChildNodes = hierarchy.getFollowingSiblingChildren();
        ArrayList<Neo4jBean> parentBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> pSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> psChildBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fsChildBeans = new ArrayList<Neo4jBean>();
        int i = 0;
        for (CustomNode parentNode : parentNodes) {
            if (i == 0) {
                struct.setSelf(this.toNeo4jBean(parentNode, index));
            } else {
                parentBeans.add(this.toNeo4jBean(parentNode, -1L));
            }
            ++i;
        }
        long previousIndex = index;
        int j = 0;
        for (CustomNode pSiblingNode : pSiblingNodes) {
            if (null == pSiblingNode) continue;
            pSiblingBeans.add(this.toNeo4jBean(pSiblingNode, --previousIndex));
            if (psChildNodes.size() > j && pSiblingNode.hasProperty(HASCHILDREN) && StringUtils.equalsIgnoreCase((CharSequence)pSiblingNode.getProperty(HASCHILDREN).toString(), (CharSequence)TRUE)) {
                psChildBeans.add(this.toNeo4jBean(psChildNodes.get(j), 1L));
                ++j;
                continue;
            }
            psChildBeans.add(this.createEmptyNeo4JBean());
        }
        long followingIndex = index;
        int k = 0;
        for (CustomNode fSiblingNode : fSiblingNodes) {
            if (null == fSiblingNode) continue;
            fSiblingBeans.add(this.toNeo4jBean(fSiblingNode, ++followingIndex));
            if (fsChildNodes.size() > k && fSiblingNode.hasProperty(HASCHILDREN) && StringUtils.equalsIgnoreCase((CharSequence)fSiblingNode.getProperty(HASCHILDREN).toString(), (CharSequence)TRUE)) {
                fsChildBeans.add(this.toNeo4jBean(fsChildNodes.get(k), 1L));
                ++k;
                continue;
            }
            fsChildBeans.add(this.createEmptyNeo4JBean());
        }
        struct.setParents(parentBeans);
        struct.setPrecedingSiblings(pSiblingBeans);
        struct.setFollowingSiblings(fSiblingBeans);
        struct.setPrecedingSiblingChildren(psChildBeans);
        struct.setFollowingSiblingChildren(fsChildBeans);
        return struct;
    }

    private Neo4jBean createEmptyNeo4JBean() {
        Neo4jBean neo4jBean = new Neo4jBean();
        final ArrayList<String> nullVal = new ArrayList<String>(){
            private static final long serialVersionUID = 1974692064190530659L;
            {
                this.add(Neo4jSearchService.NULL);
            }
        };
        HashMap<String, List<String>> titles = new HashMap<String, List<String>>(){
            private static final long serialVersionUID = 8846401931134342010L;
            {
                this.put("def", nullVal);
            }
        };
        neo4jBean.setId(NULL);
        neo4jBean.setType(DocType.safeValueOf((String)NULL));
        neo4jBean.setTitle((Map<String, List<String>>)titles);
        neo4jBean.setHasChildren(Boolean.FALSE);
        neo4jBean.setIndex(0L);
        neo4jBean.setParent(NULL);
        neo4jBean.setRelBefore(Boolean.FALSE);
        neo4jBean.setChildrenCount(0L);
        return neo4jBean;
    }
}

