/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.neo4j.entity;

import eu.europeana.corelib.definitions.solr.DocType;
import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.Neo4jBean;
import eu.europeana.corelib.neo4j.entity.Neo4jStructBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.BooleanNode;
import org.codehaus.jackson.node.IntNode;
import org.codehaus.jackson.node.TextNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;

public class Node2Neo4jBeanConverter {
    private static final String KEYXMLLANG = "_xml:lang_";

    public static Neo4jBean toNeo4jBean(Node node, long index) {
        if (node != null) {
            Neo4jBean neo4jBean = new Neo4jBean();
            neo4jBean.setId((String)node.getProperty("rdf:about"));
            neo4jBean.setType(DocType.valueOf((String)((String)node.getProperty("edm:type")).replace("\"", "")));
            neo4jBean.setHasChildren(node.hasProperty("hasChildren"));
            neo4jBean = Node2Neo4jBeanConverter.retrieveLangAwareProperties(neo4jBean, node);
            if (node.hasProperty("hasParent")) {
                neo4jBean.setParent(StringUtils.replace((String)((String)node.getProperty("hasParent")), (String)"\\\"", (String)""));
            }
            neo4jBean.setIndex(index);
            if (node.hasRelationship((RelationshipType)DynamicRelationshipType.withName((String)"edm:isNextInSequence"), Direction.OUTGOING)) {
                neo4jBean.setRelBefore(Boolean.TRUE);
            } else if (node.hasRelationship((RelationshipType)DynamicRelationshipType.withName((String)"isFakeOrder"), Direction.OUTGOING)) {
                neo4jBean.setRelBefore(Boolean.FALSE);
            }
            return neo4jBean;
        }
        return null;
    }

    public static Neo4jBean toNeo4jBean(Node node) {
        if (node != null) {
            Neo4jBean neo4jBean = new Neo4jBean();
            neo4jBean.setId((String)node.getProperty("rdf:about"));
            neo4jBean.setType(DocType.valueOf((String)((String)node.getProperty("edm:type")).replace("\"", "")));
            neo4jBean.setHasChildren(node.hasProperty("hasChildren"));
            neo4jBean = Node2Neo4jBeanConverter.retrieveLangAwareProperties(neo4jBean, node);
            if (node.hasProperty("hasParent")) {
                neo4jBean.setParent(StringUtils.replace((String)((String)node.getProperty("hasParent")), (String)"\\\"", (String)""));
            }
            if (node.hasRelationship((RelationshipType)DynamicRelationshipType.withName((String)"edm:isNextInSequance"), Direction.OUTGOING)) {
                neo4jBean.setRelBefore(Boolean.TRUE);
            } else if (node.hasRelationship((RelationshipType)DynamicRelationshipType.withName((String)"isFakeOrder"), Direction.OUTGOING)) {
                neo4jBean.setRelBefore(Boolean.FALSE);
            }
            return neo4jBean;
        }
        return null;
    }

    private static Neo4jBean retrieveLangAwareProperties(Neo4jBean bean, Node node) {
        Map<String, List<String>> titles = new HashMap<String, List<String>>();
        Map<String, List<String>> descriptions = new HashMap<String, List<String>>();
        for (String key : node.getPropertyKeys()) {
            if (key.startsWith("dc:description")) {
                descriptions = Node2Neo4jBeanConverter.getLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:description_xml:lang_"), descriptions, node);
                continue;
            }
            if (!key.startsWith("dc:title")) continue;
            titles = Node2Neo4jBeanConverter.getLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:title_xml:lang_"), titles, node);
        }
        bean.setTitle(titles);
        bean.setDescription(descriptions);
        return bean;
    }

    private static Map<String, List<String>> getLangAwareProperties(String key, String lang, Map<String, List<String>> langAwareProperties, Node node) {
        List<Object> langAwareValues = langAwareProperties.get(lang) != null ? langAwareProperties.get(lang) : new ArrayList();
        langAwareValues.addAll(Arrays.asList((String[])node.getProperty(key)));
        langAwareProperties.put(lang, langAwareValues);
        return langAwareProperties;
    }

    public static Neo4jStructBean toNeo4jStruct(Hierarchy hierarchy) {
        int i = 0;
        int j = 0;
        int k = 0;
        Neo4jStructBean struct = new Neo4jStructBean();
        if (hierarchy == null || hierarchy.getParents().size() == 0) {
            return null;
        }
        List<CustomNode> parentNodes = hierarchy.getParents();
        List<CustomNode> pSiblingNodes = hierarchy.getPrecedingSiblings();
        List<CustomNode> fSiblingNodes = hierarchy.getFollowingSiblings();
        List<CustomNode> psChildNodes = hierarchy.getPrecedingSiblingChildren();
        List<CustomNode> fsChildNodes = hierarchy.getFollowingSiblingChildren();
        ArrayList<Neo4jBean> parentBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> pSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> psChildBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fsChildBeans = new ArrayList<Neo4jBean>();
        for (CustomNode parentNode : parentNodes) {
            if (i == 0) {
                struct.setSelf(Node2Neo4jBeanConverter.toNeo4jBean(parentNode));
            } else {
                parentBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(parentNode));
            }
            ++i;
        }
        for (CustomNode pSiblingNode : pSiblingNodes) {
            pSiblingBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(pSiblingNode));
            if (psChildNodes.size() > j && pSiblingNode.hasProperty("hasChildren") && ((BooleanNode)pSiblingNode.getProperty("hasChildren")).asBoolean()) {
                psChildBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(psChildNodes.get(j)));
                ++j;
                continue;
            }
            psChildBeans.add(Node2Neo4jBeanConverter.createEmptyNeo4JBean());
        }
        for (CustomNode fSiblingNode : fSiblingNodes) {
            fSiblingBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(fSiblingNode));
            if (fsChildNodes.size() > k && fSiblingNode.hasProperty("hasChildren") && ((BooleanNode)fSiblingNode.getProperty("hasChildren")).asBoolean()) {
                fsChildBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(fsChildNodes.get(k)));
                ++k;
                continue;
            }
            fsChildBeans.add(Node2Neo4jBeanConverter.createEmptyNeo4JBean());
        }
        struct.setParents(parentBeans);
        struct.setPrecedingSiblings(pSiblingBeans);
        struct.setFollowingSiblings(fSiblingBeans);
        struct.setPrecedingSiblingChildren(psChildBeans);
        struct.setFollowingSiblingChildren(fsChildBeans);
        return struct;
    }

    public static Neo4jStructBean toNeo4jStruct(Hierarchy hierarchy, long index) {
        int i = 0;
        int j = 0;
        int k = 0;
        Neo4jStructBean struct = new Neo4jStructBean();
        if (hierarchy == null || hierarchy.getParents().size() == 0) {
            return null;
        }
        List<CustomNode> parentNodes = hierarchy.getParents();
        List<CustomNode> pSiblingNodes = hierarchy.getPrecedingSiblings();
        List<CustomNode> fSiblingNodes = hierarchy.getFollowingSiblings();
        List<CustomNode> psChildNodes = hierarchy.getPrecedingSiblingChildren();
        List<CustomNode> fsChildNodes = hierarchy.getFollowingSiblingChildren();
        ArrayList<Neo4jBean> parentBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> pSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fSiblingBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> psChildBeans = new ArrayList<Neo4jBean>();
        ArrayList<Neo4jBean> fsChildBeans = new ArrayList<Neo4jBean>();
        for (CustomNode parentNode : parentNodes) {
            if (i == 0) {
                struct.setSelf(Node2Neo4jBeanConverter.toNeo4jBean(parentNode, index));
            } else {
                parentBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(parentNode, 1L));
            }
            ++i;
        }
        long previousIndex = index;
        for (CustomNode pSiblingNode : pSiblingNodes) {
            pSiblingBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(pSiblingNode, --previousIndex));
            if (psChildNodes.size() > j && pSiblingNode.hasProperty("hasChildren") && ((BooleanNode)pSiblingNode.getProperty("hasChildren")).asBoolean()) {
                psChildBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(psChildNodes.get(j), 1L));
                ++j;
                continue;
            }
            psChildBeans.add(Node2Neo4jBeanConverter.createEmptyNeo4JBean());
        }
        long followingIndex = index;
        for (CustomNode fSiblingNode : fSiblingNodes) {
            fSiblingBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(fSiblingNode, ++followingIndex));
            if (fsChildNodes.size() > k && fSiblingNode.hasProperty("hasChildren") && ((BooleanNode)fSiblingNode.getProperty("hasChildren")).asBoolean()) {
                fsChildBeans.add(Node2Neo4jBeanConverter.toNeo4jBean(fsChildNodes.get(k), 1L));
                ++k;
                continue;
            }
            fsChildBeans.add(Node2Neo4jBeanConverter.createEmptyNeo4JBean());
        }
        struct.setParents(parentBeans);
        struct.setPrecedingSiblings(pSiblingBeans);
        struct.setFollowingSiblings(fSiblingBeans);
        struct.setPrecedingSiblingChildren(psChildBeans);
        struct.setFollowingSiblingChildren(fsChildBeans);
        return struct;
    }

    public static Neo4jBean toNeo4jBean(CustomNode node) {
        if (node != null) {
            Neo4jBean neo4jBean = new Neo4jBean();
            neo4jBean.setId(((TextNode)node.getProperty("rdf:about")).asText());
            neo4jBean.setType(DocType.safeValueOf((String)node.getProperty("edm:type").toString().replace("\"", "")));
            neo4jBean.setHasChildren(node.hasProperty("hasChildren"));
            if (node.hasProperty("hasChildren") && node.hasProperty("childrenCount")) {
                IntNode childrenCount = (IntNode)node.getProperty("childrenCount");
                neo4jBean.setChildrenCount(childrenCount.asLong());
            }
            neo4jBean = Node2Neo4jBeanConverter.retrieveLangAwareProperties(neo4jBean, node);
            if (node.hasProperty("hasParent")) {
                neo4jBean.setParent(StringUtils.replace((String)node.getProperty("hasParent").toString(), (String)"\"", (String)""));
            }
            if (node.hasProperty("relBefore")) {
                neo4jBean.setRelBefore(Boolean.parseBoolean(node.getProperty("relBefore").toString()));
            }
            return neo4jBean;
        }
        return null;
    }

    public static Neo4jBean toNeo4jBean(CustomNode node, long index) {
        if (node != null) {
            Neo4jBean neo4jBean = new Neo4jBean();
            neo4jBean.setId(((TextNode)node.getProperty("rdf:about")).asText());
            neo4jBean.setType(DocType.safeValueOf((String)node.getProperty("edm:type").toString().replace("\"", "")));
            neo4jBean.setHasChildren(node.hasProperty("hasChildren"));
            if (node.hasProperty("hasChildren") && node.hasProperty("childrenCount")) {
                IntNode childrenCount = (IntNode)node.getProperty("childrenCount");
                neo4jBean.setChildrenCount(childrenCount.asLong());
            }
            neo4jBean = Node2Neo4jBeanConverter.retrieveLangAwareProperties(neo4jBean, node);
            if (node.hasProperty("hasParent")) {
                neo4jBean.setParent(StringUtils.replace((String)node.getProperty("hasParent").toString(), (String)"\"", (String)""));
            }
            neo4jBean.setIndex(index);
            if (node.hasProperty("relBefore")) {
                neo4jBean.setRelBefore(Boolean.parseBoolean(node.getProperty("relBefore").toString()));
            }
            return neo4jBean;
        }
        return null;
    }

    private static List<String> extractArrayNode(CustomNode node, String key) {
        ArrayList<String> values = new ArrayList<String>();
        int size = ((ArrayNode)node.getProperty(key)).size();
        for (int i = 0; i < size; ++i) {
            values.add(((ArrayNode)node.getProperty(key)).get(i).asText());
        }
        return values;
    }

    private static Neo4jBean createEmptyNeo4JBean() {
        Neo4jBean neo4jBean = new Neo4jBean();
        final ArrayList<String> nullVal = new ArrayList<String>(){
            {
                this.add("(null)");
            }
        };
        HashMap<String, List<String>> titles = new HashMap<String, List<String>>(){
            {
                this.put("def", nullVal);
            }
        };
        neo4jBean.setId("(null)");
        neo4jBean.setType(DocType.safeValueOf((String)"(null)"));
        neo4jBean.setTitle((Map<String, List<String>>)titles);
        neo4jBean.setHasChildren(Boolean.FALSE);
        neo4jBean.setIndex(0L);
        neo4jBean.setParent("(null)");
        neo4jBean.setRelBefore(Boolean.FALSE);
        neo4jBean.setChildrenCount(0L);
        return neo4jBean;
    }

    private static Neo4jBean retrieveLangAwareProperties(Neo4jBean bean, CustomNode customnode) {
        Map<String, List<String>> titles = new HashMap<String, List<String>>();
        Map<String, List<String>> descriptions = new HashMap<String, List<String>>();
        for (String key : customnode.getPropertyKeys()) {
            if (key.startsWith("dc:description")) {
                descriptions = Node2Neo4jBeanConverter.getLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:description_xml:lang_"), descriptions, customnode);
                continue;
            }
            if (!key.startsWith("dc:title")) continue;
            titles = Node2Neo4jBeanConverter.getLangAwareProperties(key, StringUtils.substringAfter((String)key, (String)"dc:title_xml:lang_"), titles, customnode);
        }
        bean.setTitle(titles);
        bean.setDescription(descriptions);
        return bean;
    }

    private static Map<String, List<String>> getLangAwareProperties(String key, String lang, Map<String, List<String>> langAwareProperties, CustomNode customnode) {
        List<Object> langAwareValues;
        List<Object> list = langAwareValues = langAwareProperties.get(lang) != null ? langAwareProperties.get(lang) : new ArrayList();
        if (customnode.getProperty(key) instanceof ArrayNode) {
            langAwareValues.addAll(Node2Neo4jBeanConverter.extractArrayNode(customnode, key));
        } else {
            langAwareValues.addAll((List)customnode.getProperty(key));
        }
        langAwareProperties.put(lang, langAwareValues);
        return langAwareProperties;
    }
}

