/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.neo4j.server.impl;

import eu.europeana.corelib.neo4j.entity.CustomNode;
import eu.europeana.corelib.neo4j.entity.CustomResponse;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.IndexObject;
import eu.europeana.corelib.neo4j.entity.RelType;
import eu.europeana.corelib.neo4j.entity.Relation;
import eu.europeana.corelib.neo4j.entity.Siblington;
import eu.europeana.corelib.neo4j.exception.Neo4JException;
import eu.europeana.corelib.neo4j.server.Neo4jServer;
import eu.europeana.corelib.web.exception.ProblemType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.springframework.util.StringUtils;

public class Neo4jServerImpl
implements Neo4jServer {
    private static final Logger LOG = Logger.getLogger(Neo4jServerImpl.class);
    private RestGraphDatabase graphDb;
    private RestIndex<Node> index;
    private HttpClient client;
    private String customPath;
    private String serverPath;
    private static final Relation EDMISNEXTINSEQUENCERELATION = new Relation(RelType.EDM_ISNEXTINSEQUENCE.getRelType());
    private static final Relation ISFIRSTINSEQUENCERELATION = new Relation(RelType.ISFIRSTINSEQUENCE.getRelType());
    private static final Relation DCTERMSISPARTOFRELATION = new Relation(RelType.DCTERMS_ISPARTOF.getRelType());
    private static final Relation DCTERMSHASPARTRELATION = new Relation(RelType.DCTERMS_HASPART.getRelType());
    private static final Relation ISFAKEORDERRELATION = new Relation(RelType.ISFAKEORDER.getRelType());

    public Neo4jServerImpl(String serverPath, String index, String customPath) {
        this.graphDb = new RestGraphDatabase(serverPath);
        this.index = this.graphDb.getRestAPI().getIndex(index);
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
        this.customPath = customPath;
        this.serverPath = serverPath;
    }

    public Neo4jServerImpl() {
    }

    @Override
    public Node getNode(String rdfAbout) throws Neo4JException {
        Node node = null;
        try {
            IndexHits nodes = this.index.get("rdf_about", (Object)(!rdfAbout.startsWith("/") && (rdfAbout.contains("/") || rdfAbout.contains("%2F")) ? "/" + rdfAbout : rdfAbout));
            if (nodes.size() > 0 && this.hasRelationships((IndexHits<Node>)nodes)) {
                node = (Node)nodes.getSingle();
            }
        }
        catch (Exception e) {
            throw new Neo4JException(e, ProblemType.NEO4J_CANNOTGETNODE);
        }
        return node;
    }

    @Override
    public long getNodeIndex(Node node) {
        return this.getNodeIndex(node.getId() + "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeIndex(String nodeId) {
        HttpGet method = new HttpGet(this.fixTrailingSlash(this.customPath) + "europeana/hierarchycount/nodeId/" + nodeId);
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            IndexObject obj = (IndexObject)new ObjectMapper().readValue(resp.getEntity().getContent(), IndexObject.class);
            long l = obj.getLength();
            return l;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return 0L;
    }

    @Override
    public long getNodeIndexByRdfAbout(String rdfAbout) throws Neo4JException {
        return this.getNodeIndex(this.getNode(rdfAbout));
    }

    private boolean hasRelationships(IndexHits<Node> nodes) {
        return ((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{DCTERMSISPARTOFRELATION}) || ((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{DCTERMSHASPARTRELATION});
    }

    @Override
    public boolean isHierarchy(String rdfAbout) throws Neo4JException {
        return this.getNode(rdfAbout) != null;
    }

    @Override
    public boolean isHierarchyTimeLimited(String rdfAbout, int hierarchyTimeout) throws Neo4JException, InterruptedException, ExecutionException, TimeoutException {
        ExecutorService timeoutExecutorService = Executors.newSingleThreadExecutor();
        Future<Boolean> future = timeoutExecutorService.submit(() -> this.isHierarchy(rdfAbout));
        return future.get(hierarchyTimeout, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CustomNode> getChildren(String rdfAbout, int offset, int limit) {
        HttpGet method = new HttpGet(this.fixTrailingSlash(this.customPath) + "fetch/children/nodeId/" + StringUtils.replace((String)(rdfAbout + ""), (String)"/", (String)"%2F") + "?offset=" + offset + "&limit=" + limit);
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            ObjectMapper mapper = new ObjectMapper();
            Siblington siblington = (Siblington)mapper.readValue(resp.getEntity().getContent(), Siblington.class);
            List<CustomNode> list = siblington.getSiblings();
            return list;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public List<CustomNode> getChildren(Node node, int offset, int limit) {
        return this.getChildren(node.getProperty("rdf:about") + "", offset, limit);
    }

    @Override
    public Node getParent(Node node) {
        List<Node> nodes = this.getRelatedNodes(node, 1, 0, Direction.OUTGOING, DCTERMSISPARTOFRELATION);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CustomNode> getFollowingSiblings(String rdfAbout, int limit) {
        HttpGet method = new HttpGet(this.fixTrailingSlash(this.customPath) + "fetch/following/nodeId/" + StringUtils.replace((String)(rdfAbout + ""), (String)"/", (String)"%2F") + "?limit=" + limit);
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            ObjectMapper mapper = new ObjectMapper();
            Siblington siblington = (Siblington)mapper.readValue(resp.getEntity().getContent(), Siblington.class);
            List<CustomNode> list = siblington.getSiblings();
            return list;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public List<CustomNode> getFollowingSiblings(Node node, int limit) {
        return this.getFollowingSiblings(node.getProperty("rdf:about") + "", limit);
    }

    private List<Node> getFollowingSiblings(Node node, int limit, int offset) {
        return this.getRelatedNodes(node, limit, offset, Direction.INCOMING, EDMISNEXTINSEQUENCERELATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CustomNode> getPrecedingSiblings(String rdfAbout, int limit) {
        HttpGet method = new HttpGet(this.fixTrailingSlash(this.customPath) + "fetch/preceding/nodeId/" + StringUtils.replace((String)(rdfAbout + ""), (String)"/", (String)"%2F") + "?limit=" + limit);
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            ObjectMapper mapper = new ObjectMapper();
            Siblington siblington = (Siblington)mapper.readValue(resp.getEntity().getContent(), Siblington.class);
            List<CustomNode> list = siblington.getSiblings();
            return list;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public List<CustomNode> getPrecedingSiblings(Node node, int limit) {
        return this.getPrecedingSiblings(node.getProperty("rdf:about") + "", limit);
    }

    private List<Node> getPrecedingSiblings(Node node, int limit, int offset) {
        return this.getRelatedNodes(node, limit, offset, Direction.OUTGOING, EDMISNEXTINSEQUENCERELATION);
    }

    private List<Node> getRelatedNodes(Node node, int limit, int offset, Direction direction, Relation relType) {
        ArrayList<Node> children = new ArrayList<Node>();
        Transaction tx = this.graphDb.beginTx();
        RestTraversal traversal = (RestTraversal)this.graphDb.traversalDescription();
        traversal.evaluator(Evaluators.excludeStartPosition());
        traversal.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
        traversal.breadthFirst();
        traversal.maxDepth(offset + limit);
        traversal.relationships((RelationshipType)relType, direction);
        Traverser tr = traversal.traverse(node);
        ResourceIterator resIter = tr.nodes().iterator();
        int i = 1;
        while (resIter.hasNext()) {
            Node relatedNode = (Node)resIter.next();
            if (i >= offset) {
                if (children.size() <= limit) {
                    children.add(relatedNode);
                }
                if (children.size() == limit) break;
            }
            ++i;
        }
        tx.success();
        tx.finish();
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChildrenCount(Node node) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        ArrayNode statements = JsonNodeFactory.instance.arrayNode();
        obj.put("statements", (JsonNode)statements);
        ObjectNode statement = JsonNodeFactory.instance.objectNode();
        statement.put("statement", "start n = node:edmsearch2(rdf_about={from}) match (n)-[:`dcterms:hasPart`]->(part) WHERE NOT ID(n)=ID(part) RETURN COUNT(part) as children");
        ObjectNode parameters = statement.with("parameters");
        statements.add((JsonNode)statement);
        parameters.put("from", (String)node.getProperty("rdf:about"));
        HttpPost httpMethod = new HttpPost(this.fixTrailingSlash(this.serverPath) + "transaction/commit");
        try {
            String str = new ObjectMapper().writeValueAsString((Object)obj);
            httpMethod.setEntity((HttpEntity)new StringEntity(str));
            httpMethod.setHeader("content-type", "application/json");
            HttpResponse resp = this.client.execute((HttpUriRequest)httpMethod);
            CustomResponse cr = (CustomResponse)new ObjectMapper().readValue(resp.getEntity().getContent(), CustomResponse.class);
            if (!(cr.getResults() == null || cr.getResults().isEmpty() || cr.getResults().get(0) == null || cr.getResults().get(0).getData() == null || cr.getResults().get(0).getData().isEmpty() || cr.getResults().get(0).getData().get(0).get("row") == null || cr.getResults().get(0).getData().get(0).get("row").isEmpty())) {
                long l = Long.parseLong(cr.getResults().get(0).getData().get(0).get("row").get(0));
                return l;
            }
        }
        catch (IOException | IllegalStateException e) {
            LOG.error((Object)e.getMessage());
        }
        finally {
            httpMethod.releaseConnection();
        }
        return 0L;
    }

    @Override
    public Hierarchy getInitialStruct(String rdfAbout) throws Neo4JException {
        if (!this.isHierarchy(rdfAbout)) {
            return null;
        }
        HttpGet method = new HttpGet(this.fixTrailingSlash(this.customPath) + "initial/startup/nodeId/" + StringUtils.replace((String)rdfAbout, (String)"/", (String)"%2F"));
        LOG.info((Object)("path: " + method.getURI()));
        try {
            Hierarchy obj;
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            if (resp.getStatusLine().getStatusCode() == 502) {
                LOG.error((Object)(ProblemType.NEO4J_INCONSISTENT_DATA.getMessage() + " by Neo4J plugin, for node with ID: " + rdfAbout));
                throw new Neo4JException(ProblemType.NEO4J_INCONSISTENT_DATA, " \n\n... thrown by Neo4J plugin, for node with ID: " + rdfAbout);
            }
            ObjectMapper mapper = new ObjectMapper();
            Hierarchy hierarchy = obj = (Hierarchy)mapper.readValue(resp.getEntity().getContent(), Hierarchy.class);
            return hierarchy;
        }
        catch (IOException e) {
            LOG.error((Object)(ProblemType.NEO4J_CANNOTGETNODE.getMessage() + " with ID: " + rdfAbout));
            throw new Neo4JException(ProblemType.NEO4J_CANNOTGETNODE, " with ID: " + rdfAbout);
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public String getCustomPath() {
        return this.customPath;
    }

    private String fixTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }
}

