/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.neo4j.server.impl;

import eu.europeana.corelib.logging.Logger;
import eu.europeana.corelib.neo4j.entity.CustomResponse;
import eu.europeana.corelib.neo4j.entity.Hierarchy;
import eu.europeana.corelib.neo4j.entity.IndexObject;
import eu.europeana.corelib.neo4j.entity.RelType;
import eu.europeana.corelib.neo4j.entity.Relation;
import eu.europeana.corelib.neo4j.server.Neo4jServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.Traverser;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.rest.graphdb.RestGraphDatabase;
import org.neo4j.rest.graphdb.index.RestIndex;
import org.neo4j.rest.graphdb.traversal.RestTraversal;
import org.springframework.util.StringUtils;

public class Neo4jServerImpl
implements Neo4jServer {
    private static final Logger LOG = Logger.getLogger((String)Neo4jServerImpl.class.getCanonicalName());
    private RestGraphDatabase graphDb;
    private RestIndex<Node> index;
    private HttpClient client;
    private String customPath;
    private String serverPath;
    private static final Relation EDMISNEXTINSEQUENCERELATION = new Relation(RelType.EDM_ISNEXTINSEQUENCE.getRelType());
    private static final Relation ISFIRSTINSEQUENCERELATION = new Relation(RelType.ISFIRSTINSEQUENCE.getRelType());
    private static final Relation DCTERMSISPARTOFRELATION = new Relation(RelType.DCTERMS_ISPARTOF.getRelType());
    private static final Relation DCTERMSHASPARTRELATION = new Relation(RelType.DCTERMS_HASPART.getRelType());

    public Neo4jServerImpl(String serverPath, String index, String customPath) {
        this.graphDb = new RestGraphDatabase(serverPath);
        this.index = this.graphDb.getRestAPI().getIndex(index);
        this.client = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager()).build();
        this.customPath = customPath;
        this.serverPath = serverPath;
    }

    public Neo4jServerImpl() {
    }

    @Override
    public Node getNode(String id) {
        IndexHits nodes = this.index.get("rdf_about", (Object)id);
        if (nodes.size() > 0 && this.hasRelationships((IndexHits<Node>)nodes)) {
            return (Node)nodes.getSingle();
        }
        return null;
    }

    private boolean hasRelationships(IndexHits<Node> nodes) {
        return ((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{DCTERMSISPARTOFRELATION}) || ((Node)nodes.getSingle()).hasRelationship(new RelationshipType[]{DCTERMSHASPARTRELATION});
    }

    @Override
    public boolean isHierarchy(String id) {
        return this.getNode(id) != null;
    }

    @Override
    public List<Node> getChildren(Node id, int offset, int limit) {
        ArrayList<Node> children = new ArrayList<Node>();
        RestTraversal traversal = (RestTraversal)this.graphDb.traversalDescription();
        traversal.evaluator(Evaluators.excludeStartPosition());
        traversal.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
        traversal.breadthFirst();
        traversal.maxDepth(1);
        traversal.relationships((RelationshipType)ISFIRSTINSEQUENCERELATION, Direction.INCOMING);
        Traverser tr = traversal.traverse(id);
        for (Node node : tr.nodes()) {
            if (node == null) continue;
            if (offset == 0) {
                children.add(node);
                children.addAll(this.getFollowingSiblings(node, limit - 1, 0));
                continue;
            }
            children.addAll(this.getFollowingSiblings(node, limit, offset));
        }
        return children;
    }

    @Override
    public Node getParent(Node id) {
        List<Node> nodes = this.getRelatedNodes(id, 1, 0, Direction.OUTGOING, DCTERMSISPARTOFRELATION);
        if (nodes.size() > 0) {
            return nodes.get(0);
        }
        return null;
    }

    @Override
    public List<Node> getFollowingSiblings(Node id, int limit) {
        return this.getFollowingSiblings(id, limit, 0);
    }

    private List<Node> getFollowingSiblings(Node id, int limit, int offset) {
        return this.getRelatedNodes(id, limit, offset, Direction.INCOMING, EDMISNEXTINSEQUENCERELATION);
    }

    @Override
    public List<Node> getPreceedingSiblings(Node id, int limit) {
        return this.getPreceedingSiblings(id, limit, 0);
    }

    private List<Node> getPreceedingSiblings(Node id, int limit, int offset) {
        return this.getRelatedNodes(id, limit, offset, Direction.OUTGOING, EDMISNEXTINSEQUENCERELATION);
    }

    private List<Node> getRelatedNodes(Node id, int limit, int offset, Direction direction, Relation relType) {
        ArrayList<Node> children = new ArrayList<Node>();
        Transaction tx = this.graphDb.beginTx();
        RestTraversal traversal = (RestTraversal)this.graphDb.traversalDescription();
        traversal.evaluator(Evaluators.excludeStartPosition());
        traversal.uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL);
        traversal.breadthFirst();
        traversal.maxDepth(offset + limit);
        traversal.relationships((RelationshipType)relType, direction);
        Traverser tr = traversal.traverse(id);
        ResourceIterator resIter = tr.nodes().iterator();
        int i = 1;
        while (resIter.hasNext()) {
            Node node = (Node)resIter.next();
            if (i >= offset) {
                if (children.size() <= limit) {
                    children.add(node);
                }
                if (children.size() == limit) break;
            }
            ++i;
        }
        tx.success();
        tx.finish();
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getChildrenCount(Node id) {
        ObjectNode obj = JsonNodeFactory.instance.objectNode();
        ArrayNode statements = JsonNodeFactory.instance.arrayNode();
        obj.put("statements", (JsonNode)statements);
        ObjectNode statement = JsonNodeFactory.instance.objectNode();
        statement.put("statement", "start n = node:edmsearch2(rdf_about={from}) match (n)-[:`dcterms:hasPart`]->(part) RETURN COUNT(part) as children");
        ObjectNode parameters = statement.with("parameters");
        statements.add((JsonNode)statement);
        parameters.put("from", (String)id.getProperty("rdf:about"));
        HttpPost httpMethod = new HttpPost(this.serverPath + "transaction/commit");
        try {
            String str = new ObjectMapper().writeValueAsString((Object)obj);
            httpMethod.setEntity((HttpEntity)new StringEntity(str));
            httpMethod.setHeader("content-type", "application/json");
            HttpResponse resp = this.client.execute((HttpUriRequest)httpMethod);
            CustomResponse cr = (CustomResponse)new ObjectMapper().readValue(resp.getEntity().getContent(), CustomResponse.class);
            if (!(cr.getResults() == null || cr.getResults().isEmpty() || cr.getResults().get(0) == null || cr.getResults().get(0).getData() == null || cr.getResults().get(0).getData().isEmpty() || cr.getResults().get(0).getData().get(0).get("row") == null || cr.getResults().get(0).getData().get(0).get("row").isEmpty())) {
                long l = Long.parseLong(cr.getResults().get(0).getData().get(0).get("row").get(0));
                return l;
            }
        }
        catch (IOException | IllegalStateException e) {
            LOG.error(e.getMessage());
        }
        finally {
            httpMethod.releaseConnection();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNodeIndex(Node node) {
        HttpGet method = new HttpGet(this.customPath + "/europeana/hierarchycount/nodeId/" + node.getId());
        try {
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            IndexObject obj = (IndexObject)new ObjectMapper().readValue(resp.getEntity().getContent(), IndexObject.class);
            long l = obj.getLength();
            return l;
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Hierarchy getInitialStruct(String id) {
        if (!this.isHierarchy(id)) {
            return null;
        }
        HttpGet method = new HttpGet(this.customPath + "/initial/startup/nodeId/" + StringUtils.replace((String)id, (String)"/", (String)"%2F"));
        LOG.info("path: " + method.getURI());
        try {
            Hierarchy obj;
            HttpResponse resp = this.client.execute((HttpUriRequest)method);
            ObjectMapper mapper = new ObjectMapper();
            Hierarchy hierarchy = obj = (Hierarchy)mapper.readValue(resp.getEntity().getContent(), Hierarchy.class);
            return hierarchy;
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    @Override
    public String getCustomPath() {
        return this.customPath;
    }
}

