/*
 * Copyright 2007-2012 The Europeana Foundation
 *
 *  Licenced under the EUPL, Version 1.1 (the "Licence") and subsequent versions as approved
 *  by the European Commission;
 *  You may not use this work except in compliance with the Licence.
 * 
 *  You may obtain a copy of the Licence at:
 *  http://joinup.ec.europa.eu/software/page/eupl
 *
 *  Unless required by applicable law or agreed to in writing, software distributed under
 *  the Licence is distributed on an "AS IS" basis, without warranties or conditions of
 *  any kind, either express or implied.
 *  See the Licence for the specific language governing permissions and limitations under
 *  the Licence.
 */
package eu.europeana.corelib.neo4j.entity;

import eu.europeana.corelib.definitions.solr.DocType;

import java.util.List;
import java.util.Map;

import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;

/**
 * Neo4jBean
 * 
 * @author Yorgos.Mamakis@ europeana.eu
 */
@JsonSerialize(include = Inclusion.NON_EMPTY)
public class Neo4jBean {

	private String id;

	private Map<String, List<String>> description;

	private Map<String, List<String>> title;

	private DocType type;

	private Boolean children;

	private String parent;

	private Long index;

	private Long childrenCount = 0L;
        
        private Boolean relBefore;
        
       
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public Map<String, List<String>> getDescription() {
		return description;
	}

	public void setDescription(Map<String, List<String>> description) {
		this.description = description;
	}

	public Map<String, List<String>> getTitle() {
		return title;
	}

	public void setTitle(Map<String, List<String>> title) {
		this.title = title;
	}

	public DocType getType() {
		return type;
	}

	public void setType(DocType type) {
		this.type = type;
	}

	@JsonProperty("hasChildren")
	public Boolean hasChildren() {
		return children;
	}

	public void setHasChildren(Boolean children) {
		this.children = children;
	}

	public Long getIndex() {
		return index;
	}

	public void setIndex(Long index) {
		this.index = index;
	}

	public Long getChildrenCount() {
		return childrenCount;
	}

	public void setChildrenCount(Long childrenCount) {
		this.childrenCount = childrenCount;
	}

	public String getParent() {
		return parent;
	}

	public void setParent(String parent) {
		this.parent = parent;
	}

        public void setRelBefore(Boolean relBefore){
            this.relBefore = relBefore;
        }
        
        public Boolean isRelBefore(){
            return this.relBefore;
        }
        
        
        
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((children == null) ? 0 : children.hashCode());
		result = prime * result
				+ ((childrenCount == null) ? 0 : childrenCount.hashCode());
		result = prime * result
				+ ((description == null) ? 0 : description.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((index == null) ? 0 : index.hashCode());
		result = prime * result + ((parent == null) ? 0 : parent.hashCode());
		result = prime * result + ((title == null) ? 0 : title.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}
		if (obj == null) {
			return false;
		}
		if (getClass() != obj.getClass()) {
			return false;
		}
		Neo4jBean other = (Neo4jBean) obj;
		if (children == null) {
			if (other.children != null) {
				return false;
			}
		} else if (!children.equals(other.children)) {
			return false;
		}
		if (childrenCount == null) {
			if (other.childrenCount != null) {
				return false;
			}
		} else if (!childrenCount.equals(other.childrenCount)) {
			return false;
		}
		if (description == null) {
			if (other.description != null) {
				return false;
			}
		} else if (!description.equals(other.description)) {
			return false;
		}
		if (id == null) {
			if (other.id != null) {
				return false;
			}
		} else if (!id.equals(other.id)) {
			return false;
		}
		if (index == null) {
			if (other.index != null) {
				return false;
			}
		} else if (!index.equals(other.index)) {
			return false;
		}
		if (parent == null) {
			if (other.parent != null) {
				return false;
			}
		} else if (!parent.equals(other.parent)) {
			return false;
		}
		if (title == null) {
			if (other.title != null) {
				return false;
			}
		} else if (!title.equals(other.title)) {
			return false;
		}
		return type == other.type;
	}

}
