/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.dereference.impl;

import com.mongodb.MongoClient;
import eu.europeana.corelib.dereference.VocabularyMongoServer;
import eu.europeana.corelib.dereference.impl.ControlledVocabularyImpl;
import eu.europeana.corelib.dereference.impl.EntityImpl;
import eu.europeana.corelib.storage.impl.MongoProviderImpl;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mongodb.morphia.Datastore;
import org.mongodb.morphia.Morphia;

public class VocabularyMongoServerImpl
implements VocabularyMongoServer {
    private static final Logger LOG = Logger.getLogger((String)VocabularyMongoServerImpl.class.getName());
    private MongoClient mongoClient;
    private Datastore datastore;

    public VocabularyMongoServerImpl(MongoClient mongoClient, String databaseName) {
        this.mongoClient = mongoClient;
        this.initDatastore(mongoClient, databaseName);
    }

    public VocabularyMongoServerImpl(String host, int port, String databaseName, String username, String password) {
        this.mongoClient = new MongoProviderImpl(host, String.valueOf(port), databaseName, username, password).getMongo();
        this.initDatastore(this.mongoClient, databaseName);
    }

    private void initDatastore(MongoClient mongoClient, String databaseName) {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{ControlledVocabularyImpl.class}).map(new Class[]{EntityImpl.class});
        this.datastore = morphia.createDatastore(mongoClient, databaseName);
        this.datastore.ensureIndexes();
        LOG.info((Object)"VocabularyMongoServer datastore is created");
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        LOG.info((Object)"Closing MongoClient for VocabularyMongoServer");
        this.mongoClient.close();
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabulary(String field, String filter) {
        String[] splitName = filter.split("/");
        String vocabularyName = splitName[0] + "/" + splitName[1] + "/" + splitName[2] + "/";
        List vocabularies = this.getDatastore().find(ControlledVocabularyImpl.class).filter(field, (Object)vocabularyName).asList();
        for (ControlledVocabularyImpl vocabulary : vocabularies) {
            boolean ruleController = true;
            for (String rule : vocabulary.getRules()) {
                ruleController = ruleController && (filter.contains(rule) || StringUtils.equals((String)rule, (String)"*"));
            }
            if (!ruleController) continue;
            return vocabulary;
        }
        return null;
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabularyByUri(String uri, String name) {
        List vocabularies = this.getDatastore().find(ControlledVocabularyImpl.class).asList();
        for (ControlledVocabularyImpl vocabulary : vocabularies) {
            if (!StringUtils.equals((String)name, (String)vocabulary.getName())) continue;
            return vocabulary;
        }
        return null;
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabularyByName(String name) {
        return (ControlledVocabularyImpl)this.getDatastore().find(ControlledVocabularyImpl.class).filter("name", (Object)name).get();
    }
}

