/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.dereference.impl;

import com.ctc.wstx.stax.WstxInputFactory;
import eu.europeana.corelib.definitions.ApplicationContextContainer;
import eu.europeana.corelib.definitions.model.EdmLabel;
import eu.europeana.corelib.dereference.ControlledVocabulary;
import eu.europeana.corelib.dereference.VocabularyMongoServer;
import eu.europeana.corelib.dereference.impl.ControlledVocabularyImpl;
import eu.europeana.corelib.dereference.impl.EdmMappedField;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.mongodb.morphia.query.Query;
import org.mongodb.morphia.query.UpdateOperations;

public class Extractor {
    protected VocabularyMongoServer mongoServer;
    protected ControlledVocabularyImpl vocabulary;

    public Extractor(ControlledVocabularyImpl controlledVocabulary) {
        this.vocabulary = controlledVocabulary;
        this.mongoServer = (VocabularyMongoServer)ApplicationContextContainer.getBean(VocabularyMongoServer.class, (String)"corelib_solr_vocabularyMongoServer");
    }

    public Extractor() {
    }

    public Extractor(ControlledVocabularyImpl controlledVocabulary, VocabularyMongoServer server) {
        this.vocabulary = controlledVocabulary;
        this.mongoServer = server;
    }

    public List<ControlledVocabularyImpl> getControlledVocabularies() {
        return this.mongoServer.getDatastore().find(ControlledVocabularyImpl.class) != null ? this.mongoServer.getDatastore().find(ControlledVocabularyImpl.class).asList() : null;
    }

    public List<EdmMappedField> getEdmLabel(String field) {
        return this.vocabulary != null ? this.vocabulary.getElements().get(field) : new ArrayList<EdmMappedField>();
    }

    public void setMappedField(String fieldToMap, EdmLabel europeanaField, String attribute) {
        HashMap elements = this.vocabulary.getElements() != null ? (HashMap)this.vocabulary.getElements() : new HashMap();
        List field = (List)elements.get(fieldToMap);
        if (field == null) {
            elements.put(fieldToMap, new ArrayList());
            field = (List)elements.get(fieldToMap);
        }
        if (!field.contains(europeanaField) && europeanaField != null) {
            EdmMappedField edmMappedField = new EdmMappedField();
            edmMappedField.setLabel(europeanaField.toString());
            edmMappedField.setAttribute(StringUtils.isNotBlank((String)attribute) ? attribute : null);
            field.add(edmMappedField);
            elements.put(fieldToMap, field);
        } else if (europeanaField == null) {
            elements.put(fieldToMap, new ArrayList());
        }
        this.vocabulary.setElements(elements);
        ControlledVocabularyImpl vocRet = this.mongoServer.getControlledVocabularyByName(this.vocabulary.getName());
        if (vocRet == null) {
            this.mongoServer.getDatastore().save((Object)this.vocabulary);
        } else {
            UpdateOperations ops = this.mongoServer.getDatastore().createUpdateOperations(ControlledVocabularyImpl.class);
            Query updateQuery = (Query)this.mongoServer.getDatastore().createQuery(ControlledVocabularyImpl.class).field("name").equal((Object)this.vocabulary.getName());
            vocRet.setElements(elements);
            if (this.validate(vocRet)) {
                ops.set("elements", (Object)elements);
                this.mongoServer.getDatastore().update(updateQuery, ops);
            }
        }
    }

    public String getMappedField(EdmLabel europeanaField) {
        for (String key : this.vocabulary.getElements().keySet()) {
            if (!europeanaField.toString().equals(this.vocabulary.getElements().get(key).get(0).getLabel().toString())) continue;
            return key;
        }
        return null;
    }

    public boolean isMapped(String field) {
        if (this.vocabulary != null) {
            for (Map.Entry<String, List<EdmMappedField>> entry : this.vocabulary.getElements().entrySet()) {
                if (!StringUtils.contains((String)entry.getKey(), (String)field) || entry.getValue().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public HashMap<String, List<EdmMappedField>> readSchema(String location) {
        this.vocabulary.setElements(this.readFromFile(location));
        return (HashMap)this.vocabulary.getElements();
    }

    public void removeVocabulary(String vocabularyName) {
        this.mongoServer.getDatastore().delete(ControlledVocabularyImpl.class, (Object)((ControlledVocabularyImpl)this.mongoServer.getDatastore().find(ControlledVocabularyImpl.class).filter("name", (Object)vocabularyName).get()).getId());
    }

    public boolean saveMapping(int iterations, String[] vocabularyRules, String vocabularyUrl) {
        if (this.vocabulary != null && this.validate(this.vocabulary)) {
            if (this.mongoServer.getControlledVocabularyByUri(this.vocabulary.getURI(), this.vocabulary.getName()) != null) {
                Query updateQuery = (Query)this.mongoServer.getDatastore().createQuery(ControlledVocabularyImpl.class).field("name").equal((Object)this.vocabulary.getName());
                UpdateOperations ops = this.mongoServer.getDatastore().createUpdateOperations(ControlledVocabularyImpl.class).set("elements", this.vocabulary.getElements());
                ops.set("iterations", (Object)iterations);
                ops.set("URI", (Object)vocabularyUrl);
                ops.set("rules", (Object)vocabularyRules);
                this.mongoServer.getDatastore().update(updateQuery, ops);
            } else {
                this.mongoServer.getDatastore().save((Object)this.vocabulary);
            }
            return true;
        }
        return false;
    }

    private boolean validate(ControlledVocabulary voc) {
        Map<String, List<EdmMappedField>> elems = voc.getElements();
        ArrayList validateList = new ArrayList();
        for (Map.Entry<String, List<EdmMappedField>> entry : elems.entrySet()) {
            if (entry.getValue() != null) {
                validateList.addAll(entry.getValue());
                continue;
            }
            elems.put(entry.getKey(), new ArrayList());
        }
        HashSet<EdmLabel> edmLabelSet = new HashSet<EdmLabel>();
        for (EdmMappedField label : validateList) {
            if (StringUtils.equals((String)EdmLabel.EDM_AGENT.toString(), (String)label.getLabel())) {
                edmLabelSet.add(EdmLabel.EDM_AGENT);
                continue;
            }
            if (StringUtils.equals((String)EdmLabel.SKOS_CONCEPT.toString(), (String)label.getLabel())) {
                edmLabelSet.add(EdmLabel.SKOS_CONCEPT);
                continue;
            }
            if (StringUtils.equals((String)EdmLabel.EDM_TIMESPAN.toString(), (String)label.getLabel())) {
                edmLabelSet.add(EdmLabel.EDM_TIMESPAN);
                continue;
            }
            if (!StringUtils.equals((String)EdmLabel.EDM_PLACE.toString(), (String)label.getLabel())) continue;
            edmLabelSet.add(EdmLabel.EDM_PLACE);
        }
        for (EdmMappedField label : validateList) {
            if (!(label.getLabel().startsWith("ag") ? !edmLabelSet.contains(EdmLabel.EDM_AGENT) : (label.getLabel().startsWith("ts") ? !edmLabelSet.contains(EdmLabel.EDM_TIMESPAN) : (label.getLabel().startsWith("pl") ? !edmLabelSet.contains(EdmLabel.EDM_PLACE) : label.getLabel().startsWith("cc") && !edmLabelSet.contains(EdmLabel.SKOS_CONCEPT))))) continue;
            return false;
        }
        voc.setElements(elems);
        return true;
    }

    private HashMap<String, List<EdmMappedField>> readFromFile(String localLocation) {
        HashMap<String, List<EdmMappedField>> elements = new HashMap<String, List<EdmMappedField>>();
        WstxInputFactory inFactory = new WstxInputFactory();
        try {
            StreamSource source = new StreamSource(new FileInputStream(new File(localLocation)), "UTF-8");
            XMLStreamReader xml = inFactory.createXMLStreamReader(source);
            String element = "";
            String attribute = "";
            while (xml.hasNext()) {
                switch (xml.getEventType()) {
                    case 7: {
                        break;
                    }
                    case 1: {
                        element = (xml.getName().getPrefix().length() > 0 ? xml.getName().getPrefix() + ":" : "") + xml.getName().getLocalPart();
                        elements.put(element, new ArrayList());
                        for (int i = 0; i < xml.getAttributeCount(); ++i) {
                            attribute = element + "_" + xml.getAttributePrefix(i) + ":" + xml.getAttributeLocalName(i);
                            elements.put(attribute, new ArrayList());
                        }
                        break;
                    }
                }
                xml.next();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        return elements;
    }

    public ControlledVocabularyImpl findVocabularyByName(String name, String uri) {
        this.vocabulary = this.mongoServer.getControlledVocabularyByUri(uri, name);
        return this.vocabulary;
    }

    public void setMongoServer(VocabularyMongoServer server) {
        this.mongoServer = server;
    }

    public void setVocabulary(ControlledVocabularyImpl vocabulary) {
        this.vocabulary = vocabulary;
    }
}

