/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.dereference.impl;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.mongodb.Mongo;
import eu.europeana.corelib.dereference.VocabularyMongoServer;
import eu.europeana.corelib.dereference.impl.ControlledVocabularyImpl;
import eu.europeana.corelib.dereference.impl.EntityImpl;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class VocabularyMongoServerImpl
implements VocabularyMongoServer {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private Mongo mongoServer;
    private String databaseName;
    private Datastore datastore;
    private String username;
    private String password;

    public Datastore getDatastore() {
        return this.datastore;
    }

    public void close() {
        this.mongoServer.close();
    }

    public VocabularyMongoServerImpl(Mongo mongoServer, String databaseName) {
        this.log.info("VocabularyMongoServer is instantiated");
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.createDatastore();
    }

    public VocabularyMongoServerImpl(Mongo mongoServer, String databaseName, String username, String password) {
        this.log.info("VocabularyMongoServer is instantiated");
        this.mongoServer = mongoServer;
        this.databaseName = databaseName;
        this.username = username;
        this.password = password;
        this.createDatastoreWithCredentials();
    }

    public VocabularyMongoServerImpl() {
    }

    private void createDatastore() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{ControlledVocabularyImpl.class}).map(new Class[]{EntityImpl.class});
        this.datastore = morphia.createDatastore(this.mongoServer, this.databaseName);
        this.datastore.ensureIndexes();
        this.log.info("VocabularyMongoServer datastore is created");
    }

    private void createDatastoreWithCredentials() {
        Morphia morphia = new Morphia();
        morphia.map(new Class[]{ControlledVocabularyImpl.class}).map(new Class[]{EntityImpl.class});
        this.datastore = morphia.createDatastore(this.mongoServer, this.databaseName, this.username, this.password.toCharArray());
        this.datastore.ensureIndexes();
        this.log.info("VocabularyMongoServer datastore is created");
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabulary(String field, String filter) {
        String[] splitName = filter.split("/");
        String vocabularyName = splitName[0] + "/" + splitName[1] + "/" + splitName[2] + "/";
        List vocabularies = this.getDatastore().find(ControlledVocabularyImpl.class).filter(field, (Object)vocabularyName).asList();
        for (ControlledVocabularyImpl vocabulary : vocabularies) {
            boolean ruleController = true;
            for (String rule : vocabulary.getRules()) {
                ruleController = ruleController && (filter.contains(rule) || StringUtils.equals((String)rule, (String)"*"));
            }
            if (!ruleController) continue;
            return vocabulary;
        }
        return null;
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabularyByUri(String uri, String name) {
        List vocabularies = this.getDatastore().find(ControlledVocabularyImpl.class).asList();
        for (ControlledVocabularyImpl vocabulary : vocabularies) {
            if (!StringUtils.equals((String)name, (String)vocabulary.getName())) continue;
            return vocabulary;
        }
        return null;
    }

    @Override
    public ControlledVocabularyImpl getControlledVocabularyByName(String name) {
        return (ControlledVocabularyImpl)this.getDatastore().find(ControlledVocabularyImpl.class).filter("name", (Object)name).get();
    }
}

