/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.model;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public enum RightsOption {
    CC_NOC("http://creativecommons.org/publicdomain/mark/", "Public Domain Mark", "icon-pd", true, "mark"),
    CC_ZERO("http://creativecommons.org/publicdomain/zero/", "CC0", "icon-cczero", true, "zero"),
    CC_BY("http://creativecommons.org/licenses/by/", "CC BY", "icon-cc icon-by", true, "/by/"),
    CC_BY_SA("http://creativecommons.org/licenses/by-sa/", "CC BY-SA", "icon-cc icon-by icon-sa", true, "/by-sa/"),
    CC_BY_NC("http://creativecommons.org/licenses/by-nc/", "CC BY-NC", "icon-cc icon-by icon-nceu", true, "/by-nc/"),
    CC_BY_NC_SA("http://creativecommons.org/licenses/by-nc-sa/", "CC BY-NC-SA", "icon-cc icon-by icon-nceu icon-sa", true, "/by-nc-sa/"),
    CC_BY_NC_ND("http://creativecommons.org/licenses/by-nc-nd/", "CC BY-NC-ND", "icon-cc icon-by icon-nceu icon-nd", true, "/by-nc-nd/"),
    CC_BY_ND("http://creativecommons.org/licenses/by-nd/", "CC BY-ND", "icon-cc icon-by icon-nd", true, "/by-nd/"),
    EU_OOC_NC("http://www.europeana.eu/rights/out-of-copyright-non-commercial/", "Out of copyright - non commercial re-use", "icon-publicdomain icon-nceu", false, "out-of-copyright"),
    RS_INC_EDU("http://rightsstatements.org/vocab/InC-EDU/1.0/", "In Copyright - Educational Use Permitted", "", true, "InC-EDU"),
    RS_NOC_NC("http://rightsstatements.org/vocab/NoC-NC/1.0/", "No Copyright - non-commercial re-use only", "", true, "NoC-NC/"),
    RS_NOC_OKLR("http://rightsstatements.org/vocab/NoC-OKLR/1.0/", "No Copyright - Other Known Legal Restrictions", "", true, "NoC-OKLR/"),
    EU_RR_F("http://www.europeana.eu/rights/rr-f/", "Rights Reserved - Free Access", "icon-copyright", false, "/rr-f/"),
    EU_RR_P("http://www.europeana.eu/rights/rr-p/", "Rights Reserved - Paid Access", "icon-copyright", false, "/rr-p/"),
    EU_RR_R("http://www.europeana.eu/rights/rr-r/", "Rights Reserved - Restricted Access", "icon-copyright", false, "/rr-r/"),
    EU_U("http://www.europeana.eu/rights/unknown/", "Unknown Copyright Status", "icon-unknown", false, "unknown"),
    EU_ORPHAN("http://www.europeana.eu/rights/test-orphan-work-test/", "Orphan Work", "icon-unknown", false, "orphan"),
    RS_INC("http://rightsstatements.org/vocab/InC/1.0/", "In Copyright", "", true, "/InC/"),
    RS_INC_OW_EU("http://rightsstatements.org/vocab/InC-OW-EU/1.0/", "In Copyright - EU Orphan Work", "", true, "/InC-OW-EU/"),
    RS_CNE("http://rightsstatements.org/vocab/CNE/1.0/", "Copyright Not Evaluated", "", true, "/CNE/");

    private String url = null;
    private String rightsText = null;
    private String rightsIcon = null;
    private boolean showExternalIcon = false;
    protected String shortMatchPattern = null;

    private RightsOption(String url, String rightsText, String rightsIcon, boolean showExternalIconIn, String shortMatchPattern) {
        this.url = url;
        this.rightsText = rightsText;
        this.rightsIcon = rightsIcon;
        this.showExternalIcon = showExternalIconIn;
        this.shortMatchPattern = shortMatchPattern;
    }

    public String getUrl() {
        return this.url;
    }

    public String getRightsText() {
        return this.rightsText;
    }

    public String getRightsIcon() {
        return this.rightsIcon;
    }

    public boolean getShowExternalIcon() {
        return this.showExternalIcon;
    }

    public static RightsOption getValueByUrl(String url, boolean exactMatch) {
        block5: {
            if (!StringUtils.isNotBlank((CharSequence)url)) break block5;
            String urlToMatch = url.toLowerCase(Locale.GERMAN).trim();
            if (urlToMatch.startsWith("https://")) {
                urlToMatch = urlToMatch.replaceFirst("https://", "http://");
            }
            if (exactMatch) {
                for (RightsOption option : RightsOption.values()) {
                    if (!urlToMatch.contains(option.url.toLowerCase(Locale.GERMAN))) continue;
                    return option;
                }
            } else {
                for (RightsOption option : RightsOption.values()) {
                    if (!urlToMatch.contains(option.shortMatchPattern.toLowerCase(Locale.GERMAN))) continue;
                    return option;
                }
            }
        }
        return null;
    }
}

