/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr.model;

public class QuerySort {
    public static final int ORDER_DESC = 0;
    public static final int ORDER_ASC = 1;
    private static final String SORT_ORDER_MATCH = "(?i)(ascending|descending|asc|desc)";
    private String sortField;
    private int sortOrder = 0;

    public static boolean isSortOrder(String s) {
        return s != null && s.trim().matches("^(?i)(ascending|descending|asc|desc)$");
    }

    public static boolean isAscending(String sortOrder) {
        return sortOrder != null && sortOrder.trim().matches("(?i)(asc(ending)?)");
    }

    public QuerySort(String sortField, int sortOrder) {
        this.sortField = sortField;
        this.sortOrder = sortOrder;
    }

    public QuerySort(String sortField, String sortOrder) {
        this.sortField = sortField;
        if (QuerySort.isSortOrder(sortOrder)) {
            this.sortOrder = QuerySort.isAscending(sortOrder) ? 1 : 0;
        } else {
            throw new IllegalArgumentException("Provided sort order isn't a really a sort order");
        }
    }

    public QuerySort(String sortField) {
        if (sortField != null && sortField.trim().matches(".+\\s+(?i)(ascending|descending|asc|desc)")) {
            String[] sortFieldParts = sortField.split("\\s+");
            if (QuerySort.isAscending(sortFieldParts[1])) {
                this.sortField = sortFieldParts[0];
                this.sortOrder = 1;
            } else {
                this.sortField = sortFieldParts[0];
                this.sortOrder = 0;
            }
        } else {
            this.sortField = sortField;
            this.sortOrder = 0;
        }
    }

    public String getSortField() {
        return this.sortField;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public String toString() {
        return this.sortField + (this.sortOrder == 1 ? " asc" : " desc");
    }
}

