/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.model.web;

import org.apache.commons.lang.StringUtils;

public class BreadCrumb {
    private String display;
    private String href;
    private String param = null;
    private String value = null;
    private boolean last = false;

    public BreadCrumb(String display, String href) {
        this.display = display;
        this.href = href;
    }

    public BreadCrumb(String display, String param, String value, String prevHref) {
        this.display = display;
        this.param = param;
        this.value = value;
        this.href = this.createHref(param, value, prevHref);
    }

    public String getDisplay() {
        return this.display;
    }

    public String getHref() {
        return this.href;
    }

    private String createHref(String param, String value, String prevHref) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((String)prevHref)) {
            sb.append(prevHref);
            sb.append("&amp;");
        }
        sb.append(param);
        sb.append("=");
        sb.append(value);
        return sb.toString();
    }

    public boolean isLast() {
        return this.last;
    }

    public void markAsLast() {
        this.last = true;
    }

    public String getParam() {
        return this.param;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.format("%s / %s=%s full: %s (%b)", this.display, this.param, this.value, this.href, this.last);
    }
}

