/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.corelib.definitions.solr;

import eu.europeana.corelib.utils.StringArrayUtils;
import org.apache.commons.lang.StringUtils;

public enum DocType {
    TEXT("doc", "pdf"),
    IMAGE("jpeg", "jpg", "png", "tif"),
    SOUND("mp3"),
    VIDEO("avi", "mpg"),
    _3D(new String[0]);

    private String[] extentions;

    private DocType(String ... extentions) {
        this.extentions = extentions;
    }

    public static DocType safeValueOf(String[] strings) {
        if (StringArrayUtils.isNotBlank((String[])strings)) {
            return DocType.safeValueOf(strings[0]);
        }
        return null;
    }

    public static DocType safeValueOf(String string) {
        if (StringUtils.isNotBlank((String)string)) {
            for (DocType t : DocType.values()) {
                if (!t.toString().equalsIgnoreCase(string)) continue;
                return t;
            }
        }
        return null;
    }

    public static DocType getByExtention(String ext) {
        if (StringUtils.isNotBlank((String)ext)) {
            for (DocType t : DocType.values()) {
                if (!StringArrayUtils.isNotBlank((String[])t.extentions)) continue;
                for (String e : t.extentions) {
                    if (!StringUtils.endsWithIgnoreCase((String)ext, (String)(e = StringArrayUtils.concat((String[])new String[]{".", e})))) continue;
                    return t;
                }
            }
        }
        return null;
    }

    public String toString() {
        return StringUtils.stripStart((String)super.toString(), (String)"_");
    }
}

